/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebugTreeView;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ClickableIcon
extends JLabel
implements MouseListener {
    public static final int CLICKABLE_ICON_WIDTH = 24;
    public static final int CLICKABLE_ICON_HEIGHT = 16;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_FOCUSED = 1;
    private static final int STATE_PRESSED = 2;
    private ImageIcon resumeIcon;
    private ImageIcon focusedResumeIcon;
    private ImageIcon pressedResumeIcon;
    private ImageIcon suspendIcon;
    private ImageIcon focusedSuspendIcon;
    private ImageIcon pressedSuspendIcon;
    private int state;
    private boolean isThreadSupended;
    private JPDAThread jpdaThread;
    private DebugTreeView tree;

    ClickableIcon(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3, ImageIcon imageIcon4, ImageIcon imageIcon5, ImageIcon imageIcon6, JPDAThread jPDAThread, DebugTreeView debugTreeView) {
        this.tree = debugTreeView;
        this.resumeIcon = imageIcon;
        this.focusedResumeIcon = imageIcon2;
        this.pressedResumeIcon = imageIcon3;
        this.suspendIcon = imageIcon4;
        this.focusedSuspendIcon = imageIcon5;
        this.pressedSuspendIcon = imageIcon6;
        this.isThreadSupended = jPDAThread.isSuspended();
        this.jpdaThread = jPDAThread;
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setPreferredSize(new Dimension(24, 16));
    }

    void initializeState(Container container, int n, int n2, int n3, int n4) {
        Point point = null;
        try {
            point = container.getMousePosition(true);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.state = point != null && n <= point.x && point.x < n + n3 && n2 <= point.y && point.y < n2 + n4 ? 1 : 0;
        this.setFocusedThread();
        this.changeIcon();
        this.addMouseListener(this);
    }

    void changeThread(JPDAThread jPDAThread, Container container, int n, int n2, int n3, int n4) {
        boolean bl = jPDAThread.isSuspended();
        if (this.jpdaThread == jPDAThread && bl == this.isThreadSupended) {
            return;
        }
        this.isThreadSupended = jPDAThread.isSuspended();
        this.jpdaThread = jPDAThread;
        Point point = container.getMousePosition(true);
        this.state = point != null && n <= point.x && point.x < n + n3 && n2 <= point.y && point.y < n2 + n4 ? 1 : 0;
        this.setFocusedThread();
        this.changeIcon();
    }

    private void setFocusedThread() {
        if (this.state != 0) {
            if (this.tree != null && this.tree.threadFocuseGained(this.jpdaThread)) {
                this.getParent().repaint();
            }
        } else if (this.tree != null && this.tree.threadFocuseLost(this.jpdaThread)) {
            this.getParent().repaint();
        }
    }

    private ImageIcon computeIcon() {
        ImageIcon imageIcon = null;
        switch (this.state) {
            case 0: {
                imageIcon = this.isThreadSupended ? this.resumeIcon : this.suspendIcon;
                break;
            }
            case 1: {
                imageIcon = this.isThreadSupended ? this.focusedResumeIcon : this.focusedSuspendIcon;
                break;
            }
            case 2: {
                imageIcon = this.isThreadSupended ? this.pressedResumeIcon : this.pressedSuspendIcon;
            }
        }
        return imageIcon;
    }

    private void changeIcon() {
        this.setIcon(this.computeIcon());
        String string = this.isThreadSupended ? "LBL_RESUME_THREAD" : "LBL_SUSPEND_THREAD";
        String string2 = NbBundle.getMessage(ClickableIcon.class, (String)string, (Object)this.jpdaThread.getName());
        this.setToolTipText(string2);
    }

    private void invokeAction() {
        RequestProcessor requestProcessor;
        final boolean bl = this.isThreadSupended;
        try {
            JPDADebugger jPDADebugger = (JPDADebugger)this.jpdaThread.getClass().getMethod("getDebugger", new Class[0]).invoke((Object)this.jpdaThread, new Object[0]);
            Session session = (Session)jPDADebugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)jPDADebugger, new Object[0]);
            requestProcessor = (RequestProcessor)session.lookupFirst(null, RequestProcessor.class);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return;
        }
        if (requestProcessor == null) {
            requestProcessor = RequestProcessor.getDefault();
        }
        requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    ClickableIcon.this.jpdaThread.resume();
                } else {
                    ClickableIcon.this.jpdaThread.suspend();
                }
            }
        });
        this.isThreadSupended = !this.isThreadSupended;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.state = 2;
        this.changeIcon();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.state == 2) {
            this.state = 1;
            this.invokeAction();
            this.changeIcon();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.state = (mouseEvent.getModifiersEx() & 0x400) != 0 ? 0 : 1;
        this.setFocusedThread();
        this.changeIcon();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.state = 0;
        this.setFocusedThread();
        this.changeIcon();
    }
}

