/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.treelist.TreeListListener;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;

public class TreeListModel
extends AbstractListModel
implements TreeListListener {
    private final ArrayList<TreeListNode> nodes = new ArrayList(500);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            return this.nodes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int index) {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            if (index < 0 || index >= this.nodes.size()) {
                return null;
            }
            return this.nodes.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoot(int index, TreeListNode root) {
        int firstIndex = -1;
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            int parentIndex;
            if (index < 0 || index >= this.nodes.size()) {
                this.nodes.add(root);
            } else {
                this.nodes.add(index, root);
            }
            firstIndex = parentIndex = this.nodes.indexOf(root);
            if (root.isExpanded()) {
                lastIndex = this.addNodes(parentIndex + 1, root.getChildren()) - 1;
            }
            root.setListener(this);
        }
        if (firstIndex >= 0) {
            if (lastIndex < firstIndex) {
                lastIndex = firstIndex;
            }
            this.fireIntervalAdded(this, firstIndex, lastIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoot(TreeListNode root) {
        int firstIndex = -1;
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            firstIndex = this.nodes.indexOf(root);
            if (firstIndex < 0) {
                root.dispose();
                return;
            }
            ArrayList<TreeListNode> toRemove = this.findDescendants(root);
            if (null == toRemove) {
                toRemove = new ArrayList(1);
            }
            toRemove.add(0, root);
            lastIndex = this.nodes.indexOf(toRemove.get(toRemove.size() - 1));
            for (TreeListNode node : toRemove) {
                node.dispose();
            }
            this.nodes.removeAll(toRemove);
        }
        if (firstIndex >= 0) {
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            for (TreeListNode node : this.nodes) {
                node.dispose();
            }
            this.nodes.clear();
        }
        this.fireIntervalRemoved(this, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeListNode> getRootNodes() {
        ArrayList<TreeListNode> res = new ArrayList<TreeListNode>(this.getSize());
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            for (TreeListNode n : this.nodes) {
                if (null != n.getParent()) continue;
                res.add(n);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenOf(TreeListNode parent) {
        int firstIndex = -1;
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            ArrayList<TreeListNode> toRemove = this.findDescendants(parent);
            if (null == toRemove) {
                return;
            }
            firstIndex = this.nodes.indexOf(toRemove.get(0));
            lastIndex = this.nodes.indexOf(toRemove.get(toRemove.size() - 1));
            for (TreeListNode node : toRemove) {
                node.dispose();
            }
            this.nodes.removeAll(toRemove);
        }
        if (firstIndex >= 0) {
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    private ArrayList<TreeListNode> findDescendants(TreeListNode parent) {
        TreeListNode child;
        ArrayList<TreeListNode> descendants = null;
        int parentIndex = this.nodes.indexOf(parent);
        if (parentIndex < 0) {
            return null;
        }
        for (int i = parentIndex + 1; i < this.nodes.size() && (child = this.nodes.get(i)).isDescendantOf(parent); ++i) {
            if (null == descendants) {
                descendants = new ArrayList<TreeListNode>(20);
            }
            descendants.add(child);
        }
        return descendants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildrenOf(TreeListNode parent) {
        int firstIndex = -1;
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            firstIndex = this.nodes.indexOf(parent);
            if (firstIndex < 0) {
                return;
            }
            lastIndex = this.addNodes(++firstIndex, parent.getChildren()) - 1;
        }
        if (firstIndex >= 0) {
            if (lastIndex < firstIndex) {
                lastIndex = firstIndex;
            }
            this.fireIntervalAdded(this, firstIndex, lastIndex);
        }
    }

    private int addNodes(int insertPoint, List<TreeListNode> newNodes) {
        for (int i = 0; i < newNodes.size(); ++i) {
            TreeListNode node = newNodes.get(i);
            if (this.nodes.contains(node)) continue;
            node.setListener(this);
            this.nodes.add(insertPoint++, node);
            if (!node.isExpanded()) continue;
            insertPoint = this.addNodes(insertPoint, node.getChildren());
        }
        return insertPoint;
    }

    @Override
    public void childrenRemoved(TreeListNode parent) {
        this.removeChildrenOf(parent);
    }

    @Override
    public void childrenAdded(TreeListNode parent) {
        this.addChildrenOf(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentChanged(TreeListNode node) {
        int index = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            index = this.nodes.indexOf(node);
        }
        if (index >= 0) {
            this.fireContentsChanged(this, index, index);
        }
    }

    @Override
    protected void fireContentsChanged(final Object source, final int index0, final int index1) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeListModel.super.fireContentsChanged(source, index0, index1);
                }
            });
        } else {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    @Override
    protected void fireIntervalAdded(final Object source, final int index0, final int index1) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeListModel.super.fireIntervalAdded(source, index0, index1);
                }
            });
        } else {
            super.fireIntervalAdded(source, index0, index1);
        }
    }

    @Override
    protected void fireIntervalRemoved(final Object source, final int index0, final int index1) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeListModel.super.fireIntervalRemoved(source, index0, index1);
                }
            });
        } else {
            super.fireIntervalRemoved(source, index0, index1);
        }
    }
}

