/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;

public class JFileChooserOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    private static final long WAIT_LIST_PAINTED_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private ComponentSearcher innerSearcher;

    public JFileChooserOperator(JFileChooser comp) {
        super(comp);
        this.innerSearcher = new ComponentSearcher(comp);
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
    }

    public JFileChooserOperator(Operator env) {
        this((JFileChooser)JFileChooserOperator.waitComponent(JDialogOperator.waitJDialog(new JFileChooserJDialogFinder(env.getOutput()), 0, env.getTimeouts(), env.getOutput()), new JFileChooserFinder(), 0, env.getTimeouts(), env.getOutput()));
        this.copyEnvironment(env);
    }

    public JFileChooserOperator() {
        this(JFileChooserOperator.getEnvironmentOperator());
    }

    public static JDialog findJFileChooserDialog() {
        return JDialogOperator.findJDialog(new JFileChooserJDialogFinder(JemmyProperties.getCurrentOutput()));
    }

    public static JDialog waitJFileChooserDialog() {
        return JDialogOperator.waitJDialog(new JFileChooserJDialogFinder(JemmyProperties.getCurrentOutput()));
    }

    public static JFileChooser findJFileChooser(Container cont) {
        return (JFileChooser)JFileChooserOperator.findComponent(cont, new JFileChooserFinder());
    }

    public static JFileChooser waitJFileChooser(Container cont) {
        return (JFileChooser)JFileChooserOperator.waitComponent(cont, new JFileChooserFinder());
    }

    public static JFileChooser findJFileChooser() {
        return JFileChooserOperator.findJFileChooser(JFileChooserOperator.findJFileChooserDialog());
    }

    public static JFileChooser waitJFileChooser() {
        return JFileChooserOperator.waitJFileChooser(JFileChooserOperator.waitJFileChooserDialog());
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
        if (this.innerSearcher != null) {
            this.innerSearcher.setOutput(this.output.createErrorOutput());
        }
    }

    public TestOut getOutput() {
        return this.output;
    }

    public JComboBox getPathCombo() {
        return this.getCombo(0);
    }

    public JComboBox getFileTypesCombo() {
        return this.getCombo(1);
    }

    public JButton getApproveButton() {
        String aText = this.getApproveButtonText();
        if (aText == null) {
            aText = this.getUI().getApproveButtonText((JFileChooser)this.getSource());
        }
        if (aText != null) {
            return (JButton)this.innerSearcher.findComponent(new ButtonFinder(aText));
        }
        throw new JemmyException("JFileChooser.getApproveButtonText() and getUI().getApproveButtonText return null");
    }

    public JButton getCancelButton() {
        return (JButton)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp != null && comp instanceof JButton && comp.getParent() != null && !(comp.getParent() instanceof JComboBox) && ((JButton)comp).getText() != null && ((JButton)comp).getText().length() != 0;
            }

            public String getDescription() {
                return "JButton";
            }
        }, 1);
    }

    public JButton getHomeButton() {
        return this.getNoTextButton(1);
    }

    public JButton getUpLevelButton() {
        return this.getNoTextButton(0);
    }

    public JToggleButton getListToggleButton() {
        return this.getToggleButton(0);
    }

    public JToggleButton getDetailsToggleButton() {
        return this.getToggleButton(1);
    }

    public JTextField getPathField() {
        return (JTextField)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp != null && comp instanceof JTextField;
            }

            public String getDescription() {
                return "JTextField";
            }
        });
    }

    public JList getFileList() {
        return (JList)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp != null && comp instanceof JList;
            }

            public String getDescription() {
                return "JList";
            }
        });
    }

    public void approve() {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Push approve button in JFileChooser\n    : " + this.toStringSource());
        JButtonOperator approveOper = new JButtonOperator(this.getApproveButton());
        approveOper.copyEnvironment(this);
        approveOper.setOutput(this.output.createErrorOutput());
        approveOper.push();
    }

    public void cancel() {
        this.output.printTrace("Push cancel button in JFileChooser\n    : " + this.toStringSource());
        JButtonOperator cancelOper = new JButtonOperator(this.getCancelButton());
        cancelOper.copyEnvironment(this);
        cancelOper.setOutput(this.output.createErrorOutput());
        cancelOper.push();
    }

    public void chooseFile(String fileName) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Choose file by JFileChooser\n    : " + fileName + "\n    : " + this.toStringSource());
        JTextFieldOperator fieldOper = new JTextFieldOperator(this.getPathField());
        fieldOper.copyEnvironment(this);
        fieldOper.setOutput(this.output.createErrorOutput());
        fieldOper.setText(fileName);
        this.approve();
    }

    public File goUpLevel() {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Go up level in JFileChooser\n    : " + this.toStringSource());
        this.setCurrentDirectory(this.getCurrentDirectory().getParentFile());
        this.waitPainted(-1);
        return this.getCurrentDirectory();
    }

    public File goHome() {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Go home in JFileChooser\n    : " + this.toStringSource());
        JButtonOperator homeOper = new JButtonOperator(this.getHomeButton());
        homeOper.copyEnvironment(this);
        homeOper.setOutput(this.output.createErrorOutput());
        homeOper.push();
        this.waitPainted(-1);
        return this.getCurrentDirectory();
    }

    public void clickOnFile(int index, int clickCount) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Click " + Integer.toString(clickCount) + "times on " + Integer.toString(index) + "`th file in JFileChooser\n    : " + this.toStringSource());
        JListOperator listOper = new JListOperator(this.getFileList());
        this.waitPainted(index);
        listOper.copyEnvironment(this);
        listOper.setOutput(this.output.createErrorOutput());
        listOper.clickOnItem(index, clickCount);
    }

    public void clickOnFile(String file, Operator.StringComparator comparator, int clickCount) {
        this.output.printTrace("Click " + Integer.toString(clickCount) + "times on \"" + file + "\" file in JFileChooser\n    : " + this.toStringSource());
        this.clickOnFile(this.findFileIndex(file, comparator), clickCount);
    }

    public void clickOnFile(String file, boolean ce, boolean cc, int clickCount) {
        this.clickOnFile(file, new Operator.DefaultStringComparator(ce, cc), clickCount);
    }

    public void clickOnFile(String file, int clickCount) {
        this.clickOnFile(file, this.getComparator(), clickCount);
    }

    public void clickOnFile(String file, Operator.StringComparator comparator) {
        this.clickOnFile(file, comparator, 1);
    }

    public void clickOnFile(String file, boolean ce, boolean cc) {
        this.clickOnFile(file, ce, cc, 1);
    }

    public void clickOnFile(String file) {
        this.clickOnFile(file, 1);
    }

    public File enterSubDir(String dir, Operator.StringComparator comparator) {
        this.getQueueTool().waitEmpty();
        this.selectFile(dir, comparator);
        int index = this.findFileIndex(dir, comparator);
        this.waitPainted(index);
        this.setCurrentDirectory(this.getSelectedFile());
        return this.getCurrentDirectory();
    }

    public File enterSubDir(String dir, boolean ce, boolean cc) {
        return this.enterSubDir(dir, new Operator.DefaultStringComparator(ce, cc));
    }

    public File enterSubDir(String dir) {
        return this.enterSubDir(dir, this.getComparator());
    }

    public void selectFile(String file, Operator.StringComparator comparator) {
        this.getQueueTool().waitEmpty();
        int index = this.findFileIndex(file, comparator);
        JListOperator listOper = new JListOperator(this.getFileList());
        this.waitPainted(index);
        listOper.copyEnvironment(this);
        listOper.setOutput(this.output.createErrorOutput());
        listOper.setSelectedIndex(index);
    }

    public void selectFile(String file, boolean ce, boolean cc) {
        this.clickOnFile(file, ce, cc);
    }

    public void selectFile(String file) {
        this.clickOnFile(file);
    }

    public void selectPathDirectory(String dir, Operator.StringComparator comparator) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Select \"" + dir + "\" directory in JFileChooser\n    : " + this.toStringSource());
        JComboBoxOperator comboOper = new JComboBoxOperator(this.getPathCombo());
        comboOper.copyEnvironment(this);
        comboOper.setOutput(this.output.createErrorOutput());
        comboOper.setSelectedIndex(this.findDirIndex(dir, comparator));
        this.waitPainted(-1);
    }

    public void selectPathDirectory(String dir, boolean ce, boolean cc) {
        this.selectPathDirectory(dir, new Operator.DefaultStringComparator(ce, cc));
    }

    public void selectPathDirectory(String dir) {
        this.selectPathDirectory(dir, this.getComparator());
    }

    public void selectFileType(String filter, Operator.StringComparator comparator) {
        this.getQueueTool().waitEmpty();
        this.output.printTrace("Select \"" + filter + "\" file type in JFileChooser\n    : " + this.toStringSource());
        JComboBoxOperator comboOper = new JComboBoxOperator(this.getFileTypesCombo());
        comboOper.copyEnvironment(this);
        comboOper.setOutput(this.output.createErrorOutput());
        comboOper.setSelectedIndex(this.findFileTypeIndex(filter, comparator));
        this.waitPainted(-1);
    }

    public void selectFileType(String filter, boolean ce, boolean cc) {
        this.selectFileType(filter, new Operator.DefaultStringComparator(ce, cc));
    }

    public void selectFileType(String filter) {
        this.selectFileType(filter, this.getComparator());
    }

    public boolean checkFileDisplayed(String file, Operator.StringComparator comparator) {
        this.waitPainted(-1);
        return this.findFileIndex(file, comparator) != -1;
    }

    public boolean checkFileDisplayed(String file, boolean ce, boolean cc) {
        return this.checkFileDisplayed(file, new Operator.DefaultStringComparator(ce, cc));
    }

    public boolean checkFileDisplayed(String file) {
        return this.checkFileDisplayed(file, this.getComparator());
    }

    public int getFileCount() {
        this.waitPainted(-1);
        return this.getFileList().getModel().getSize();
    }

    public File[] getFiles() {
        this.waitPainted(-1);
        ListModel listModel = this.getFileList().getModel();
        File[] result = new File[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            result[i] = (File)listModel.getElementAt(i);
        }
        return result;
    }

    public void waitFileCount(final int count) {
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JFileChooserOperator.this.getFileCount() == count;
            }

            public String getDescription() {
                return "Count of files to be equal " + Integer.toString(count);
            }
        });
    }

    public void waitFileDisplayed(final String fileName) {
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JFileChooserOperator.this.checkFileDisplayed(fileName);
            }

            public String getDescription() {
                return "\"" + fileName + "\"file to be displayed";
            }
        });
    }

    public boolean accept(final File file) {
        return this.runMapping(new Operator.MapBooleanAction("accept"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).accept(file);
            }
        });
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public void addChoosableFileFilter(final FileFilter fileFilter) {
        this.runMapping(new Operator.MapVoidAction("addChoosableFileFilter"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).addChoosableFileFilter(fileFilter);
            }
        });
    }

    public void approveSelection() {
        this.runMapping(new Operator.MapVoidAction("approveSelection"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).approveSelection();
            }
        });
    }

    public void cancelSelection() {
        this.runMapping(new Operator.MapVoidAction("cancelSelection"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).cancelSelection();
            }
        });
    }

    public void changeToParentDirectory() {
        this.runMapping(new Operator.MapVoidAction("changeToParentDirectory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).changeToParentDirectory();
            }
        });
    }

    public void ensureFileIsVisible(final File file) {
        this.runMapping(new Operator.MapVoidAction("ensureFileIsVisible"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).ensureFileIsVisible(file);
            }
        });
    }

    public FileFilter getAcceptAllFileFilter() {
        return (FileFilter)this.runMapping(new Operator.MapAction("getAcceptAllFileFilter"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getAcceptAllFileFilter();
            }
        });
    }

    public JComponent getAccessory() {
        return (JComponent)this.runMapping(new Operator.MapAction("getAccessory"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getAccessory();
            }
        });
    }

    public int getApproveButtonMnemonic() {
        return this.runMapping(new Operator.MapIntegerAction("getApproveButtonMnemonic"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getApproveButtonMnemonic();
            }
        });
    }

    public String getApproveButtonText() {
        return (String)this.runMapping(new Operator.MapAction("getApproveButtonText"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getApproveButtonText();
            }
        });
    }

    public String getApproveButtonToolTipText() {
        return (String)this.runMapping(new Operator.MapAction("getApproveButtonToolTipText"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getApproveButtonToolTipText();
            }
        });
    }

    public FileFilter[] getChoosableFileFilters() {
        return (FileFilter[])this.runMapping(new Operator.MapAction("getChoosableFileFilters"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getChoosableFileFilters();
            }
        });
    }

    public File getCurrentDirectory() {
        return (File)this.runMapping(new Operator.MapAction("getCurrentDirectory"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getCurrentDirectory();
            }
        });
    }

    public String getDescription(final File file) {
        return (String)this.runMapping(new Operator.MapAction("getDescription"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getDescription(file);
            }
        });
    }

    public String getDialogTitle() {
        return (String)this.runMapping(new Operator.MapAction("getDialogTitle"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getDialogTitle();
            }
        });
    }

    public int getDialogType() {
        return this.runMapping(new Operator.MapIntegerAction("getDialogType"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getDialogType();
            }
        });
    }

    public FileFilter getFileFilter() {
        return (FileFilter)this.runMapping(new Operator.MapAction("getFileFilter"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileFilter();
            }
        });
    }

    public int getFileSelectionMode() {
        return this.runMapping(new Operator.MapIntegerAction("getFileSelectionMode"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileSelectionMode();
            }
        });
    }

    public FileSystemView getFileSystemView() {
        return (FileSystemView)this.runMapping(new Operator.MapAction("getFileSystemView"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileSystemView();
            }
        });
    }

    public FileView getFileView() {
        return (FileView)this.runMapping(new Operator.MapAction("getFileView"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getFileView();
            }
        });
    }

    public Icon getIcon(final File file) {
        return (Icon)this.runMapping(new Operator.MapAction("getIcon"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getIcon(file);
            }
        });
    }

    public String getName(final File file) {
        return (String)this.runMapping(new Operator.MapAction("getName"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getName(file);
            }
        });
    }

    public File getSelectedFile() {
        return (File)this.runMapping(new Operator.MapAction("getSelectedFile"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getSelectedFile();
            }
        });
    }

    public File[] getSelectedFiles() {
        return (File[])this.runMapping(new Operator.MapAction("getSelectedFiles"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getSelectedFiles();
            }
        });
    }

    public String getTypeDescription(final File file) {
        return (String)this.runMapping(new Operator.MapAction("getTypeDescription"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getTypeDescription(file);
            }
        });
    }

    public FileChooserUI getUI() {
        return (FileChooserUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean isDirectorySelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isDirectorySelectionEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isDirectorySelectionEnabled();
            }
        });
    }

    public boolean isFileHidingEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isFileHidingEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isFileHidingEnabled();
            }
        });
    }

    public boolean isFileSelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isFileSelectionEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isFileSelectionEnabled();
            }
        });
    }

    public boolean isMultiSelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isMultiSelectionEnabled"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isMultiSelectionEnabled();
            }
        });
    }

    public boolean isTraversable(final File file) {
        return this.runMapping(new Operator.MapBooleanAction("isTraversable"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).isTraversable(file);
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public boolean removeChoosableFileFilter(final FileFilter fileFilter) {
        return this.runMapping(new Operator.MapBooleanAction("removeChoosableFileFilter"){

            public boolean map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).removeChoosableFileFilter(fileFilter);
            }
        });
    }

    public void rescanCurrentDirectory() {
        this.runMapping(new Operator.MapVoidAction("rescanCurrentDirectory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).rescanCurrentDirectory();
            }
        });
    }

    public void resetChoosableFileFilters() {
        this.runMapping(new Operator.MapVoidAction("resetChoosableFileFilters"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).resetChoosableFileFilters();
            }
        });
    }

    public void setAccessory(final JComponent jComponent) {
        this.runMapping(new Operator.MapVoidAction("setAccessory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setAccessory(jComponent);
            }
        });
    }

    public void setApproveButtonMnemonic(final char c) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonMnemonic"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonMnemonic(c);
            }
        });
    }

    public void setApproveButtonMnemonic(final int i) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonMnemonic"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonMnemonic(i);
            }
        });
    }

    public void setApproveButtonText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonText"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonText(string);
            }
        });
    }

    public void setApproveButtonToolTipText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setApproveButtonToolTipText"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setApproveButtonToolTipText(string);
            }
        });
    }

    public void setCurrentDirectory(final File file) {
        this.runMapping(new Operator.MapVoidAction("setCurrentDirectory"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setCurrentDirectory(file);
            }
        });
    }

    public void setDialogTitle(final String string) {
        this.runMapping(new Operator.MapVoidAction("setDialogTitle"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setDialogTitle(string);
            }
        });
    }

    public void setDialogType(final int i) {
        this.runMapping(new Operator.MapVoidAction("setDialogType"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setDialogType(i);
            }
        });
    }

    public void setFileFilter(final FileFilter fileFilter) {
        this.runMapping(new Operator.MapVoidAction("setFileFilter"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileFilter(fileFilter);
            }
        });
    }

    public void setFileHidingEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setFileHidingEnabled"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileHidingEnabled(b);
            }
        });
    }

    public void setFileSelectionMode(final int i) {
        this.runMapping(new Operator.MapVoidAction("setFileSelectionMode"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileSelectionMode(i);
            }
        });
    }

    public void setFileSystemView(final FileSystemView fileSystemView) {
        this.runMapping(new Operator.MapVoidAction("setFileSystemView"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileSystemView(fileSystemView);
            }
        });
    }

    public void setFileView(final FileView fileView) {
        this.runMapping(new Operator.MapVoidAction("setFileView"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setFileView(fileView);
            }
        });
    }

    public void setMultiSelectionEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setMultiSelectionEnabled"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setMultiSelectionEnabled(b);
            }
        });
    }

    public void setSelectedFile(final File file) {
        this.runMapping(new Operator.MapVoidAction("setSelectedFile"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setSelectedFile(file);
            }
        });
    }

    public void setSelectedFiles(final File[] file) {
        this.runMapping(new Operator.MapVoidAction("setSelectedFiles"){

            public void map() {
                ((JFileChooser)JFileChooserOperator.this.getSource()).setSelectedFiles(file);
            }
        });
    }

    public int showDialog(final Component component, final String string) {
        return this.runMapping(new Operator.MapIntegerAction("showDialog"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).showDialog(component, string);
            }
        });
    }

    public int showOpenDialog(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("showOpenDialog"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).showOpenDialog(component);
            }
        });
    }

    public int showSaveDialog(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("showSaveDialog"){

            public int map() {
                return ((JFileChooser)JFileChooserOperator.this.getSource()).showSaveDialog(component);
            }
        });
    }

    private void waitPainted(int index) {
        Waiter drawingWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object param) {
                JList list = JFileChooserOperator.this.getFileList();
                int last_one = list.getModel().getSize() - 1;
                if (last_one == -1) {
                    return "";
                }
                int current = param != null ? (Integer)param : 0;
                try {
                    if (list.getCellBounds(current, current) != null) {
                        return list.getCellBounds(last_one, last_one);
                    }
                    return null;
                }
                catch (NullPointerException e) {
                    return null;
                }
            }

            public String getDescription() {
                return "List drawed";
            }
        });
        drawingWaiter.setTimeouts(this.getTimeouts().cloneThis());
        drawingWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JFileChooserOperator.WaitListPaintedTimeout"));
        drawingWaiter.setOutput(this.getOutput().createErrorOutput());
        try {
            drawingWaiter.waitAction(index != -1 ? new Integer(index) : null);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
        }
    }

    private JComboBox getCombo(int index) {
        return (JComboBox)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp != null && comp instanceof JComboBox;
            }

            public String getDescription() {
                return "JComboBox";
            }
        }, index);
    }

    private JButton getNoTextButton(int index) {
        return (JButton)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp != null && comp instanceof JButton && !(comp.getParent() instanceof JComboBox) && (((JButton)comp).getText() == null || ((JButton)comp).getText().length() == 0);
            }

            public String getDescription() {
                return "JButton";
            }
        }, index);
    }

    private JToggleButton getToggleButton(int index) {
        return (JToggleButton)this.innerSearcher.findComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp != null && comp instanceof JToggleButton;
            }

            public String getDescription() {
                return "JToggleButton";
            }
        }, index);
    }

    private int findFileIndex(final String file, final Operator.StringComparator comparator) {
        Waiter fileWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                File[] files = JFileChooserOperator.this.getFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!comparator.equals(files[i].getName(), file)) continue;
                    return new Integer(i);
                }
                return null;
            }

            public String getDescription() {
                return "\"" + file + "\" file to be displayed";
            }
        });
        fileWaiter.setOutput(this.getOutput().createErrorOutput());
        fileWaiter.setTimeouts(this.getTimeouts().cloneThis());
        fileWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JFileChooserOperator.WaitListPaintedTimeout"));
        try {
            return (Integer)fileWaiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting has been interrupted!");
        }
    }

    private int findDirIndex(String dir, Operator.StringComparator comparator) {
        ComboBoxModel cbModel = this.getPathCombo().getModel();
        for (int i = cbModel.getSize() - 1; i >= 0; --i) {
            if (!comparator.equals(((File)cbModel.getElementAt(i)).getName(), dir)) continue;
            return i;
        }
        return -1;
    }

    private int findFileTypeIndex(String fileType, Operator.StringComparator comparator) {
        ComboBoxModel cbModel = this.getFileTypesCombo().getModel();
        for (int i = 0; i < cbModel.getSize(); ++i) {
            if (!comparator.equals(((FileFilter)cbModel.getElementAt(i)).getDescription(), fileType)) continue;
            return i;
        }
        return -1;
    }

    static {
        Timeouts.initDefault("JFileChooserOperator.WaitListPaintedTimeout", 60000L);
    }

    private class ButtonFinder
    implements ComponentChooser {
        String text;

        public ButtonFinder(String text) {
            this.text = text;
        }

        public boolean checkComponent(Component comp) {
            return comp != null && comp instanceof JButton && ((JButton)comp).getText() != null && ((JButton)comp).getText().equals(this.text);
        }

        public String getDescription() {
            return "\"" + this.text + "\" button";
        }
    }

    public static class JFileChooserFinder
    extends Operator.Finder {
        public JFileChooserFinder(ComponentChooser sf) {
            super(JFileChooser.class, sf);
        }

        public JFileChooserFinder() {
            super(JFileChooser.class);
        }
    }

    public static class JFileChooserJDialogFinder
    implements ComponentChooser {
        TestOut output;
        ComponentChooser subChooser;

        public JFileChooserJDialogFinder(TestOut output) {
            this.output = output;
            this.subChooser = new JFileChooserFinder();
        }

        public boolean checkComponent(Component comp) {
            if (comp != null && comp instanceof Window && ((Window)comp).isVisible()) {
                ComponentSearcher searcher = new ComponentSearcher((Container)comp);
                searcher.setOutput(this.output);
                return searcher.findComponent(this.subChooser) != null;
            }
            return false;
        }

        public String getDescription() {
            return "JFileChooser's window";
        }
    }
}

