/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.Component;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.editor.filecreation.CndPanel;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanelGUI;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class NewCndFileChooserPanel
extends CndPanel {
    private final MIMEExtensions es;
    private final String defaultExt;
    private final boolean fileWithoutExtension;

    NewCndFileChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, MIMEExtensions es, String defaultExt) {
        super(project, folders, bottomPanel);
        this.es = es;
        this.defaultExt = defaultExt;
        this.fileWithoutExtension = "".equals(defaultExt);
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new NewCndFileChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.es, this.defaultExt);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    @Override
    protected void doStoreSettings(WizardDescriptor settings) {
        if (this.getTargetExtension().length() > 0) {
            if (((NewCndFileChooserPanelGUI)this.gui).useTargetExtensionAsDefault()) {
                this.es.setDefaultExtension(this.getTargetExtension());
            } else {
                this.es.addExtension(this.getTargetExtension());
            }
        }
    }

    @Override
    public boolean isValid() {
        String errorMessage;
        boolean ok = super.isValid();
        this.setErrorMessage("");
        if (!ok) {
            return false;
        }
        String documentName = this.gui.getTargetName();
        if (!this.fileWithoutExtension && this.getTargetExtension().length() == 0 || documentName.charAt(0) == '.') {
            this.setErrorMessage(NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_Invalid_File_Name"));
            return false;
        }
        if (!this.fileWithoutExtension && !this.es.getValues().contains(this.getTargetExtension())) {
            String msg = NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_new_extension_introduced", (Object)this.getTargetExtension());
            this.setErrorMessage(msg);
        }
        if ((errorMessage = NewCndFileChooserPanel.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), documentName, false)) != null) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    private String getTargetExtension() {
        return ((NewCndFileChooserPanelGUI)this.gui).getTargetExtension();
    }
}

