/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.ruby.railsprojects.ui.FoldersListSettings;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class SourceRoots {
    public static final String PROP_ROOT_PROPERTIES = "rootProperties";
    public static final String PROP_ROOTS = "roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_src.dir");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_test.src.dir");
    private boolean showRSpec;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final String elementName;
    private final String newRootNameTemplate;
    private List<String> sourceRootProperties;
    private List<String> sourceRootNames;
    private List<FileObject> sourceRoots;
    private List<FileObject> plainFiles;
    private List<URL> sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final boolean isTest;
    private final File projectDir;
    private static final String DEFAULT_IGNORED_FILES = "^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(?!htaccess$).*$";

    SourceRoots(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, String elementName, boolean isTest, String newRootNameTemplate) {
        assert (helper != null && evaluator != null && refHelper != null && elementName != null && newRootNameTemplate != null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.elementName = elementName;
        this.isTest = isTest;
        this.newRootNameTemplate = newRootNameTemplate;
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getRakeProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
        this.helper.getRakeProjectHelper().addRakeProjectListener((RakeProjectListener)WeakListeners.create(RakeProjectListener.class, (EventListener)this.listener, (Object)this.helper));
        this.showRSpec = true;
    }

    private String getNodeDescription(String key) {
        return NbBundle.getMessage(SourceRoots.class, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRoots() {
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (this.sourceRoots == null) {
                if (this.isTest) {
                    this.initializeTestRoots();
                } else if (FoldersListSettings.getDefault().getLogicalView()) {
                    this.initializeRootsLogical();
                } else {
                    this.initializeRootsFiles();
                }
            }
        }
    }

    private void initializeTestRoots() {
        this.sourceRootNames = new ArrayList<String>();
        this.sourceRootProperties = new ArrayList<String>();
        if (this.showRSpec) {
            this.sourceRootNames.add(this.getNodeDescription("rspec"));
            this.sourceRootProperties.add("spec");
        }
        this.sourceRootNames.add(this.getNodeDescription("test"));
        this.sourceRootProperties.add("test");
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (String p : this.sourceRootProperties) {
            FileObject f = this.helper.getRakeProjectHelper().resolveFileObject(p);
            if (f == null) continue;
            if (FileUtil.isArchiveFile((FileObject)f)) {
                f = FileUtil.getArchiveRoot((FileObject)f);
            }
            result.add(f);
        }
        this.sourceRoots = Collections.unmodifiableList(result);
    }

    private void addPlainFiles(FileObject dir, String ... fileNames) {
        this.plainFiles = new ArrayList<FileObject>(20);
        for (String fileName : fileNames) {
            FileObject toAdd = dir.getFileObject(fileName);
            if (toAdd == null) continue;
            this.plainFiles.add(toAdd);
        }
    }

    private void initializeRootsLogical() {
        List<String> missing;
        FileObject fo = this.helper.getRakeProjectHelper().getProjectDirectory();
        this.addPlainFiles(fo, "Capfile", "Gemfile", "Rakefile", "README");
        boolean metal = fo.getFileObject("app/metal") != null;
        boolean mails = fo.getFileObject("app/mails") != null;
        boolean middleware = fo.getFileObject("app/middleware") != null;
        boolean reports = fo.getFileObject("app/reports") != null;
        this.sourceRootNames = new ArrayList<String>(20);
        this.sourceRootProperties = new ArrayList<String>(20);
        this.sourceRootNames.add(this.getNodeDescription("app_controllers"));
        this.sourceRootNames.add(this.getNodeDescription("app_helpers"));
        if (metal) {
            this.sourceRootNames.add(this.getNodeDescription("app_metal"));
        }
        if (mails) {
            this.sourceRootNames.add(this.getNodeDescription("app_mails"));
        }
        if (middleware) {
            this.sourceRootNames.add(this.getNodeDescription("app_middleware"));
        }
        if (reports) {
            this.sourceRootNames.add(this.getNodeDescription("app_reports"));
        }
        this.sourceRootNames.add(this.getNodeDescription("app_models"));
        this.sourceRootNames.add(this.getNodeDescription("app_views"));
        this.sourceRootProperties.add("app/controllers");
        this.sourceRootProperties.add("app/helpers");
        if (metal) {
            this.sourceRootProperties.add("app/metal");
        }
        if (mails) {
            this.sourceRootProperties.add("app/mails");
        }
        if (middleware) {
            this.sourceRootProperties.add("app/middleware");
        }
        if (reports) {
            this.sourceRootProperties.add("app/reports");
        }
        this.sourceRootProperties.add("app/models");
        this.sourceRootProperties.add("app/views");
        FileObject app = fo.getFileObject("app");
        if (app != null) {
            HashSet<String> knownAppDirs = new HashSet<String>();
            knownAppDirs.add("controllers");
            knownAppDirs.add("helpers");
            knownAppDirs.add("models");
            knownAppDirs.add("views");
            knownAppDirs.add("reports");
            knownAppDirs.add("metal");
            knownAppDirs.add("mails");
            missing = SourceRoots.findUnknownFolders(app, knownAppDirs);
            if (missing != null) {
                for (String name : missing) {
                    String combinedName = "app/" + name;
                    this.sourceRootNames.add(combinedName);
                    this.sourceRootProperties.add(combinedName);
                }
            }
        }
        this.sourceRootNames.add(this.getNodeDescription("components"));
        this.sourceRootProperties.add("components");
        this.sourceRootNames.add(this.getNodeDescription("config"));
        this.sourceRootProperties.add("config");
        this.sourceRootNames.add(this.getNodeDescription("db"));
        this.sourceRootProperties.add("db");
        this.sourceRootNames.add(this.getNodeDescription("lib"));
        this.sourceRootProperties.add("lib");
        this.sourceRootNames.add(this.getNodeDescription("log"));
        this.sourceRootProperties.add("log");
        this.sourceRootNames.add(this.getNodeDescription("public"));
        this.sourceRootProperties.add("public");
        if (this.showRSpec) {
            this.sourceRootNames.add(this.getNodeDescription("rspec"));
            this.sourceRootProperties.add("spec");
        }
        this.sourceRootNames.add(this.getNodeDescription("test"));
        this.sourceRootProperties.add("test");
        this.sourceRootNames.add(this.getNodeDescription("script"));
        this.sourceRootProperties.add("script");
        this.sourceRootNames.add(this.getNodeDescription("doc"));
        this.sourceRootProperties.add("doc");
        this.sourceRootNames.add(this.getNodeDescription("vendor"));
        this.sourceRootProperties.add("vendor");
        if (fo != null) {
            HashSet<String> knownTopDirs = new HashSet<String>();
            knownTopDirs.add("nbproject");
            knownTopDirs.add("tmp");
            knownTopDirs.add("app");
            knownTopDirs.add("components");
            knownTopDirs.add("config");
            knownTopDirs.add("db");
            knownTopDirs.add("lib");
            knownTopDirs.add("log");
            knownTopDirs.add("public");
            knownTopDirs.add("spec");
            knownTopDirs.add("lib");
            knownTopDirs.add("test");
            knownTopDirs.add("doc");
            knownTopDirs.add("script");
            knownTopDirs.add("vendor");
            missing = SourceRoots.findUnknownFolders(fo, knownTopDirs);
            if (missing != null) {
                for (String name : missing) {
                    this.sourceRootNames.add(name);
                    this.sourceRootProperties.add(name);
                }
            }
        }
        assert (this.sourceRoots == null);
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (String p : this.sourceRootProperties) {
            FileObject f = this.helper.getRakeProjectHelper().resolveFileObject(p);
            if (f == null) continue;
            if (FileUtil.isArchiveFile((FileObject)f)) {
                f = FileUtil.getArchiveRoot((FileObject)f);
            }
            result.add(f);
        }
        this.sourceRoots = Collections.unmodifiableList(result);
    }

    private static List<String> findUnknownFolders(FileObject folder, Set<String> known) {
        ArrayList<String> result = null;
        for (FileObject child : folder.getChildren()) {
            String name;
            if (!child.isFolder() || known.contains(name = child.getNameExt()) || !SourceRoots.isVisible(child)) continue;
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(name);
        }
        if (result != null) {
            Collections.sort(result);
        }
        return result;
    }

    private static boolean isVisible(FileObject child) {
        return !child.getNameExt().matches(DEFAULT_IGNORED_FILES);
    }

    private void initializeRootsFiles() {
        FileObject[] children;
        FileObject fo = this.helper.getRakeProjectHelper().getProjectDirectory();
        if (fo == null) {
            this.initializeRootsLogical();
            return;
        }
        assert (this.sourceRoots == null);
        ArrayList<FileObject> result = new ArrayList<FileObject>(20);
        this.sourceRootNames = new ArrayList<String>(20);
        this.sourceRootProperties = new ArrayList<String>(20);
        this.plainFiles = new ArrayList<FileObject>(20);
        for (FileObject f : children = fo.getChildren()) {
            if (!VisibilityQuery.getDefault().isVisible(f)) continue;
            if (FileUtil.isArchiveFile((FileObject)f)) {
                f = FileUtil.getArchiveRoot((FileObject)f);
            }
            if (f.isFolder()) {
                String name = f.getName();
                if (name.equals("nbproject") || name.equals("tmp")) continue;
                result.add(f);
                continue;
            }
            this.plainFiles.add(f);
        }
        Collections.sort(result, new Comparator<FileObject>(){

            @Override
            public int compare(FileObject f1, FileObject f2) {
                return f1.getNameExt().compareTo(f2.getNameExt());
            }
        });
        for (FileObject f : result) {
            String name = f.getNameExt();
            this.sourceRootNames.add(name);
            this.sourceRootProperties.add(name);
        }
        this.sourceRoots = Collections.unmodifiableList(result);
    }

    public String[] getRootNames() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootNames == null) {
                        SourceRoots.this.initializeRoots();
                    }
                    assert (SourceRoots.this.sourceRootNames != null);
                    return SourceRoots.this.sourceRootNames.toArray(new String[SourceRoots.this.sourceRootNames.size()]);
                }
            }
        });
    }

    public String[] getRootProperties() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootProperties == null) {
                        SourceRoots.this.initializeRoots();
                    }
                    assert (SourceRoots.this.sourceRootProperties != null);
                    return SourceRoots.this.sourceRootProperties.toArray(new String[SourceRoots.this.sourceRootProperties.size()]);
                }
            }
        });
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    SourceRoots.this.initializeRoots();
                    assert (SourceRoots.this.sourceRoots != null);
                    return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
                }
            }
        });
    }

    public FileObject[] getExtraFiles() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    SourceRoots.this.initializeRoots();
                    assert (SourceRoots.this.plainFiles != null);
                    return SourceRoots.this.plainFiles.toArray(new FileObject[SourceRoots.this.plainFiles.size()]);
                }
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URL[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] run() {
                6 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        String[] srcProps = SourceRoots.this.getRootProperties();
                        ArrayList<URL> result = new ArrayList<URL>();
                        for (int i = 0; i < srcProps.length; ++i) {
                            String prop = srcProps[i];
                            if (prop == null) continue;
                            File f = SourceRoots.this.helper.getRakeProjectHelper().resolveFile(prop);
                            try {
                                URL url = f.toURI().toURL();
                                if (!f.exists()) {
                                    url = new URL(url.toExternalForm() + "/");
                                }
                                result.add(url);
                                continue;
                            }
                            catch (MalformedURLException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(result);
                    }
                }
                return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String getRootDisplayName(String rootName, String propName) {
        if (rootName == null || rootName.length() == 0) {
            String propValue = this.evaluator.getProperty(propName);
            File sourceRoot = propValue == null ? null : this.helper.getRakeProjectHelper().resolveFile(propValue);
            rootName = this.createInitialDisplayName(sourceRoot);
        }
        return rootName;
    }

    public String createInitialDisplayName(File sourceRoot) {
        String pdPath;
        String srPath;
        String rootName = sourceRoot != null ? ((srPath = sourceRoot.getAbsolutePath()).startsWith(pdPath = this.projectDir.getAbsolutePath() + File.separatorChar) ? srPath.substring(pdPath.length()) : sourceRoot.getAbsolutePath()) : (this.isTest ? DEFAULT_TEST_LABEL : DEFAULT_SOURCE_LABEL);
        return rootName;
    }

    public boolean isTest() {
        return this.isTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(boolean isXMLChange, String propName) {
        boolean fire = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (isXMLChange) {
                this.sourceRootProperties = null;
                this.sourceRootNames = null;
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                fire = true;
            } else if (propName == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(propName)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                fire = true;
            }
        }
        if (fire) {
            if (isXMLChange) {
                this.support.firePropertyChange(PROP_ROOT_PROPERTIES, null, null);
            }
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private class ProjectMetadataListener
    implements PropertyChangeListener,
    RakeProjectListener {
        private ProjectMetadataListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SourceRoots.this.resetCache(false, evt.getPropertyName());
        }

        public void configurationXmlChanged(RakeProjectEvent ev) {
            SourceRoots.this.resetCache(true, null);
        }

        public void propertiesChanged(RakeProjectEvent ev) {
        }
    }
}

