/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class Deprecations
extends RubyAstRule {
    static Set<NodeType> kinds = new HashSet<NodeType>();
    private static Map<String, Deprecation> deprecatedMethods = new HashMap<String, Deprecation>();
    private static Map<String, Deprecation> deprecatedRequires = new HashMap<String, Deprecation>();

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return kinds;
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        boolean isRequire;
        Node node = context.node;
        ParserResult info = context.parserResult;
        String name = ((INameNode)node).getName();
        Deprecation deprecation = null;
        if ("require".equals(name)) {
            isRequire = true;
            String require = Deprecations.getStringArg(node);
            if (require != null) {
                deprecation = deprecatedRequires.get(require);
            }
        } else if (deprecatedMethods.containsKey(name)) {
            isRequire = false;
            deprecation = deprecatedMethods.get(name);
        } else {
            return;
        }
        if (deprecation != null) {
            OffsetRange range = AstUtilities.getNameRange((Node)node);
            if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) != OffsetRange.NONE) {
                String defaultKey = isRequire ? "DeprecatedRequire" : "DeprecatedMethodUse";
                String message = NbBundle.getMessage(Deprecations.class, (String)(deprecation.descriptionKey != null ? deprecation.descriptionKey : defaultKey), (Object)deprecation.oldName, (Object)deprecation.newName);
                ArrayList<DeprecationCallFix> fixes = new ArrayList<DeprecationCallFix>();
                if (!isRequire) {
                    fixes.add(new DeprecationCallFix(context, node, deprecation, false));
                }
                if (deprecation.helpUrl != null) {
                    fixes.add(new DeprecationCallFix(context, node, deprecation, true));
                }
                Hint desc = new Hint((Rule)this, message, RubyUtils.getFileObject((Parser.Result)info), range, fixes, 100);
                result.add(desc);
            }
        }
    }

    private static String getStringArg(Node node) {
        String require;
        Node n;
        ListNode args;
        Node argsNode;
        if (node.getNodeType() == NodeType.FCALLNODE && (argsNode = ((FCallNode)node).getArgsNode()) instanceof ListNode && (args = (ListNode)argsNode).size() > 0 && (n = args.get(0)) instanceof StrNode && (require = ((StrNode)n).getValue()) != null && require.length() > 0) {
            return require.toString();
        }
        return null;
    }

    public void cancel() {
    }

    public String getId() {
        return "Deprecations";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(Deprecations.class, (String)"Deprecation");
    }

    public String getDescription() {
        return NbBundle.getMessage(Deprecations.class, (String)"DeprecationDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    static {
        kinds.add(NodeType.FCALLNODE);
        kinds.add(NodeType.VCALLNODE);
        kinds.add(NodeType.CALLNODE);
        Deprecation require_gem = new Deprecation("require_gem", "gem", "HELP_require_gem", "http://www.ruby-forum.com/topic/136010");
        deprecatedMethods.put(require_gem.oldName, require_gem);
        Deprecation assert_raises = new Deprecation("assert_raises", "assert_raise", "HELP_assert_raises", "http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-talk/155815");
        deprecatedMethods.put(assert_raises.oldName, assert_raises);
        Deprecation d = new Deprecation("getopts", "optparse", null, null);
        deprecatedRequires.put(d.oldName, d);
        d = new Deprecation("cgi-lib", "cgi", null, null);
        deprecatedRequires.put(d.oldName, d);
        d = new Deprecation("importenv", "(no replacement)", null, null);
        deprecatedRequires.put(d.oldName, d);
        d = new Deprecation("parsearg", "optparse", null, null);
        deprecatedRequires.put(d.oldName, d);
        d = new Deprecation("ftools", "fileutils", "HELP_ftools", null);
        deprecatedRequires.put(d.oldName, d);
    }

    static class DeprecationCallFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final Node node;
        private final Deprecation deprecation;
        private final boolean help;

        public DeprecationCallFix(RubyRuleContext context, Node node, Deprecation deprecation, boolean help) {
            this.context = context;
            this.node = node;
            this.deprecation = deprecation;
            this.help = help;
        }

        public String getDescription() {
            if (this.help) {
                return NbBundle.getMessage(Deprecations.class, (String)"ShowDeprecationHelp");
            }
            return NbBundle.getMessage(Deprecations.class, (String)"DeprecationFix", (Object)this.deprecation.oldName, (Object)this.deprecation.newName);
        }

        public void implement() throws Exception {
            if (this.help) {
                URL url = new URL(this.deprecation.helpUrl);
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            } else {
                EditList edits = this.getEditList();
                if (edits != null) {
                    edits.apply();
                }
            }
        }

        public EditList getEditList() throws Exception {
            BaseDocument doc = this.context.doc;
            OffsetRange range = null;
            range = AstUtilities.isCall((Node)this.node) ? AstUtilities.getCallRange((Node)this.node) : AstUtilities.getRange((Node)this.node);
            EditList list = new EditList(doc);
            if (range != OffsetRange.NONE) {
                if ("require_gem".equals(this.deprecation.oldName)) {
                    String gemName = Deprecations.getStringArg(this.node);
                    int rowEnd = Utilities.getRowEnd((BaseDocument)doc, (int)range.getStart());
                    list.replace(range.getStart(), range.getLength(), this.deprecation.newName, false, 0);
                    if (gemName != null) {
                        list.replace(rowEnd, 0, "\nrequire \"" + gemName + "\"", false, 1);
                    }
                    list.setFormatAll(true);
                } else {
                    list.replace(range.getStart(), range.getLength(), this.deprecation.newName, false, 0);
                }
            }
            return list;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return !this.help;
        }
    }

    static class Deprecation {
        final String oldName;
        final String newName;
        final String descriptionKey;
        final String helpUrl;
        final boolean enableFix;

        public Deprecation(String oldName, String newName, String descriptionKey, String helpUrl) {
            this(oldName, newName, descriptionKey, helpUrl, true);
        }

        public Deprecation(String oldName, String newName, String descriptionKey, String helpUrl, boolean enableFix) {
            this.oldName = oldName;
            this.newName = newName;
            this.descriptionKey = descriptionKey;
            this.helpUrl = helpUrl;
            this.enableFix = enableFix;
        }
    }
}

