/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class VariablesModel {
    private static final String VARIABLE_PREFIX = "var.";
    private List<Variable> vars = this.readVariables();

    VariablesModel() {
    }

    public List<Variable> getVariables() {
        return this.vars;
    }

    public Variable find(String name) {
        return VariablesModel.find(name, this.vars);
    }

    private static Variable find(String name, List<Variable> vs) {
        for (Variable v : vs) {
            if (!v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    void remove(Variable var) {
        this.vars.remove(var);
    }

    void save() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                EditableProperties ep = PropertyUtils.getGlobalProperties();
                boolean change = false;
                List old = VariablesModel.this.readVariables();
                for (Variable var : VariablesModel.this.vars) {
                    Variable oldVar = VariablesModel.find(var.getName(), old);
                    if (oldVar == null || !oldVar.getValue().equals(var.getValue())) {
                        ep.put(VariablesModel.VARIABLE_PREFIX + var.getName(), var.getValue().getAbsolutePath());
                        change = true;
                    }
                    if (oldVar == null) continue;
                    old.remove(oldVar);
                }
                for (Variable v : old) {
                    ep.remove(VariablesModel.VARIABLE_PREFIX + v.getName());
                    change = true;
                }
                if (change) {
                    try {
                        PropertyUtils.putGlobalProperties(ep);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }

    private List<Variable> readVariables() {
        ArrayList<Variable> vs = new ArrayList<Variable>();
        EditableProperties ep = PropertyUtils.getGlobalProperties();
        for (Map.Entry<String, String> entry : ep.entrySet()) {
            if (!entry.getKey().startsWith(VARIABLE_PREFIX)) continue;
            vs.add(new Variable(entry.getKey().substring(VARIABLE_PREFIX.length()), FileUtil.normalizeFile((File)new File(entry.getValue()))));
        }
        return vs;
    }

    public void add(String name, File location) {
        assert (this.find(name) == null) : name;
        this.vars.add(new Variable(name, location));
    }

    public String getRelativePath(File path, boolean forDisplay) {
        for (Variable v : this.vars) {
            if (!path.getAbsolutePath().startsWith(v.getValue().getAbsolutePath())) continue;
            String s = forDisplay ? v.name : "${var." + v.name + "}";
            String p = path.getAbsolutePath().substring(v.getValue().getAbsolutePath().length()).replace('\\', '/');
            if (p.startsWith("/")) {
                p = p.substring(1);
            }
            return s + "/" + p;
        }
        return null;
    }

    public static class Variable {
        private String name;
        private File value;

        public Variable(String name, File value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public File getValue() {
            return this.value;
        }

        public boolean equals(Object arg0) {
            return this.name.equals(((Variable)arg0).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void setValue(File loc) {
            this.value = loc;
        }

        public String toString() {
            return "var[" + this.getName() + "=" + this.getValue().getAbsolutePath() + "]";
        }
    }
}

