/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.border;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.border.BevelBorder;
import org.netbeans.modules.visual.border.CompositeBorder;
import org.netbeans.modules.visual.border.DashedBorder;
import org.netbeans.modules.visual.border.EmptyBorder;
import org.netbeans.modules.visual.border.FancyDashedBorder;
import org.netbeans.modules.visual.border.ImageBorder;
import org.netbeans.modules.visual.border.LineBorder;
import org.netbeans.modules.visual.border.ResizeBorder;
import org.netbeans.modules.visual.border.RoundedBorder;
import org.netbeans.modules.visual.border.SwingBorder;
import org.netbeans.modules.visual.util.GeomUtil;
import org.openide.util.Parameters;

public final class BorderFactory {
    private static final Border BORDER_EMPTY = new EmptyBorder(0, 0, 0, 0, false);
    private static final Border BORDER_LINE = BorderFactory.createLineBorder(1);

    private BorderFactory() {
    }

    public static Border createEmptyBorder() {
        return BORDER_EMPTY;
    }

    public static Border createEmptyBorder(int thickness) {
        return thickness > 0 ? BorderFactory.createEmptyBorder(thickness, thickness, thickness, thickness) : BORDER_EMPTY;
    }

    public static Border createEmptyBorder(int horizontal, int vertical) {
        return BorderFactory.createEmptyBorder(vertical, horizontal, vertical, horizontal);
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        return new EmptyBorder(top, left, bottom, right, false);
    }

    public static Border createOpaqueBorder(int top, int left, int bottom, int right) {
        return new EmptyBorder(top, left, bottom, right, true);
    }

    public static Border createCompositeBorder(Border ... borders) {
        return new CompositeBorder(borders);
    }

    public static Border createSwingBorder(Scene scene, javax.swing.border.Border border) {
        Parameters.notNull((CharSequence)"scene", (Object)scene);
        Parameters.notNull((CharSequence)"border", (Object)border);
        return new SwingBorder(scene, border);
    }

    public static Border createLineBorder() {
        return BORDER_LINE;
    }

    public static Border createLineBorder(String property, Widget associated) {
        return BorderFactory.createLineBorder(1, property, associated);
    }

    public static Border createLineBorder(String property, ResourceTable table) {
        return BorderFactory.createLineBorder(1, property, table);
    }

    public static Border createLineBorder(int thickness) {
        return BorderFactory.createLineBorder(thickness, null);
    }

    public static Border createLineBorder(int thickness, Color color) {
        return new LineBorder(thickness, thickness, thickness, thickness, color != null ? color : Color.BLACK);
    }

    public static Border createLineBorder(int thickness, String property, Widget associated) {
        return new LineBorder(thickness, thickness, thickness, thickness, property, associated);
    }

    public static Border createLineBorder(int thickness, String property, ResourceTable table) {
        return new LineBorder(thickness, thickness, thickness, thickness, property, table);
    }

    public static Border createLineBorder(int top, int left, int bottom, int right, Color color) {
        return new LineBorder(top, left, bottom, right, color != null ? color : Color.BLACK);
    }

    public static Border createLineBorder(int top, int left, int bottom, int right, String property, Widget associated) {
        return new LineBorder(top, left, bottom, right, property, associated);
    }

    public static Border createLineBorder(int top, int left, int bottom, int right, String property, ResourceTable table) {
        return new LineBorder(top, left, bottom, right, property, table);
    }

    public static Border createBevelBorder(boolean raised) {
        return BorderFactory.createBevelBorder(raised, null);
    }

    public static Border createBevelBorder(boolean raised, Color color) {
        return new BevelBorder(raised, color != null ? color : Color.GRAY);
    }

    public static Border createBevelBorder(boolean raised, String property, ResourceTable table) {
        return new BevelBorder(raised, property, table);
    }

    public static Border createBevelBorder(boolean raised, String property, Widget associated) {
        return new BevelBorder(raised, property, associated);
    }

    public static Border createImageBorder(Insets insets, Image image) {
        return BorderFactory.createImageBorder(insets, insets, image);
    }

    public static Border createImageBorder(Insets borderInsets, Insets imageInsets, Image image) {
        assert (borderInsets != null && imageInsets != null && image != null);
        return new ImageBorder(borderInsets, imageInsets, image);
    }

    public static Border createRoundedBorder(int arcWidth, int arcHeight, Color fillColor, Color drawColor) {
        return BorderFactory.createRoundedBorder(arcWidth, arcHeight, arcWidth, arcHeight, fillColor, drawColor);
    }

    public static Border createRoundedBorder(int arcWidth, int arcHeight, String fillProperty, String drawProperty, Widget associated) {
        return BorderFactory.createRoundedBorder(arcWidth, arcHeight, arcWidth, arcHeight, fillProperty, drawProperty, associated);
    }

    public static Border createRoundedBorder(int arcWidth, int arcHeight, String fillProperty, String drawProperty, ResourceTable table) {
        return BorderFactory.createRoundedBorder(arcWidth, arcHeight, arcWidth, arcHeight, fillProperty, drawProperty, table);
    }

    public static Border createRoundedBorder(int arcWidth, int arcHeight, int insetWidth, int insetHeight, Color fillColor, Color drawColor) {
        return new RoundedBorder(arcWidth, arcHeight, insetWidth, insetHeight, fillColor, drawColor);
    }

    public static Border createRoundedBorder(int arcWidth, int arcHeight, int insetWidth, int insetHeight, String fillProperty, String drawProperty, ResourceTable table) {
        return new RoundedBorder(arcWidth, arcHeight, insetWidth, insetHeight, fillProperty, drawProperty, table);
    }

    public static Border createRoundedBorder(int arcWidth, int arcHeight, int insetWidth, int insetHeight, String fillProperty, String drawProperty, Widget associated) {
        return new RoundedBorder(arcWidth, arcHeight, insetWidth, insetHeight, fillProperty, drawProperty, associated);
    }

    public static Border createResizeBorder(int thickness) {
        return BorderFactory.createResizeBorder(thickness, null, false);
    }

    public static Border createResizeBorder(int thickness, String property, Widget assocaited) {
        return BorderFactory.createResizeBorder(thickness, property, assocaited, false);
    }

    public static Border createResizeBorder(int thickness, String property, ResourceTable table) {
        return BorderFactory.createResizeBorder(thickness, property, table, false);
    }

    public static Border createResizeBorder(int thickness, Color color, boolean outer) {
        return new ResizeBorder(thickness, color != null ? color : Color.BLACK, outer);
    }

    public static Border createResizeBorder(int thickness, String property, Widget associated, boolean outer) {
        return new ResizeBorder(thickness, property, associated, outer);
    }

    public static Border createResizeBorder(int thickness, String property, ResourceTable table, boolean outer) {
        return new ResizeBorder(thickness, property, table, outer);
    }

    public static Border createDashedBorder(Color color, int width, int height) {
        return BorderFactory.createDashedBorder(color, width, height, false);
    }

    public static Border createDashedBorder(String property, Widget associated, int width, int height) {
        return BorderFactory.createDashedBorder(property, associated, width, height, false);
    }

    public static Border createDashedBorder(String property, ResourceTable table, int width, int height) {
        return BorderFactory.createDashedBorder(property, table, width, height, false);
    }

    public static Border createDashedBorder(Color color, int width, int height, boolean squares) {
        if (!squares) {
            return new FancyDashedBorder(color != null ? color : Color.BLACK, width, height);
        }
        return new DashedBorder(color != null ? color : Color.BLACK, width, (float)height);
    }

    public static Border createDashedBorder(String property, Widget associated, int width, int height, boolean squares) {
        if (!squares) {
            return new FancyDashedBorder(property, associated, width, height);
        }
        return new DashedBorder(property, associated, (float)width, (float)height);
    }

    public static Border createDashedBorder(String property, ResourceTable table, int width, int height, boolean squares) {
        if (!squares) {
            return new FancyDashedBorder(property, table, width, height);
        }
        return new DashedBorder(property, table, (float)width, (float)height);
    }

    public static Border createFancyDashedBorder(Color color, int width, int height) {
        GeomUtil.LOG.warning("BorderFactory.createFancyDashedBorder() method is deprecated. Use BorderFactory.createDashedBorder(color,width,height,true) method instead.");
        return new FancyDashedBorder(color != null ? color : Color.BLACK, width, height);
    }
}

