/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.util.prefs.Preferences;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.openide.util.NbPreferences;

public class HintsSettings {
    static final HintSeverity SEVERITY_DEFAUT = HintSeverity.WARNING;
    static final boolean IN_TASK_LIST_DEFAULT = true;
    static final String ENABLED_KEY = "enabled";
    static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private static final String DEFAULT_PROFILE = "default";

    private HintsSettings() {
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static Preferences getPreferences(GsfHintsManager manager, Rule.UserConfigurableRule rule, String profile) {
        profile = profile == null ? HintsSettings.getCurrentProfileId() : profile;
        return NbPreferences.forModule(HintsSettings.class).node(profile).node(manager.getId() + rule.getId());
    }

    public static HintSeverity getSeverity(GsfHintsManager manager, Rule.UserConfigurableRule rule) {
        return HintsSettings.getSeverity(rule, HintsSettings.getPreferences(manager, rule, HintsSettings.getCurrentProfileId()));
    }

    public static boolean isEnabled(GsfHintsManager manager, Rule.UserConfigurableRule hint) {
        Preferences p = HintsSettings.getPreferences(manager, hint, HintsSettings.getCurrentProfileId());
        return HintsSettings.isEnabled(manager, hint, p);
    }

    public static boolean isShowInTaskList(GsfHintsManager manager, Rule.UserConfigurableRule hint) {
        Preferences p = HintsSettings.getPreferences(manager, hint, HintsSettings.getCurrentProfileId());
        return HintsSettings.isShowInTaskList(hint, p);
    }

    public static boolean isEnabled(HintsProvider.HintsManager manager, Rule.UserConfigurableRule hint, Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, hint.getDefaultEnabled());
    }

    public static void setEnabled(Preferences p, boolean value) {
        p.putBoolean(ENABLED_KEY, value);
    }

    public static boolean isShowInTaskList(Rule.UserConfigurableRule hint, Preferences preferences) {
        return preferences.getBoolean(IN_TASK_LIST_KEY, hint.showInTasklist());
    }

    public static void setShowInTaskList(Preferences p, boolean value) {
        p.putBoolean(IN_TASK_LIST_KEY, value);
    }

    public static HintSeverity getSeverity(Rule.UserConfigurableRule hint, Preferences preferences) {
        String s = preferences.get(SEVERITY_KEY, null);
        return s == null ? hint.getDefaultSeverity() : HintSeverity.valueOf((String)s);
    }

    public static void setSeverity(Preferences p, HintSeverity severity) {
        p.put(SEVERITY_KEY, severity.name());
    }
}

