/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.types.TimeDuration;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapData;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataQuery;
import org.netbeans.modules.dlight.threadmap.storage.ThreadDataImpl;
import org.netbeans.modules.dlight.threadmap.storage.ThreadInfoImpl;

public class ThreadMapDataStorage
implements ProxyDataStorage {
    public static final String THREAD_MAP_STORAGE_TYPE_ID = "ThreadMapDataStorage";
    private static final List<ThreadMapDataStorage> instances = new ArrayList<ThreadMapDataStorage>();
    private final List<ThreadDataImpl> data = new LinkedList<ThreadDataImpl>();
    private TimeDuration frequency;
    private SQLDataStorage sqlStorage;

    public static final ThreadMapDataStorage getInstance() {
        return instances.get(0);
    }

    ThreadMapDataStorage() {
    }

    public void addThreadInfo(ThreadInfoImpl threadInfo) {
        this.data.add(new ThreadDataImpl(threadInfo));
    }

    public void addThreadState(ThreadInfoImpl threadInfo, ThreadState state) {
        for (ThreadDataImpl td : this.data) {
            if (td.getThreadInfo() != threadInfo) continue;
            td.addState(state);
            break;
        }
    }

    public final void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
    }

    public ThreadInfoImpl getThreadInfo(int tid) {
        for (ThreadDataImpl tmd : this.data) {
            if (tmd.getThreadInfo().getThreadId() != tid) continue;
            return tmd.getThreadInfo();
        }
        return null;
    }

    public void clear() {
        this.data.clear();
    }

    public void init(TimeDuration frequency, DataTableMetadata metadata) {
        this.clear();
        this.frequency = frequency;
    }

    public ThreadMapData queryThreadMapData(ThreadMapDataQuery query) {
        final ArrayList<ThreadDataImpl> threadsData = new ArrayList<ThreadDataImpl>();
        for (ThreadDataImpl td : this.data) {
            threadsData.add(td);
        }
        ThreadMapData result = new ThreadMapData(){

            @Override
            public List<ThreadData> getThreadsData() {
                return Collections.unmodifiableList(threadsData);
            }

            @Override
            public boolean isSamplingMode() {
                return false;
            }
        };
        return result;
    }

    public boolean shutdown() {
        this.clear();
        return true;
    }

    public DataStorageType getBackendDataStorageType() {
        return DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    }

    public List<DataTableMetadata> getBackendTablesMetadata() {
        return Collections.emptyList();
    }

    public void attachTo(DataStorage storage) {
        this.sqlStorage = (SQLDataStorage)storage;
    }

    public boolean hasData(DataTableMetadata data) {
        return false;
    }

    public void addData(String tableName, List<DataRow> data) {
        if (this.sqlStorage != null) {
            this.sqlStorage.addData(tableName, data);
        }
    }

    public void syncAddData(String tableName, List<DataRow> data) {
        if (this.sqlStorage != null) {
            this.sqlStorage.syncAddData(tableName, data);
        }
    }

    public Collection<DataStorageType> getStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType(THREAD_MAP_STORAGE_TYPE_ID));
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
    }

    static {
        instances.add(new ThreadMapDataStorage());
    }
}

