/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.FieldWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

public class ObjectFieldVariable
extends AbstractObjectVariable
implements org.netbeans.api.debugger.jpda.Field,
Refreshable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    protected Field field;
    private ObjectReference objectReference;
    private ReferenceType classType;
    private String genericSignature;
    private boolean valueSet = true;
    private final Object valueLock = new Object();
    private boolean valueRetrieved = false;
    private ObjectReference value;

    public ObjectFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, Field field, String string, ObjectReference objectReference2) {
        super(jPDADebuggerImpl, objectReference, ObjectFieldVariable.getID(string, field));
        this.field = field;
        this.objectReference = objectReference2;
    }

    private static String getID(String string, Field field) {
        try {
            return string + '.' + TypeComponentWrapper.name(field) + "^";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return string + '.' + internalExceptionWrapper.getCause().getLocalizedMessage() + "^";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return string + ".0^";
        }
    }

    public ObjectFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, Field field, String string, String string2, ObjectReference objectReference2) {
        this(jPDADebuggerImpl, objectReference, field, string, objectReference2);
        this.genericSignature = string2;
    }

    public ObjectFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, Field field, String string, String string2, ObjectReference objectReference) {
        this(jPDADebuggerImpl, null, field, string, string2, objectReference);
        this.valueSet = false;
    }

    public String getName() {
        try {
            return TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return ReferenceTypeWrapper.name(TypeComponentWrapper.declaringType(this.field));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public JPDAClassType getDeclaringClass() {
        return new JPDAClassTypeImpl(this.getDebugger(), this.getTheDeclaringClassType());
    }

    private ReferenceType getTheDeclaringClassType() {
        ReferenceType referenceType = this.classType;
        if (referenceType == null) {
            this.classType = referenceType = FieldVariable.getTheDeclaringClassType(this.objectReference, this.field);
        }
        return referenceType;
    }

    public String getDeclaredType() {
        try {
            return FieldWrapper.typeName(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    @Override
    public JPDAClassType getClassType() {
        Value value = this.getInnerValue();
        if (value != null) {
            return super.getClassType();
        }
        try {
            Type type;
            try {
                type = FieldWrapper.type(this.field);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return null;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                return null;
            }
            if (type instanceof ReferenceType) {
                return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)type);
            }
            return null;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            return null;
        }
    }

    public boolean isStatic() {
        return TypeComponentWrapper.isStatic0(this.field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Value getInnerValue() {
        if (this.valueSet) {
            return super.getInnerValue();
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                Value value;
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("STARTED (OFV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ")");
                    } else {
                        logger.fine("STARTED (OFV): " + this.objectReference + ".getValue(" + this.field + ")");
                    }
                }
                try {
                    value = this.objectReference == null ? ReferenceTypeWrapper.getValue(this.getTheDeclaringClassType(), this.field) : ObjectReferenceWrapper.getValue(this.objectReference, this.field);
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    value = null;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    value = null;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    value = null;
                }
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("FINISHED(OFV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ") = " + value);
                    } else {
                        logger.fine("FINISHED(OFV): " + this.objectReference + ".getValue(" + this.field + ") = " + value);
                    }
                    logger.log(Level.FINE, "Called from ", new IllegalStateException("TEST"));
                }
                this.value = (ObjectReference)value;
                this.valueRetrieved = true;
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        block15: {
            try {
                Object object;
                boolean bl = false;
                if (this.objectReference != null) {
                    ObjectReferenceWrapper.setValue(this.objectReference, this.field, value);
                    bl = true;
                } else {
                    object = this.getTheDeclaringClassType();
                    if (object instanceof ClassType) {
                        ClassType classType = (ClassType)object;
                        ClassTypeWrapper.setValue(classType, this.field, value);
                        bl = true;
                    }
                }
                if (!bl) {
                    throw new InvalidExpressionException(this.field.toString());
                }
                if (this.valueSet) break block15;
                object = this.valueLock;
                synchronized (object) {
                    this.value = (ObjectReference)value;
                }
            }
            catch (IllegalArgumentExceptionWrapper illegalArgumentExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)illegalArgumentExceptionWrapper.getCause());
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new InvalidExpressionException((Throwable)invalidTypeException);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                throw new InvalidExpressionException((Throwable)classNotLoadedException);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)internalExceptionWrapper);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)vMDisconnectedExceptionWrapper);
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)classNotPreparedExceptionWrapper);
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws RefreshFailedException {
        if (this.valueSet) {
            return;
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                this.getInnerValue();
            }
        }
    }

    @Override
    public synchronized boolean isCurrent() {
        return this.valueSet || this.valueRetrieved;
    }

    @Override
    public ObjectFieldVariable clone() {
        String string;
        try {
            string = TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            string = internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            string = "0";
        }
        ObjectFieldVariable objectFieldVariable = new ObjectFieldVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + string + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.genericSignature, this.objectReference);
        objectFieldVariable.classType = this.classType;
        return objectFieldVariable;
    }

    @Override
    public String toString() {
        try {
            return "ObjectFieldVariable " + TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "Disconnected";
        }
    }
}

