/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocalVariableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class ObjectLocalVariable
extends AbstractObjectVariable
implements org.netbeans.api.debugger.jpda.LocalVariable {
    LocalVariable local;
    JPDAThread thread;
    int depth;
    String className;
    String genericSignature;
    private int cloneNumber = 1;

    ObjectLocalVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, String string, LocalVariable localVariable, String string2, CallStackFrameImpl callStackFrameImpl) {
        this(jPDADebuggerImpl, objectReference, string, localVariable, string2, ObjectLocalVariable.getID(localVariable), callStackFrameImpl);
    }

    private static String getID(LocalVariable localVariable) {
        try {
            return LocalVariableWrapper.name(localVariable) + LocalVariableWrapper.hashCode(localVariable) + "^";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }

    private ObjectLocalVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, String string, LocalVariable localVariable, String string2, String string3, CallStackFrameImpl callStackFrameImpl) {
        super(jPDADebuggerImpl, objectReference, string2, string3);
        this.local = localVariable;
        if (callStackFrameImpl != null) {
            this.thread = callStackFrameImpl.getThread();
            this.depth = callStackFrameImpl.getFrameDepth();
        }
        this.className = string;
    }

    public String getName() {
        try {
            return LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }

    public String getClassName() {
        return this.className;
    }

    protected final void setClassName(String string) {
        this.className = string;
    }

    public String getDeclaredType() {
        try {
            return LocalVariableWrapper.typeName(this.local);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }

    @Override
    protected final void setValue(Value value) throws InvalidExpressionException {
        try {
            StackFrame stackFrame = ((CallStackFrameImpl)this.thread.getCallStack(this.depth, this.depth + 1)[0]).getStackFrame();
            StackFrameWrapper.setValue(stackFrame, this.local, value);
            this.setInnerValue(value);
        }
        catch (AbsentInformationException absentInformationException) {
            throw new InvalidExpressionException((Throwable)absentInformationException);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)invalidStackFrameExceptionWrapper);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    @Override
    public ObjectLocalVariable clone() {
        ObjectLocalVariable objectLocalVariable = new ObjectLocalVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.className, this.local, this.genericSignature, this.getID() + "_clone" + this.cloneNumber++, null);
        objectLocalVariable.depth = this.depth;
        objectLocalVariable.thread = this.thread;
        return objectLocalVariable;
    }

    final void setFrame(CallStackFrameImpl callStackFrameImpl) {
        this.thread = callStackFrameImpl.getThread();
        this.depth = callStackFrameImpl.getFrameDepth();
    }

    @Override
    public String toString() {
        try {
            return "ObjectLocalVariable " + LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "ObjectLocalVariable " + internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }
}

