/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

class FileContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    private final Object lock = new Lock();
    private final Map<CharSequence, FileEntry> myFiles = new ConcurrentHashMap<CharSequence, FileEntry>();
    private final Map<CharSequence, Object> canonicFiles = new ConcurrentHashMap<CharSequence, Object>();
    private static final FileContainer EMPTY = new FileContainer(){

        @Override
        public void put() {
        }

        @Override
        public void putFile(File file, FileImpl fileImpl, APTPreprocHandler.State state) {
        }

        @Override
        public void putPreprocState(File file, APTPreprocHandler.State state) {
        }
    };

    public FileContainer(ProjectBase projectBase) {
        super(new FileContainerKey(((Object)projectBase.getUniqueName()).toString()), false);
        this.put();
    }

    public FileContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        FileContainer.readStringToFileEntryMap(dataInput, this.myFiles);
        FileContainer.readStringToStringsArrMap(dataInput, this.canonicFiles);
    }

    private FileContainer() {
        super(null, false);
    }

    static FileContainer empty() {
        return EMPTY;
    }

    private void trace(Map<CharSequence, Object> map, String string) {
        System.err.printf("%s\n", string);
        for (Map.Entry<CharSequence, Object> entry : map.entrySet()) {
            System.err.printf("%s ->\n%s\n\n", entry.getKey(), entry.getValue());
        }
    }

    public void putFile(File file, FileImpl fileImpl, APTPreprocHandler.State state) {
        CharSequence charSequence = FileContainer.getFileKey(file, true);
        CsmUID<FileImpl> csmUID = RepositoryUtils.put(fileImpl);
        FileEntry fileEntry = new FileEntry(csmUID, state, charSequence);
        FileEntry fileEntry2 = this.myFiles.put(charSequence, fileEntry);
        this.addAlternativeFileKey(charSequence, fileEntry.canonical);
        if (fileEntry2 != null) {
            System.err.println("Replace file info for " + fileEntry2.fileNew + " with " + fileImpl);
        }
        this.put();
    }

    public void removeFile(CharSequence charSequence) {
        CharSequence charSequence2 = FileContainer.getFileKey(charSequence, false);
        FileEntry fileEntry = this.myFiles.remove(charSequence2);
        if (fileEntry != null) {
            this.removeAlternativeFileKey(fileEntry.canonical, charSequence2);
        }
        if (fileEntry == null || fileEntry.fileNew != null) {
            // empty if block
        }
        this.put();
    }

    public FileImpl getFile(File file, boolean bl) {
        FileEntry fileEntry = this.getFileEntry(file, bl, false);
        if (fileEntry == null) {
            return null;
        }
        CsmUID csmUID = fileEntry.fileNew;
        FileImpl fileImpl = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)fileEntry.fileNew);
        if (fileImpl == null) {
            DiagnosticExceptoins.register(new IllegalStateException("no file for UID " + csmUID));
        }
        return fileImpl;
    }

    public void putPreprocState(File file, APTPreprocHandler.State state) {
        assert (state != null) : "state can not be null state for file " + file;
        FileEntry fileEntry = this.getFileEntry(file, false, true);
        fileEntry.setState(state, FilePreprocessorConditionState.PARSING);
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePreprocState(File file) {
        FileEntry fileEntry = this.getFileEntry(file, false, false);
        if (fileEntry == null) {
            return;
        }
        Object object = fileEntry;
        synchronized (object) {
            fileEntry.invalidateStates();
        }
        if (TRACE_PP_STATE_OUT) {
            object = FileContainer.getFileKey(file, false);
            System.err.println("\nInvalidated state for file" + object + "\n");
        }
    }

    public Collection<APTPreprocHandler.State> getPreprocStates(File file) {
        FileEntry fileEntry = this.getFileEntry(file, false, false);
        if (fileEntry == null) {
            return Collections.emptyList();
        }
        return fileEntry.getPrerocStates();
    }

    public Collection<PreprocessorStatePair> getStatePairs(File file) {
        FileEntry fileEntry = this.getFileEntry(file, false, false);
        if (fileEntry == null) {
            return Collections.emptyList();
        }
        return fileEntry.getStatePairs();
    }

    public FileEntry getEntry(File file) {
        return this.getFileEntry(file, false, false);
    }

    public Object getLock(File file) {
        FileEntry fileEntry = this.getFileEntry(file, false, false);
        return fileEntry == null ? this.lock : fileEntry.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugClearState() {
        ArrayList<FileEntry> arrayList = new ArrayList<FileEntry>(this.myFiles.values());
        for (FileEntry fileEntry : arrayList) {
            Object object = fileEntry.getLock();
            synchronized (object) {
                fileEntry.debugClearState();
            }
        }
        this.put();
    }

    public Collection<CsmFile> getFiles() {
        ArrayList arrayList = new ArrayList(this.myFiles.values().size());
        this.getFiles2(arrayList);
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public Collection<CsmUID<CsmFile>> getFilesUID() {
        ArrayList<CsmUID<CsmFile>> arrayList = new ArrayList<CsmUID<CsmFile>>(this.myFiles.values().size());
        this.getFiles2(arrayList);
        return arrayList;
    }

    public Collection<FileImpl> getFileImpls() {
        ArrayList arrayList = new ArrayList(this.myFiles.values().size());
        this.getFiles2(arrayList);
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    private void getFiles2(List<CsmUID<CsmFile>> list) {
        ArrayList<FileEntry> arrayList = new ArrayList<FileEntry>(this.myFiles.values());
        for (FileEntry fileEntry : arrayList) {
            list.add((CsmUID<CsmFile>)fileEntry.fileNew);
        }
    }

    public void clear() {
        this.myFiles.clear();
        this.put();
    }

    public int getSize() {
        return this.myFiles.size();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        FileContainer.writeStringToFileEntryMap(dataOutput, this.myFiles);
        FileContainer.writeStringToStringsArrMap(dataOutput, this.canonicFiles);
    }

    public static CharSequence getFileKey(File file, boolean bl) {
        CndUtils.assertNormalized((File)file);
        String string = null;
        if (TraceFlags.USE_CANONICAL_PATH) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
        } else {
            string = file.getAbsolutePath();
        }
        return bl ? FilePathCache.getManager().getString((CharSequence)string) : DefaultCache.getManager().getString((CharSequence)string);
    }

    public static CharSequence getFileKey(CharSequence charSequence, boolean bl) {
        return bl ? FilePathCache.getManager().getString(charSequence) : DefaultCache.getManager().getString(charSequence);
    }

    private CharSequence getAlternativeFileKey(CharSequence charSequence) {
        Object object = this.canonicFiles.get(charSequence);
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object != null) {
            assert (((CharSequence[])object).length >= 2);
            return ((CharSequence[])object)[0];
        }
        return null;
    }

    private FileEntry getFileEntry(File file, boolean bl, boolean bl2) {
        CharSequence charSequence = FileContainer.getFileKey(file, bl2);
        FileEntry fileEntry = this.myFiles.get(charSequence);
        if (!(fileEntry != null || bl && TraceFlags.SYMLINK_AS_OWN_FILE)) {
            CharSequence charSequence2 = this.getAlternativeFileKey(charSequence);
            FileEntry fileEntry2 = fileEntry = charSequence2 == null ? null : this.myFiles.get(charSequence2);
            if (fileEntry != null && TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("alternative for " + charSequence + " is " + charSequence2));
            }
        }
        return fileEntry;
    }

    private void addAlternativeFileKey(CharSequence charSequenceArray, CharSequence charSequence) {
        CharSequence[] charSequenceArray2;
        Object object = this.canonicFiles.get(charSequence);
        if (object == null) {
            charSequenceArray2 = charSequenceArray;
        } else if (object instanceof CharSequence) {
            if (object.equals(charSequenceArray)) {
                return;
            }
            charSequenceArray2 = new CharSequence[]{(CharSequence)object, charSequenceArray};
        } else {
            CharSequence[] charSequenceArray3;
            for (CharSequence charSequence2 : charSequenceArray3 = (CharSequence[])object) {
                if (!charSequence2.equals(charSequenceArray)) continue;
                return;
            }
            CharSequence[] charSequenceArray4 = new CharSequence[charSequenceArray3.length + 1];
            System.arraycopy(charSequenceArray3, 0, charSequenceArray4, 0, charSequenceArray3.length);
            charSequenceArray4[charSequenceArray3.length] = charSequenceArray;
            charSequenceArray2 = charSequenceArray4;
        }
        this.canonicFiles.put(charSequence, charSequenceArray2);
        if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
            if (charSequenceArray2 instanceof CharSequence[]) {
                System.err.println("entry for " + charSequence + " while adding " + charSequenceArray + " is " + Arrays.asList(charSequenceArray2).toString());
            } else {
                System.err.println("entry for " + charSequence + " while adding " + charSequenceArray + " is " + charSequenceArray2);
            }
        }
    }

    private void removeAlternativeFileKey(CharSequence charSequence, CharSequence charSequence2) {
        CharSequence[] charSequenceArray;
        Object object = this.canonicFiles.get(charSequence);
        assert (object != null) : "no entry for " + charSequence + " of " + charSequence2;
        if (object instanceof CharSequence) {
            charSequenceArray = null;
        } else {
            CharSequence[] charSequenceArray2 = (CharSequence[])object;
            assert (charSequenceArray2.length >= 2);
            if (charSequenceArray2.length == 2) {
                charSequenceArray = charSequenceArray2[0].equals(charSequence2) ? charSequenceArray2[1] : charSequenceArray2[0];
            } else {
                CharSequence[] charSequenceArray3 = new CharSequence[charSequenceArray2.length - 1];
                int n = 0;
                for (CharSequence charSequence3 : charSequenceArray2) {
                    if (charSequence3.equals(charSequence2)) continue;
                    charSequenceArray3[n++] = charSequence3;
                }
                charSequenceArray = charSequenceArray3;
            }
        }
        if (charSequenceArray == null) {
            this.canonicFiles.remove(charSequence2);
            if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                System.err.println("removed entry for " + charSequence + " while removing " + charSequence2);
            }
        } else {
            this.canonicFiles.put(charSequence, charSequenceArray);
            if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                System.err.println("change entry for " + charSequence + " while removing " + charSequence2 + " to " + charSequenceArray);
            }
        }
    }

    private static void writeStringToFileEntryMap(DataOutput dataOutput, Map<CharSequence, FileEntry> map) throws IOException {
        assert (dataOutput != null);
        assert (map != null);
        int n = map.size();
        dataOutput.writeInt(n);
        Set<Map.Entry<CharSequence, FileEntry>> set = map.entrySet();
        for (Map.Entry<CharSequence, FileEntry> entry : set) {
            PersistentUtils.writeUTF(entry.getKey(), dataOutput);
            assert (entry.getValue() != null);
            entry.getValue().write(dataOutput);
        }
    }

    private static void readStringToFileEntryMap(DataInput dataInput, Map<CharSequence, FileEntry> map) throws IOException {
        assert (dataInput != null);
        assert (map != null);
        APTStringManager aPTStringManager = FilePathCache.getManager();
        map.clear();
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence = PersistentUtils.readUTF(dataInput, aPTStringManager);
            FileEntry fileEntry = new FileEntry(dataInput);
            assert (charSequence != null);
            assert (fileEntry != null);
            map.put(charSequence, fileEntry);
        }
    }

    private static void writeStringToStringsArrMap(DataOutput dataOutput, Map<CharSequence, Object> map) throws IOException {
        assert (dataOutput != null);
        assert (map != null);
        int n = map.size();
        dataOutput.writeInt(n);
        Set<Map.Entry<CharSequence, Object>> set = map.entrySet();
        for (Map.Entry<CharSequence, Object> entry : set) {
            assert (entry != null);
            CharSequence charSequence = entry.getKey();
            Object object = entry.getValue();
            assert (charSequence != null);
            assert (object != null);
            assert (object instanceof CharSequence || object instanceof CharSequence[]);
            PersistentUtils.writeUTF(charSequence, dataOutput);
            if (object instanceof CharSequence) {
                dataOutput.writeInt(1);
                PersistentUtils.writeUTF((CharSequence)object, dataOutput);
                continue;
            }
            if (!(object instanceof CharSequence[])) continue;
            CharSequence[] charSequenceArray = (CharSequence[])object;
            dataOutput.writeInt(charSequenceArray.length);
            for (int i = 0; i < charSequenceArray.length; ++i) {
                PersistentUtils.writeUTF(charSequenceArray[i], dataOutput);
            }
        }
    }

    private static void readStringToStringsArrMap(DataInput dataInput, Map<CharSequence, Object> map) throws IOException {
        assert (dataInput != null);
        assert (map != null);
        APTStringManager aPTStringManager = FilePathCache.getManager();
        map.clear();
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence = PersistentUtils.readUTF(dataInput, aPTStringManager);
            assert (charSequence != null);
            int n2 = dataInput.readInt();
            assert (n2 != 0);
            if (n2 == 1) {
                map.put(charSequence, PersistentUtils.readUTF(dataInput, aPTStringManager));
                continue;
            }
            CharSequence[] charSequenceArray = new CharSequence[n2];
            for (int j = 0; j < n2; ++j) {
                CharSequence charSequence2 = PersistentUtils.readUTF(dataInput, aPTStringManager);
                assert (charSequence2 != null);
                charSequenceArray[j] = charSequence2;
            }
            map.put(charSequence, charSequenceArray);
        }
    }

    Map<CharSequence, FileEntry> getFileStorage() {
        return new TreeMap<CharSequence, FileEntry>(this.myFiles);
    }

    Map<CharSequence, Object> getCanonicalNames() {
        return new TreeMap<CharSequence, Object>(this.canonicFiles);
    }

    private static CharSequence getCanonicalKey(CharSequence charSequence) {
        try {
            CharSequence charSequence2 = new File(((Object)charSequence).toString()).getCanonicalPath();
            charSequence2 = FilePathCache.getManager().getString(charSequence2);
            if (charSequence.equals(charSequence2)) {
                return charSequence;
            }
            return charSequence2;
        }
        catch (IOException iOException) {
            return charSequence;
        }
    }

    public static final class FileEntry {
        private final CsmUID<CsmFile> fileNew;
        private final CharSequence canonical;
        private volatile Object data;
        private volatile int modCount;

        private FileEntry(DataInput dataInput) throws IOException {
            this.fileNew = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
            this.canonical = PersistentUtils.readUTF(dataInput, FilePathCache.getManager());
            this.modCount = dataInput.readInt();
            if (dataInput.readBoolean()) {
                int n = dataInput.readInt();
                assert (n > 0);
                if (n == 1) {
                    this.data = FileEntry.readStatePair(dataInput);
                } else {
                    this.data = new ArrayList(n);
                    for (int i = 0; i < n; ++i) {
                        ((List)this.data).add(FileEntry.readStatePair(dataInput));
                    }
                }
            } else {
                this.data = null;
            }
        }

        private FileEntry(CsmUID<CsmFile> csmUID, APTPreprocHandler.State state, CharSequence charSequence) {
            this.fileNew = csmUID;
            this.data = state == null ? null : new PreprocessorStatePair(state, FilePreprocessorConditionState.PARSING);
            this.canonical = FileContainer.getCanonicalKey(charSequence);
            this.modCount = 0;
        }

        private void write(DataOutput dataOutput) throws IOException {
            UIDObjectFactory.getDefaultFactory().writeUID(this.fileNew, dataOutput);
            PersistentUtils.writeUTF(this.canonical, dataOutput);
            dataOutput.writeInt(this.modCount);
            Object object = this.data;
            dataOutput.writeBoolean(object != null);
            if (object != null) {
                if (object instanceof PreprocessorStatePair) {
                    dataOutput.writeInt(1);
                    FileEntry.writeStatePair(dataOutput, (PreprocessorStatePair)object);
                } else {
                    Collection collection = (Collection)object;
                    dataOutput.writeInt(collection.size());
                    for (PreprocessorStatePair preprocessorStatePair : collection) {
                        FileEntry.writeStatePair(dataOutput, preprocessorStatePair);
                    }
                }
            }
        }

        private static PreprocessorStatePair readStatePair(DataInput dataInput) throws IOException {
            if (dataInput.readBoolean()) {
                APTPreprocHandler.State state = null;
                if (dataInput.readBoolean()) {
                    state = PersistentUtils.readPreprocState(dataInput);
                }
                FilePreprocessorConditionState filePreprocessorConditionState = null;
                filePreprocessorConditionState = dataInput.readBoolean() ? new FilePreprocessorConditionState(dataInput) : FilePreprocessorConditionState.PARSING;
                return new PreprocessorStatePair(state, filePreprocessorConditionState);
            }
            return null;
        }

        private static void writeStatePair(DataOutput dataOutput, PreprocessorStatePair preprocessorStatePair) throws IOException {
            dataOutput.writeBoolean(preprocessorStatePair != null);
            if (preprocessorStatePair != null) {
                dataOutput.writeBoolean(preprocessorStatePair.state != null);
                if (preprocessorStatePair.state != null) {
                    PersistentUtils.writePreprocState(preprocessorStatePair.state, dataOutput);
                }
                dataOutput.writeBoolean(preprocessorStatePair.pcState != FilePreprocessorConditionState.PARSING);
                if (preprocessorStatePair.pcState != FilePreprocessorConditionState.PARSING) {
                    preprocessorStatePair.pcState.write(dataOutput);
                }
            }
        }

        public final synchronized int getModCount() {
            return this.modCount;
        }

        public Object getLock() {
            return this;
        }

        private synchronized void debugClearState() {
            this.data = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final synchronized void setState(APTPreprocHandler.State state, FilePreprocessorConditionState filePreprocessorConditionState) {
            block16: {
                Object object;
                if (TraceFlags.TRACE_182342_BUG) {
                    new Exception("setState replacing:\n" + this.toString()).printStackTrace(System.err);
                }
                APTPreprocHandler.State state2 = null;
                if (state != null && !state.isCleaned()) {
                    state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
                }
                if (this.data instanceof Collection) {
                    Object object2;
                    object = (Collection)this.data;
                    int n = 0;
                    Object object3 = object.iterator();
                    while (object3.hasNext()) {
                        object2 = (PreprocessorStatePair)object3.next();
                        if (((PreprocessorStatePair)object2).state == null || !((PreprocessorStatePair)object2).state.isValid()) continue;
                        ++n;
                        if (state2 != null && !state.isCompileContext()) continue;
                        state2 = state;
                    }
                    if (n > 1 && CndUtils.isDebugMode()) {
                        object3 = new StringBuilder("Attempt to set state while there are multiple states: " + this.canonical);
                        object2 = object.iterator();
                        while (object2.hasNext()) {
                            PreprocessorStatePair preprocessorStatePair = (PreprocessorStatePair)object2.next();
                            ((StringBuilder)object3).append(String.format("\nvalid: %b context: %b %s", preprocessorStatePair.state.isValid(), preprocessorStatePair.state.isCompileContext(), preprocessorStatePair.pcState));
                        }
                        Utils.LOG.log(Level.SEVERE, ((StringBuilder)object3).toString(), new Exception(((StringBuilder)object3).toString()));
                    }
                } else if (this.data instanceof PreprocessorStatePair) {
                    state2 = ((PreprocessorStatePair)this.data).state;
                }
                this.incrementModCount();
                if (state2 == null || !state2.isValid()) {
                    this.data = state;
                } else {
                    if (state2.isCompileContext()) {
                        if (state.isCompileContext()) {
                            this.data = state;
                            break block16;
                        } else {
                            if (CndUtils.isDebugMode()) {
                                object = "Replacing correct state to incorrect " + this.canonical;
                                Utils.LOG.log(Level.SEVERE, (String)object, new Exception());
                            }
                            return;
                        }
                    }
                    this.data = state;
                }
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.println("\nPut state for file" + this.canonical + "\n");
                System.err.println(state);
            }
            this.data = new PreprocessorStatePair(state, filePreprocessorConditionState);
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("setState at the end:\n" + this.toString()).printStackTrace(System.err);
            }
        }

        public synchronized void setStates(Collection<PreprocessorStatePair> collection, PreprocessorStatePair preprocessorStatePair) {
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("setStates replacing:\n" + this.toString()).printStackTrace(System.err);
            }
            this.incrementModCount();
            if (preprocessorStatePair != null && preprocessorStatePair.state != null && !preprocessorStatePair.state.isCleaned()) {
                preprocessorStatePair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), preprocessorStatePair.pcState);
            }
            if (preprocessorStatePair == null && collection.size() == 1) {
                preprocessorStatePair = collection.iterator().next();
                collection = Collections.emptyList();
            }
            if (collection.isEmpty()) {
                assert (preprocessorStatePair != null);
                this.data = preprocessorStatePair;
            } else {
                ArrayList<PreprocessorStatePair> arrayList = new ArrayList<PreprocessorStatePair>(collection.size() + 1);
                arrayList.addAll(collection);
                if (preprocessorStatePair != null) {
                    arrayList.add(preprocessorStatePair);
                }
                this.data = arrayList;
            }
            if (CndUtils.isDebugMode()) {
                this.checkConsistency();
            }
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("setStates at the end:\n" + this.toString()).printStackTrace(System.err);
            }
        }

        private void checkConsistency() {
            Collection<PreprocessorStatePair> collection = this.getStatePairs();
            if (!collection.isEmpty()) {
                boolean bl = false;
                APTPreprocHandler.State state = null;
                FilePreprocessorConditionState filePreprocessorConditionState = null;
                boolean bl2 = true;
                for (PreprocessorStatePair object : this.getStatePairs()) {
                    if (bl2) {
                        bl2 = false;
                        state = object.state;
                        filePreprocessorConditionState = object.pcState;
                        continue;
                    }
                    if (state == null != (object.state == null)) {
                        bl = true;
                        break;
                    }
                    if (state == null) continue;
                    if (state.isCompileContext() != object.state.isCompileContext()) {
                        bl = true;
                        break;
                    }
                    if (state.isValid() == object.state.isValid()) continue;
                    bl = !state.isValid() && filePreprocessorConditionState != FilePreprocessorConditionState.PARSING;
                    if (!(bl |= !object.state.isValid() && object.pcState != FilePreprocessorConditionState.PARSING)) continue;
                    break;
                }
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder("Mixed preprocessor states: " + this.canonical);
                    for (PreprocessorStatePair preprocessorStatePair : this.getStatePairs()) {
                        if (preprocessorStatePair.state == null) {
                            stringBuilder.append(String.format(" (null, %s)", preprocessorStatePair.pcState));
                            continue;
                        }
                        stringBuilder.append(String.format(" (valid: %b, context: %b, %s) ", preprocessorStatePair.state.isValid(), preprocessorStatePair.state.isCompileContext(), preprocessorStatePair.pcState));
                    }
                    Utils.LOG.log(Level.SEVERE, stringBuilder.toString(), new Exception());
                }
            }
        }

        private synchronized void incrementModCount() {
            this.modCount = this.modCount == Integer.MAX_VALUE ? 0 : this.modCount + 1;
        }

        public synchronized void invalidateStates() {
            this.incrementModCount();
            if (this.data != null) {
                if (this.data instanceof PreprocessorStatePair) {
                    this.data = FileEntry.createInvalidState((PreprocessorStatePair)this.data);
                } else {
                    ArrayList<PreprocessorStatePair> arrayList = new ArrayList<PreprocessorStatePair>();
                    for (PreprocessorStatePair preprocessorStatePair : (Collection)this.data) {
                        arrayList.add(FileEntry.createInvalidState(preprocessorStatePair));
                    }
                    this.data = arrayList;
                }
            }
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("invalidateStates:\n" + this.toString()).printStackTrace(System.err);
            }
        }

        private static PreprocessorStatePair createInvalidState(PreprocessorStatePair preprocessorStatePair) {
            if (preprocessorStatePair == null) {
                return preprocessorStatePair;
            }
            if (preprocessorStatePair.state == null) {
                return preprocessorStatePair;
            }
            return new PreprocessorStatePair(APTHandlersSupport.createInvalidPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), FilePreprocessorConditionState.PARSING);
        }

        public synchronized Collection<PreprocessorStatePair> getStatePairs() {
            if (this.data == null) {
                return Collections.emptyList();
            }
            if (this.data instanceof PreprocessorStatePair) {
                return Collections.singleton((PreprocessorStatePair)this.data);
            }
            Collection collection = (Collection)this.data;
            return new ArrayList<PreprocessorStatePair>(collection);
        }

        public synchronized Collection<APTPreprocHandler.State> getPrerocStates() {
            if (this.data == null) {
                return Collections.emptyList();
            }
            if (this.data instanceof PreprocessorStatePair) {
                return Collections.singleton(((PreprocessorStatePair)this.data).state);
            }
            Collection collection = (Collection)this.data;
            ArrayList<APTPreprocHandler.State> arrayList = new ArrayList<APTPreprocHandler.State>(collection.size());
            for (PreprocessorStatePair preprocessorStatePair : collection) {
                arrayList.add(preprocessorStatePair.state);
            }
            return arrayList;
        }

        CsmUID<CsmFile> getFileUID() {
            return this.fileNew;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.fileNew);
            stringBuilder.append("\nstates:\n");
            for (PreprocessorStatePair preprocessorStatePair : this.getStatePairs()) {
                stringBuilder.append(preprocessorStatePair);
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

