/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.PathShape;
import com.sun.perseus.j2d.PathSupport;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.j2d.RenderContext;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.Transform;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class RenderGraphics
extends RenderContext {
    static final Line2D.Float line = new Line2D.Float();
    static final Rectangle2D.Float rect = new Rectangle2D.Float();
    static final RoundRectangle2D.Float rrect = new RoundRectangle2D.Float();
    static final Ellipse2D.Float ellipse = new Ellipse2D.Float();
    static final PathShape shape = new PathShape(null, 0);
    static final AffineTransform IDENTITY = new AffineTransform();
    protected Tile renderingTile = new Tile();
    protected Tile primitiveTile = new Tile();
    protected PaintTarget paintTarget;
    protected Transform paintTransform = null;
    protected Graphics2D g;
    protected Graphics2D clearG;
    protected AffineTransform transform = new AffineTransform();
    protected int width;
    protected int height;
    public BufferedImage bi;
    protected Component targetComponent = null;

    public RenderGraphics(BufferedImage bi) {
        if (bi == null) {
            throw new NullPointerException();
        }
        this.bi = bi;
        this.g = bi.createGraphics();
        this.clearG = bi.createGraphics();
        this.clearG.setComposite(AlphaComposite.Src);
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        this.setRenderingQuality(true);
        this.setRenderingTile(null);
        this.setPrimitiveTile(null);
    }

    public void clearRect(int x, int y, int width, int height, RGB clearColor) {
        this.clearG.setColor(clearColor.getColor());
        this.clearG.fillRect(x, y, width, height);
    }

    public void setRenderingTile(Tile renderingTile) {
        if (renderingTile != null) {
            this.renderingTile.x = renderingTile.x;
            this.renderingTile.y = renderingTile.y;
            this.renderingTile.maxX = renderingTile.maxX;
            this.renderingTile.maxY = renderingTile.maxY;
        } else {
            this.renderingTile.x = 0;
            this.renderingTile.y = 0;
            this.renderingTile.maxX = this.width - 1;
            this.renderingTile.maxY = this.height - 1;
        }
        this.setPrimitiveTile(renderingTile);
    }

    public void setPrimitiveTile(Tile primitiveTile) {
        if (primitiveTile != null) {
            this.primitiveTile.x = primitiveTile.x;
            this.primitiveTile.y = primitiveTile.y;
            this.primitiveTile.maxX = primitiveTile.maxX;
            this.primitiveTile.maxY = primitiveTile.maxY;
        } else {
            this.primitiveTile.x = this.renderingTile.x;
            this.primitiveTile.y = this.renderingTile.y;
            this.primitiveTile.maxX = this.renderingTile.maxX;
            this.primitiveTile.maxY = this.renderingTile.maxY;
        }
        this.applyClip();
    }

    void applyClip() {
        AffineTransform txf = this.g.getTransform();
        this.g.setTransform(IDENTITY);
        int x = this.primitiveTile.x;
        int y = this.primitiveTile.y;
        int mx = this.primitiveTile.maxX;
        int my = this.primitiveTile.maxY;
        if (x < this.renderingTile.x) {
            x = this.renderingTile.x;
        }
        if (y < this.renderingTile.y) {
            y = this.renderingTile.y;
        }
        if (mx > this.renderingTile.maxX) {
            mx = this.renderingTile.maxX;
        }
        if (my > this.renderingTile.maxY) {
            my = this.renderingTile.maxY;
        }
        int w = mx - x + 1;
        int h = my - y + 1;
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException();
        }
        this.g.setClip(x, y, w, h);
        this.g.setTransform(txf);
    }

    public Tile getRenderingTile() {
        return this.renderingTile;
    }

    public Tile getPrimitiveTile() {
        return this.primitiveTile;
    }

    public void setPaintTarget(PaintTarget paintTarget) {
        this.paintTarget = paintTarget;
    }

    public void setPaintTransform(Transform paintTransform) {
        this.paintTransform = paintTransform;
    }

    public void setRenderingQuality(boolean isHigh) {
        if (isHigh) {
            this.g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public void setTransform(Transform newTransform) {
        if (newTransform == null) {
            this.transform.setToIdentity();
        } else {
            this.transform.setTransform(newTransform.m0, newTransform.m1, newTransform.m2, newTransform.m3, newTransform.m4, newTransform.m5);
        }
    }

    public void fill(Path path) {
        RenderGraphics.shape.path = path;
        RenderGraphics.shape.windingRule = this.fillRule;
        this.g.setTransform(this.transform);
        this.fill.getPaintDef().applyPaint(this);
        this.g.setComposite(this.fillOpacity);
        this.g.fill(shape);
    }

    public void draw(Path path) {
        RenderGraphics.shape.path = path;
        RenderGraphics.shape.windingRule = this.fillRule;
        this.g.setTransform(this.transform);
        this.stroke.getPaintDef().applyPaint(this);
        this.g.setStroke(PathSupport.getBasicStroke(this));
        this.g.setComposite(this.strokeOpacity);
        this.g.draw(shape);
    }

    public void fillRect(float x, float y, float w, float h, float aw, float ah) {
        this.g.setTransform(this.transform);
        this.fill.getPaintDef().applyPaint(this);
        this.g.setComposite(this.fillOpacity);
        this.g.fill(this.buildRect(x, y, w, h, aw, ah));
    }

    public void drawRect(float x, float y, float w, float h, float aw, float ah) {
        this.g.setTransform(this.transform);
        this.stroke.getPaintDef().applyPaint(this);
        this.g.setStroke(PathSupport.getBasicStroke(this));
        this.g.setComposite(this.strokeOpacity);
        this.g.draw(this.buildRect(x, y, w, h, aw, ah));
    }

    Shape buildRect(float x, float y, float w, float h, float aw, float ah) {
        if (aw == 0.0f && ah == 0.0f) {
            RenderGraphics.rect.x = x;
            RenderGraphics.rect.y = y;
            RenderGraphics.rect.width = w;
            RenderGraphics.rect.height = h;
            return rect;
        }
        RenderGraphics.rrect.x = x;
        RenderGraphics.rrect.y = y;
        RenderGraphics.rrect.width = w;
        RenderGraphics.rrect.height = h;
        RenderGraphics.rrect.arcwidth = aw;
        RenderGraphics.rrect.archeight = ah;
        return rrect;
    }

    public void drawOval(float x, float y, float w, float h) {
        this.g.setTransform(this.transform);
        this.stroke.getPaintDef().applyPaint(this);
        this.g.setStroke(PathSupport.getBasicStroke(this));
        this.g.setComposite(this.strokeOpacity);
        RenderGraphics.ellipse.x = x;
        RenderGraphics.ellipse.y = y;
        RenderGraphics.ellipse.width = w;
        RenderGraphics.ellipse.height = h;
        this.g.draw(ellipse);
    }

    public void fillOval(float x, float y, float w, float h) {
        this.g.setTransform(this.transform);
        this.fill.getPaintDef().applyPaint(this);
        this.g.setComposite(this.fillOpacity);
        RenderGraphics.ellipse.x = x;
        RenderGraphics.ellipse.y = y;
        RenderGraphics.ellipse.width = w;
        RenderGraphics.ellipse.height = h;
        this.g.fill(ellipse);
    }

    public void drawLine(float x1, float y1, float x2, float y2) {
        this.g.setTransform(this.transform);
        this.stroke.getPaintDef().applyPaint(this);
        this.g.setStroke(PathSupport.getBasicStroke(this));
        this.g.setComposite(this.strokeOpacity);
        RenderGraphics.line.x1 = x1;
        RenderGraphics.line.x2 = x2;
        RenderGraphics.line.y1 = y1;
        RenderGraphics.line.y2 = y2;
        this.g.draw(line);
    }

    public void drawImage(RasterImage image, float dx, float dy, float dw, float dh) {
        this.g.setTransform(this.transform);
        this.g.setComposite(this.opacity);
        this.g.drawImage(image.image, (int)dx, (int)dy, (int)(dx + dw), (int)(dy + dh), 0, 0, image.getWidth(), image.getHeight(), null);
    }

    public void setTargetComponent(Component targetComponent) {
        this.targetComponent = targetComponent;
    }

    public Component getTargetComponent() {
        return this.targetComponent;
    }
}

