/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.AnimateMotion;
import com.sun.perseus.model.LeafMotionSegment;
import com.sun.perseus.model.MotionSegment;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.Segment;

public class MotionRefValues
implements RefValues {
    MotionSegment[] segments;
    float[][] w;
    float length;
    float[] nSegLength;
    float[] segLength;
    AnimateMotion motion;

    public MotionRefValues(AnimateMotion motion) {
        this.motion = motion;
    }

    public void getSegmentAtDist(float[] sisp, float dist) {
        int i;
        if (dist >= 1.0f) {
            sisp[0] = this.segments.length - 1;
            sisp[1] = 1.0f;
            return;
        }
        if (dist < 0.0f) {
            sisp[0] = 0.0f;
            sisp[1] = 0.0f;
            return;
        }
        float prevSegLength = 0.0f;
        for (i = 0; i < this.nSegLength.length - 1 && !(dist < this.nSegLength[i]); ++i) {
            prevSegLength = this.nSegLength[i];
        }
        float p = 1.0f;
        if (this.nSegLength[i] > prevSegLength) {
            p = (dist - prevSegLength) / (this.nSegLength[i] - prevSegLength);
        }
        sisp[0] = i;
        sisp[1] = p;
    }

    public Segment getSegment(int i) {
        return this.segments[i];
    }

    public int getSegments() {
        return this.segments.length;
    }

    public int getComponents() {
        return this.segments[0].getStart().length;
    }

    public Object[] compute(int si, float p) {
        this.segments[si].compute(p, this.w);
        return this.w;
    }

    public void makeDiscrete() {
        MotionSegment[] tmpSegments = new MotionSegment[this.segments.length + 1];
        System.arraycopy(this.segments, 0, tmpSegments, 0, this.segments.length);
        MotionSegment lastSeg = this.segments[this.segments.length - 1];
        float[][] end = (float[][])lastSeg.getEnd();
        LeafMotionSegment newSeg = new LeafMotionSegment(end[4][0], end[5][0], end[4][0], end[5][0], this.motion);
        tmpSegments[tmpSegments.length - 1] = newSeg;
        this.segments = tmpSegments;
    }

    public float getLength() {
        return this.length;
    }

    public float getLength(int si) {
        return this.segLength[si];
    }

    public void initialize() {
        int si;
        int nc = this.segments[0].getStart().length;
        this.w = new float[nc][];
        for (int ci = 0; ci < nc; ++ci) {
            this.w[ci] = new float[1];
        }
        int ns = this.segments.length;
        for (si = 0; si < ns; ++si) {
            this.segments[si].initialize();
        }
        this.nSegLength = new float[ns];
        this.segLength = new float[ns];
        for (si = 0; si < this.segments.length; ++si) {
            this.segLength[si] = this.segments[si].getLength();
            this.length += this.segLength[si];
        }
        if (this.length > 0.0f) {
            float curLength = 0.0f;
            for (int si2 = 0; si2 < ns - 1; ++si2) {
                this.nSegLength[si2] = (curLength += this.segLength[si2]) / this.length;
            }
        } else {
            for (si = 0; si < ns - 1; ++si) {
                this.nSegLength[si] = 0.0f;
            }
        }
        this.nSegLength[this.nSegLength.length - 1] = 1.0f;
    }
}

