/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.VariablesNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WatchesTreeModel
implements TreeModel,
PropertyChangeListener {
    private final GdbDebugger debugger;
    private Listener listener;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private final Map<Watch, AbstractVariable> watchToVariable = new WeakHashMap<Watch, AbstractVariable>();
    private final AbstractVariable EMPTY_WATCH = new EmptyWatch();

    public WatchesTreeModel(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("var_value".equals(ev.getPropertyName())) {
            this.fireNodeChanged(ev.getSource());
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            to = Math.min(ws.length, to);
            from = Math.min(ws.length, from);
            Watch[] fws = new Watch[to - from];
            System.arraycopy(ws, from, fws, 0, to - from);
            int k = fws.length;
            Object[] gws = new AbstractVariable[k + 1];
            for (int i = 0; i < k; ++i) {
                AbstractVariable gw = this.watchToVariable.get(fws[i]);
                if (gw == null) {
                    gw = new GdbWatchVariable(this.debugger, fws[i]);
                    this.watchToVariable.put(fws[i], gw);
                    gw.addPropertyChangeListener(this);
                }
                gws[i] = gw;
            }
            gws[k] = this.EMPTY_WATCH;
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return gws;
        }
        if (parent instanceof AbstractVariable) {
            return ((AbstractVariable)parent).getFields();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node == this.EMPTY_WATCH) {
            return true;
        }
        if (node instanceof Watch) {
            return true;
        }
        if (node instanceof AbstractVariable) {
            return ((AbstractVariable)node).getFieldsCount() == 0;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Integer.MAX_VALUE;
        }
        if (node instanceof AbstractVariable) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTreeChanged() {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener l : ls) {
            l.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableValueChanged(Object node, String propertyName) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener l : ls) {
            l.modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener l : ls) {
            l.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
        }
    }

    final class EmptyWatch
    extends AbstractVariable {
        public EmptyWatch() {
            super(null, null);
        }

        @Override
        protected void selfDestroy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getName() {
            return "<_html><font color=\"#808080\">&lt;" + NbBundle.getBundle(VariablesNodeModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint") + "&gt;</font></html>";
        }

        @Override
        public String getType() {
            return "";
        }

        @Override
        public String getValue() {
            return "";
        }

        public void setExpression(String expr) {
            String infoStr = NbBundle.getBundle(WatchesTreeModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint");
            infoStr = '<' + infoStr + '>';
            if (expr == null || expr.trim().length() == 0 || infoStr.equals(expr)) {
                return;
            }
            DebuggerManager.getDebuggerManager().createWatch(expr);
            WatchesTreeModel.this.fireNodeChanged(this);
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private final WeakReference<WatchesTreeModel> model;
        private final WeakReference<GdbDebugger> debugger;
        private RequestProcessor.Task task;

        private Listener(WatchesTreeModel tm, GdbDebugger debugger) {
            this.model = new WeakReference<WatchesTreeModel>(tm);
            this.debugger = new WeakReference<GdbDebugger>(debugger);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            debugger.addPropertyChangeListener(this);
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesTreeModel getModel() {
            WatchesTreeModel m = (WatchesTreeModel)this.model.get();
            if (m == null) {
                this.destroy();
            }
            return m;
        }

        public void watchAdded(Watch watch) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            Object o = m.watchToVariable.remove(watch);
            if (o != null && o instanceof GdbWatchVariable) {
                ((GdbWatchVariable)o).destroy();
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("watches".equals(propName)) {
                return;
            }
            final WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            if (m.debugger.getState() == GdbDebugger.State.EXITED) {
                this.destroy();
                return;
            }
            if (m.debugger.getState() == GdbDebugger.State.RUNNING) {
                return;
            }
            if (evt.getSource() instanceof Watch) {
                Object node;
                Map map = m.watchToVariable;
                synchronized (map) {
                    node = m.watchToVariable.get((Watch)evt.getSource());
                }
                if (node != null) {
                    if (node instanceof AbstractVariable && ((AbstractVariable)node).getFieldsCount() > 0) {
                        m.fireTreeChanged();
                    } else {
                        m.fireTableValueChanged(node, null);
                    }
                    return;
                }
            }
            if (this.task == null) {
                GdbDebugger d = (GdbDebugger)this.debugger.get();
                RequestProcessor rp = d != null ? d.getRequestProcessor() : RequestProcessor.getDefault();
                this.task = rp.create(new Runnable(){

                    @Override
                    public void run() {
                        m.fireTreeChanged();
                    }
                });
            }
            this.task.schedule(100);
        }

        private void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            GdbDebugger d = (GdbDebugger)this.debugger.get();
            if (d != null) {
                d.removePropertyChangeListener(this);
            }
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

