/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.awt.Component;
import java.awt.Graphics;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmTemplateBasedReferencedObject;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionTokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmExpandedTokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.util.NbBundle;

public abstract class CsmCompletionQuery {
    private BaseDocument baseDocument;
    private static final String NO_SUGGESTIONS = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-no-suggestions");
    private static final String PROJECT_BEEING_PARSED = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-project-beeing-parsed");
    private static final boolean TRACE_COMPLETION = Boolean.getBoolean("cnd.completion.trace");
    private static CsmItemFactory itemFactory;
    private static final int MAX_DEPTH = 15;
    private static final int FAKE_PRIORITY = 1000;

    protected BaseDocument getBaseDocument() {
        return this.baseDocument;
    }

    protected abstract CompletionResolver getCompletionResolver(boolean var1, boolean var2, boolean var3);

    protected abstract CsmFinder getFinder();

    protected abstract QueryScope getCompletionQueryScope();

    protected abstract FileReferencesContext getFileReferencesContext();

    public CsmCompletionQuery() {
        this.initFactory();
    }

    protected void initFactory() {
        this.setCsmItemFactory(new DefaultCsmItemFactory());
    }

    public CsmCompletionResult query(JTextComponent component, int offset, boolean instantiateTypes) {
        boolean sort = false;
        return this.query(component, offset, false, sort, instantiateTypes);
    }

    public CsmCompletionResult query(JTextComponent component, int offset, boolean openingSource, boolean sort, boolean instantiateTypes) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        return this.query(component, doc, offset, openingSource, sort, instantiateTypes);
    }

    public static boolean checkCondition(final Document doc, final int dot, boolean takeLock) {
        if (!takeLock) {
            return CsmCompletionQuery._checkCondition(doc, dot);
        }
        final AtomicBoolean res = new AtomicBoolean(false);
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).render(new Runnable(){

                @Override
                public void run() {
                    res.set(CsmCompletionQuery._checkCondition(doc, dot));
                }
            });
        } else {
            res.set(CsmCompletionQuery._checkCondition(doc, dot));
        }
        return res.get();
    }

    private static boolean _checkCondition(Document doc, int dot) {
        return !CompletionSupport.isPreprocCompletionEnabled(doc, dot) && CompletionSupport.isCompletionEnabled(doc, dot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmCompletionResult query(JTextComponent component, BaseDocument doc, int offset, boolean openingSource, boolean sort, boolean instantiateTypes) {
        this.baseDocument = doc;
        CsmCompletionResult ret = null;
        CompletionSupport sup = CompletionSupport.get((Document)doc);
        if (sup == null || !CsmCompletionQuery.checkCondition((Document)doc, offset, true)) {
            return null;
        }
        try {
            int lastSepOffset = sup.getLastCommandSeparator(offset);
            CsmCompletionTokenProcessor tp = new CsmCompletionTokenProcessor(offset, lastSepOffset);
            CndTokenProcessor<Token<CppTokenId>> etp = CsmExpandedTokenProcessor.create((Document)doc, tp, offset);
            if (etp instanceof CsmExpandedTokenProcessor) {
                tp.setMacroCallback((CsmExpandedTokenProcessor)etp);
            }
            tp.enableTemplateSupport(true);
            doc.readLock();
            try {
                CndTokenUtilities.processTokens(etp, (Document)doc, (int)lastSepOffset, (int)offset);
            }
            finally {
                doc.readUnlock();
            }
            sup.setLastSeparatorOffset(tp.getLastSeparatorOffset());
            boolean errState = false;
            CppTokenId lastValidTokenID = tp.getLastValidTokenID();
            if (lastValidTokenID != null) {
                switch (lastValidTokenID) {
                    case BLOCK_COMMENT: {
                        if (tp.getLastValidTokenText() != null && tp.getLastValidTokenText().endsWith("*/")) break;
                        errState = true;
                        break;
                    }
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        errState = true;
                        break;
                    }
                    default: {
                        errState = "preprocessor-keyword".equals(lastValidTokenID.primaryCategory()) ? true : tp.isErrorState();
                    }
                }
            }
            if (!errState) {
                CsmCompletionExpression exp = tp.getResultExp();
                if (TRACE_COMPLETION) {
                    System.err.println("expression " + exp);
                }
                ret = this.getResult(component, (Document)doc, openingSource, offset, exp, sort, this.isInIncludeDirective(doc, offset), instantiateTypes);
            } else if (TRACE_COMPLETION) {
                System.err.println("Error expression " + tp.getResultExp());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    protected abstract boolean isProjectBeeingParsed(boolean var1);

    private CsmCompletionResult getResult(JTextComponent component, Document doc, boolean openingSource, int offset, CsmCompletionExpression exp, boolean sort, boolean inIncludeDirective, boolean instantiateTypes) {
        CompletionResolver resolver = this.getCompletionResolver(openingSource, sort, inIncludeDirective);
        if (resolver != null) {
            CompletionSupport sup = CompletionSupport.get(doc);
            CsmOffsetableDeclaration context = sup.getDefinition(offset, this.getFileReferencesContext());
            Context ctx = new Context(component, sup, openingSource, offset, this.getFinder(), resolver, context, sort, instantiateTypes);
            ctx.resolveExp(exp);
            if (ctx.result != null) {
                ctx.result.setSimpleVariableExpression(CsmCompletionQuery.isSimpleVariableExpression(exp));
            }
            if (TRACE_COMPLETION) {
                CompletionItem[] array = ctx.result == null ? new CompletionItem[]{} : ctx.result.getItems().toArray(new CompletionItem[ctx.result.getItems().size()]);
                System.err.println("Completion Items " + array.length);
                for (int i = 0; i < array.length; ++i) {
                    CompletionItem completionItem = array[i];
                    System.err.println(completionItem.toString());
                }
            }
            return ctx.result;
        }
        boolean isProjectBeeingParsed = this.isProjectBeeingParsed(openingSource);
        return new CsmCompletionResult(component, this.getBaseDocument(), Collections.EMPTY_LIST, "", exp, 0, isProjectBeeingParsed, null, instantiateTypes);
    }

    private String formatName(String name, boolean appendStar) {
        return name != null ? (appendStar ? name + '*' : name) : (appendStar ? "*" : "");
    }

    private String formatType(CsmType type, boolean useFullName, boolean appendColon) {
        StringBuilder sb = new StringBuilder();
        if (type != null) {
            sb.append(type.getText());
        }
        if (appendColon) {
            sb.append("::");
        }
        return sb.toString();
    }

    private static String formatType(CsmType type, boolean useFullName, boolean appendDblComma, boolean appendStar) {
        StringBuilder sb = new StringBuilder();
        if (type != null && type.getClassifier() != null) {
            sb.append(useFullName ? type.getClassifier().getQualifiedName() : type.getClassifier().getName());
        }
        if (appendDblComma) {
            sb.append("::");
        }
        if (appendStar) {
            sb.append('*');
        }
        return sb.toString();
    }

    static List<CsmClassifier> findNestedClassifiers(CsmFinder finder, CsmOffsetableDeclaration context, CsmClassifier classifier, String name, boolean exactMatch, boolean inspectParentClasses, boolean sort) {
        ArrayList<CsmClassifier> ret = new ArrayList<CsmClassifier>();
        if (!CsmKindUtilities.isClass((CsmObject)(classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)finder.getCsmFile())))) {
            return ret;
        }
        CsmClass cls = (CsmClass)classifier;
        List<CsmClassifier> res = finder.findNestedClassifiers(context, cls, name, exactMatch, inspectParentClasses, sort);
        if (res != null) {
            ret.addAll(res);
        }
        return ret;
    }

    static List<CsmObject> findFieldsAndMethods(CsmFinder finder, CsmOffsetableDeclaration context, CsmClassifier classifier, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses, boolean inspectParentClasses, boolean scopeAccessedClassifier, boolean skipConstructors, boolean sort) {
        List<CsmField> res;
        ArrayList<CsmObject> ret = new ArrayList<CsmObject>();
        if (!CsmKindUtilities.isClass((CsmObject)(classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)finder.getCsmFile())))) {
            return ret;
        }
        CsmClass cls = (CsmClass)classifier;
        CsmFunction contextFunction = CsmBaseUtilities.getContextFunction((CsmOffsetableDeclaration)context);
        CsmClass contextClass = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)context);
        if (CsmInheritanceUtilities.isAssignableFrom((CsmClass)contextClass, (CsmClass)cls)) {
            staticOnly = false;
        }
        if ((res = finder.findFields(context, cls, name, exactMatch, staticOnly, inspectOuterClasses, inspectParentClasses, scopeAccessedClassifier, sort)) != null) {
            ret.addAll(res);
        }
        if ((res = finder.findEnumerators(context, cls, name, exactMatch, inspectOuterClasses, inspectParentClasses, scopeAccessedClassifier, sort)) != null) {
            ret.addAll(res);
        }
        if (contextFunction == null && contextClass == null) {
            staticOnly = false;
            context = cls;
        }
        if ((res = finder.findMethods(context, cls, name, exactMatch, staticOnly, inspectOuterClasses, inspectParentClasses, scopeAccessedClassifier, sort)) != null) {
            if (!skipConstructors) {
                ret.addAll(res);
            } else {
                for (CsmField mtd : res) {
                    if (CsmKindUtilities.isConstructor((CsmObject)((CsmObject)mtd))) continue;
                    ret.add((CsmObject)mtd);
                }
            }
        }
        return ret;
    }

    private static CsmClassifier getClassifier(CsmType type, CsmFile contextFile) {
        CsmClassifier cls = CsmBaseUtilities.getClassifier((CsmType)type, (CsmFile)contextFile, (boolean)true);
        return cls;
    }

    private static CsmFunction getOperator(CsmClassifier classifier, CsmFile contextFile, CsmFunction.OperatorKind opKind) {
        if (!CsmKindUtilities.isClass((CsmObject)classifier)) {
            return null;
        }
        CsmClass cls = (CsmClass)classifier;
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter((CharSequence)("operator " + opKind.getImage()), false, true, false);
        return CsmCompletionQuery.getOperatorCheckBaseClasses(cls, contextFile, filter, opKind, new AntiLoop());
    }

    private static CsmFunction getOperatorCheckBaseClasses(CsmClass cls, CsmFile contextFile, CsmSelect.CsmFilter filter, CsmFunction.OperatorKind opKind, AntiLoop antiLoop) {
        if (antiLoop.contains((CsmClassifier)cls)) {
            return null;
        }
        antiLoop.add((CsmClassifier)cls);
        Iterator it = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter);
        while (it.hasNext()) {
            CsmMember member = (CsmMember)it.next();
            if (!CsmKindUtilities.isOperator((CsmObject)member) || ((CsmFunction)member).getOperatorKind() != opKind) continue;
            return (CsmFunction)member;
        }
        for (CsmInheritance csmInheritance : cls.getBaseClasses()) {
            CsmFunction operatorFun;
            CsmClassifier baseClassifier = CsmCompletionQuery.getClassifier(csmInheritance.getAncestorType(), contextFile);
            if (!CsmKindUtilities.isClass((CsmObject)baseClassifier) || (operatorFun = CsmCompletionQuery.getOperatorCheckBaseClasses((CsmClass)baseClassifier, contextFile, filter, opKind, antiLoop)) == null) continue;
            return operatorFun;
        }
        return null;
    }

    private static CsmType getOverloadedOperatorReturnType(CsmType type, CsmFile contextFile, CsmFunction.OperatorKind operator, int level) {
        CsmFunction op;
        if (type == null || type.isPointer() || type.getArrayDepth() > 0) {
            return null;
        }
        CsmType opType = null;
        CsmClassifier cls = CsmCompletionQuery.getClassifier(type, contextFile);
        if (CsmKindUtilities.isClass((CsmObject)cls) && (op = CsmCompletionQuery.getOperator((CsmClassifier)((CsmClass)cls), contextFile, operator)) != null) {
            opType = op.getReturnType();
            if (!type.equals(opType) && level > 0) {
                CsmType opType2;
                if (operator == CsmFunction.OperatorKind.ARROW && (opType2 = CsmCompletionQuery.getOverloadedOperatorReturnType(opType, contextFile, operator, level - 1)) != null) {
                    opType = opType2;
                }
            } else {
                CsmFile typeFile = type.getContainingFile();
                System.err.printf("circular pointer delegation detected:%s, line %d/n", typeFile != null ? typeFile.getAbsolutePath() : type, type.getStartOffset());
                CndUtils.assertTrueInConsole((boolean)false, (String)("Infinite recursion in file " + typeFile + " type " + type));
            }
        }
        return opType;
    }

    private boolean isInIncludeDirective(BaseDocument doc, int offset) {
        return false;
    }

    private static String formatTypeList(List typeList, boolean methodOpen) {
        StringBuilder sb = new StringBuilder();
        if (typeList.size() > 0) {
            int cntM1 = typeList.size() - 1;
            for (int i = 0; i <= cntM1; ++i) {
                CsmType t = (CsmType)typeList.get(i);
                if (t != null) {
                    sb.append(t.getText());
                } else {
                    sb.append('?');
                }
                if (i >= cntM1) continue;
                sb.append(", ");
            }
            if (methodOpen) {
                sb.append(", *");
            }
        } else if (methodOpen) {
            sb.append("*");
        }
        return sb.toString();
    }

    private static boolean isSimpleVariableExpression(CsmCompletionExpression exp) {
        switch (exp.getExpID()) {
            case 4: 
            case 5: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return false;
            }
        }
        return true;
    }

    protected void setCsmItemFactory(CsmItemFactory itemFactory) {
        CsmCompletionQuery.itemFactory = itemFactory;
    }

    public static CsmItemFactory getCsmItemFactory() {
        return itemFactory;
    }

    private static List<CompletionItem> convertData(Collection dataList, int classDisplayOffset, CsmCompletionExpression substituteExp, int substituteOffset, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
        ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
        for (Object obj : dataList) {
            CsmResultItem item = CsmCompletionQuery.createResultItem(obj, classDisplayOffset, substituteExp, contextElement, instantiateTypes);
            assert (item != null) : "why null item? object " + obj;
            if (item == null) continue;
            item.setSubstituteOffset(substituteOffset);
            ret.add(item);
        }
        return ret;
    }

    private static CsmResultItem createResultItem(Object obj, int classDisplayOffset, CsmCompletionExpression substituteExp, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
        if (CsmKindUtilities.isCsmObject((Object)obj)) {
            CsmObject csmObj = (CsmObject)obj;
            assert (!CsmKindUtilities.isMethod((CsmObject)csmObj) || CsmKindUtilities.isMethodDeclaration((CsmObject)csmObj)) : "completion result can not have method definitions " + obj;
            if (CsmKindUtilities.isNamespace((Object)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createNamespaceResultItem((CsmNamespace)csmObj, false);
            }
            if (CsmKindUtilities.isEnum((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createEnumResultItem((CsmEnum)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isEnumerator((Object)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalEnumeratorResultItem((CsmEnumerator)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isClass((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createClassResultItem((CsmClass)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createForwardClassResultItem((CsmClassForwardDeclaration)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isField((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createFieldResultItem((CsmField)csmObj);
            }
            if (CsmKindUtilities.isConstructor((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createConstructorResultItem((CsmConstructor)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            }
            if (CsmKindUtilities.isMethodDeclaration((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createMethodResultItem((CsmMethod)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            }
            if (CsmKindUtilities.isGlobalFunction((CsmObject)csmObj)) {
                if (CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObj))) {
                    return CsmCompletionQuery.getCsmItemFactory().createFileLocalFunctionResultItem((CsmFunction)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
                }
                return CsmCompletionQuery.getCsmItemFactory().createGlobalFunctionResultItem((CsmFunction)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            }
            if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalVariableResultItem((CsmVariable)csmObj);
            }
            if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createFileLocalVariableResultItem((CsmVariable)csmObj);
            }
            if (CsmKindUtilities.isLocalVariable((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createLocalVariableResultItem((CsmVariable)csmObj);
            }
            if (CsmKindUtilities.isMacro((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalMacroResultItem((CsmMacro)csmObj);
            }
            if (CsmKindUtilities.isTypedef((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createTypedefResultItem((CsmTypedef)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isStatement((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createLabelResultItem((CsmLabel)csmObj);
            }
            if (CsmKindUtilities.isNamespaceAlias((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createNamespaceAliasResultItem((CsmNamespaceAlias)csmObj, false);
            }
            if (csmObj instanceof CsmTemplateBasedReferencedObject) {
                return new TemplateBasedReferencedObjectResultItem((CsmObject)obj);
            }
        }
        return null;
    }

    private static List<CompletionItem> convertData(CompletionResolver.Result res, int classDisplayOffset, CsmCompletionExpression substituteExp, int substituteOffset, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
        CsmResultItem item;
        if (res == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> out = new ArrayList<CompletionItem>(res.size());
        CsmItemFactory factory = CsmCompletionQuery.getCsmItemFactory();
        for (CsmVariable csmVariable : res.getLocalVariables()) {
            item = factory.createLocalVariableResultItem(csmVariable);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmTemplateParameter csmTemplateParameter : res.getTemplateparameters()) {
            item = factory.createTemplateParameterResultItem(csmTemplateParameter);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmField csmField : res.getClassFields()) {
            item = factory.createFieldResultItem(csmField);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getClassEnumerators()) {
            item = factory.createMemberEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmMethod csmMethod : res.getClassMethods()) {
            item = CsmKindUtilities.isConstructor((CsmObject)csmMethod) ? factory.createConstructorResultItem((CsmConstructor)csmMethod, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes) : factory.createMethodResultItem(csmMethod, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmClassifier csmClassifier : res.getProjectClassesifiersEnums()) {
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                item = factory.createClassResultItem((CsmClass)csmClassifier, classDisplayOffset, false);
            } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmClassifier)) {
                CsmClassForwardDeclaration fd = (CsmClassForwardDeclaration)csmClassifier;
                if (fd.getCsmClass() == null) continue;
                item = factory.createClassResultItem(fd.getCsmClass(), classDisplayOffset, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                item = factory.createTypedefResultItem((CsmTypedef)csmClassifier, classDisplayOffset, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                item = factory.createEnumResultItem((CsmEnum)csmClassifier, classDisplayOffset, false);
            }
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmVariable csmVariable : res.getFileLocalVars()) {
            item = factory.createFileLocalVariableResultItem(csmVariable);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getFileLocalEnumerators()) {
            item = factory.createFileLocalEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getFileLocalMacros()) {
            item = factory.createFileLocalMacroResultItem(csmMacro);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmFunction csmFunction : res.getFileLocalFunctions()) {
            item = factory.createFileLocalFunctionResultItem(csmFunction, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getInFileIncludedProjectMacros()) {
            item = factory.createFileIncludedProjectMacroResultItem(csmMacro);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmVariable csmVariable : res.getGlobalVariables()) {
            item = factory.createGlobalVariableResultItem(csmVariable);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getGlobalEnumerators()) {
            item = factory.createGlobalEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getGlobalProjectMacros()) {
            item = factory.createGlobalMacroResultItem(csmMacro);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmFunction csmFunction : res.getGlobalProjectFunctions()) {
            item = factory.createGlobalFunctionResultItem(csmFunction, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmNamespace csmNamespace : res.getGlobalProjectNamespaces()) {
            item = factory.createNamespaceResultItem(csmNamespace, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : res.getProjectNamespaceAliases()) {
            item = factory.createNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmClassifier csmClassifier : res.getLibClassifiersEnums()) {
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                item = factory.createLibClassResultItem((CsmClass)csmClassifier, classDisplayOffset, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                item = factory.createLibTypedefResultItem((CsmTypedef)csmClassifier, classDisplayOffset, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                item = factory.createLibEnumResultItem((CsmEnum)csmClassifier, classDisplayOffset, false);
            }
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getInFileIncludedLibMacros()) {
            item = factory.createFileIncludedLibMacroResultItem(csmMacro);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getLibMacros()) {
            item = factory.createLibMacroResultItem(csmMacro);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmVariable csmVariable : res.getLibVariables()) {
            item = factory.createLibGlobalVariableResultItem(csmVariable);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getLibEnumerators()) {
            item = factory.createLibGlobalEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmFunction csmFunction : res.getLibFunctions()) {
            item = factory.createLibGlobalFunctionResultItem(csmFunction, substituteExp, instantiateTypes);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmNamespace csmNamespace : res.getLibNamespaces()) {
            item = factory.createLibNamespaceResultItem(csmNamespace, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : res.getLibNamespaceAliases()) {
            item = factory.createLibNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (item != null);
            item.setSubstituteOffset(substituteOffset);
            out.add(item);
        }
        return out;
    }

    private static boolean isDeclaration(CsmCompletionExpression substituteExp, CsmOffsetableDeclaration scopeElement) {
        int expId = substituteExp.getExpID();
        return scopeElement == null && (expId == 1 || expId == 27 || expId == 28);
    }

    private static class TemplateBasedReferencedObjectResultItem
    extends CsmResultItem {
        TemplateBasedReferencedObjectResultItem(CsmObject obj) {
            super(obj, 0);
        }

        @Override
        public String getItemText() {
            return "TemplateBasedReferencedObjectResultItem for " + this.getAssociatedObject();
        }

        @Override
        protected Component getPaintComponent(boolean isSelected) {
            return new CsmPaintComponent(){

                protected void draw(Graphics g) {
                }

                public String toString() {
                    return "fake TemplateBasedReferencedObjectResultItem paint component";
                }
            };
        }

        @Override
        public String toString() {
            return "TemplateBasedReferencedObjectResultItem for " + this.getAssociatedObject();
        }
    }

    private static class TemplateBasedReferencedObjectImpl
    implements CsmTemplateBasedReferencedObject {
        private TemplateBasedReferencedObjectImpl() {
        }

        public int getNameStartOffset() {
            return 0;
        }

        public int getNameEndOffset() {
            return 0;
        }

        public CharSequence getName() {
            return "template based ref object";
        }

        public CsmFile getContainingFile() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public CsmOffsetable.Position getStartPosition() {
            return null;
        }

        public CsmOffsetable.Position getEndPosition() {
            return null;
        }

        public CharSequence getText() {
            return this.getName();
        }
    }

    public static final class DefaultCsmItemFactory
    implements CsmItemFactory {
        @Override
        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace pkg, boolean displayFullNamespacePath) {
            return new CsmResultItem.NamespaceResultItem(pkg, displayFullNamespacePath, 1000);
        }

        @Override
        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias alias, boolean displayFullNamespacePath) {
            return new CsmResultItem.NamespaceAliasResultItem(alias, displayFullNamespacePath, 1000);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return this.createGlobalEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return this.createGlobalEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.EnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass cls, int classDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.ClassResultItem(cls, classDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.ForwardClassResultItem createForwardClassResultItem(CsmClassForwardDeclaration cls, int classDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.ForwardClassResultItem(cls, classDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum enm, int enumDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.EnumResultItem(enm, enumDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef def, int classDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.TypedefResultItem(def, classDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass cls, int classDisplayOffset, boolean displayFQN) {
            return this.createClassResultItem(cls, classDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum enm, int enumDisplayOffset, boolean displayFQN) {
            return this.createEnumResultItem(enm, enumDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef def, int classDisplayOffset, boolean displayFQN) {
            return this.createTypedefResultItem(def, classDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField fld) {
            return new CsmResultItem.FieldResultItem(fld, 1000);
        }

        @Override
        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod mtd, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.MethodResultItem((CsmFunction)mtd, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor ctr, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.ConstructorResultItem((CsmFunction)ctr, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.GlobalFunctionResultItem(fun, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable var) {
            return new CsmResultItem.GlobalVariableResultItem(var, 1000);
        }

        @Override
        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable var) {
            return new CsmResultItem.LocalVariableResultItem(var, 1000);
        }

        @Override
        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable var) {
            return new CsmResultItem.FileLocalVariableResultItem(var, 1000);
        }

        @Override
        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.FileLocalFunctionResultItem(fun, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro mac) {
            return new CsmResultItem.MacroResultItem(mac, 1000);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable var) {
            return this.createGlobalVariableResultItem(var);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return this.createGlobalEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean instantiateTypes) {
            return this.createGlobalFunctionResultItem(fun, substituteExp, false, instantiateTypes);
        }

        @Override
        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace pkg, boolean displayFullNamespacePath) {
            return this.createNamespaceResultItem(pkg, displayFullNamespacePath);
        }

        @Override
        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias alias, boolean displayFullNamespacePath) {
            return this.createNamespaceAliasResultItem(alias, displayFullNamespacePath);
        }

        @Override
        public CsmResultItem.TemplateParameterResultItem createTemplateParameterResultItem(CsmTemplateParameter par) {
            return new CsmResultItem.TemplateParameterResultItem(par, 1000);
        }

        @Override
        public CsmResultItem createLabelResultItem(CsmLabel csmStatement) {
            return new CsmResultItem.LabelResultItem(csmStatement, 1000);
        }
    }

    public static interface CsmItemFactory {
        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem createLabelResultItem(CsmLabel var1);

        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField var1);

        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.ForwardClassResultItem createForwardClassResultItem(CsmClassForwardDeclaration var1, int var2, boolean var3);

        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro var1);

        public CsmResultItem.TemplateParameterResultItem createTemplateParameterResultItem(CsmTemplateParameter var1);

        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro var1);

        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);

        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3);

        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);
    }

    public static class CsmCompletionResult {
        private int classDisplayOffset;
        private CsmCompletionExpression substituteExp;
        private int substituteOffset;
        private int substituteLength;
        private JTextComponent component;
        private BaseDocument baseDocument;
        private List<CompletionItem> items;
        private boolean simpleVariableExpression;

        public CsmCompletionResult(JTextComponent component, BaseDocument doc, Collection data, String title, CsmCompletionExpression substituteExp, int classDisplayOffset, boolean isProjectBeeingParsed, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
            this(component, doc, data, title, substituteExp, substituteExp.getTokenOffset(0), substituteExp.getTokenLength(0), classDisplayOffset, isProjectBeeingParsed, contextElement, instantiateTypes);
        }

        public CsmCompletionResult(JTextComponent component, BaseDocument doc, CompletionResolver.Result res, String title, CsmCompletionExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset, boolean isProjectBeeingParsed, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
            this(component, doc, CsmCompletionQuery.convertData(res, classDisplayOffset, substituteExp, substituteOffset, contextElement, instantiateTypes), true, title, substituteExp, substituteOffset, substituteLength, classDisplayOffset, isProjectBeeingParsed);
        }

        public CsmCompletionResult(JTextComponent component, BaseDocument doc, Collection data, String title, CsmCompletionExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset, boolean isProjectBeeingParsed, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
            this(component, doc, CsmCompletionQuery.convertData(data, classDisplayOffset, substituteExp, substituteOffset, contextElement, instantiateTypes), true, title, substituteExp, substituteOffset, substituteLength, classDisplayOffset, isProjectBeeingParsed);
        }

        public CsmCompletionResult(JTextComponent component, BaseDocument doc, List<CompletionItem> data, boolean updateTitle, String title, CsmCompletionExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset, boolean isProjectBeeingParsed) {
            this.component = component;
            this.baseDocument = doc;
            this.substituteExp = substituteExp;
            this.substituteOffset = substituteOffset;
            this.substituteLength = substituteLength;
            this.classDisplayOffset = classDisplayOffset;
            this.items = data;
        }

        public List<CompletionItem> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        private static String getTitle(List data, String origTitle, boolean isProjectBeeingParsed) {
            if (CsmUtilities.DEBUG) {
                System.out.println("original title (resolved type) was " + origTitle);
            }
            String out = NO_SUGGESTIONS;
            if (data != null && data.size() > 0) {
                out = origTitle;
            }
            if (isProjectBeeingParsed) {
                out = MessageFormat.format(PROJECT_BEEING_PARSED, out);
            }
            return out;
        }

        protected JTextComponent getComponent() {
            return this.component;
        }

        protected int getSubstituteLength() {
            return this.substituteLength;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }

        protected CsmCompletionExpression getSubstituteExp() {
            return this.substituteExp;
        }

        protected int getClassDisplayOffset() {
            return this.classDisplayOffset;
        }

        private void setSimpleVariableExpression(boolean simple) {
            this.simpleVariableExpression = simple;
        }

        public boolean isSimpleVariableExpression() {
            return this.simpleVariableExpression;
        }
    }

    class Context {
        private boolean sort;
        private JTextComponent component;
        private CompletionSupport sup;
        private boolean openingSource;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = false;
        private boolean memberPointer = false;
        private boolean scopeAccessedClassifier = false;
        private CsmNamespace lastNamespace;
        private CsmType lastType;
        private CsmCompletionResult result;
        private boolean isConstructor;
        private final CsmFinder finder;
        private final CsmFile contextFile;
        private CompletionResolver compResolver;
        private CsmOffsetableDeclaration contextElement;
        private final boolean instantiateTypes;

        public Context(JTextComponent component, CompletionSupport sup, boolean openingSource, int endOffset, CsmFinder finder, CompletionResolver compResolver, CsmOffsetableDeclaration contextElement, boolean sort, boolean instantiateTypes) {
            this.component = component;
            this.sup = sup;
            this.openingSource = openingSource;
            this.endOffset = endOffset;
            this.finder = finder;
            this.contextFile = finder == null ? null : finder.getCsmFile();
            this.compResolver = compResolver;
            this.contextElement = contextElement;
            this.sort = sort;
            this.instantiateTypes = instantiateTypes;
        }

        private int convertOffset(int pos) {
            return this.sup.doc2context(pos);
        }

        private boolean resolve(int varPos, String var, boolean match) {
            varPos = this.convertOffset(varPos);
            return this.compResolver.refresh() && this.compResolver.resolve(varPos, var, match);
        }

        private void setFindType(boolean findType) {
            this.findType = findType;
        }

        protected Object clone() {
            return new Context(this.component, this.sup, this.openingSource, this.endOffset, this.finder, this.compResolver, this.contextElement, this.sort, this.instantiateTypes);
        }

        private CsmClassifier extractLastTypeClassifier(ExprKind expKind) {
            CsmCompletion.SimpleClass cls = this.lastType.getArrayDepth() == 0 || expKind == ExprKind.ARROW ? CsmCompletionQuery.getClassifier(this.lastType, this.contextFile) : CsmCompletion.OBJECT_CLASS_ARRAY;
            return cls;
        }

        private Collection<CsmFunction> getConstructors(CsmClass cls) {
            ArrayList<CsmFunction> out = new ArrayList<CsmFunction>();
            CsmSelect.CsmFilterBuilder filterBuilder = CsmSelect.getFilterBuilder();
            CsmSelect.CsmFilter filter = filterBuilder.createCompoundFilter(filterBuilder.createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION}), filterBuilder.createNameFilter(cls.getName(), true, true, false));
            Iterator classMembers = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter);
            while (classMembers.hasNext()) {
                CsmMember csmMember = (CsmMember)classMembers.next();
                if (!CsmKindUtilities.isConstructor((CsmObject)csmMember)) continue;
                out.add((CsmFunction)((CsmConstructor)csmMember));
            }
            return out;
        }

        private CsmType extractFunctionType(Collection<CsmFunction> mtdList, CsmCompletionExpression genericNameExp) {
            CsmType out = null;
            if (mtdList.isEmpty()) {
                return null;
            }
            for (CsmFunction fun : mtdList) {
                CsmObject inst;
                if (genericNameExp != null && CsmKindUtilities.isTemplate((CsmObject)fun) && CsmKindUtilities.isFunction((CsmObject)(inst = this.createInstantiation((CsmTemplate)fun, genericNameExp)))) {
                    fun = (CsmFunction)inst;
                }
                if (CsmKindUtilities.isConstructor((CsmObject)fun)) {
                    CsmClass cls = ((CsmConstructor)fun).getContainingClass();
                    out = CsmCompletion.getType((CsmClassifier)cls, 0, false, 0, false);
                } else {
                    out = fun.getReturnType();
                }
                if (out == null) continue;
                break;
            }
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CsmType resolveType(CsmCompletionExpression exp) {
            CsmType typ = exp.getCachedType();
            if (typ == null) {
                Context ctx = (Context)this.clone();
                ctx.setFindType(true);
                QueryScope old = ctx.compResolver.setResolveScope(QueryScope.GLOBAL_QUERY);
                try {
                    if (ctx.resolveExp(exp)) {
                        typ = ctx.lastType;
                    }
                }
                finally {
                    exp.cacheType(typ);
                    ctx.compResolver.setResolveScope(old);
                }
            }
            return typ;
        }

        private boolean isProjectBeeingParsed() {
            return CsmCompletionQuery.this.isProjectBeeingParsed(this.openingSource);
        }

        private ExprKind extractKind(CsmCompletionExpression exp, int i, int startIdx, boolean lastDot, boolean reset) {
            ExprKind kind;
            block15: {
                block16: {
                    int tokCount;
                    block14: {
                        kind = ExprKind.NONE;
                        tokCount = exp.getTokenCount();
                        if (i != startIdx) break block14;
                        kind = ExprKind.NONE;
                        break block15;
                    }
                    if (i - 1 >= tokCount) break block16;
                    switch (exp.getTokenID(i - 1)) {
                        case ARROW: {
                            kind = ExprKind.ARROW;
                            if (reset) {
                                this.scopeAccessedClassifier = false;
                                break;
                            }
                            break block15;
                        }
                        case DOT: {
                            kind = ExprKind.DOT;
                            if (reset) {
                                this.scopeAccessedClassifier = false;
                                break;
                            }
                            break block15;
                        }
                        case SCOPE: {
                            kind = ExprKind.SCOPE;
                            if (reset) {
                                this.scopeAccessedClassifier = true;
                                break;
                            }
                            break block15;
                        }
                        default: {
                            System.err.println("unexpected token " + exp.getTokenID(i));
                            break;
                        }
                    }
                    break block15;
                }
                if (lastDot) {
                    switch (exp.getExpID()) {
                        case 25: 
                        case 26: {
                            kind = ExprKind.ARROW;
                            if (!reset) break;
                            this.scopeAccessedClassifier = false;
                            break;
                        }
                        case 4: 
                        case 5: {
                            kind = ExprKind.DOT;
                            if (!reset) break;
                            this.scopeAccessedClassifier = false;
                            break;
                        }
                        case 27: 
                        case 28: {
                            kind = ExprKind.SCOPE;
                            if (!reset) break;
                            this.scopeAccessedClassifier = true;
                            break;
                        }
                        default: {
                            System.err.println("unexpected expression" + exp);
                        }
                    }
                }
            }
            return kind;
        }

        private boolean resolveParams(CsmCompletionExpression exp, boolean lastDot, ExprKind[] lastKind) {
            CsmType opType;
            boolean ok = true;
            int parmCnt = exp.getParameterCount();
            int startIdx = 0;
            int tokCount = exp.getTokenCount();
            for (int i = tokCount - 1; 0 <= i; --i) {
                CppTokenId token = exp.getTokenID(i);
                if (token != CppTokenId.DOTMBR && token != CppTokenId.ARROWMBR) continue;
                startIdx = i + 1;
                break;
            }
            ExprKind kind = ExprKind.NONE;
            ExprKind nextKind = ExprKind.NONE;
            int lastInd = parmCnt - 1;
            AtomicBoolean derefOfTHIS = new AtomicBoolean(false);
            for (int i = startIdx; i < parmCnt && ok; ++i) {
                CsmType opType2;
                kind = this.extractKind(exp, i, startIdx, lastDot, true);
                nextKind = this.extractKind(exp, i + 1, startIdx, lastDot, false);
                if (kind == ExprKind.ARROW && !derefOfTHIS.get() && i != startIdx && (i < parmCnt || lastDot || this.findType) && this.lastType != null && this.lastType.getArrayDepth() == 0 && (opType2 = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, CsmFunction.OperatorKind.ARROW, 15)) != null) {
                    this.lastType = opType2;
                }
                derefOfTHIS.set(false);
                ok = this.resolveItem(exp.getParameter(i), i == startIdx, !lastDot && i == lastInd, kind, nextKind, derefOfTHIS);
            }
            if (ok && lastDot && (kind = this.extractKind(exp, tokCount + 1, startIdx, true, true)) == ExprKind.ARROW && !derefOfTHIS.get() && (lastDot || this.findType) && this.lastType != null && this.lastType.getArrayDepth() == 0 && (opType = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, CsmFunction.OperatorKind.ARROW, 15)) != null) {
                this.lastType = opType;
            }
            lastKind[0] = kind;
            return ok;
        }

        boolean resolveExp(CsmCompletionExpression exp) {
            boolean lastDot = false;
            boolean ok = true;
            switch (exp.getExpID()) {
                case 5: 
                case 26: {
                    lastDot = true;
                }
                case 4: 
                case 25: {
                    ExprKind[] lastParamKind = new ExprKind[]{ExprKind.NONE};
                    ok = this.resolveParams(exp, lastDot, lastParamKind);
                    if (!ok || !lastDot) break;
                    int tokenCntM1 = exp.getTokenCount() - 1;
                    int substPos = exp.getTokenOffset(tokenCntM1) + exp.getTokenLength(tokenCntM1);
                    if (this.lastType != null) {
                        List<Object> res;
                        CsmClassifier cls = this.extractLastTypeClassifier(lastParamKind[0]);
                        if (this.openingSource) {
                            res = new ArrayList<CsmClassifier>();
                            res.add(this.lastType.getClassifier());
                        } else {
                            res = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, cls, "", false, this.staticOnly && !this.memberPointer, false, true, this.scopeAccessedClassifier, true, this.sort);
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, CsmCompletionQuery.formatType(this.lastType, true, true, true), exp, substPos, 0, cls.getName().length() + 1, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    this.result = null;
                    break;
                }
                case 28: {
                    lastDot = true;
                }
                case 27: {
                    List<Object> res;
                    this.staticOnly = true;
                    ExprKind[] lastParamKind = new ExprKind[]{ExprKind.NONE};
                    ok = this.resolveParams(exp, lastDot, lastParamKind);
                    if (!ok || !lastDot) break;
                    int tokenCntM1 = exp.getTokenCount() - 1;
                    int substPos = exp.getTokenOffset(tokenCntM1) + exp.getTokenLength(tokenCntM1);
                    if (this.lastType != null) {
                        List<Object> res2;
                        CsmClassifier cls = this.extractLastTypeClassifier(ExprKind.SCOPE);
                        if (this.openingSource) {
                            res2 = new ArrayList<CsmClassifier>();
                            res2.add(this.lastType.getClassifier());
                        } else {
                            res2 = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, cls, "", false, this.staticOnly && !this.memberPointer, false, true, this.scopeAccessedClassifier, false, this.sort);
                            List<CsmClassifier> nestedClassifiers = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, cls, "", false, true, this.sort);
                            res2.addAll(nestedClassifiers);
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res2, CsmCompletionQuery.formatType(this.lastType, true, true, true), exp, substPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    String searchPkg = (this.lastNamespace.isGlobal() ? "" : this.lastNamespace.getQualifiedName()) + "::";
                    if (this.openingSource) {
                        res = new ArrayList<CsmNamespace>();
                        res.add(this.lastNamespace);
                    } else {
                        res = this.finder.findNestedNamespaces(this.lastNamespace, "", false, false);
                        String text = null;
                        try {
                            int firstTokenIdx = exp.getTokenOffset(0);
                            int cmdStartIdx = this.sup.getLastCommandSeparator(firstTokenIdx);
                            if (cmdStartIdx >= 0) {
                                text = this.sup.getDocument().getText(cmdStartIdx, firstTokenIdx - cmdStartIdx);
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                        if (text != null && -1 == text.indexOf("namespace")) {
                            res.addAll(this.finder.findNamespaceElements(this.lastNamespace, "", false, false, false));
                        }
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, searchPkg + '*', exp, substPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 15: {
                    List<CsmClassifier> res = this.finder.findClasses(null, "", false, false);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, "*", exp, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 35: {
                    String name = exp.getParameter(0).getTokenText(0);
                    List<CsmLabel> res = this.finder.findLabel(this.contextElement, name, false, false);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, "*", exp, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 24: {
                    exp = exp.getParameter(0);
                }
                default: {
                    AtomicBoolean derefOfTHIS = new AtomicBoolean(false);
                    ok = this.resolveItem(exp, true, true, ExprKind.NONE, ExprKind.NONE, derefOfTHIS);
                }
            }
            return ok;
        }

        private CsmType getPredefinedType(CsmCompletionExpression item) {
            CsmFile containingFile = CsmCompletionQuery.this.getFinder().getCsmFile();
            int startOffset = item.getTokenOffset(0);
            int lastInd = item.getTokenCount() - 1;
            int endtOffset = item.getTokenOffset(lastInd) + item.getTokenLength(lastInd);
            return CsmCompletion.getPredefinedType(containingFile, startOffset, endtOffset, item.getType());
        }

        boolean resolveItem(CsmCompletionExpression item, boolean first, boolean last, ExprKind kind, ExprKind nextKind, AtomicBoolean derefOfThisOUT) {
            CsmClassifier classifier;
            boolean cont = true;
            boolean methodOpen = false;
            boolean skipConstructors = kind != ExprKind.NONE && kind != ExprKind.SCOPE;
            block0 : switch (item.getExpID()) {
                case 0: {
                    if (first) {
                        this.lastType = this.getPredefinedType(item);
                        this.staticOnly = false;
                        break;
                    }
                    cont = false;
                    break;
                }
                case 1: {
                    Object res;
                    CsmClassifier classifier2;
                    switch (item.getTokenID(0)) {
                        case THIS: {
                            if (first) {
                                CsmClass cls = this.sup.getClass(item.getTokenOffset(0));
                                if (cls == null) break block0;
                                derefOfThisOUT.set(true);
                                this.lastType = CsmCompletion.getType((CsmClassifier)cls, 0, false, 0, false);
                                this.staticOnly = false;
                                break;
                            }
                            this.staticOnly = false;
                            break;
                        }
                        default: {
                            String var = item.getTokenText(0);
                            int varPos = item.getTokenOffset(0) + item.getTokenLength(0);
                            if (first) {
                                Collection<? extends CsmObject> res2;
                                Collection<? extends CsmObject> res3;
                                if (last && !this.findType) {
                                    CompletionResolver.Result res4 = null;
                                    if (this.isConstructor) {
                                        this.compResolver.setResolveTypes(39322242);
                                    } else {
                                        this.compResolver.setResolveTypes(1);
                                    }
                                    if (this.resolve(varPos, var, this.openingSource)) {
                                        res4 = this.compResolver.getResult();
                                    }
                                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res4, var + '*', item, item.getTokenOffset(0), item.getTokenLength(0), 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                    break;
                                }
                                if (nextKind != ExprKind.SCOPE) {
                                    if (first && !this.findType) {
                                        this.lastType = this.findExactVarType(var, varPos);
                                    }
                                    if (this.lastType == null) {
                                        CompletionResolver.Result res5 = null;
                                        this.compResolver.setResolveTypes(1);
                                        if (this.resolve(varPos, var, true)) {
                                            res5 = this.compResolver.getResult();
                                            ArrayList vars = new ArrayList();
                                            res5.addResulItemsToCol(vars);
                                            for (CsmObject firstElem : vars) {
                                                if (CsmKindUtilities.isVariable((CsmObject)firstElem)) {
                                                    CsmVariable csmVariable = (CsmVariable)firstElem;
                                                    this.lastType = csmVariable.getType();
                                                } else if (this.findType && CsmKindUtilities.isClassifier((CsmObject)firstElem)) {
                                                    this.lastType = CsmCompletion.getType((CsmClassifier)firstElem, 0, false, 0, false);
                                                }
                                                if (this.lastType == null) continue;
                                                break;
                                            }
                                        }
                                    }
                                }
                                if (this.lastType != null) {
                                    this.staticOnly = false;
                                    break;
                                }
                                if (var.length() == 0) {
                                    this.lastNamespace = this.finder.getCsmFile().getProject().getGlobalNamespace();
                                    break;
                                }
                                this.compResolver.setResolveTypes(37749378);
                                boolean foundVisibleClassifier = false;
                                if (this.resolve(varPos, var, true) && !(res3 = this.compResolver.getResult().addResulItemsToCol(new ArrayList())).isEmpty()) {
                                    this.lastType = null;
                                    CsmObject classifierCandidate = null;
                                    for (CsmObject csmObject : res3) {
                                        if (this.lastType != null || !CsmKindUtilities.isClassifier((CsmObject)csmObject)) continue;
                                        if (classifierCandidate == null) {
                                            classifierCandidate = csmObject;
                                        }
                                        if (!CsmIncludeResolver.getDefault().isObjectVisible(this.contextFile, csmObject)) continue;
                                        this.lastType = CsmCompletion.getType((CsmClassifier)csmObject, 0, false, 0, false);
                                        foundVisibleClassifier = true;
                                        break;
                                    }
                                    if (this.lastType == null && classifierCandidate != null) {
                                        this.lastType = CsmCompletion.getType((CsmClassifier)classifierCandidate, 0, false, 0, false);
                                    }
                                }
                                if (foundVisibleClassifier) break block0;
                                QueryScope old = this.compResolver.setResolveScope(QueryScope.GLOBAL_QUERY);
                                this.compResolver.setResolveTypes(0x180000);
                                if (this.resolve(varPos, var, true) && !(res2 = this.compResolver.getResult().addResulItemsToCol(new ArrayList())).isEmpty()) {
                                    CsmObject ns = res2.iterator().next();
                                    if (CsmKindUtilities.isNamespaceAlias((CsmObject)ns)) {
                                        this.lastNamespace = ((CsmNamespaceAlias)ns).getReferencedNamespace();
                                    } else if (CsmKindUtilities.isNamespace((Object)ns)) {
                                        this.lastNamespace = (CsmNamespace)ns;
                                    }
                                }
                                this.compResolver.setResolveScope(old);
                                if (this.lastNamespace == null) break block0;
                                this.lastType = null;
                                break;
                            }
                            boolean needToCheckNS = true;
                            if (this.lastType != null) {
                                needToCheckNS = false;
                                if (this.findType || !last) {
                                    CsmClass csmClass;
                                    List<CsmClassifier> classes;
                                    CsmClassifier classifier22;
                                    boolean inner = false;
                                    int ad = this.lastType.getArrayDepth();
                                    if (this.staticOnly && ad == 0 && CsmKindUtilities.isClass((CsmObject)(classifier22 = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile))) && (classes = this.finder.findNestedClassifiers(this.contextElement, csmClass = (CsmClass)classifier22, var, true, true, this.sort)) != null && !classes.isEmpty()) {
                                        this.lastType = CsmCompletion.createType(classes.get(0), 0, 0, false);
                                        inner = true;
                                    }
                                    if (!inner) {
                                        if (ad == 0 || kind == ExprKind.ARROW) {
                                            classifier2 = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile);
                                            if (CsmKindUtilities.isClass((CsmObject)classifier2)) {
                                                CsmClass csmClass2 = (CsmClass)classifier2;
                                                List<CsmField> elemList = this.finder.findFields(this.contextElement, csmClass2, var, true, this.staticOnly, true, true, this.scopeAccessedClassifier, this.sort);
                                                if (kind == ExprKind.ARROW || kind == ExprKind.DOT) {
                                                    List<CsmClass> baseClasses = this.finder.findBaseClasses(this.contextElement, (CsmClassifier)csmClass2, var, true, this.sort);
                                                    if (elemList == null) {
                                                        elemList = baseClasses;
                                                    } else if (baseClasses != null) {
                                                        elemList.addAll(baseClasses);
                                                    }
                                                }
                                                if (elemList != null && elemList.size() > 0) {
                                                    CsmObject csmObj = (CsmObject)elemList.get(0);
                                                    this.lastType = CsmCompletion.getObjectType(csmObj);
                                                    this.staticOnly = false;
                                                } else if (kind != ExprKind.ARROW) {
                                                    this.lastType = null;
                                                    cont = false;
                                                }
                                            } else {
                                                this.lastType = null;
                                                cont = false;
                                            }
                                        } else {
                                            cont = false;
                                        }
                                    }
                                } else {
                                    this.scopeAccessedClassifier = kind == ExprKind.SCOPE;
                                    CsmClassifier cls = this.extractLastTypeClassifier(kind);
                                    if (cls == null) {
                                        this.lastType = null;
                                        cont = false;
                                    } else {
                                        boolean inspectParentClasses = this.contextElement != null || !this.scopeAccessedClassifier;
                                        res = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, cls, var, this.openingSource, this.staticOnly && !this.memberPointer, false, inspectParentClasses, this.scopeAccessedClassifier, skipConstructors, this.sort);
                                        List<CsmClassifier> list = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, cls, var, this.openingSource, true, this.sort);
                                        res.addAll(list);
                                        if (kind == ExprKind.ARROW || kind == ExprKind.DOT) {
                                            List<CsmClass> baseClasses = this.finder.findBaseClasses(this.contextElement, cls, var, this.openingSource, this.sort);
                                            res.addAll(baseClasses);
                                        }
                                        if (res.isEmpty() && this.scopeAccessedClassifier && this.lastNamespace != null) {
                                            needToCheckNS = true;
                                        } else {
                                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), (Collection)res, CsmCompletionQuery.formatType(this.lastType, true, true, false) + var + '*', item, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                        }
                                    }
                                }
                            }
                            if (this.lastNamespace == null || !needToCheckNS) break block0;
                            String searchPkg = (this.lastNamespace.isGlobal() ? "" : this.lastNamespace.getQualifiedName() + "::") + var;
                            if (this.findType || !last) {
                                CsmNamespace curNs;
                                List<CsmNamespace> res6 = this.finder.findNestedNamespaces(this.lastNamespace, var, true, false);
                                CsmNamespace csmNamespace = curNs = res6.isEmpty() ? null : res6.get(0);
                                if (curNs != null) {
                                    this.lastNamespace = curNs;
                                    this.lastType = null;
                                    break;
                                }
                                res6 = this.finder.findNamespaceElements(this.lastNamespace, var, true, false, true);
                                CsmObject csmObject = res6.isEmpty() ? null : (CsmObject)res6.iterator().next();
                                this.lastType = CsmCompletion.getObjectType(csmObject);
                                cont = this.lastType != null;
                                this.lastNamespace = null;
                                break;
                            }
                            if (!last) break block0;
                            List<CsmNamespace> res7 = this.finder.findNestedNamespaces(this.lastNamespace, var, this.openingSource, false);
                            res7.addAll(this.finder.findNamespaceElements(this.lastNamespace, var, this.openingSource, false, false));
                            res7.addAll(this.finder.findStaticNamespaceElements(this.lastNamespace, var, this.openingSource));
                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res7, searchPkg + '*', item, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    CsmClassifier cls;
                    this.lastType = this.resolveType(item.getParameter(0));
                    cont = false;
                    if (this.lastType == null || (cls = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile)) == null) break;
                    if (item.getParameterCount() == 2) {
                        int ptrDepth = this.lastType.getPointerDepth();
                        int arrDepth = this.lastType.getArrayDepth();
                        if (ptrDepth > 0) {
                            this.lastType = CsmCompletion.getType(cls, ptrDepth, --ptrDepth > 0, arrDepth, this.lastType.isConst());
                        } else if (arrDepth > 0) {
                            this.lastType = CsmCompletion.getType(cls, ptrDepth, ptrDepth > 0, --arrDepth, this.lastType.isConst());
                        } else {
                            CsmFunction opArray = CsmCompletionQuery.getOperator(cls, this.contextFile, CsmFunction.OperatorKind.ARRAY);
                            if (opArray != null) {
                                this.lastType = opArray.getReturnType();
                            }
                        }
                        cont = true;
                        break;
                    }
                    this.lastType = CsmCompletion.getType(cls, this.lastType.getPointerDepth(), this.lastType.isPointer(), this.lastType.getArrayDepth() + 1, this.lastType.isConst());
                    cont = true;
                    break;
                }
                case 16: {
                    this.lastType = CsmCompletion.BOOLEAN_TYPE;
                    break;
                }
                case 17: {
                    CsmType typ = this.resolveType(item.getParameter(0));
                    if (typ == null) break;
                    this.lastType = typ;
                    CsmClassifier cls = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile);
                    if (cls == null || !CsmKindUtilities.isTemplate((CsmObject)cls)) break;
                    CsmObject obj = this.createInstantiation((CsmTemplate)cls, item);
                    if (obj != null && CsmKindUtilities.isClass((CsmObject)obj)) {
                        this.lastType = CsmCompletion.createType((CsmClassifier)((CsmClass)obj), 0, 0, false);
                    }
                    if (!last || !CsmKindUtilities.isClass((CsmObject)obj)) break;
                    CsmClass c = (CsmClass)obj;
                    LinkedHashSet<CsmClass> classList = new LinkedHashSet<CsmClass>();
                    classList.add(c);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), classList, ((Object)c.getQualifiedName()).toString(), item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 2: 
                case 18: {
                    CsmClassifier classifier2;
                    boolean boolOperator = false;
                    CompletionResolver.Result res = null;
                    Collection<CsmFunction> mtdList = new LinkedHashSet<CsmFunction>();
                    this.compResolver.setResolveTypes(0x800828);
                    String operatorPrefix = "operator " + item.getTokenText(0);
                    if (this.resolve(item.getTokenOffset(0), operatorPrefix, false)) {
                        res = this.compResolver.getResult();
                    }
                    res.addResulItemsToCol(mtdList);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, operatorPrefix, item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    this.lastType = null;
                    switch (item.getTokenID(0)) {
                        case EQ: 
                        case PLUSEQ: 
                        case MINUSEQ: 
                        case STAREQ: 
                        case SLASHEQ: 
                        case AMPEQ: 
                        case BAREQ: 
                        case CARETEQ: 
                        case PERCENTEQ: 
                        case LTLTEQ: 
                        case GTGTEQ: {
                            if (item.getParameterCount() <= 0) break;
                            this.lastType = this.resolveType(item.getParameter(0));
                            this.staticOnly = false;
                            break;
                        }
                        case LT: 
                        case GT: 
                        case LTEQ: 
                        case GTEQ: 
                        case EQEQ: 
                        case NOTEQ: 
                        case AMPAMP: 
                        case BARBAR: {
                            boolOperator = true;
                        }
                        case PLUS: 
                        case MINUS: {
                            if (this.findType && mtdList.isEmpty() && this.lastType == null) {
                                if (item.getParameterCount() <= 0) break;
                                this.lastType = this.resolveType(item.getParameter(0));
                                this.staticOnly = false;
                                break;
                            }
                        }
                        case LTLT: 
                        case GTGT: 
                        case STAR: 
                        case SLASH: 
                        case AMP: 
                        case BAR: 
                        case CARET: 
                        case PERCENT: {
                            CsmType typ2;
                            CsmType typ1;
                            if (!this.findType || this.lastType != null) break;
                            if (!mtdList.isEmpty()) {
                                List<CsmType> typeList = this.getTypeList(item, 0);
                                Collection<CsmFunction> filtered = CompletionSupport.filterMethods(mtdList, typeList, false, false);
                                if (filtered.size() > 0) {
                                    mtdList = filtered;
                                    this.lastType = this.extractFunctionType(mtdList, null);
                                } else if (item.getParameterCount() > 0) {
                                    this.lastType = this.resolveType(item.getParameter(0));
                                    this.staticOnly = false;
                                }
                            }
                            if (this.lastType == null) {
                                block29 : switch (item.getParameterCount()) {
                                    case 2: {
                                        typ1 = this.resolveType(item.getParameter(0));
                                        if (typ1 == null || typ1.getArrayDepth() != 0) break;
                                        if (CsmCompletion.isPrimitiveClass(typ1.getClassifier())) {
                                            typ2 = this.resolveType(item.getParameter(1));
                                            if (typ2 == null || typ2.getArrayDepth() != 0 || !CsmCompletion.isPrimitiveClass(typ2.getClassifier())) break;
                                            this.lastType = this.sup.getCommonType(typ1, typ2);
                                            break;
                                        }
                                        classifier2 = typ1.getClassifier();
                                        if (!CsmKindUtilities.isClass((CsmObject)classifier2)) break;
                                        CsmClass csmClass = (CsmClass)classifier2;
                                        for (CsmMember member : csmClass.getMembers()) {
                                            if (!CsmKindUtilities.isFunction((CsmObject)member) || !((Object)member.getName()).toString().equals(operatorPrefix)) continue;
                                            this.lastType = ((CsmFunction)member).getReturnType();
                                            break block29;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        CsmType typ = this.resolveType(item.getParameter(0));
                                        if (typ == null || !CsmCompletion.isPrimitiveClass(typ.getClassifier())) break;
                                        this.lastType = typ;
                                    }
                                }
                            }
                            if (this.lastType != null || !boolOperator) break;
                            this.lastType = CsmCompletion.BOOLEAN_TYPE;
                            break;
                        }
                        case COLON: {
                            CsmType typ2;
                            CsmType typ1;
                            switch (item.getParameterCount()) {
                                case 2: {
                                    typ1 = this.resolveType(item.getParameter(0));
                                    typ2 = this.resolveType(item.getParameter(1));
                                    if (typ1 == null || typ2 == null) break;
                                    this.lastType = this.sup.getCommonType(typ1, typ2);
                                    break;
                                }
                                case 1: {
                                    this.lastType = this.resolveType(item.getParameter(0));
                                }
                            }
                            break;
                        }
                        case QUESTION: {
                            if (item.getParameterCount() < 2) break;
                            this.lastType = this.resolveType(item.getParameter(1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (item.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 33: {
                    if (item.getParameterCount() <= 0) break;
                    if (item.getTokenCount() == 1) {
                        switch (item.getTokenID(0)) {
                            case AMP: {
                                this.memberPointer = true;
                            }
                        }
                    }
                    cont = this.resolveExp(item.getParameter(0));
                    this.memberPointer = false;
                    break;
                }
                case 32: {
                    if (item.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(item.getParameter(0));
                    this.staticOnly = false;
                    CsmFunction.OperatorKind opKind = null;
                    if (item.getTokenCount() == 1) {
                        switch (item.getTokenID(0)) {
                            case AMP: {
                                opKind = CsmFunction.OperatorKind.ADDRESS;
                                break;
                            }
                            case STAR: {
                                opKind = CsmFunction.OperatorKind.POINTER;
                            }
                        }
                    }
                    if (opKind == null) break;
                    CsmType opType = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, opKind, 15);
                    if (opType != null) {
                        this.lastType = opType;
                        break;
                    }
                    if (this.lastType == null) break;
                    int ptrDepth = this.lastType.getPointerDepth();
                    if (ptrDepth > 0 && opKind == CsmFunction.OperatorKind.POINTER) {
                        --ptrDepth;
                    }
                    this.lastType = CsmCompletion.getType(CsmCompletionQuery.getClassifier(this.lastType, this.contextFile), ptrDepth, this.lastType.isReference(), this.lastType.getArrayDepth(), this.lastType.isConst());
                    break;
                }
                case 13: {
                    this.lastType = this.resolveType(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 31: {
                    if (item.getParameterCount() <= 0) break;
                    CsmCompletionExpression param = item.getParameter(0);
                    this.staticOnly = false;
                    this.lastType = this.resolveType(param);
                    if (this.lastType == null) break;
                    this.lastType = new CsmCompletion.BaseType(this.lastType.getClassifier(), this.lastType.getPointerDepth() + 1, this.lastType.isReference(), this.lastType.getArrayDepth(), this.lastType.isConst());
                    break;
                }
                case 14: {
                    int nrTokens;
                    if (this.findType) {
                        this.lastType = item.getParameterCount() > 0 ? this.resolveType(item.getParameter(0)) : this.getPredefinedType(item);
                    }
                    if (this.findType && this.lastType != null || (nrTokens = item.getTokenCount()) < 1) break;
                    String varName = item.getTokenText(nrTokens - 1);
                    int varPos = item.getTokenOffset(nrTokens - 1);
                    this.compResolver.setResolveTypes(38273090);
                    if (!this.resolve(varPos, varName, this.openingSource)) break;
                    CompletionResolver.Result res = this.compResolver.getResult();
                    if (this.findType) {
                        CsmClassifier cls = null;
                        ArrayList elems = new ArrayList();
                        res.addResulItemsToCol(elems);
                        for (CsmObject csmObject : elems) {
                            if (CsmKindUtilities.isVariable((CsmObject)csmObject)) {
                                this.lastType = ((CsmVariable)csmObject).getType();
                                break;
                            }
                            if (!CsmKindUtilities.isClassifier((CsmObject)csmObject)) continue;
                            cls = (CsmClassifier)csmObject;
                            break;
                        }
                        if (this.lastType == null && cls != null) {
                            int n;
                            boolean bl = false;
                            for (int i = 0; i < item.getTokenCount() - 1; ++i) {
                                n |= item.getTokenText(i).equals("const");
                            }
                            this.lastType = CsmCompletion.getType(cls, 0, false, 0, n != 0);
                        }
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, varName + '*', item, varPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 9: {
                    this.lastType = this.resolveType(item.getParameter(item.getParameterCount() - 1));
                    break;
                }
                case 12: {
                    this.isConstructor = true;
                    cont = this.resolveExp(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 10: {
                    methodOpen = true;
                }
                case 11: {
                    CsmCompletionExpression mtdNameExp = item.getParameter(0);
                    CsmCompletionExpression genericNameExp = null;
                    while (mtdNameExp.getExpID() == 17) {
                        genericNameExp = mtdNameExp;
                        if (mtdNameExp.getParameterCount() <= 0) break;
                        mtdNameExp = mtdNameExp.getParameter(0);
                    }
                    String mtdName = mtdNameExp.getTokenText(0);
                    CsmCompletionExpression param = item.getParameter(0);
                    if (param.getExpID() == 11) {
                        boolean oldFindType = this.findType;
                        this.setFindType(true);
                        cont = this.resolveExp(param);
                        this.setFindType(oldFindType);
                    }
                    if (this.isConstructor) {
                        CsmClassifier cls = null;
                        if (first) {
                            cls = CompletionSupport.getClassFromName(CsmCompletionQuery.this.getFinder(), mtdName, true);
                        }
                        if (cls == null) {
                            cls = this.findExactClass(mtdName, mtdNameExp.getTokenOffset(0));
                        }
                        if (cls != null) {
                            this.lastType = CsmCompletion.getType(cls, 0, false, 0, false);
                        } else {
                            this.isConstructor = false;
                        }
                    }
                    if (!methodOpen || this.openingSource) {
                        Collection<CsmFunction> mtdList = new LinkedHashSet<CsmFunction>();
                        if (first && (!this.isConstructor || this.lastType == null)) {
                            ArrayList candidates;
                            boolean bl;
                            int varPos = mtdNameExp.getTokenOffset(0);
                            boolean bl2 = bl = this.findType || this.openingSource;
                            if (bl) {
                                candidates = new ArrayList();
                                this.compResolver.setResolveTypes(25167912);
                                if (this.resolve(varPos, mtdName, true)) {
                                    this.compResolver.getResult().addResulItemsToCol(candidates);
                                }
                                for (CsmObject object : candidates) {
                                    if (CsmKindUtilities.isClass((CsmObject)object)) {
                                        mtdList.addAll(this.getConstructors((CsmClass)object));
                                        continue;
                                    }
                                    if (!CsmKindUtilities.isFunction((CsmObject)object)) continue;
                                    mtdList.add((CsmFunction)object);
                                }
                            }
                            this.compResolver.setResolveTypes(0x800828);
                            if (this.resolve(varPos, mtdName, this.openingSource)) {
                                this.compResolver.getResult().addResulItemsToCol(mtdList);
                            }
                            if (!last || this.findType) {
                                candidates = new ArrayList();
                                this.compResolver.setResolveTypes(1364);
                                if (this.resolve(varPos, mtdName, true)) {
                                    this.compResolver.getResult().addResulItemsToCol(candidates);
                                }
                                for (CsmObject object : candidates) {
                                    CsmClassifier cls;
                                    CsmFunction funCall;
                                    CsmType varType;
                                    if (!CsmKindUtilities.isVariable((CsmObject)object) || (varType = ((CsmVariable)object).getType()) == null || (funCall = (cls = CsmCompletionQuery.getClassifier(varType, this.contextFile)) == null ? null : CsmCompletionQuery.getOperator(cls, this.contextFile, CsmFunction.OperatorKind.CAST)) == null) continue;
                                    mtdList.add(funCall);
                                }
                            }
                            if (this.lastType != null && (!last || this.findType)) {
                                CsmFunction funCall;
                                CsmClassifier cls = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile);
                                CsmFunction csmFunction = funCall = cls == null ? null : CsmCompletionQuery.getOperator(cls, this.contextFile, CsmFunction.OperatorKind.CAST);
                                if (funCall != null) {
                                    mtdList.add(funCall);
                                }
                            }
                        } else if (this.lastType != null) {
                            CsmClassifier classifier3 = this.extractLastTypeClassifier(kind);
                            if (CsmKindUtilities.isClass((CsmObject)classifier3)) {
                                boolean bl = this.contextElement != null;
                                mtdList.addAll(this.finder.findMethods(this.contextElement, (CsmClass)classifier3, mtdName, true, false, first, bl, this.scopeAccessedClassifier, this.sort));
                                if (mtdList == null || mtdList.size() == 0) {
                                    List<CsmField> foundFields = this.finder.findFields(this.contextElement, (CsmClass)classifier3, mtdName, true, false, first, true, this.scopeAccessedClassifier, this.sort);
                                    if (foundFields != null && !foundFields.isEmpty()) {
                                        CsmType type;
                                        CsmClassifier cls;
                                        CsmField csmField;
                                        CsmType fldType;
                                        if (!last || this.findType) {
                                            this.lastType = null;
                                            for (CsmField csmField2 : foundFields) {
                                                CsmClassifier cls2;
                                                CsmFunction funCall;
                                                CsmType fldType2 = csmField2.getType();
                                                if (fldType2 != null) {
                                                    if (CsmKindUtilities.isFunctionPointerType((CsmObject)fldType2)) {
                                                        this.lastType = fldType2;
                                                    } else {
                                                        CsmType type2;
                                                        CsmClassifier cls22 = fldType2.getClassifier();
                                                        if (CsmKindUtilities.isTypedef((CsmObject)cls22) && CsmKindUtilities.isFunctionPointerType((CsmObject)(type2 = ((CsmTypedef)cls22).getType()))) {
                                                            this.lastType = fldType2 = type2;
                                                        }
                                                    }
                                                }
                                                if (fldType2 == null || (funCall = (cls2 = CsmCompletionQuery.getClassifier(fldType2, this.contextFile)) == null ? null : CsmCompletionQuery.getOperator(cls2, this.contextFile, CsmFunction.OperatorKind.CAST)) == null) continue;
                                                this.lastType = funCall.getReturnType();
                                            }
                                        }
                                        if (last && (fldType = (csmField = foundFields.get(0)).getType()) != null && CsmKindUtilities.isTypedef((CsmObject)(cls = fldType.getClassifier())) && CsmKindUtilities.isFunctionPointerType((CsmObject)(type = ((CsmTypedef)cls).getType()))) {
                                            this.lastType = fldType = type;
                                            List<CsmType> typeList = this.getTypeList(item, 1);
                                            String parmStr = CsmCompletionQuery.formatTypeList(typeList, methodOpen);
                                            LinkedHashSet<CsmField> varList = new LinkedHashSet<CsmField>();
                                            varList.add(csmField);
                                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), varList, CsmCompletionQuery.formatType(this.lastType, true, true, false) + mtdName + '(' + parmStr + ')', item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                        }
                                    }
                                    return this.lastType != null;
                                }
                            }
                        } else if (this.lastNamespace != null) {
                            CsmNamespace curNs = this.lastNamespace;
                            this.lastNamespace = null;
                            List<CsmNamespace> list = this.finder.findNestedNamespaces(curNs, mtdName, this.openingSource, false);
                            Iterator<CsmNamespace> i$ = list.iterator();
                            if (i$.hasNext()) {
                                CsmNamespace csmNamespace;
                                this.lastNamespace = csmNamespace = i$.next();
                            }
                            List<CsmObject> elems = this.finder.findNamespaceElements(curNs, mtdName, this.openingSource, false, false);
                            for (CsmObject obj : elems) {
                                if (CsmKindUtilities.isFunction((CsmObject)obj)) {
                                    mtdList.add((CsmFunction)obj);
                                    continue;
                                }
                                if (CsmKindUtilities.isTypedef((CsmObject)obj)) {
                                    this.lastType = ((CsmTypedef)obj).getType();
                                    break;
                                }
                                if (!CsmKindUtilities.isClassifier((CsmObject)obj)) continue;
                                this.lastType = CsmCompletion.getType((CsmClassifier)obj, 0, false, 0, false);
                                break;
                            }
                            if (this.findType && mtdList.isEmpty()) {
                                return this.lastType != null || this.lastNamespace != null;
                            }
                        }
                        if (mtdList == null || mtdList.size() == 0) {
                            if (!this.isConstructor) {
                                if (first) {
                                    CsmClassifier cls = null;
                                    if (cls == null) {
                                        cls = this.findExactClass(mtdName, mtdNameExp.getTokenOffset(0));
                                    }
                                    if (cls != null) {
                                        CsmObject csmObject;
                                        if (CsmKindUtilities.isTemplate(cls) && genericNameExp != null && CsmKindUtilities.isClassifier((CsmObject)(csmObject = this.createInstantiation((CsmTemplate)cls, genericNameExp)))) {
                                            cls = (CsmClassifier)csmObject;
                                        }
                                        this.lastType = CsmCompletion.getType(cls, 0, false, 0, false);
                                    }
                                } else {
                                    this.lastType = null;
                                }
                                if (this.lastType == null && (!last || this.findType)) {
                                    this.lastType = this.findBuiltInFunctionReturnType(mtdName, mtdNameExp.getTokenOffset(0));
                                }
                            }
                            return this.lastType != null;
                        }
                        String parmStr = "*";
                        List<CsmType> list = this.getTypeList(item, 1);
                        Collection<CsmFunction> filtered = CompletionSupport.filterMethods(mtdList, list, methodOpen, true);
                        if (filtered.size() > 0) {
                            mtdList = filtered;
                            parmStr = CsmCompletionQuery.formatTypeList(list, methodOpen);
                        }
                        if (mtdList.size() > 0) {
                            if (last && !this.findType) {
                                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), mtdList, CsmCompletionQuery.formatType(this.lastType, true, true, false) + mtdName + '(' + parmStr + ')', item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                break;
                            }
                            this.lastType = this.extractFunctionType(mtdList, genericNameExp);
                            this.staticOnly = false;
                            break;
                        }
                        this.lastType = null;
                        cont = false;
                        break;
                    }
                    int varPos = this.endOffset;
                    this.compResolver.setResolveTypes(1);
                    if (!this.resolve(varPos, "", false)) break;
                    Object res = this.compResolver.getResult();
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), (CompletionResolver.Result)res, mtdName + '*', mtdNameExp, varPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                }
            }
            if ((this.result == null || this.result.getItems().isEmpty()) && this.lastType != null && (this.lastType.isTemplateBased() || CsmFileReferences.isTemplateParameterInvolved((CsmObject)this.lastType) || CsmFileReferences.hasTemplateBasedAncestors((CsmType)this.lastType))) {
                ArrayList<TemplateBasedReferencedObjectImpl> data = new ArrayList<TemplateBasedReferencedObjectImpl>();
                data.add(new TemplateBasedReferencedObjectImpl());
                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), data, "title", item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
            }
            if (last && !first && (this.result == null || this.result.getItems().isEmpty()) && this.lastType != null && CsmKindUtilities.isInstantiation((CsmObject)(classifier = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile)))) {
                boolean instantiatedByTemplateParam = false;
                CsmInstantiation inst = (CsmInstantiation)classifier;
                Map mapping = inst.getMapping();
                for (CsmTemplateParameter templateParam : mapping.keySet()) {
                    CsmType type;
                    CsmSpecializationParameter csmSpecializationParameter = (CsmSpecializationParameter)mapping.get(templateParam);
                    if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)csmSpecializationParameter) || (type = ((CsmTypeBasedSpecializationParameter)csmSpecializationParameter).getType()) == null || !type.isTemplateBased()) continue;
                    instantiatedByTemplateParam = true;
                    break;
                }
                if (instantiatedByTemplateParam && !CsmInstantiationProvider.getDefault().getSpecializations(classifier, this.contextFile, this.endOffset).isEmpty()) {
                    ArrayList<TemplateBasedReferencedObjectImpl> data = new ArrayList<TemplateBasedReferencedObjectImpl>();
                    data.add(new TemplateBasedReferencedObjectImpl());
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), data, "title", item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                }
            }
            if (this.lastType == null && this.lastNamespace == null) {
                cont = false;
            }
            return cont;
        }

        private CsmObject createInstantiation(CsmTemplate template, CsmCompletionExpression exp) {
            if (exp.getExpID() == 17) {
                CsmCompletionExpression paramInst;
                CsmInstantiationProvider ip = CsmInstantiationProvider.getDefault();
                ArrayList<Object> params = new ArrayList<Object>();
                int paramsNumber = template.getTemplateParameters().size() < exp.getParameterCount() - 1 ? template.getTemplateParameters().size() : exp.getParameterCount() - 1;
                block3: for (int i = 0; i < paramsNumber && (paramInst = exp.getParameter(i + 1)) != null; ++i) {
                    switch (paramInst.getExpID()) {
                        case 0: {
                            params.add(ip.createExpressionBasedSpecializationParameter(paramInst.getTokenText(0), this.contextFile, paramInst.getTokenOffset(0), paramInst.getTokenOffset(0) + paramInst.getTokenLength(0)));
                            continue block3;
                        }
                        default: {
                            CsmType type = this.resolveType(paramInst);
                            if (type != null) {
                                params.add(ip.createTypeBasedSpecializationParameter(type));
                                continue block3;
                            }
                            params.add(ip.createExpressionBasedSpecializationParameter(paramInst.getTokenText(0), this.contextFile, paramInst.getTokenOffset(0), paramInst.getTokenOffset(0) + paramInst.getTokenLength(0)));
                        }
                    }
                }
                int contextOffset = exp.getTokenOffset(0);
                return ip.instantiate(template, params, CsmCompletionQuery.this.getFinder().getCsmFile(), contextOffset);
            }
            return null;
        }

        private CsmType findBuiltInFunctionReturnType(String mtdName, int tokenOffset) {
            CsmType out = null;
            if ("typeid".contentEquals(mtdName)) {
                List<CsmClassifier> findClasses;
                Iterator<CsmClassifier> i$;
                CsmNamespace ns;
                CsmClassifier cls = CsmCompletionQuery.this.getFinder().getExactClassifier("std::type_info");
                if (cls == null && (ns = this.findExactNamespace("std", tokenOffset)) != null && (i$ = (findClasses = CsmCompletionQuery.this.getFinder().findClasses(ns, mtdName, true, false)).iterator()).hasNext()) {
                    CsmClassifier csmClassifier;
                    cls = csmClassifier = i$.next();
                }
                if (cls != null) {
                    out = CsmCompletion.getType(cls, 0, false, 0, false);
                }
            }
            return out;
        }

        private CsmNamespace findExactNamespace(String var, int varPos) {
            CsmNamespace ns = null;
            this.compResolver.setResolveTypes(0x180000);
            if (this.resolve(varPos, var, true)) {
                CompletionResolver.Result res = this.compResolver.getResult();
                Collection<? extends CsmObject> addResulItemsToCol = res.addResulItemsToCol(new ArrayList());
                for (CsmObject csmObject : addResulItemsToCol) {
                    if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                        return (CsmNamespace)csmObject;
                    }
                    if (!CsmKindUtilities.isNamespaceAlias((CsmObject)csmObject) || (ns = ((CsmNamespaceAlias)csmObject).getReferencedNamespace()) == null) continue;
                    return ns;
                }
            }
            return ns;
        }

        private CsmClassifier findExactClass(String var, int varPos) {
            CsmClassifier cls = null;
            this.compResolver.setResolveTypes(0x400202);
            if (this.resolve(varPos, var, true)) {
                CompletionResolver.Result res = this.compResolver.getResult();
                Collection<? extends CsmObject> allItems = res.addResulItemsToCol(new ArrayList());
                for (CsmObject csmObject : allItems) {
                    if (CsmKindUtilities.isClassifier((CsmObject)csmObject)) {
                        cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)((CsmClassifier)csmObject), (CsmFile)this.contextFile);
                    }
                    if (cls == null) continue;
                    break;
                }
            }
            return cls;
        }

        private CsmType findExactVarType(String var, int varPos) {
            return this.sup.findExactVarType(this.finder.getCsmFile(), var, varPos, CsmCompletionQuery.this.getFileReferencesContext());
        }

        private List<CsmType> getTypeList(CsmCompletionExpression item, int firstChildIdx) {
            int parmCnt = item.getParameterCount();
            ArrayList<CsmType> typeList = new ArrayList<CsmType>();
            if (parmCnt > firstChildIdx) {
                for (int i = firstChildIdx; i < parmCnt; ++i) {
                    CsmCompletionExpression parm = item.getParameter(i);
                    CsmType typ = this.resolveType(parm);
                    typeList.add(typ);
                }
            }
            return typeList;
        }
    }

    static enum ExprKind {
        NONE,
        SCOPE,
        ARROW,
        DOT;

    }

    public static enum QueryScope {
        LOCAL_QUERY,
        SMART_QUERY,
        GLOBAL_QUERY;

    }
}

