/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class EncloseAction
extends NodeAction {
    public String getName() {
        return NbBundle.getBundle(EncloseAction.class).getString("ACT_EncloseInContainer");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodeArray) {
        List<RADComponent> list = EncloseAction.getComponents(nodeArray);
        return list != null && EncloseAction.getContainer(list) != null;
    }

    protected void performAction(Node[] nodeArray) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        ContainersMenu containersMenu = new ContainersMenu(this.getName(), EncloseAction.getComponents(this.getActivatedNodes()));
        containersMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)containersMenu, (String)EncloseAction.class.getName());
        return containersMenu;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static List<RADComponent> getComponents(Node[] nodeArray) {
        return FormUtils.getSelectedLayoutComponents(nodeArray);
    }

    private static RADVisualContainer getContainer(List list) {
        RADVisualContainer rADVisualContainer = null;
        for (Object e : list) {
            if (e instanceof RADVisualComponent) {
                RADVisualContainer rADVisualContainer2 = ((RADVisualComponent)e).getParentContainer();
                if (rADVisualContainer2 == null || rADVisualContainer != null && rADVisualContainer2 != rADVisualContainer) {
                    return null;
                }
                if (rADVisualContainer != null) continue;
                rADVisualContainer = rADVisualContainer2;
                continue;
            }
            return null;
        }
        return rADVisualContainer;
    }

    private static PaletteItem[] getAllContainers() {
        ArrayList<PaletteItem> arrayList = new ArrayList<PaletteItem>();
        for (PaletteItem paletteItem : PaletteUtils.getAllItems()) {
            Class clazz;
            if ("chooseBean".equals(paletteItem.getExplicitComponentType()) || (clazz = paletteItem.getComponentClass()) == null || !JComponent.class.isAssignableFrom(clazz) || MenuElement.class.isAssignableFrom(clazz) || !FormUtils.isContainer(clazz)) continue;
            arrayList.add(paletteItem);
        }
        return arrayList.toArray(new PaletteItem[arrayList.size()]);
    }

    private static class ContainersMenu
    extends JMenu {
        private boolean initialized = false;
        private List<RADComponent> components;

        private ContainersMenu(String string, List<RADComponent> list) {
            super(string);
            this.components = list;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            final JPopupMenu jPopupMenu = super.getPopupMenu();
            if (!this.initialized) {
                jPopupMenu.removeAll();
                String string = NbBundle.getBundle(EncloseAction.class).getString("MSG_EncloseInPleaseWait");
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setEnabled(false);
                jPopupMenu.add(jMenuItem);
                FormUtils.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        final PaletteItem[] paletteItemArray = EncloseAction.getAllContainers();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jPopupMenu.removeAll();
                                for (PaletteItem paletteItem : paletteItemArray) {
                                    JMenuItem jMenuItem = new JMenuItem(paletteItem.getNode().getDisplayName());
                                    HelpCtx.setHelpIDString((JComponent)jMenuItem, (String)EncloseAction.class.getName());
                                    ContainersMenu.addSortedMenuItem(jPopupMenu, jMenuItem);
                                    jMenuItem.addActionListener(new EncloseActionListener(paletteItem));
                                }
                                jPopupMenu.pack();
                            }
                        });
                    }
                });
                this.initialized = true;
            }
            return jPopupMenu;
        }

        private static void addSortedMenuItem(JPopupMenu jPopupMenu, JMenuItem jMenuItem) {
            String string = jMenuItem.getText();
            for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
                String string2;
                if (!(jPopupMenu.getComponent(i) instanceof JMenuItem) || string.compareTo(string2 = ((JMenuItem)jPopupMenu.getComponent(i)).getText()) >= 0) continue;
                jPopupMenu.add((Component)jMenuItem, i);
                return;
            }
            jPopupMenu.add(jMenuItem);
        }

        private class EncloseActionListener
        implements ActionListener {
            private PaletteItem paletteItem;

            EncloseActionListener(PaletteItem paletteItem) {
                this.paletteItem = paletteItem;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RADVisualContainer rADVisualContainer = EncloseAction.getContainer(ContainersMenu.this.components);
                if (rADVisualContainer != null) {
                    FormModel formModel = rADVisualContainer.getFormModel();
                    MetaComponentCreator metaComponentCreator = formModel.getComponentCreator();
                    if (rADVisualContainer.getLayoutSupport() == null) {
                        LayoutModel layoutModel = formModel.getLayoutModel();
                        Object object = null;
                        UndoableEdit undoableEdit = null;
                        boolean bl = true;
                        try {
                            RADComponent rADComponent = metaComponentCreator.createComponent(this.paletteItem.getComponentClassSource(), rADVisualContainer, null);
                            boolean bl2 = rADComponent instanceof RADVisualContainer;
                            if (!bl2) {
                                String string = NbBundle.getMessage(EncloseAction.class, (String)"MSG_EncloseInNotEmpty");
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
                            } else {
                                RADVisualContainer rADVisualContainer2 = (RADVisualContainer)rADComponent;
                                object = layoutModel.getChangeMark();
                                undoableEdit = layoutModel.getUndoableEdit();
                                layoutModel.removeComponent(rADVisualContainer2.getId(), false);
                                String[] stringArray = new String[ContainersMenu.this.components.size()];
                                int n = 0;
                                for (RADComponent rADComponent2 : ContainersMenu.this.components) {
                                    stringArray[n++] = rADComponent2.getId();
                                }
                                for (RADComponent rADComponent2 : ContainersMenu.this.components) {
                                    formModel.removeComponent(rADComponent2, false);
                                }
                                bl2 = metaComponentCreator.addComponents(ContainersMenu.this.components, rADVisualContainer2);
                                if (bl2) {
                                    FormEditor.getFormDesigner(formModel).getLayoutDesigner().encloseInContainer(stringArray, rADVisualContainer2.getId());
                                } else {
                                    String string = NbBundle.getMessage(EncloseAction.class, (String)"MSG_EncloseInFailed");
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
                                }
                            }
                            boolean bl3 = bl = !bl2;
                            if (object != null && !object.equals(layoutModel.getChangeMark())) {
                                formModel.addUndoableEdit(undoableEdit);
                            }
                            if (bl) {
                                formModel.forceUndoOfCompoundEdit();
                            }
                        }
                        catch (Throwable throwable) {
                            if (object != null && !object.equals(layoutModel.getChangeMark())) {
                                formModel.addUndoableEdit(undoableEdit);
                            }
                            if (bl) {
                                formModel.forceUndoOfCompoundEdit();
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
    }
}

