/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.scope;

import org.jruby.nb.RubyArray;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.scope.TwoVarDynamicScope;

public class ThreeVarDynamicScope
extends TwoVarDynamicScope {
    private static final int SIZE = 3;
    private static final String SIZE_ERROR = "ThreeVarDynamicScope only supports scopes with three variables";
    private static final String GROW_ERROR = "ThreeVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueTwo;

    public ThreeVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public ThreeVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 3) {
            throw new RuntimeException(GROW_ERROR);
        }
    }

    @Override
    public DynamicScope cloneScope() {
        return new ThreeVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo};
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        assert (offset < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
            case 2: {
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        assert (offset < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
            case 2: {
                if (this.variableValueTwo == null) {
                    this.variableValueTwo = nil;
                    return this.variableValueTwo;
                }
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueTwo == null) {
            this.variableValueTwo = nil;
            return this.variableValueTwo;
        }
        return this.variableValueTwo;
    }

    @Override
    public IRubyObject setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset, value, depth - 1);
        }
        assert (offset < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value;
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value, int offset) {
        assert (offset < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value;
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueTwoDepthZero(IRubyObject value) {
        this.variableValueTwo = value;
        return this.variableValueTwo;
    }

    @Override
    public void setArgValues(IRubyObject[] values, int size) {
        assert (size <= 3) : "ThreeVarDynamicScope only supports scopes with three variables, not " + size;
        switch (size) {
            case 3: {
                this.variableValueTwo = values[2];
            }
            case 2: {
                this.variableValueOne = values[1];
            }
            case 1: {
                this.variableValueZero = values[0];
            }
        }
    }

    @Override
    public void setArgValues(IRubyObject arg0) {
        this.variableValueZero = arg0;
    }

    @Override
    public void setArgValues(IRubyObject arg0, IRubyObject arg1) {
        this.variableValueZero = arg0;
        this.variableValueOne = arg1;
    }

    @Override
    public void setArgValues(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.variableValueZero = arg0;
        this.variableValueOne = arg1;
        this.variableValueTwo = arg2;
    }

    @Override
    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        if (this.staticScope.getRestArg() < 0) {
            switch (totalArgs) {
                case 0: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 1: {
                    return new IRubyObject[]{this.variableValueZero};
                }
                case 2: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
                }
                case 3: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo};
                }
            }
            throw new RuntimeException("more args requested than available variables");
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = RuntimeHelpers.splatValue(restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        switch (totalArgs) {
            case 3: {
                argValues[2] = this.variableValueTwo;
            }
            case 2: {
                argValues[1] = this.variableValueOne;
            }
            case 1: {
                argValues[0] = this.variableValueZero;
            }
        }
        return argValues;
    }

    @Override
    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] names = this.staticScope.getVariables();
        buf.append(names[0]).append("=");
        if (this.variableValueZero == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueZero);
        }
        buf.append(",");
        if (this.variableValueOne == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueOne);
        }
        buf.append(",");
        if (this.variableValueTwo == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueTwo);
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

