/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.util.CollectionUtils;

public class Resources
extends DataType
implements ResourceCollection {
    public static final ResourceCollection NONE = new ResourceCollection(){

        public boolean isFilesystemOnly() {
            return true;
        }

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }

        public int size() {
            return 0;
        }
    };
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public Object next() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private Vector rc;
    private Collection coll;
    private boolean cache = false;

    public Resources() {
    }

    public Resources(Project project) {
        this.setProject(project);
    }

    public synchronized void setCache(boolean b) {
        this.cache = b;
    }

    public synchronized void add(ResourceCollection c) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (c == null) {
            return;
        }
        if (this.rc == null) {
            this.rc = new Vector();
        }
        this.rc.add(c);
        this.invalidateExistingIterators();
        this.coll = null;
        this.setChecked(false);
    }

    public synchronized Iterator iterator() {
        if (this.isReference()) {
            return this.getRef().iterator();
        }
        this.validate();
        return new FailFast(this, this.coll.iterator());
    }

    public synchronized int size() {
        if (this.isReference()) {
            return this.getRef().size();
        }
        this.validate();
        return this.coll.size();
    }

    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return this.getRef().isFilesystemOnly();
        }
        this.validate();
        Iterator i = this.getNested().iterator();
        while (i.hasNext()) {
            if (((ResourceCollection)i.next()).isFilesystemOnly()) continue;
            return false;
        }
        return true;
    }

    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.coll == null || this.coll.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = this.coll.iterator();
        while (i.hasNext()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(i.next());
        }
        return sb.toString();
    }

    protected void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            Iterator i = this.getNested().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof DataType)) continue;
                Resources.pushAndInvokeCircularReferenceCheck((DataType)o, stk, p);
            }
            this.setChecked(true);
        }
    }

    protected void invalidateExistingIterators() {
        FailFast.invalidate(this);
    }

    private ResourceCollection getRef() {
        return (ResourceCollection)this.getCheckedRef(ResourceCollection.class, "ResourceCollection");
    }

    private synchronized void validate() {
        this.dieOnCircularReference();
        this.coll = this.coll == null ? new MyCollection() : this.coll;
    }

    private synchronized List getNested() {
        return this.rc == null ? Collections.EMPTY_LIST : this.rc;
    }

    private class MyCollection
    extends AbstractCollection {
        private Collection cached;

        MyCollection() {
        }

        public int size() {
            return this.getCache().size();
        }

        public Iterator iterator() {
            return this.getCache().iterator();
        }

        private synchronized Collection getCache() {
            Collection coll = this.cached;
            if (coll == null) {
                coll = CollectionUtils.asCollection(new MyIterator());
                if (Resources.this.cache) {
                    this.cached = coll;
                }
            }
            return coll;
        }

        private class MyIterator
        implements Iterator {
            private Iterator rci;
            private Iterator ri;

            private MyIterator() {
                this.rci = Resources.this.getNested().iterator();
                this.ri = null;
            }

            public boolean hasNext() {
                boolean result;
                boolean bl = result = this.ri != null && this.ri.hasNext();
                while (!result && this.rci.hasNext()) {
                    this.ri = ((ResourceCollection)this.rci.next()).iterator();
                    result = this.ri.hasNext();
                }
                return result;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.ri.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

