/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.JavaCodeGenerator;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.codegen.CodeUtils;
import org.openide.ErrorManager;

public final class MultiGuardedSection {
    private StyledDocument document;
    private String multiGuardedID;
    private ArrayList<SimpleSection> guardedSections = new ArrayList();
    private ArrayList<String> editableSectionIDs = new ArrayList();
    private int index = 0;
    private boolean guarded = true;
    private CodeWriter writer;

    private MultiGuardedSection(StyledDocument document, String multiGuardedID) {
        assert (multiGuardedID.indexOf(124) < 0);
        this.document = document;
        this.multiGuardedID = multiGuardedID;
        this.initialize();
        JavaCodeGenerator.getDefault().registerUsedMultiGuardedSection(document, this);
    }

    private void initialize() {
        String prefix;
        SimpleSection section;
        GuardedSectionManager instance = GuardedSectionManager.getInstance((StyledDocument)this.document);
        Iterable allSections = instance.getGuardedSections();
        while ((section = CodeUtils.findSectionByPrefix(allSections, prefix = this.createSectionID(this.guardedSections.size(), null))) != null) {
            String editableSectionID = section.getName().substring(prefix.length());
            this.addSection(section, editableSectionID);
        }
        if (this.guardedSections.size() <= 0) {
            String sectionID = this.createSectionID(0, null);
            this.addSection(CodeUtils.createSimpleSectionAfter(this.document, CodeUtils.findLast(allSections), sectionID), null);
        }
    }

    public void switchToGuarded() {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is closed already", this.multiGuardedID});
        }
        if (this.guarded) {
            throw Debug.illegalState((Object[])new Object[]{"Cannot switch to guarded from guarded", this.multiGuardedID, this.index});
        }
        if (!this.isWriterCommitted()) {
            throw Debug.illegalState((Object[])new Object[]{"Writer is not committed yet", this.multiGuardedID, this.index});
        }
        this.writer = null;
        ++this.index;
        this.guarded = !this.guarded;
    }

    public void switchToEditable(String editableSectionID) {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is already closed", this.multiGuardedID});
        }
        if (!this.guarded) {
            throw Debug.illegalState((Object[])new Object[]{"Cannot switch from editable to editable", this.multiGuardedID, this.index, editableSectionID});
        }
        if (!this.isWriterCommitted()) {
            throw Debug.illegalState((Object[])new Object[]{"Writer is not committed yet", this.multiGuardedID, this.index});
        }
        this.writer = null;
        if (this.index + 1 >= this.guardedSections.size()) {
            GuardedSection last = CodeUtils.findLast(this.guardedSections);
            String sectionID = this.createSectionID(this.guardedSections.size(), null);
            SimpleSection newGuardedSection = CodeUtils.createSimpleSectionAfter(this.document, last, sectionID);
            this.addSection(newGuardedSection, null);
        }
        this.editableSectionIDs.set(this.index, editableSectionID);
        this.guarded = !this.guarded;
    }

    public CodeWriter getWriter() {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is closed already", this.multiGuardedID});
        }
        if (this.writer == null) {
            if (this.guarded) {
                this.writer = new CodeWriter(this.document, this.guardedSections.get(this.index));
            } else {
                String editableID = this.editableSectionIDs.get(this.index);
                this.writer = new CodeWriter(this.document, this.guardedSections.get(this.index), this.guardedSections.get(this.index + 1), JavaCodeGenerator.getDefault().getUserCode(this.document, this.multiGuardedID, editableID));
            }
        }
        return this.writer;
    }

    public void close() {
        if (this.index < 0) {
            throw Debug.illegalState((Object[])new Object[]{"Section is closed already", this.multiGuardedID});
        }
        if (!this.guarded || !this.isWriterCommitted()) {
            throw Debug.illegalState((Object[])new Object[]{"Cannot close - last section is not properly commited", this.multiGuardedID, this.guarded, this.isWriterCommitted()});
        }
        int size = this.guardedSections.size();
        if (size > 0) {
            this.editableSectionIDs.set(size - 1, "");
        }
        for (int a = 0; a < size; ++a) {
            try {
                this.guardedSections.get(a).setName(this.createSectionID(a, this.editableSectionIDs.get(a)));
                continue;
            }
            catch (PropertyVetoException e) {
                throw Debug.error((Object[])new Object[]{e});
            }
        }
        Position begin = this.guardedSections.get(this.index).getEndPosition();
        Position end = this.guardedSections.get(size - 1).getEndPosition();
        for (int a = this.index + 1; a < size; ++a) {
            this.guardedSections.get(a).removeSection();
        }
        try {
            this.document.remove(begin.getOffset() + 1, end.getOffset() - (begin.getOffset() + 1));
        }
        catch (BadLocationException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
        this.index = -1;
    }

    public static MultiGuardedSection create(StyledDocument document, String multiGuardedID) {
        return multiGuardedID != null ? new MultiGuardedSection(document, multiGuardedID) : null;
    }

    String getMultiGuardedID() {
        return this.multiGuardedID;
    }

    private void addSection(SimpleSection section, String editableSectionID) {
        this.guardedSections.add(section);
        this.editableSectionIDs.add(editableSectionID);
    }

    private String createSectionID(int index, String editableID) {
        return '|' + this.multiGuardedID + '|' + index + '|' + (editableID != null ? editableID : "");
    }

    static String createSectionIDPrefix(String multiGuardedID) {
        return '|' + multiGuardedID + '|';
    }

    private static String createSectionID(String multiGuardedID, int index, String editableID) {
        return '|' + multiGuardedID + '|' + index + '|' + (editableID != null ? editableID : "");
    }

    private boolean isWriterCommitted() {
        return this.writer != null && this.writer.isCommitted();
    }

    public boolean isGuarded() {
        return this.guarded;
    }

    public static boolean isPartOfMultiGuardedSection(GuardedSection section) {
        return section.getName().startsWith("|");
    }

    static Object[] parsePartOfMultiGuardedSection(GuardedSection section) {
        assert (MultiGuardedSection.isPartOfMultiGuardedSection(section));
        String name = section.getName();
        Object[] result = new Object[3];
        int secondSeparator = name.indexOf(124, 1);
        assert (secondSeparator >= 1);
        result[0] = name.substring(1, secondSeparator);
        int thirdSeparator = name.indexOf(124, ++secondSeparator);
        assert (thirdSeparator >= 1);
        result[1] = Integer.parseInt(name.substring(secondSeparator, thirdSeparator));
        result[2] = name.substring(++thirdSeparator);
        return result;
    }

    public static boolean matches(GuardedSection section, String multiGuardedID, int index) {
        Object[] objects = MultiGuardedSection.parsePartOfMultiGuardedSection(section);
        return multiGuardedID.equals(objects[0]) && index == (Integer)objects[1];
    }

    public static boolean matches(GuardedSection section, String multiGuardedID, String editableID) {
        Object[] objects = MultiGuardedSection.parsePartOfMultiGuardedSection(section);
        return multiGuardedID.equals(objects[0]) && editableID.equals(objects[2]);
    }

    static GuardedSection findNextPartOfMultiGuardedSectionAfter(StyledDocument document, Object[] info) {
        GuardedSectionManager instance = GuardedSectionManager.getInstance((StyledDocument)document);
        return CodeUtils.findSectionByPrefix(instance.getGuardedSections(), MultiGuardedSection.createSectionID((String)info[0], (Integer)info[1] + 1, null));
    }

    public static void remove(StyledDocument document, String multiGuardedID) {
        Iterable allSections = GuardedSectionManager.getInstance((StyledDocument)document).getGuardedSections();
        ArrayList<SimpleSection> sections = CodeUtils.findSectionsByPrefix(allSections, MultiGuardedSection.createSectionIDPrefix(multiGuardedID));
        CodeUtils.sortSections(sections);
        Iterator<SimpleSection> iterator = sections.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        SimpleSection firstSection = iterator.next();
        ArrayList<SimpleSection> sectionsBlock = new ArrayList<SimpleSection>();
        sectionsBlock.add(firstSection);
        int lastIndex = (Integer)MultiGuardedSection.parsePartOfMultiGuardedSection((GuardedSection)firstSection)[1];
        while (iterator.hasNext()) {
            SimpleSection nextSection = iterator.next();
            int nextIndex = (Integer)MultiGuardedSection.parsePartOfMultiGuardedSection((GuardedSection)nextSection)[1];
            if (lastIndex + 1 != nextIndex) {
                MultiGuardedSection.removeSectionsBlock(document, sectionsBlock);
                Debug.warning((Object[])new Object[]{"Broken multi-guarded-section", "Missing sections between", lastIndex, nextIndex});
            }
            sectionsBlock.add(nextSection);
            lastIndex = nextIndex;
        }
        MultiGuardedSection.removeSectionsBlock(document, sectionsBlock);
    }

    private static void removeSectionsBlock(StyledDocument document, ArrayList<SimpleSection> sectionsBlock) {
        Position begin = sectionsBlock.get(0).getStartPosition();
        Position end = sectionsBlock.get(sectionsBlock.size() - 1).getEndPosition();
        for (SimpleSection section : sectionsBlock) {
            section.removeSection();
        }
        try {
            document.remove(begin.getOffset(), end.getOffset() - begin.getOffset());
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        sectionsBlock.clear();
    }
}

