/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class FileUtils {
    public static final String PHP_MIME_TYPE = "text/x-php5";

    private FileUtils() {
    }

    public static boolean isPhpFile(FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        return PHP_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)file, (String[])new String[]{PHP_MIME_TYPE}));
    }

    public static List<String> findFileOnUsersPath(String filename) {
        Parameters.notNull((CharSequence)"filename", (Object)filename);
        String path = System.getenv("PATH");
        if (path == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
        ArrayList<String> found = new ArrayList<String>(dirs.size());
        for (String d : dirs) {
            String absolutePath;
            File file = new File(d, filename);
            if (!file.isFile() || found.contains(absolutePath = FileUtil.normalizeFile((File)file).getAbsolutePath())) continue;
            found.add(absolutePath);
        }
        return found;
    }

    public static FileObject getFileObject(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo != null) {
            return fo;
        }
        DataObject d = (DataObject)context.lookup(DataObject.class);
        if (d != null) {
            return d.getPrimaryFile();
        }
        return null;
    }

    public static XMLReader createXmlReader() throws SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create SAX parser", ex);
        }
    }
}

