/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.api.ui.SearchPanel;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class UiUtils {
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory";

    private UiUtils() {
    }

    public static void invalidScriptProvided(String message) {
        UiUtils.invalidScriptProvided(message, null);
    }

    public static void invalidScriptProvided(String message, String optionsSubcategory) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        UiUtils.informAndOpenOptions((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0), optionsSubcategory);
    }

    public static void processExecutionException(ExecutionException exc) {
        UiUtils.processExecutionException(exc, null);
    }

    public static void processExecutionException(ExecutionException exc, final String optionsSubcategory) {
        Parameters.notNull((CharSequence)"exc", (Object)exc);
        final Throwable cause = exc.getCause();
        assert (cause != null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UiUtils.informAndOpenOptions((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UiUtils.class, (String)"MSG_ExceptionDuringRunScript", (Object)cause.getLocalizedMessage()), 0), optionsSubcategory);
            }
        });
    }

    public static void showGeneralOptions() {
        UiUtils.showOptions(null);
    }

    public static void showOptions(String optionsSubcategory) {
        String path = OPTIONS_PATH;
        if (StringUtils.hasText(optionsSubcategory)) {
            path = path + "/" + optionsSubcategory;
        }
        OptionsDisplayer.getDefault().open(path);
    }

    private static void informAndOpenOptions(NotifyDescriptor descriptor, String optionsSubcategory) {
        assert (descriptor != null);
        DialogDisplayer.getDefault().notify(descriptor);
        UiUtils.showOptions(optionsSubcategory);
    }

    public static final class SearchWindow {
        private SearchWindow() {
        }

        public static String search(SearchWindowSupport support) {
            Parameters.notNull((CharSequence)"support", (Object)support);
            SearchPanel panel = SearchPanel.create(support);
            if (panel.open()) {
                return panel.getSelectedItem();
            }
            return null;
        }

        public static interface SearchWindowSupport {
            public List<String> detect();

            public String getWindowTitle();

            public String getListTitle();

            public String getPleaseWaitPart();

            public String getNoItemsFound();
        }
    }
}

