/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1Exception;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CadT1
extends CadDevice {
    byte[] sendBuffer = new byte[40];
    byte[] recvBuffer = new byte[40];
    protected static final int MAX_IFS_SIZE = 32;
    private static final byte BLOCKPROTOCOL_POWERUP = -16;
    private static final byte BLOCKPROTOCOL_POWERDOWN = -32;
    private static final byte BLOCKPROTOCOL_COMMAND = -128;
    private static final int BLOCKPROTOCOL_OFFSET_OPCODE = 0;
    private static final int BLOCKPROTOCOL_OFFSET_LENGTH = 1;
    private static final int BLOCKPROTOCOL_OFFSET_MESSAGE = 3;
    private static final int BLOCKPROTOCOL_HEADER_SIZE = 3;
    private static final int BLOCKPROTOCOL_OVERHEAD_SIZE = 4;

    public CadT1(InputStream inputStream, OutputStream outputStream) {
        super((byte)1, inputStream, outputStream);
    }

    synchronized void sendBlockProtocolMessage(int n) throws IOException, T1Exception {
        this.out.write(this.sendBuffer, 0, n);
        this.out.flush();
    }

    synchronized int receiveBlockProtocolMessage() throws IOException, T1Exception {
        int n = this.in.read(this.recvBuffer, 0, 3);
        int n2 = this.recvBuffer[1] << 8 | this.recvBuffer[2];
        n += this.in.read(this.recvBuffer, 3, n2 + 1);
        if (this.recvBuffer[0] == -32) {
            return -1;
        }
        if (this.recvBuffer[0] != -128) {
            throw new T1Exception(-126);
        }
        return n;
    }

    public synchronized boolean exchangeBlock(T1Block t1Block, T1Block t1Block2) throws IOException, T1Exception {
        byte[] byArray = t1Block.toByteArray();
        int n = byArray.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(n >> 8);
        this.sendBuffer[2] = (byte)n;
        System.arraycopy(byArray, 0, this.sendBuffer, 3, n);
        this.sendBuffer[n + 3] = this.computeLRC(this.sendBuffer, 0, n + 3);
        this.sendBlockProtocolMessage(n + 4);
        n = this.receiveBlockProtocolMessage();
        if (n == -1) {
            return false;
        }
        t1Block2.readBlockInstance(this.recvBuffer, 3, n - 4);
        return true;
    }

    public synchronized boolean receiveBlock(T1Block t1Block) throws IOException, T1Exception {
        int n = this.receiveBlockProtocolMessage();
        t1Block.readBlockInstance(this.recvBuffer, 3, n - 4);
        return true;
    }

    public boolean sendATR(byte[] byArray) throws IOException, T1Exception {
        int n = byArray.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(n >> 8);
        this.sendBuffer[2] = (byte)n;
        System.arraycopy(byArray, 0, this.sendBuffer, 3, n);
        this.sendBuffer[n + 3] = this.computeLRC(this.sendBuffer, 0, n + 3);
        this.sendBlockProtocolMessage(n + 4);
        return true;
    }

    public int getMaxIFSSize() {
        return 32;
    }

    public byte[] retrieveATR() throws IOException, T1Exception {
        int n = this.in.read(this.recvBuffer, 0, 3);
        if (n < 0) {
            throw new EOFException();
        }
        if (this.recvBuffer[0] != -128) {
            return null;
        }
        int n2 = this.recvBuffer[1] << 8 | this.recvBuffer[2];
        if (n2 <= 0) {
            return null;
        }
        n = this.in.read(this.recvBuffer, 3, n2 + 1);
        if (this.computeLRC(this.recvBuffer, 0, n2 + 4) != 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.recvBuffer, 3, byArray, 0, n2);
        return byArray;
    }

    public synchronized boolean receivePowerUp() throws IOException, T1Exception {
        int n = this.in.read(this.recvBuffer, 0, 3);
        int n2 = this.recvBuffer[1] << 8 | this.recvBuffer[2];
        n = this.in.read(this.recvBuffer, 3, n2 + 1);
        return this.recvBuffer[0] == -16;
    }

    public synchronized void sendPowerUp() throws IOException, T1Exception {
        this.sendBuffer[0] = -16;
        this.sendBuffer[1] = 0;
        this.sendBuffer[2] = 0;
        this.sendBuffer[3] = this.computeLRC(this.sendBuffer, 0, 3);
        this.sendBlockProtocolMessage(4);
    }

    public synchronized void sendPowerDown() throws IOException, T1Exception {
        this.sendBuffer[0] = -32;
        this.sendBuffer[1] = 0;
        this.sendBuffer[2] = 0;
        this.sendBuffer[3] = this.computeLRC(this.sendBuffer, 0, 3);
        this.sendBlockProtocolMessage(4);
    }

    private byte computeLRC(byte[] byArray, int n, int n2) {
        byte by = 0;
        for (int i = 0; i < n2; ++i) {
            by = (byte)(by ^ byArray[n + i]);
        }
        return by;
    }
}

