/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classparser;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classparser.ClassFile;
import com.sun.javacard.debugproxy.classparser.FileReference;
import com.sun.javacard.debugproxy.classparser.SearchPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;

public class ClassManager {
    Object classes = new Object();
    SearchPath path = null;
    public static Map<Integer, ClassFile> classMap = new HashMap<Integer, ClassFile>(128, 0.75f);

    public ClassManager() {
    }

    public ClassManager(SearchPath searchPath) {
        this();
        this.path = searchPath;
    }

    public ClassFile loadClass(String string, FileReference fileReference, byte by) {
        Log.LOGN(3, "loadclass: " + fileReference);
        ClassFile classFile = new ClassFile(fileReference, string, by);
        try {
            classFile.readClassFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.LOGN(2, "Error loading: " + fileReference);
            classFile = null;
        }
        return classFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile findClass(byte by, String string) {
        ClassFile classFile2 = null;
        Object object = this.classes;
        synchronized (object) {
            for (ClassFile classFile2 : classMap.values()) {
                if (!classFile2.getClassName().equals(string)) continue;
                return classFile2;
            }
        }
        if (by == 3) {
            Log.LOGN(4, "findclass: Array class " + string);
            classFile2 = new ClassFile(null, string, by);
            return classFile2;
        }
        if (this.path != null) {
            Log.LOGN(4, "findclass: finding " + string);
            object = this.path.resolve(string);
            if (object != null) {
                return this.loadClass(string, (FileReference)object, by);
            }
        }
        return null;
    }

    static {
        try {
            File file;
            if (System.getProperty("jc.home") != null && (file = new File(System.getProperty("jc.home"), "bin/debug.info")).exists()) {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                classMap = (HashMap)objectInputStream.readObject();
                objectInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

