/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGLabel;
import org.netbeans.microedition.svg.SVGPlayer;
import org.netbeans.microedition.svg.SVGRectangle;
import org.netbeans.microedition.svg.SVGTextArea;
import org.netbeans.microedition.svg.SVGTextField;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.NumPadInputHandler;
import org.netbeans.microedition.svg.input.PointerEvent;
import org.w3c.dom.svg.SVGElement;

public class SVGForm
extends SVGPlayer
implements InputHandler.CaretVisibilityListener {
    private final Vector components = new Vector();
    private SVGComponent focusedComponent = null;
    private NumPadInputHandler inputHandler;

    public SVGForm(SVGImage svgImage, Display display) throws IllegalArgumentException {
        super(svgImage, display);
        this.setResetAnimationWhenStopped(false);
        this.setSVGEventListener(new SvgFormEventListener());
        this.setFullScreenMode(true);
    }

    public synchronized void add(SVGComponent component) {
        this.components.addElement(component);
        if (this.getFocusedField() == null && component.isFocusable()) {
            component.requestFocus();
        }
    }

    public synchronized SVGComponent getFocusedField() {
        return this.focusedComponent;
    }

    synchronized void requestFocus(SVGComponent comp) {
        if (this.focusedComponent != comp) {
            if (this.focusedComponent != null) {
                this.focusedComponent.focusLost();
            }
            this.focusedComponent = comp;
            if (this.focusedComponent != null) {
                this.getSVGImage().focusOn((SVGElement)this.focusedComponent.getElement());
                this.focusedComponent.focusGained();
            } else {
                this.getSVGImage().focusOn(null);
            }
        }
    }

    public void activate(SVGComponent comp) {
        this.requestFocus(comp);
        this.getSVGImage().activate();
    }

    public void setCaretVisible(boolean isVisible) {
        SVGComponent component = this.focusedComponent;
        if (component instanceof SVGTextField) {
            ((SVGTextField)component).setCaretVisible(isVisible);
        }
        if (component instanceof SVGTextArea) {
            ((SVGTextArea)component).setCaretVisible(isVisible);
        }
    }

    public synchronized NumPadInputHandler getNumPadInputHandler() {
        if (this.inputHandler == null) {
            this.inputHandler = new NumPadInputHandler(this.getDisplay());
            this.inputHandler.addVisibilityListener(this);
        }
        return this.inputHandler;
    }

    synchronized SVGLabel getLabelFor(SVGComponent component) {
        Enumeration en = this.components.elements();
        while (en.hasMoreElements()) {
            SVGLabel label;
            SVGComponent labelFor;
            SVGComponent comp = (SVGComponent)en.nextElement();
            if (!(comp instanceof SVGLabel) || (labelFor = (label = (SVGLabel)comp).getLabelFor()) != component) continue;
            return label;
        }
        return null;
    }

    private class SvgFormEventListener
    implements SVGEventListener {
        private int MILLIS_ON_CLICK = 300;
        private PointerEvent myLastEvent;

        private SvgFormEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(int keyCode) {
            SVGForm sVGForm = SVGForm.this;
            synchronized (sVGForm) {
                if (SVGForm.this.focusedComponent != null) {
                    block2 : switch (keyCode) {
                        case -1: {
                            SVGComponent next = null;
                            int index = SVGForm.this.components.indexOf(SVGForm.this.focusedComponent);
                            while (next != SVGForm.this.focusedComponent) {
                                if (--index < 0) {
                                    index = SVGForm.this.components.size() - 1;
                                }
                                if (!(next = (SVGComponent)SVGForm.this.components.elementAt(index)).isFocusable()) continue;
                                SVGForm.this.requestFocus(next);
                                break block2;
                            }
                            break;
                        }
                        case -2: {
                            SVGComponent next = null;
                            int index = SVGForm.this.components.indexOf(SVGForm.this.focusedComponent);
                            while (next != SVGForm.this.focusedComponent) {
                                if (++index >= SVGForm.this.components.size()) {
                                    index = 0;
                                }
                                if (!(next = (SVGComponent)SVGForm.this.components.elementAt(index)).isFocusable()) continue;
                                SVGForm.this.requestFocus(next);
                            }
                            break;
                        }
                        default: {
                            InputHandler handler = SVGForm.this.focusedComponent.getInputHandler();
                            if (handler == null) break;
                            handler.handleKeyPress(SVGForm.this.focusedComponent, keyCode);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyReleased(int keyCode) {
            SVGForm sVGForm = SVGForm.this;
            synchronized (sVGForm) {
                InputHandler handler;
                if (SVGForm.this.focusedComponent != null && (handler = SVGForm.this.focusedComponent.getInputHandler()) != null) {
                    handler.handleKeyRelease(SVGForm.this.focusedComponent, keyCode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pointerPressed(int x, int y) {
            long currentTime = System.currentTimeMillis();
            if (this.myLastEvent != null && x == this.myLastEvent.getX() && y == this.myLastEvent.getY() && currentTime - this.myLastEvent.getWhen() <= (long)this.MILLIS_ON_CLICK) {
                SVGComponent component = this.myLastEvent.getComponent();
                if (component.getInputHandler() != null) {
                    component.getInputHandler().handlePointerPress(new PointerEvent(component, x, y, this.myLastEvent.getClickCount() + 1));
                }
                return;
            }
            this.myLastEvent = null;
            SVGForm sVGForm = SVGForm.this;
            synchronized (sVGForm) {
                Enumeration en = SVGForm.this.components.elements();
                while (en.hasMoreElements()) {
                    SVGComponent next = (SVGComponent)en.nextElement();
                    SVGRectangle rectangle = next.getBounds();
                    if (rectangle == null || !rectangle.contains(x, y) || next.getInputHandler() == null) continue;
                    next.getInputHandler().handlePointerPress(new PointerEvent(next, x, y));
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pointerReleased(int x, int y) {
            long currentTime = System.currentTimeMillis();
            if (this.myLastEvent != null && x == this.myLastEvent.getX() && y == this.myLastEvent.getY() && currentTime - this.myLastEvent.getWhen() <= (long)this.MILLIS_ON_CLICK) {
                SVGComponent component = this.myLastEvent.getComponent();
                this.myLastEvent = new PointerEvent(component, x, y, this.myLastEvent.getClickCount() + 1);
                if (component.getInputHandler() != null) {
                    component.getInputHandler().handlePointerRelease(this.myLastEvent);
                }
                return;
            }
            this.myLastEvent = null;
            SVGForm sVGForm = SVGForm.this;
            synchronized (sVGForm) {
                Enumeration en = SVGForm.this.components.elements();
                while (en.hasMoreElements()) {
                    SVGComponent next = (SVGComponent)en.nextElement();
                    SVGRectangle rectangle = next.getBounds();
                    if (rectangle == null || !rectangle.contains(x, y) || next.getInputHandler() == null) continue;
                    this.myLastEvent = new PointerEvent(next, x, y);
                    next.getInputHandler().handlePointerRelease(this.myLastEvent);
                    return;
                }
            }
        }

        public void hideNotify() {
        }

        public void showNotify() {
        }

        public void sizeChanged(int width, int height) {
        }
    }

    public static interface FocusListener {
        public void focusGained();

        public void focusLost();
    }
}

