/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xmlbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.CharBuffer;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xmlbeans.XMLStreamValidationException;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlSaxHandler;
import org.apache.xmlbeans.XmlValidationError;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeansMarshaller
extends AbstractMarshaller {
    private XmlOptions xmlOptions;
    private boolean validating = false;

    public void setXmlOptions(XmlOptions xmlOptions) {
        this.xmlOptions = xmlOptions;
    }

    public XmlOptions getXmlOptions() {
        return this.xmlOptions;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return XmlObject.class.isAssignableFrom(clazz);
    }

    @Override
    protected final void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        Node xmlBeansNode = ((XmlObject)graph).newDomNode(this.getXmlOptions());
        NodeList xmlBeansChildNodes = xmlBeansNode.getChildNodes();
        int i = 0;
        while (i < xmlBeansChildNodes.getLength()) {
            Node xmlBeansChildNode = xmlBeansChildNodes.item(i);
            Node importedNode = document.importNode(xmlBeansChildNode, true);
            node.appendChild(importedNode);
            ++i;
        }
    }

    @Override
    protected final void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        ((XmlObject)graph).save(outputStream, this.getXmlOptions());
    }

    @Override
    protected final void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        try {
            ((XmlObject)graph).save(contentHandler, lexicalHandler, this.getXmlOptions());
        }
        catch (SAXException ex) {
            throw this.convertXmlBeansException(ex, true);
        }
    }

    @Override
    protected final void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        ((XmlObject)graph).save(writer, this.getXmlOptions());
    }

    @Override
    protected final void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) {
        ContentHandler contentHandler = StaxUtils.createContentHandler((XMLEventWriter)eventWriter);
        this.marshalSaxHandlers(graph, contentHandler, null);
    }

    @Override
    protected final void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        ContentHandler contentHandler = StaxUtils.createContentHandler((XMLStreamWriter)streamWriter);
        this.marshalSaxHandlers(graph, contentHandler, null);
    }

    @Override
    protected final Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            XmlObject object = XmlObject.Factory.parse((Node)node, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected final Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            NonClosingInputStream nonClosingInputStream = new NonClosingInputStream(inputStream);
            XmlObject object = XmlObject.Factory.parse((InputStream)nonClosingInputStream, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected final Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            NonClosingReader nonClosingReader = new NonClosingReader(reader);
            XmlObject object = XmlObject.Factory.parse((Reader)nonClosingReader, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected final Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        XmlSaxHandler saxHandler = XmlObject.Factory.newXmlSaxHandler((XmlOptions)this.getXmlOptions());
        xmlReader.setContentHandler(saxHandler.getContentHandler());
        try {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", saxHandler.getLexicalHandler());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        try {
            xmlReader.parse(inputSource);
            XmlObject object = saxHandler.getObject();
            this.validate(object);
            return object;
        }
        catch (SAXException ex) {
            throw this.convertXmlBeansException(ex, false);
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected final Object unmarshalXmlEventReader(XMLEventReader eventReader) throws XmlMappingException {
        XMLReader reader = StaxUtils.createXMLReader((XMLEventReader)eventReader);
        try {
            return this.unmarshalSaxReader(reader, new InputSource());
        }
        catch (IOException ex) {
            throw this.convertXmlBeansException(ex, false);
        }
    }

    @Override
    protected final Object unmarshalXmlStreamReader(XMLStreamReader streamReader) throws XmlMappingException {
        try {
            XmlObject object = XmlObject.Factory.parse((XMLStreamReader)streamReader, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    protected void validate(XmlObject object) throws ValidationFailureException {
        if (this.isValidating() && object != null) {
            XmlOptions validateOptions = this.getXmlOptions() != null ? this.getXmlOptions() : new XmlOptions();
            ArrayList errorsList = new ArrayList();
            validateOptions.setErrorListener(errorsList);
            if (!object.validate(validateOptions)) {
                StringBuilder builder = new StringBuilder("Could not validate XmlObject :");
                for (Object anErrorsList : errorsList) {
                    XmlError xmlError = (XmlError)anErrorsList;
                    if (!(xmlError instanceof XmlValidationError)) continue;
                    builder.append(xmlError.toString());
                }
                throw new ValidationFailureException("XMLBeans validation failure", new XmlException(builder.toString(), null, errorsList));
            }
        }
    }

    protected XmlMappingException convertXmlBeansException(Exception ex, boolean marshalling) {
        if (ex instanceof XMLStreamValidationException) {
            return new ValidationFailureException("XmlBeans validation exception", ex);
        }
        if (ex instanceof XmlException || ex instanceof SAXException) {
            if (marshalling) {
                return new MarshallingFailureException("XMLBeans marshalling exception", ex);
            }
            return new UnmarshallingFailureException("XMLBeans unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown XMLBeans exception", ex);
    }

    private static class NonClosingInputStream
    extends InputStream {
        private final WeakReference<InputStream> in;

        private NonClosingInputStream(InputStream in) {
            this.in = new WeakReference<InputStream>(in);
        }

        private InputStream getInputStream() {
            return (InputStream)this.in.get();
        }

        public int read() throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.read() : -1;
        }

        public int read(byte[] b) throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.read(b) : -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.read(b, off, len) : -1;
        }

        public long skip(long n) throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.skip(n) : 0L;
        }

        public boolean markSupported() {
            InputStream in = this.getInputStream();
            return in != null && in.markSupported();
        }

        public void mark(int readlimit) {
            InputStream in = this.getInputStream();
            if (in != null) {
                in.mark(readlimit);
            }
        }

        public void reset() throws IOException {
            InputStream in = this.getInputStream();
            if (in != null) {
                in.reset();
            }
        }

        public int available() throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.available() : 0;
        }

        public void close() throws IOException {
            InputStream in = this.getInputStream();
            if (in != null) {
                this.in.clear();
            }
        }
    }

    private static class NonClosingReader
    extends Reader {
        private final WeakReference<Reader> reader;

        private NonClosingReader(Reader reader) {
            this.reader = new WeakReference<Reader>(reader);
        }

        private Reader getReader() {
            return (Reader)this.reader.get();
        }

        public int read(CharBuffer target) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read(target) : -1;
        }

        public int read() throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read() : -1;
        }

        public int read(char[] cbuf) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read(cbuf) : -1;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read(cbuf, off, len) : -1;
        }

        public long skip(long n) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.skip(n) : 0L;
        }

        public boolean ready() throws IOException {
            Reader rdr = this.getReader();
            return rdr != null && rdr.ready();
        }

        public boolean markSupported() {
            Reader rdr = this.getReader();
            return rdr != null && rdr.markSupported();
        }

        public void mark(int readAheadLimit) throws IOException {
            Reader rdr = this.getReader();
            if (rdr != null) {
                rdr.mark(readAheadLimit);
            }
        }

        public void reset() throws IOException {
            Reader rdr = this.getReader();
            if (rdr != null) {
                rdr.reset();
            }
        }

        public void close() throws IOException {
            Reader rdr = this.getReader();
            if (rdr != null) {
                this.reader.clear();
            }
        }
    }
}

