/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataTableGenerator;

public abstract class NonRelationshipAccessor
extends MetadataAccessor {
    public NonRelationshipAccessor(MetadataAccessibleObject accessibleObject, MetadataProcessor processor, MetadataDescriptor descriptor) {
        super(accessibleObject, processor, descriptor);
    }

    public NonRelationshipAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected void processSequenceGenerator() {
        SequenceGenerator sequenceGenerator = (SequenceGenerator)this.getAnnotation(SequenceGenerator.class);
        if (sequenceGenerator != null) {
            this.processSequenceGenerator(new MetadataSequenceGenerator(sequenceGenerator, this.getJavaClassName()));
        }
    }

    protected void processSequenceGenerator(MetadataSequenceGenerator sequenceGenerator) {
        String name = sequenceGenerator.getName();
        if (name.equals("SEQ_GEN_TABLE")) {
            this.m_validator.throwSequenceGeneratorUsingAReservedName("SEQ_GEN_TABLE", sequenceGenerator.getLocation());
        }
        if (this.m_project.hasConflictingSequenceGenerator(sequenceGenerator)) {
            MetadataSequenceGenerator otherSequenceGenerator = this.m_project.getSequenceGenerator(name);
            if (sequenceGenerator.loadedFromAnnotations() && otherSequenceGenerator.loadedFromXML()) {
                return;
            }
            this.m_validator.throwConflictingSequenceGeneratorsSpecified(name, sequenceGenerator.getLocation(), otherSequenceGenerator.getLocation());
        }
        if (this.m_project.hasTableGenerator(name)) {
            MetadataTableGenerator otherTableGenerator = this.m_project.getTableGenerator(name);
            this.m_validator.throwConflictingSequenceAndTableGeneratorsSpecified(name, sequenceGenerator.getLocation(), otherTableGenerator.getLocation());
        }
        for (MetadataTableGenerator otherTableGenerator : this.m_project.getTableGenerators()) {
            if (!otherTableGenerator.getPkColumnValue().equals(sequenceGenerator.getSequenceName()) || otherTableGenerator.getPkColumnValue().length() <= 0) continue;
            this.m_validator.throwConflictingSequenceNameAndTablePkColumnValueSpecified(sequenceGenerator.getSequenceName(), sequenceGenerator.getLocation(), otherTableGenerator.getLocation());
        }
        this.m_project.addSequenceGenerator(sequenceGenerator);
    }

    protected void processTableGenerator() {
        TableGenerator tableGenerator = (TableGenerator)this.getAnnotation(TableGenerator.class);
        if (tableGenerator != null) {
            this.processTableGenerator(new MetadataTableGenerator(tableGenerator, this.getJavaClassName()));
        }
    }

    protected void processTableGenerator(MetadataTableGenerator tableGenerator) {
        String name = tableGenerator.getName();
        if (name.equals("SEQ_GEN_SEQUENCE")) {
            this.m_validator.throwTableGeneratorUsingAReservedName("SEQ_GEN_SEQUENCE", tableGenerator.getLocation());
        }
        if (this.m_project.hasConflictingTableGenerator(tableGenerator)) {
            MetadataTableGenerator otherTableGenerator = this.m_project.getTableGenerator(name);
            if (tableGenerator.loadedFromAnnotations() && otherTableGenerator.loadedFromXML()) {
                return;
            }
            this.m_validator.throwConflictingTableGeneratorsSpecified(name, tableGenerator.getLocation(), otherTableGenerator.getLocation());
        }
        if (this.m_project.hasSequenceGenerator(tableGenerator.getName())) {
            MetadataSequenceGenerator otherSequenceGenerator = this.m_project.getSequenceGenerator(name);
            this.m_validator.throwConflictingSequenceAndTableGeneratorsSpecified(name, otherSequenceGenerator.getLocation(), tableGenerator.getLocation());
        }
        for (MetadataSequenceGenerator otherSequenceGenerator : this.m_project.getSequenceGenerators()) {
            if (!otherSequenceGenerator.getSequenceName().equals(tableGenerator.getPkColumnValue()) || otherSequenceGenerator.getSequenceName().length() <= 0) continue;
            this.m_validator.throwConflictingSequenceNameAndTablePkColumnValueSpecified(otherSequenceGenerator.getSequenceName(), otherSequenceGenerator.getLocation(), tableGenerator.getLocation());
        }
        this.m_project.addTableGenerator(tableGenerator);
    }
}

