/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.JButton;

public class IconButton
extends JButton {
    private String iconText;

    public void setIconText(String iconText) {
        this.iconText = iconText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getIcon() == null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.GRAY);
            float[] dash = new float[]{10.0f, 3.0f};
            g2.setStroke(new BasicStroke(3.0f, 0, 1, 1.0f, dash, 0.0f));
            float in = 2.0f;
            GeneralPath rect = IconButton.generateSeamlessRoundRect(in, in, (float)this.getWidth() - in * 2.0f, (float)this.getHeight() - in * 2.0f, 12.0f);
            g2.draw(rect);
            g2.getFont().getStringBounds(this.iconText, g2.getFontRenderContext());
            g2.dispose();
        } else {
            super.paintComponent(g);
        }
    }

    private static GeneralPath generateSeamlessRoundRect(float rx, float ry, float rw, float rh, float rr) {
        GeneralPath gp = new GeneralPath();
        gp.append(new Arc2D.Float(rx, ry, rr, rr, 135.0f, 45.0f, 0), false);
        gp.append(new Line2D.Float(rx, ry + rr / 2.0f, rx, ry + rh / 2.0f), true);
        gp.append(new Arc2D.Float(rx, ry, rr, rr, 135.0f, -45.0f, 0), false);
        gp.append(new Line2D.Float(rx + rr / 2.0f, ry, rx + rw / 2.0f, ry), true);
        gp.append(new Arc2D.Float(rx, ry + rh - rr, rr, rr, 225.0f, -45.0f, 0), false);
        gp.append(new Line2D.Float(rx, ry + rh - rr, rx, ry + rh / 2.0f), true);
        gp.append(new Arc2D.Float(rx, ry + rh - rr, rr, rr, 225.0f, 45.0f, 0), false);
        gp.append(new Line2D.Float(rx + rr / 2.0f, ry + rh, rx + rw / 2.0f, ry + rh), true);
        gp.append(new Arc2D.Float(rx + rw - rr, ry + rh - rr, rr, rr, -45.0f, -45.0f, 0), false);
        gp.append(new Line2D.Float(rx + rw - rr / 2.0f, ry + rh, rx + rw / 2.0f, ry + rh), true);
        gp.append(new Arc2D.Float(rx + rw - rr, ry + rh - rr, rr, rr, -45.0f, 45.0f, 0), false);
        gp.append(new Line2D.Float(rx + rw, ry + rh - rr, rx + rw, ry + rh / 2.0f), true);
        gp.append(new Arc2D.Float(rx + rw - rr, ry, rr, rr, 45.0f, -45.0f, 0), false);
        gp.append(new Line2D.Float(rx + rw, ry + rr / 2.0f, rx + rw, ry + rh / 2.0f), true);
        gp.append(new Arc2D.Float(rx + rw - rr, ry, rr, rr, 45.0f, 45.0f, 0), false);
        gp.append(new Line2D.Float(rx + rw - rr / 2.0f, ry, rx + rw / 2.0f, ry), true);
        return gp;
    }
}

