/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.filters;

import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.filters.FilterSet;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;

public class FilterUtils {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.filters.Bundle");
    private static final String PROFILE_ALL_CLASSES_FILTER_NAME = bundle.getString("FilterUtils_ProfileAllClassesFilterName");
    private static final String QUICK_FILTER_FILTER_NAME = bundle.getString("FilterUtils_QuickFilterFilterName");
    public static final String PROP_FILTER_TYPE = "profiler.filter.type";
    public static final SimpleFilter NONE_FILTER = new SimpleFilter(PROFILE_ALL_CLASSES_FILTER_NAME, 0, "");
    public static final SimpleFilter QUICK_FILTER = new SimpleFilter(QUICK_FILTER_FILTER_NAME, 1, "");

    public static String[] getSeparateFilters(String complexFilter) {
        return complexFilter.replace(',', ' ').trim().split(" +");
    }

    public static boolean isValidProfilerFilter(String filterPart) {
        int filterPartLength = filterPart.length();
        if (filterPartLength < 1) {
            return true;
        }
        if (filterPart.indexOf("..") != -1) {
            return false;
        }
        char[] c = new char[filterPartLength];
        filterPart.getChars(0, filterPart.length(), c, 0);
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < filterPartLength - 1; ++i) {
            if (Character.isJavaIdentifierPart(c[i]) || c[i] == '.') continue;
            return false;
        }
        return Character.isJavaIdentifierPart(c[filterPartLength - 1]) || c[filterPartLength - 1] == '.' || c[filterPartLength - 1] == '*';
    }

    public static Object loadFilter(Map props) {
        return FilterUtils.loadFilter(props, "");
    }

    public static Object loadFilter(Map props, String prefix) {
        Object filterType = props.get(prefix + PROP_FILTER_TYPE);
        if (props == null || filterType == null) {
            return null;
        }
        if (filterType.equals("profiler.simple.filter")) {
            SimpleFilter filter = new SimpleFilter();
            filter.load(props, prefix);
            return filter;
        }
        if (filterType.equals("profiler.filter.set")) {
            FilterSet filter = new FilterSet();
            filter.load(props, prefix);
            return filter;
        }
        return null;
    }

    public static void storeFilter(Map props, Object filter) {
        FilterUtils.storeFilter(props, filter, "");
    }

    public static void storeFilter(Map props, Object filter, String prefix) {
        if (props == null) {
            throw new RuntimeException("Cannot store a filter to null properties");
        }
        if (filter == null) {
            throw new RuntimeException("Cannot store null filter");
        }
        if (filter instanceof SimpleFilter) {
            ((SimpleFilter)filter).store(props, prefix);
            return;
        }
        if (filter instanceof FilterSet) {
            ((FilterSet)filter).store(props, prefix);
            return;
        }
        throw new RuntimeException("Unsupported filter type: " + filter.getClass().getName());
    }
}

