/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.javaint;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.javaint.ClassPathUiSupport;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.netbeans.modules.ruby.rubyproject.ui.FoldersListSettings;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RubyClassPathUi {
    private RubyClassPathUi() {
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    public static class EditMediator
    implements ActionListener,
    ListSelectionListener {
        private final Project project;
        private final JList list;
        private final DefaultListModel listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addJar;
        private final ButtonModel addLibrary;
        private final ButtonModel addAntArtifact;
        private final ButtonModel remove;
        private final ButtonModel moveUp;
        private final ButtonModel moveDown;

        public EditMediator(Project project, JList list, DefaultListModel listModel, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown) {
            this.list = list;
            if (!(list.getModel() instanceof DefaultListModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = (DefaultListModel)list.getModel();
            this.selectionModel = list.getSelectionModel();
            this.addJar = addJar;
            this.addLibrary = addLibrary;
            this.addAntArtifact = addAntArtifact;
            this.remove = remove;
            this.moveUp = moveUp;
            this.moveDown = moveDown;
            this.project = project;
        }

        public static void register(Project project, JList list, DefaultListModel listModel, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown) {
            EditMediator em = new EditMediator(project, list, listModel, addJar, addLibrary, addAntArtifact, remove, moveUp, moveDown);
            addJar.addActionListener(em);
            addLibrary.addActionListener(em);
            addAntArtifact.addActionListener(em);
            remove.addActionListener(em);
            moveUp.addActionListener(em);
            moveDown.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.addJar) {
                JFileChooser chooser = new JFileChooser();
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
                chooser.setFileSelectionMode(2);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle(NbBundle.getMessage(RubyClassPathUi.class, (String)"LBL_AddJar_DialogTitle"));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(RubyClassPathUi.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"}));
                File curDir = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
                chooser.setCurrentDirectory(curDir);
                int option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.list));
                if (option == 0) {
                    File[] files = chooser.getSelectedFiles();
                    int[] newSelection = ClassPathUiSupport.addJarFiles(this.listModel, this.list.getSelectedIndices(), files);
                    this.list.setSelectedIndices(newSelection);
                    curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                    FoldersListSettings.getDefault().setLastUsedClassPathFolder(curDir);
                }
            } else if (source == this.remove) {
                int[] newSelection = ClassPathUiSupport.remove(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (source == this.moveUp) {
                int[] newSelection = ClassPathUiSupport.moveUp(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (source == this.moveDown) {
                int[] newSelection = ClassPathUiSupport.moveDown(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean canRemove = false;
            if (this.selectionModel.getMinSelectionIndex() != -1) {
                canRemove = true;
                int iMin = this.selectionModel.getMinSelectionIndex();
                int iMax = this.selectionModel.getMinSelectionIndex();
                for (int i = iMin; i <= iMax; ++i) {
                    ProjectPropertyExtender.Item item;
                    if (!this.selectionModel.isSelectedIndex(i) || (item = (ProjectPropertyExtender.Item)this.listModel.get(i)).getType() != 3) continue;
                    canRemove = false;
                    break;
                }
            }
            this.remove.setEnabled(canRemove);
            this.moveUp.setEnabled(ClassPathUiSupport.canMoveUp(this.selectionModel));
            this.moveDown.setEnabled(ClassPathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
        }
    }

    public static class ClassPathListCellRenderer
    extends DefaultListCellRenderer {
        private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
        private static final Pattern UNKNOWN_FILE_REFERENCE = Pattern.compile("\\$\\{([^${}]+)\\}");
        private static String RESOURCE_ICON_JAR = "org/netbeans/modules/ruby/javaint//jar.gif";
        private static String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/ruby/javaint/libraries.gif";
        private static String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/ruby/javaint//projectDependencies.gif";
        private static String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/ruby/javaint//referencedClasspath.gif";
        private static String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/ruby/javaint//brokenProjectBadge.gif";
        private static ImageIcon ICON_JAR = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_JAR, (boolean)false);
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_LIBRARY = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_LIBRARY, (boolean)false);
        private static ImageIcon ICON_ARTIFACT = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_ARTIFACT, (boolean)false);
        private static ImageIcon ICON_CLASSPATH = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_CLASSPATH, (boolean)false);
        private static ImageIcon ICON_BROKEN_BADGE = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_BROKEN_BADGE, (boolean)false);
        private static ImageIcon ICON_BROKEN_JAR;
        private static ImageIcon ICON_BROKEN_LIBRARY;
        private static ImageIcon ICON_BROKEN_ARTIFACT;
        private PropertyEvaluator evaluator;
        private static final Map WELL_KNOWN_PATHS_NAMES;

        public ClassPathListCellRenderer(PropertyEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ProjectPropertyExtender.Item item = (ProjectPropertyExtender.Item)value;
            super.getListCellRendererComponent((JList<?>)list, this.getDisplayName(item), index, isSelected, cellHasFocus);
            this.setIcon(ClassPathListCellRenderer.getIcon(item));
            this.setToolTipText(this.getToolTipText(item));
            return this;
        }

        private String getDisplayName(ProjectPropertyExtender.Item item) {
            switch (item.getType()) {
                case 0: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(RubyClassPathUi.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                    }
                    return item.getFile().getPath();
                }
            }
            return item.getReference();
        }

        static Icon getIcon(ProjectPropertyExtender.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_LIBRARY == null) {
                            ICON_BROKEN_LIBRARY = new ImageIcon(ImageUtilities.mergeImages((Image)ICON_LIBRARY.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_LIBRARY;
                    }
                    return ICON_LIBRARY;
                }
                case 0: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_JAR == null) {
                            ICON_BROKEN_JAR = new ImageIcon(ImageUtilities.mergeImages((Image)ICON_JAR.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_JAR;
                    }
                    File file = item.getFile();
                    return file.isDirectory() ? ClassPathListCellRenderer.getFolderIcon() : ICON_JAR;
                }
                case 3: {
                    return ICON_CLASSPATH;
                }
            }
            return null;
        }

        private String getToolTipText(ProjectPropertyExtender.Item item) {
            if (item.isBroken() && (item.getType() == 0 || item.getType() == 2)) {
                return this.evaluator.evaluate(item.getReference());
            }
            return this.getDisplayName(item);
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getProjectName(ProjectPropertyExtender.Item item) {
            String ID = item.getReference();
            return ID.substring(12, ID.indexOf(".", 12));
        }

        private String getLibraryName(ProjectPropertyExtender.Item item) {
            String ID = item.getReference();
            return ID.substring(7, ID.indexOf(".classpath"));
        }

        private String getFileRefName(ProjectPropertyExtender.Item item) {
            String ID = item.getReference();
            Matcher m = FOREIGN_PLAIN_FILE_REFERENCE.matcher(ID);
            if (m.matches()) {
                return m.group(1);
            }
            m = UNKNOWN_FILE_REFERENCE.matcher(ID);
            if (m.matches()) {
                return m.group(1);
            }
            return ID;
        }

        static {
            WELL_KNOWN_PATHS_NAMES = new HashMap();
        }
    }
}

