/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryCategory;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryDefinition;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryRepository;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class OQLSupport {
    private static final String CATEGORY_CAPTION = NbBundle.getMessage(OQLSupport.class, (String)"OQLSupport_CategoryCaption");
    private static final String CUSTOM_CATEGORY_NAME = NbBundle.getMessage(OQLSupport.class, (String)"OQLSupport_CustomCategoryName");
    private static final String CUSTOM_CATEGORY_DESCR = NbBundle.getMessage(OQLSupport.class, (String)"OQLSupport_CustomCategoryDescr");
    private static final String QUERY_CAPTION = NbBundle.getMessage(OQLSupport.class, (String)"OQLSupport_QueryCaption");
    private static final String NO_CUSTOM_QUERY_NAME = NbBundle.getMessage(OQLSupport.class, (String)"OQLSupport_NoCustomQueryName");
    private static final String NO_CUSTOM_QUERY_DESCR = NbBundle.getMessage(OQLSupport.class, (String)"OQLSupport_NoCustomQueryDescr");
    private static final String SAVED_OQL_QUERIES_FILENAME = "oqlqueries";
    private static final String SNAPSHOT_VERSION = "oqlqueries_version_1";
    private static final String PROP_QUERY_NAME_KEY = "query-name";
    private static final String PROP_QUERY_DESCR_KEY = "query-descr";
    private static final String PROP_QUERY_SCRIPT_KEY = "query-script";

    public static OQLTreeModel createModel() {
        return new OQLTreeModel();
    }

    public static void loadModel(OQLTreeModel model) {
        RootNode root = (RootNode)model.getRoot();
        try {
            FileObject folder = IDEUtils.getSettingsFolder(false);
            FileObject filtersFO = null;
            if (folder != null && folder.isValid()) {
                filtersFO = folder.getFileObject(SAVED_OQL_QUERIES_FILENAME, "xml");
            }
            if (filtersFO != null) {
                InputStream fis = filtersFO.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(fis);
                Properties properties = new Properties();
                properties.loadFromXML(bis);
                bis.close();
                if (!properties.isEmpty()) {
                    OQLSupport.propertiesToModel(properties, model);
                }
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        List categories = OQLQueryRepository.getInstance().listCategories();
        for (OQLQueryCategory category : categories) {
            OQLCategoryNode cnode = new OQLCategoryNode(category);
            root.add(cnode);
            List queries = category.listQueries();
            for (OQLQueryDefinition query : queries) {
                cnode.add(new OQLQueryNode(new Query(query)));
            }
        }
        model.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModel(OQLTreeModel model) {
        FileLock lock = null;
        try {
            Properties properties = OQLSupport.modelToProperties(model);
            FileObject folder = IDEUtils.getSettingsFolder(true);
            FileObject fo = folder.getFileObject(SAVED_OQL_QUERIES_FILENAME, "xml");
            if (fo != null || !properties.isEmpty()) {
                if (fo == null) {
                    fo = folder.createData(SAVED_OQL_QUERIES_FILENAME, "xml");
                }
                lock = fo.lock();
                if (properties.isEmpty()) {
                    fo.delete(lock);
                } else {
                    OutputStream os = fo.getOutputStream(lock);
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    properties.storeToXML(bos, SNAPSHOT_VERSION);
                    bos.close();
                }
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private static void propertiesToModel(Properties properties, OQLTreeModel model) {
        OQLCategoryNode custom = model.customCategory;
        int i = -1;
        while (properties.containsKey("query-name-" + ++i)) {
            String name = properties.getProperty("query-name-" + i).trim();
            String description = properties.getProperty("query-descr-" + i, "").trim();
            String script = properties.getProperty("query-script-" + i, "").trim();
            if (name == null || script == null) continue;
            custom.add(new OQLQueryNode(new Query(script, name, description)));
        }
    }

    private static Properties modelToProperties(OQLTreeModel model) {
        Properties properties = new Properties();
        if (model.hasCustomQueries()) {
            int i = -1;
            Enumeration<TreeNode> queries = model.customCategory.children();
            while (queries.hasMoreElements()) {
                Query q = (Query)((OQLQueryNode)queries.nextElement()).getUserObject();
                properties.put("query-name-" + ++i, q.getName().trim());
                properties.put("query-script-" + i, q.getScript().trim());
                if (q.getDescription() == null) continue;
                properties.put("query-descr-" + i, q.getDescription().trim());
            }
        }
        return properties;
    }

    public static final class Query {
        private String script;
        private String name;
        private String description;

        public Query(OQLQueryDefinition qdef) {
            this(qdef.getContent(), qdef.getName(), qdef.getDescription());
        }

        public Query(String script, String name, String description) {
            this.setScript(script);
            this.setName(name);
            this.setDescription(description);
        }

        public void setScript(String script) {
            if (script == null) {
                throw new IllegalArgumentException("Script cannot be null");
            }
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }

        public void setName(String name) {
            this.name = Query.normalizeString(name);
            if (this.name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = Query.normalizeString(description);
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private static String normalizeString(String string) {
            String normalizedString = null;
            if (string != null && (normalizedString = string.trim()).length() == 0) {
                normalizedString = null;
            }
            return normalizedString;
        }
    }

    private static class NoCustomQueriesNode
    extends SpecialNode {
        private NoCustomQueriesNode() {
        }

        @Override
        public String toString() {
            return NO_CUSTOM_QUERY_NAME;
        }

        @Override
        public String getDescription() {
            return NO_CUSTOM_QUERY_DESCR;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    private static class RootNode
    extends SpecialNode {
        private RootNode() {
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class OQLQueryNode
    extends OQLNode<Query> {
        public OQLQueryNode(Query query) {
            super(query);
        }

        @Override
        public boolean supportsOpen() {
            return true;
        }

        @Override
        public boolean supportsDelete() {
            return this.isCustomQuery();
        }

        @Override
        public boolean isReadOnly() {
            return !this.isCustomQuery();
        }

        @Override
        public String toString() {
            return ((Query)this.getUserObject()).getName();
        }

        @Override
        public String getCaption() {
            return QUERY_CAPTION;
        }

        @Override
        public String getDescription() {
            return ((Query)this.getUserObject()).getDescription();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        private boolean isCustomQuery() {
            return this.getParent() instanceof CustomCategoryNode;
        }
    }

    private static class CustomCategoryNode
    extends OQLCategoryNode {
        private CustomCategoryNode() {
            super(null);
        }

        @Override
        public String toString() {
            return CUSTOM_CATEGORY_NAME;
        }

        @Override
        public String getDescription() {
            return CUSTOM_CATEGORY_DESCR;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class OQLCategoryNode
    extends OQLNode<OQLQueryCategory> {
        private final NoCustomQueriesNode noQueries = new NoCustomQueriesNode();

        public OQLCategoryNode(OQLQueryCategory category) {
            super(category);
            super.insert(this.noQueries, 0);
        }

        @Override
        public String toString() {
            return ((OQLQueryCategory)this.getUserObject()).getName();
        }

        @Override
        public String getCaption() {
            return CATEGORY_CAPTION;
        }

        @Override
        public String getDescription() {
            return ((OQLQueryCategory)this.getUserObject()).getDescription();
        }

        @Override
        public boolean supportsProperties() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            if (this.isNodeChild(this.noQueries)) {
                super.remove(0);
            }
        }

        @Override
        public void remove(int childIndex) {
            super.remove(childIndex);
            if (this.getChildCount() == 0) {
                super.insert(this.noQueries, 0);
            }
        }
    }

    private static abstract class SpecialNode
    extends OQLNode<Object> {
        public SpecialNode() {
            super(null);
        }

        @Override
        public boolean supportsProperties() {
            return false;
        }
    }

    public static abstract class OQLNode<T>
    extends DefaultMutableTreeNode {
        public OQLNode(T userObject) {
            super(userObject);
        }

        public final T getUserObject() {
            return (T)super.getUserObject();
        }

        public String getDescription() {
            return null;
        }

        public String getCaption() {
            return "";
        }

        public boolean supportsProperties() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        public boolean supportsDelete() {
            return false;
        }

        public boolean supportsOpen() {
            return false;
        }
    }

    public static final class OQLTreeModel
    extends DefaultTreeModel {
        private final OQLCategoryNode customCategory = new CustomCategoryNode();

        public OQLTreeModel() {
            super(new RootNode());
            this.root().add(this.customCategory);
        }

        public boolean hasCustomQueries() {
            return this.customCategory.getChildCount() > 1 || !(this.customCategory.getChildAt(0) instanceof NoCustomQueriesNode);
        }

        public boolean hasDefinedCategories() {
            return this.root.getChildCount() > 1 || !(this.root.getChildAt(0) instanceof CustomCategoryNode);
        }

        public OQLCategoryNode customCategory() {
            return this.customCategory;
        }

        private OQLNode root() {
            return (OQLNode)this.root;
        }
    }
}

