/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.LinkedList;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.classview.ClassViewModel;
import org.netbeans.modules.cnd.classview.SmartChangeEvent;

public class ClassViewUpdater
extends Thread {
    private static final boolean traceEvents = Boolean.getBoolean("cnd.classview.updater-events");
    private ClassViewModel model;
    private BlockingQueue queue;
    private volatile boolean isStoped = false;
    private static final int MINIMAL_DELAY = 500;
    private static final int BATCH_MODE_DELAY = 1000;
    private static final int MAXIMAL_BATCH_SIZE = 50;
    private static final int MAXIMAL_BATCH_TIME = 10;
    private static final int USER_ACTIVITY_DELAY = 1000;

    ClassViewUpdater(ClassViewModel model) {
        super("Class View Updater");
        this.model = model;
        this.queue = new BlockingQueue();
    }

    public void setStop() {
        this.isStoped = true;
        if (this.queue != null) {
            this.queue.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        start = 0L;
        try {
            block10: while (true) {
                if (this.isStoped) {
                    return;
                }
                compose = this.queue.get();
                if (this.isStoped) {
                    return;
                }
                if (this.queue.isEmpty()) {
                    Thread.sleep(500L);
                }
                doWait = 0;
                while (true) {
                    if (this.isStoped) {
                        return;
                    }
                    while (!this.queue.isEmpty()) {
                        if (this.isStoped) {
                            return;
                        }
                        e = this.queue.peek();
                        if (!compose.addChangeEvent(e)) break;
                        this.queue.get();
                        if (!this.queue.isEmpty() || compose.getCount() >= 50 || doWait >= 10) continue;
                        ++doWait;
                        Thread.sleep(1000L);
                    }
                    if (!this.model.isUserActivity()) break;
                    Thread.sleep(1000L);
                }
                if (ClassViewUpdater.traceEvents) {
                    start = System.nanoTime();
                }
                if (this.isStoped) {
                    return;
                }
                this.model.update(compose);
                if (!ClassViewUpdater.traceEvents) continue;
                end = System.nanoTime();
                time = (end - start) / 1000000L;
                System.out.println("Compose change event contains " + compose.getCount() + " events. Time = " + (double)time / 1000.0);
                i$ = compose.getChangedProjects().entrySet().iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block10;
                    entry = i$.next();
                    System.out.println("    Project " + entry.getKey().getName() + " Nd=" + entry.getValue().getNewDeclarations().size() + ", Rd=" + entry.getValue().getRemovedDeclarations().size() + ", Ud=" + entry.getValue().getChangedDeclarations().size() + ", Nn=" + entry.getValue().getNewNamespaces().size() + ", Rn=" + entry.getValue().getRemovedNamespaces().size());
                }
                break;
            }
            catch (InterruptedException e) {
                return;
            }
        }
        finally {
            this.model = null;
            this.queue = null;
        }
    }

    public void scheduleUpdate(CsmChangeEvent e) {
        if (this.queue != null) {
            this.queue.add(new SmartChangeEvent(e));
        }
    }

    private static class BlockingQueue {
        private LinkedList<SmartChangeEvent> data = new LinkedList();
        private final Object lock = new Object();

        private BlockingQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SmartChangeEvent get() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (this.data.isEmpty()) {
                    this.lock.wait();
                }
                return this.data.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(SmartChangeEvent event) {
            Object object = this.lock;
            synchronized (object) {
                this.data.add(event);
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SmartChangeEvent peek() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (this.data.isEmpty()) {
                    this.lock.wait();
                }
                return this.data.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                return this.data.isEmpty();
            }
        }
    }
}

