/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.annotationsupport.AnnotationBar;
import org.netbeans.modules.dlight.annotationsupport.AnnotationBarManager;
import org.netbeans.modules.dlight.annotationsupport.AnnotationSupport;
import org.netbeans.modules.dlight.annotationsupport.ShowTextAnnotationsAction;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.windows.WindowManager;

public class ShowTextAnnotationsAction2
extends BooleanStateAction {
    public boolean isEnabled() {
        return this.hasAnnotations();
    }

    public boolean getBooleanState() {
        return AnnotationSupport.getInstance().getTextAnnotationVisible();
    }

    public String getName() {
        return NbBundle.getMessage(ShowTextAnnotationsAction.class, (String)"CTL_MenuItem_ShowAnnotations2");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent ev) {
        boolean tav = AnnotationSupport.getInstance().getTextAnnotationVisible();
        AnnotationSupport.getInstance().setTextAnnotationVisible(!tav);
    }

    private boolean hasAnnotations() {
        Node[] nodes = WindowManager.getDefault().getRegistry().getCurrentNodes();
        if (nodes == null || nodes.length != 1) {
            return true;
        }
        Node node = nodes[0];
        if (node == null) {
            return true;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return true;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return true;
        }
        JEditorPane[] panes = editorCookie.getOpenedPanes();
        boolean annotated = false;
        for (JEditorPane pane : panes) {
            AnnotationBar ab = (AnnotationBar)pane.getClientProperty(AnnotationBarManager.BAR_KEY);
            if (!ab.hasAnnotations()) continue;
            annotated = true;
            break;
        }
        return annotated;
    }
}

