<?xml version='1.0' encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="text" encoding="ISO-8859-1"/>

<xsl:template match="/listeDesPays">
<xsl:for-each select="pays">
 <xsl:sort select="capitale"/>
 <xsl:if test="string(capitale) != '-'">
  <xsl:value-of select="capitale"/>
  <xsl:variable name="Nom" select="string(nomComplet)"/>
  <xsl:choose>
   <xsl:when test="substring($Nom,1,3) = 'les'">
    <xsl:text> est la capitale des </xsl:text>
    <xsl:value-of select="substring-after($Nom,' ')"/>
   </xsl:when>
   <xsl:when test="substring($Nom,1,3) = 'le '">
    <xsl:text> est la capitale du </xsl:text>
    <xsl:value-of select="substring-after($Nom,' ')"/>
   </xsl:when>
   <xsl:when test="substring($Nom,1,3) = 'la '">
    <xsl:text> est la capitale de </xsl:text>
    <xsl:value-of select="$Nom"/>
   </xsl:when>
   <xsl:when test='substring($Nom,1,2) = "l&#39;"'>
    <xsl:text> est la capitale de </xsl:text>
    <xsl:value-of select="$Nom"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:variable name="L1" select="substring($Nom,1,1)"/>
    <xsl:choose>
     <xsl:when test="$L1 = 'A' or $L1 = 'E' or $L1 = 'I' or 
                     $L1 = 'O' or $L1 = 'U' or $L1 = 'Y'">
      <xsl:text> est la capitale de l'</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text> est la capitale de </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="$Nom"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>.&#xA;</xsl:text><!-- retour  la ligne -->
 </xsl:if>
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
