<?php
/*********************************************************************************
 * TimeTrex is a Payroll and Time Management program developed by
 * TimeTrex Payroll Services Copyright (C) 2003 - 2011 TimeTrex Payroll Services.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY TIMETREX, TIMETREX DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact TimeTrex headquarters at Unit 22 - 2475 Dobbin Rd. Suite
 * #292 Westbank, BC V4T 2E9, Canada or at email address info@timetrex.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by TimeTrex" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by TimeTrex".
 ********************************************************************************/
/*
 * $Revision: 2095 $
 * $Id: Sort.class.php 2095 2008-09-01 07:04:25Z ipso $
 * $Date: 2008-09-01 00:04:25 -0700 (Mon, 01 Sep 2008) $
 */

/**
 * @package Core
 */
class InvoiceTransactionSummaryReport extends Report {

	function __construct() {
		$this->title = TTi18n::getText('Invoice Transaction Report');
		$this->file_name = 'invoice_transaction_report';

		parent::__construct();

		return TRUE;
	}

	protected function _checkPermissions( $user_id, $company_id ) {
		if ( $this->getPermissionObject()->Check('invoice_report','enabled', $user_id, $company_id )
				AND $this->getPermissionObject()->Check('invoice_report','view_transaction_summary', $user_id, $company_id ) ) {
			return TRUE;
		}

		return FALSE;
	}

	protected function _getOptions( $name, $params = NULL ) {
		$retval = NULL;
		switch( $name ) {
			case 'default_setup_fields':
				$retval = array(
										'template',
										'time_period',
										'columns',
							   );
				break;
			case 'setup_fields':
				$retval = array(
										//Static Columns - Aggregate functions can't be used on these.
										'-1000-template' => TTi18n::gettext('Template'),
										'-1010-time_period' => TTi18n::gettext('Time Period'),

										'-2010-client_status_id' => TTi18n::gettext('Client Status'),
										'-2020-client_group_id' => TTi18n::gettext('Client Group'),
										'-2040-include_client_id' => TTi18n::gettext('Client Include'),
										'-2050-exclude_client_id' => TTi18n::gettext('Client Exclude'),

										//Invoice transaction API not done yet.
										//'-2100-invoice_transaction_type_id' => TTi18n::gettext('Transaction Type'),

										'-2210-product_type_id' => TTi18n::gettext('Product Type'),
										'-2220-product_group_id' => TTi18n::gettext('Product Group'),
										'-2230-include_product_id' => TTi18n::gettext('Product Include'),
										'-2240-exclude_product_id' => TTi18n::gettext('Product Exclude'),

										'-2500-currency_id' => TTi18n::gettext('Currency'),

										'-5000-columns' => TTi18n::gettext('Display Columns'),
										'-5010-group' => TTi18n::gettext('Group By'),
										'-5020-sub_total' => TTi18n::gettext('SubTotal By'),
										'-5030-sort' => TTi18n::gettext('Sort By'),
							   );
				break;
			case 'time_period':
				$retval = TTDate::getTimePeriodOptions();
				break;
			case 'date_columns':
				$retval = array_merge( 	TTDate::getReportDateOptions( 'effective', TTi18n::getText('Effective Date'), 13, FALSE ),
										TTDate::getReportDateOptions( 'invoice', TTi18n::getText('Invoice Date'), 15, FALSE ),
										TTDate::getReportDateOptions( 'invoice_shipped', TTi18n::getText('Invoice Shipped Date'), 16, FALSE )
									);
				break;
			case 'static_columns':
				$retval = array(
										//Static Columns - Aggregate functions can't be used on these.
										'-1010-client_company_name' => TTi18n::gettext('Client Name'),
										'-1020-client_status' => TTi18n::gettext('Client Status'),
										'-1030-client_group' => TTi18n::gettext('Client Group'),
										//'-1040-client_created_date' => TTi18n::gettext('Client Created Date'),

										'-1110-product_type' => TTi18n::gettext('Product Type'),
										'-1120-product_group' => TTi18n::gettext('Product Group'),
										'-1130-product_status' => TTi18n::gettext('Product Status'),
										'-1140-product_name' => TTi18n::gettext('Product Name'),
										'-1150-product_part_number' => TTi18n::gettext('Product Part Number'),
										'-1160-product_description' => TTi18n::gettext('Product Descripton'),


										'-1210-type' => TTi18n::gettext('Type'),
										'-1230-currency' => TTi18n::gettext('Currency'),
										'-1240-current_currency' => TTi18n::gettext('Converted Currency'),
										'-1250-note' => TTi18n::gettext('Note'),
										//'-120-effective_date' => TTi18n::gettext('Transaction Effective Date'),

										'-1400-invoice_id' => TTi18n::gettext('Invoice #'),
										'-1410-invoice_status' => TTi18n::gettext('Invoice Status'),
										'-1420-invoice_po_number' => TTi18n::gettext('Invoice PO Number'),
										'-1430-invoice_tracking_number' => TTi18n::gettext('Invoice Tracking Number'),
										'-1440-invoice_private_note' => TTi18n::gettext('Invoice Private Note'),
										'-1450-invoice_public_note' => TTi18n::gettext('Invoice Public Note'),
										'-1460-invoice_shipping_policy' => TTi18n::gettext('Invoice Shipping Policy'),
										'-1470-invoice_order_date' => TTi18n::gettext('Invoice Order Date'),
										'-1480-invoice_required_date' => TTi18n::gettext('Invoice Required Date'),

										//'-1500-invoice_date' => TTi18n::gettext('Invoice Date'),
										//'-1600-invoice_shipped_date' => TTi18n::gettext('Invoice Shipped Date'),

										'-1810-invoice_billing_full_name' => TTi18n::gettext('Invoice Billing Contact'),
										'-1820-invoice_billing_country' => TTi18n::gettext('Invoice Billing Country'),
										'-1830-invoice_billing_province' => TTi18n::gettext('Invoice Billing Province/State'),
										'-1840-invoice_billing_city' => TTi18n::gettext('Invoice Billing City'),
										'-1850-invoice_billing_postal_code' => TTi18n::gettext('Invoice Billing Postal/ZIP Code'),

										'-1910-invoice_shipping_full_name' => TTi18n::gettext('Invoice Shipping Contact'),
										'-1920-invoice_shipping_country' => TTi18n::gettext('Invoice Shipping Country'),
										'-1930-invoice_shipping_province' => TTi18n::gettext('Invoice Shipping Province/State'),
										'-1940-invoice_shipping_city' => TTi18n::gettext('Invoice Shipping City'),
										'-1950-invoice_shipping_postal_code' => TTi18n::gettext('Invoice Shipping Postal/ZIP Code'),
							   );

				$retval = array_merge( $retval, $this->getOptions('date_columns') );
				ksort($retval);
				break;
			case 'dynamic_columns':
				$retval = array(
										//Dynamic - Aggregate functions can be used
										'-2000-debit_amount' => TTi18n::gettext('Debit'),
										'-2001-credit_amount' => TTi18n::gettext('Credit'),
										'-2010-quantity' => TTi18n::gettext('Quantity'),
										'-2021-unit_cost' => TTi18n::gettext('Unit Cost'),
										'-2022-total_unit_cost' => TTi18n::gettext('Total Cost'),
										'-2030-unit_price' => TTi18n::gettext('Unit Price'),
										'-2040-profit_amount' => TTi18n::gettext('Profit Amount'),
										'-2041-profit_percent' => TTi18n::gettext('Profit %'),
							);
				break;
			case 'columns':
				$retval = array_merge( $this->getOptions('static_columns'), $this->getOptions('dynamic_columns') );
				break;
			case 'column_format':
				//Define formatting function for each column.
				$columns = $this->getOptions('dynamic_columns');
				if ( is_array($columns) ) {
					foreach($columns as $column => $name ) {
						if ( strpos($column, '_amount') !== FALSE OR strpos($column, '_cost') !== FALSE OR strpos($column, '_price') !== FALSE ) {
							$retval[$column] = 'currency';
						} elseif ( strpos($column, 'invoice_order_date') OR strpos($column, 'invoice_shipped_date') OR strpos($column, 'invoice_required_date') ) {
							$retval[$column] = 'date_stamp';
						} elseif ( strpos($column, '_percent') ) {
							$retval[$column] = 'percent';
						} else {
							$retval[$column] = 'numeric';
						}
					}

				}
				break;
			case 'aggregates':
				$retval = array();
				$dynamic_columns = array_keys( Misc::trimSortPrefix( $this->getOptions('dynamic_columns') ) );
				if ( is_array($dynamic_columns ) ) {
					foreach( $dynamic_columns as $column ) {
						switch ( $column ) {
							default:
								if ( strpos($column, 'profit_percent') !== FALSE ) {
									$retval[$column] = 'avg';
								} else {
									$retval[$column] = 'sum';
								}
						}
					}
				}
				break;
			case 'templates':
				$retval = array(
										'-1010-detail+debit' => TTi18n::gettext('Detailed Debits'),
										'-1020-detail+credit' => TTi18n::gettext('Detailed Credits'),
										'-1030-combined_detail' => TTi18n::gettext('Detailed Debits/Credits'),
										'-1040-separated_detail' => TTi18n::gettext('Detailed Debits/Credits By Type'),

										'-1110-by_client+debit' => TTi18n::gettext('Debits By Client'),
										'-1120-by_client_group+debit' => TTi18n::gettext('Debits By Client Group'),
										'-1130-by_client_group_by_client+debit' => TTi18n::gettext('Debits By Client Group/Client'),

										'-1210-by_product_type+debit' => TTi18n::gettext('Debits By Product Type'),
										'-1220-by_product_group+debit' => TTi18n::gettext('Debits By Product Group'),
										'-1230-by_product_name+debit' => TTi18n::gettext('Debits By Product Name'),

										'-1310-by_product_type_by_product_group+debit' => TTi18n::gettext('Debits By Product Type/Group'),
										'-1320-by_product_type_by_product_name+debit' => TTi18n::gettext('Debits By Product Type/Name'),
										'-1330-by_product_type_by_product_group_by_product_name+debit' => TTi18n::gettext('Debits By Product Type/Group/Name'),

										'-1410-by_date_stamp+debit' => TTi18n::gettext('Debits By Date'),
										'-1420-by_month_by_dom+debit' => TTi18n::gettext('Debits By Month/Day'),
										'-1430-by_month+debit' => TTi18n::gettext('Debits By Month'),
										'-1440-by_quarter+debit' => TTi18n::gettext('Debits By Quarter'),
										'-1450-by_year+debit' => TTi18n::gettext('Debits By Year'),
										'-1460-by_month_by_year+debit' => TTi18n::gettext('Debits By Month/Year'),
										'-1470-by_year_by_quarter_by_month_by_dom+debit' => TTi18n::gettext('Debits By Year/Quarter/Month/Day'),

							   );

				break;
			case 'template_config':
				$template = strtolower( Misc::trimSortPrefix( $params['template'] ) );
				if ( isset($template) AND $template != '' ) {
					switch( $template ) {
						case 'specific_template_name':
							//$retval['column'] = array();
							//$retval['filter'] = array();
							//$retval['group'] = array();
							//$retval['sub_total'] = array();
							//$retval['sort'] = array();
							break;
						default:
							Debug::Text(' Parsing template name: '. $template, __FILE__, __LINE__, __METHOD__,10);
							$retval['-1010-time_period']['time_period'] = 'last_quarter';

							//Parse template name, and use the keywords separated by '+' to determine settings.
							$template_keywords = explode('+', $template );
							if ( is_array($template_keywords) ) {
								foreach( $template_keywords as $template_keyword ) {
									Debug::Text(' Keyword: '. $template_keyword, __FILE__, __LINE__, __METHOD__,10);
									switch( $template_keyword ) {
										//Columns
										case 'debit':
											$retval['columns'][] = 'debit_amount';
											$retval['filter']['invoice_transaction_type_id'] = array(10);
											break;
										case 'credit':
											$retval['columns'][] = 'credit_amount';
											$retval['filter']['invoice_transaction_type_id'] = array(20);
											break;
										case 'profit':
											$retval['columns'][] = 'profit_amount';
											$retval['columns'][] = 'profit_percent';
											break;
										//Filter
										//Group By
										//SubTotal
										//Sort

										case 'detail':
											$retval['columns'][] = 'effective-date_stamp';
											$retval['columns'][] = 'client_group';
											$retval['columns'][] = 'client_company_name';
											$retval['columns'][] = 'product_type';
											$retval['columns'][] = 'product_group';
											$retval['columns'][] = 'product_name';

											$retval['sub_total'][] = 'effective-date_stamp';
											$retval['sub_total'][] = 'client_group';

											$retval['sort'][] = array('effective-date_stamp' => 'asc');
											$retval['sort'][] = array('client_group' => 'asc');
											$retval['sort'][] = array('client_company_name' => 'asc');
											$retval['sort'][] = array('product_type' => 'asc');
											$retval['sort'][] = array('product_group' => 'asc');
											$retval['sort'][] = array('product_name' => 'asc');
											break;

										case 'combined_detail':
											$retval['columns'][] = 'effective-date_stamp';
											$retval['columns'][] = 'client_group';
											$retval['columns'][] = 'client_company_name';
											$retval['columns'][] = 'product_type';
											$retval['columns'][] = 'product_group';
											$retval['columns'][] = 'product_name';
											$retval['columns'][] = 'type';
											$retval['columns'][] = 'debit_amount';
											$retval['columns'][] = 'credit_amount';

											$retval['sub_total'][] = 'effective-date_stamp';
											$retval['sub_total'][] = 'client_group';

											$retval['sort'][] = array('effective-date_stamp' => 'asc');
											$retval['sort'][] = array('client_group' => 'asc');
											$retval['sort'][] = array('client_company_name' => 'asc');
											$retval['sort'][] = array('type' => 'desc');
											$retval['sort'][] = array('product_type' => 'asc');
											$retval['sort'][] = array('product_group' => 'asc');
											$retval['sort'][] = array('product_name' => 'asc');
											break;

										case 'separated_detail':
											$retval['columns'][] = 'type';
											$retval['columns'][] = 'effective-date_stamp';
											$retval['columns'][] = 'client_group';
											$retval['columns'][] = 'client_company_name';
											$retval['columns'][] = 'product_type';
											$retval['columns'][] = 'product_group';
											$retval['columns'][] = 'product_name';
											$retval['columns'][] = 'debit_amount';
											$retval['columns'][] = 'credit_amount';

											$retval['sub_total'][] = 'type';
											$retval['sub_total'][] = 'effective-date_stamp';
											$retval['sub_total'][] = 'client_group';

											$retval['sort'][] = array('type' => 'desc');
											$retval['sort'][] = array('effective-date_stamp' => 'asc');
											$retval['sort'][] = array('client_group' => 'asc');
											$retval['sort'][] = array('client_company_name' => 'asc');
											$retval['sort'][] = array('product_type' => 'asc');
											$retval['sort'][] = array('product_group' => 'asc');
											$retval['sort'][] = array('product_name' => 'asc');
											break;

										case 'by_client':
											$retval['columns'][] = 'client_company_name';

											$retval['group'][] = 'client_company_name';

											$retval['sort'][] = array('client_company_name' => 'asc');
											break;
										case 'by_client_group':
											$retval['columns'][] = 'client_group';

											$retval['group'][] = 'client_group';

											$retval['sort'][] = array('client_group' => 'asc');
											break;
										case 'by_client_group_by_client':
											$retval['columns'][] = 'client_group';
											$retval['columns'][] = 'client_company_name';

											$retval['group'][] = 'client_group';
											$retval['group'][] = 'client_company_name';

											$retval['sub_total'][] = 'client_group';

											$retval['sort'][] = array('client_group' => 'asc');
											$retval['sort'][] = array('client_company_name' => 'asc');
											break;

										case 'by_product_type':
											$retval['columns'][] = 'product_type';

											$retval['group'][] = 'product_type';

											$retval['sort'][] = array('product_type' => 'asc');
											break;
										case 'by_product_group':
											$retval['columns'][] = 'product_group';

											$retval['group'][] = 'product_group';

											$retval['sort'][] = array('product_group' => 'asc');
											break;
										case 'by_product_name':
											$retval['columns'][] = 'product_part_number';
											$retval['columns'][] = 'product_name';

											$retval['group'][] = 'product_part_number';
											$retval['group'][] = 'product_name';

											$retval['sort'][] = array('product_part_number' => 'asc');
											$retval['sort'][] = array('product_name' => 'asc');
											break;
										case 'by_product_type_by_product_name':
											$retval['columns'][] = 'product_type';
											$retval['columns'][] = 'product_name';

											$retval['group'][] = 'product_type';
											$retval['group'][] = 'product_name';

											$retval['sub_total'][] = 'product_type';

											$retval['sort'][] = array('product_type' => 'asc');
											$retval['sort'][] = array('product_name' => 'asc');
											break;
										case 'by_product_type_by_product_group':
											$retval['columns'][] = 'product_type';
											$retval['columns'][] = 'product_group';

											$retval['group'][] = 'product_type';
											$retval['group'][] = 'product_group';

											$retval['sub_total'][] = 'product_type';

											$retval['sort'][] = array('product_type' => 'asc');
											$retval['sort'][] = array('product_group' => 'asc');
											break;
										case 'by_product_type_by_product_group_by_product_name':
											$retval['columns'][] = 'product_type';
											$retval['columns'][] = 'product_group';
											$retval['columns'][] = 'product_name';

											$retval['group'][] = 'product_type';
											$retval['group'][] = 'product_group';
											$retval['group'][] = 'product_name';

											$retval['sub_total'][] = 'product_type';
											$retval['sub_total'][] = 'product_group';

											$retval['sort'][] = array('product_type' => 'asc');
											$retval['sort'][] = array('product_group' => 'asc');
											$retval['sort'][] = array('product_name' => 'asc');
											break;
										case 'by_date_stamp':
											$retval['columns'][] = 'effective-date_stamp';

											$retval['group'][] = 'effective-date_stamp';

											$retval['sort'][] = array('effective-date_stamp' => 'asc');
											break;
										case 'by_month_by_dom':
											$retval['columns'][] = 'effective-date_month';
											$retval['columns'][] = 'effective-date_dom';

											$retval['group'][] = 'effective-date_month';
											$retval['group'][] = 'effective-date_dom';

											$retval['sub_total'][] = 'effective-date_month';

											$retval['sort'][] = array('effective-date_month' => 'asc');
											$retval['sort'][] = array('effective-date_dom' => 'asc');
											break;
										case 'by_month':
											$retval['columns'][] = 'effective-date_month';

											$retval['group'][] = 'effective-date_month';

											$retval['sort'][] = array('effective-date_month' => 'asc');
											break;
										case 'by_quarter':
											$retval['columns'][] = 'effective-date_quarter';

											$retval['group'][] = 'effective-date_quarter';

											$retval['sort'][] = array('effective-date_quarter' => 'asc');
											break;
										case 'by_year':
											$retval['columns'][] = 'effective-date_year';

											$retval['group'][] = 'effective-date_year';

											$retval['sort'][] = array('effective-date_year' => 'asc');
											break;
										case 'by_month_by_year':
											$retval['columns'][] = 'effective-date_month';
											$retval['columns'][] = 'effective-date_year';

											$retval['group'][] = 'effective-date_month';
											$retval['group'][] = 'effective-date_year';

											$retval['sort'][] = array('effective-date_month' => 'asc');
											$retval['sort'][] = array('effective-date_year' => 'asc');
											break;
										case 'by_year_by_quarter_by_month_by_dom':
											$retval['columns'][] = 'effective-date_year';
											$retval['columns'][] = 'effective-date_quarter';
											$retval['columns'][] = 'effective-date_month';
											$retval['columns'][] = 'effective-date_dom';

											$retval['group'][] = 'effective-date_year';
											$retval['group'][] = 'effective-date_quarter';
											$retval['group'][] = 'effective-date_month';
											$retval['group'][] = 'effective-date_dom';

											$retval['sub_total'][] = 'effective-date_year';
											$retval['sub_total'][] = 'effective-date_quarter';
											$retval['sub_total'][] = 'effective-date_month';

											$retval['sort'][] = array('effective-date_year' => 'asc');
											$retval['sort'][] = array('effective-date_quarter' => 'asc');
											$retval['sort'][] = array('effective-date_month' => 'asc');
											$retval['sort'][] = array('effective-date_dom' => 'asc');
											break;

									}
								}
							}

							break;
					}
				}

				//Set the template dropdown as well.
				$retval['-1000-template'] = $template;

				//Add sort prefixes so Flex can maintain order.
				if ( isset($retval['filter']) ) {
					$retval['-5000-filter'] = $retval['filter'];
					unset($retval['filter']);
				}
				if ( isset($retval['columns']) ) {
					$retval['-5010-columns'] = $retval['columns'];
					unset($retval['columns']);
				}
				if ( isset($retval['group']) ) {
					$retval['-5020-group'] = $retval['group'];
					unset($retval['group']);
				}
				if ( isset($retval['sub_total']) ) {
					$retval['-5030-sub_total'] = $retval['sub_total'];
					unset($retval['sub_total']);
				}
				if ( isset($retval['sort']) ) {
					$retval['-5040-sort'] = $retval['sort'];
					unset($retval['sort']);
				}
				Debug::Arr($retval, ' Template Config for: '. $template, __FILE__, __LINE__, __METHOD__,10);

				break;
			default:
				//Call report parent class options function for options valid for all reports.
				$retval = $this->__getOptions( $name );
				break;
		}

		return $retval;
	}

	//Get raw data for report
	function _getData() {
		$this->tmp_data = array('transaction' => array() );

		$columns = $this->getColumnConfig();
		$filter_data = $this->getFilterConfig();

		$crlf = new CurrencyListFactory();
		$crlf->getByCompanyId( $this->getUserObject()->getCompany() );
		$currency_options = $crlf->getArrayByListFactory( $crlf, FALSE, TRUE );
		Debug::Arr($currency_options, 'Currency Options: ', __FILE__, __LINE__, __METHOD__,10);

		//Get Base Currency
		$crlf->getByCompanyIdAndBase( $this->getUserObject()->getCompany(), TRUE );
		if ( $crlf->getRecordCount() > 0 ) {
			$base_currency_obj = $crlf->getCurrent();
		}

		$currency_convert_to_base = FALSE;
		if ( !isset($filter_data['currency_id']) OR count($filter_data['currency_id']) != 1 ) {
			Debug::Text('More then one currency selected, converting to base!', __FILE__, __LINE__, __METHOD__,10);
			$currency_convert_to_base = TRUE;
		}

		$cf = new ClientFactory();
		$pf = new ProductFactory();
		$if = new InvoiceFactory();

		$tlf = new TransactionListFactory();
		$tlf->getTransactionReportByCompanyIdAndArrayCriteria( $this->getUserObject()->getCompany(), $filter_data );
		Debug::Text('Total Transaction Rows: '. $tlf->getRecordCount(), __FILE__, __LINE__, __METHOD__,10);
		$this->getProgressBarObject()->start( $this->getAMFMessageID(), $tlf->getRecordCount(), NULL, TTi18n::getText('Retrieving Data...') );
		if ( $tlf->getRecordCount() > 0 ) {
			foreach( $tlf as $key => $t_obj ) {
				$transaction_row_data = (array)$t_obj->getObjectAsArray( $this->getColumnConfig() );

				$debit_amount = NULL;
				$credit_amount = NULL;
				if ( $t_obj->getType() == 10 ) {
					$debit_amount = $t_obj->getAmount();
					$product_name = $t_obj->getColumn('product_name');
					$product_description = $t_obj->getColumn('product_description');
					$product_type = Option::getByKey( $t_obj->getColumn('product_type_id'), $pf->getOptions('type') );
				} else {
					$credit_amount = $t_obj->getAmount();
					$product_name = Option::getByKey( $t_obj->getPaymentType(), $t_obj->getOptions('payment_type') );
					$product_description = NULL;
					$product_type = TTi18n::getTexT('Payment');
					if ( is_object( $t_obj->getClientPaymentObject() ) ) {
						$product_description = $t_obj->getClientPaymentObject()->getCreditCardTypeName();
					}
				}

				$currency = $current_currency = Option::getByKey( $t_obj->getCurrency(), $currency_options );
				if ( $currency_convert_to_base == TRUE ) {
					$current_currency = Option::getByKey( $base_currency_obj->getId(), $currency_options );
				}
				$transaction_row_data['currency'] = $currency;
				$transaction_row_data['current_currency'] = $current_currency;

				$total_unit_cost = 0;
				if ( $t_obj->getType() == 10 ) {
					$total_unit_cost = bcmul( $t_obj->getQuantity(), $t_obj->getUnitCost() );
				}
				$profit_amount = bcsub( $debit_amount, $total_unit_cost );
				if ( $total_unit_cost == 0 ) {
					$profit_percent = '100.00';
				} else {
					$profit_percent = bcmul( bcdiv( $profit_amount, $total_unit_cost), 100 );
				}

				$transaction_row_data['unit_cost'] = $base_currency_obj->getBaseCurrencyAmount( $t_obj->getUnitCost(), $t_obj->getCurrencyRate(), $currency_convert_to_base );
				$transaction_row_data['total_unit_cost'] = $base_currency_obj->getBaseCurrencyAmount( $total_unit_cost, $t_obj->getCurrencyRate(), $currency_convert_to_base );
				$transaction_row_data['unit_price'] = $base_currency_obj->getBaseCurrencyAmount( $t_obj->getUnitPrice(), $t_obj->getCurrencyRate(), $currency_convert_to_base );
				$transaction_row_data['profit_amount'] = $base_currency_obj->getBaseCurrencyAmount( $profit_amount, $t_obj->getCurrencyRate(), $currency_convert_to_base );
				$transaction_row_data['profit_percent'] = $profit_percent;

				$transaction_row_data['debit_amount'] = $base_currency_obj->getBaseCurrencyAmount( $debit_amount, $t_obj->getCurrencyRate(), $currency_convert_to_base );
				$transaction_row_data['credit_amount'] = $base_currency_obj->getBaseCurrencyAmount( $credit_amount, $t_obj->getCurrencyRate(), $currency_convert_to_base );
				unset($profit_percent, $profit_amount, $total_unit_cost);

				$external_row_data = array(
								'client_company_name' => $t_obj->getColumn('client_company_name'),
								'client_status' => Option::getByKey( $t_obj->getColumn('client_status_id'), $cf->getOptions('status') ),
								'client_group' => $t_obj->getColumn('client_group'),
								'client_created_date' => $t_obj->getColumn('client_created_date'),

								'product_type' => $product_type,
								'product_status' => Option::getByKey( $t_obj->getColumn('product_status_id'), $pf->getOptions('status') ),
								'product_name' => $product_name,
								'product_part_number' => $t_obj->getColumn('product_part_number'),
								'product_description' => $product_description,
								'product_group' => $t_obj->getColumn('product_group'),
								'product_description' => $t_obj->getColumn('product_description'),

								'type' => $t_obj->getColumn('type'),
								//'effective_date' => $date_stamp,
								'note' => $t_obj->getColumn('note'),

								'invoice_id' => $t_obj->getColumn('invoice_id'),
								'invoice_status' => Option::getByKey( $t_obj->getColumn('invoice_status_id'), $if->getOptions('status') ),
								'invoice_po_number' => $t_obj->getColumn('invoice_po_number'),
								'invoice_tracking_number' => $t_obj->getColumn('invoice_tracking_number'),
								'invoice_private_note' => $t_obj->getColumn('invoice_private_note'),
								'invoice_public_note' => $t_obj->getColumn('invoice_public_note'),
								'invoice_shipping_policy' => $t_obj->getColumn('invoice_shipping_policy'),

								//'invoice_date' => TTDate::strtotime( $t_obj->getColumn('invoice_date') ),
								'invoice_order_date' => TTDate::strtotime(  $t_obj->getColumn('invoice_order_date') ),
								'invoice_required_date' => TTDate::strtotime(  $t_obj->getColumn('invoice_required_date') ),
								//'invoice_shipped_date' => TTDate::strtotime(  $t_obj->getColumn('invoice_shipped_date') ),

								'invoice_billing_full_name' => Misc::getFullName( $t_obj->getColumn('invoice_billing_first_name'), NULL, $t_obj->getColumn('invoice_billing_last_name') ),
								'invoice_billing_country' => $t_obj->getColumn('invoice_billing_country'),
								'invoice_billing_province' => $t_obj->getColumn('invoice_billing_province'),
								'invoice_billing_city' => $t_obj->getColumn('invoice_billing_city'),
								'invoice_billing_postal_code' => $t_obj->getColumn('invoice_billing_postal_code'),

								'invoice_shipping_full_name' => Misc::getFullName( $t_obj->getColumn('invoice_shipping_first_name'), NULL, $t_obj->getColumn('invoice_shipping_last_name') ),
								'invoice_shipping_country' => $t_obj->getColumn('invoice_shipping_country'),
								'invoice_shipping_province' => $t_obj->getColumn('invoice_shipping_province'),
								'invoice_shipping_city' => $t_obj->getColumn('invoice_shipping_city'),
								'invoice_shipping_postal_code' => $t_obj->getColumn('invoice_shipping_postal_code'),
				);

				$this->tmp_data['transaction'][] = array_merge( $external_row_data,
																$transaction_row_data,
																TTDate::getReportDates( 'effective', TTDate::strtotime( $t_obj->getColumn('effective_date') ), FALSE, $this->getUserObject(), array('include_pay_period_dates' => FALSE) ),
																TTDate::getReportDates( 'invoice', TTDate::strtotime( $t_obj->getColumn('invoice_date') ), FALSE, $this->getUserObject(), array('include_pay_period_dates' => FALSE) ),
																TTDate::getReportDates( 'invoice_shipped', TTDate::strtotime( $t_obj->getColumn('invoice_shipped_date') ), FALSE, $this->getUserObject(), array('include_pay_period_dates' => FALSE) )
															);

				$this->getProgressBarObject()->set( $this->getAMFMessageID(), $key );
			}
		}

		//Debug::Arr($this->tmp_data['transaction'], 'Transaction Raw Data: ', __FILE__, __LINE__, __METHOD__,10);
		return TRUE;
	}

	//PreProcess data such as calculating additional columns from raw data etc...
	function _preProcess() {
		$this->data = $this->tmp_data['transaction'];
		return TRUE;
	}
}
?>
