/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.compat.JdkCompat;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSE13Factory;
import org.apache.tomcat.util.net.jsse.JSSEFactory;

public class JSSEImplementation
extends SSLImplementation {
    static final String JSSE15Factory = "org.apache.tomcat.util.net.jsse.JSSE15Factory";
    static final String JSSE14Factory = "org.apache.tomcat.util.net.jsse.JSSE14Factory";
    static final String JSSE13Factory = "org.apache.tomcat.util.net.jsse.JSSE13Factory";
    static final String SSLSocketClass = "javax.net.ssl.SSLSocket";
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$net$jsse$JSSEImplementation == null ? (class$org$apache$tomcat$util$net$jsse$JSSEImplementation = JSSEImplementation.class$("org.apache.tomcat.util.net.jsse.JSSEImplementation")) : class$org$apache$tomcat$util$net$jsse$JSSEImplementation));
    private JSSEFactory factory;
    static /* synthetic */ Class class$org$apache$tomcat$util$net$jsse$JSSEImplementation;

    public JSSEImplementation() throws ClassNotFoundException {
        block8: {
            Class<?> factcl;
            block7: {
                this.factory = null;
                Class.forName(SSLSocketClass);
                if (JdkCompat.isJava15()) {
                    try {
                        factcl = Class.forName(JSSE15Factory);
                        this.factory = (JSSEFactory)factcl.newInstance();
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug((Object)"Error getting factory: org.apache.tomcat.util.net.jsse.JSSE15Factory", (Throwable)ex);
                    }
                }
            }
            if (this.factory == null && JdkCompat.isJava14()) {
                try {
                    factcl = Class.forName(JSSE14Factory);
                    this.factory = (JSSEFactory)factcl.newInstance();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug((Object)"Error getting factory: org.apache.tomcat.util.net.jsse.JSSE14Factory", (Throwable)ex);
                }
            }
        }
        if (this.factory == null) {
            this.factory = new JSSE13Factory();
        }
    }

    public String getImplementationName() {
        return "JSSE";
    }

    public ServerSocketFactory getServerSocketFactory() {
        ServerSocketFactory ssf = this.factory.getSocketFactory();
        return ssf;
    }

    public SSLSupport getSSLSupport(Socket s) {
        SSLSupport ssls = this.factory.getSSLSupport(s);
        return ssls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

