//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappplatform

import "time"

// APIPortalCustomDomainProperties - The properties of custom domain for API portal
type APIPortalCustomDomainProperties struct {
	// The thumbprint of bound certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// APIPortalCustomDomainResource - Custom domain of the API portal
type APIPortalCustomDomainResource struct {
	// The properties of custom domain for API portal
	Properties *APIPortalCustomDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// APIPortalCustomDomainResourceCollection - Object that includes an array of API portal custom domain resources and a possible
// link for next set
type APIPortalCustomDomainResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of API portal custom domain resources
	Value []*APIPortalCustomDomainResource `json:"value,omitempty"`
}

// APIPortalCustomDomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the APIPortalCustomDomainsClient.BeginCreateOrUpdate
// method.
type APIPortalCustomDomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APIPortalCustomDomainsClientBeginDeleteOptions contains the optional parameters for the APIPortalCustomDomainsClient.BeginDelete
// method.
type APIPortalCustomDomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APIPortalCustomDomainsClientGetOptions contains the optional parameters for the APIPortalCustomDomainsClient.Get method.
type APIPortalCustomDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIPortalCustomDomainsClientListOptions contains the optional parameters for the APIPortalCustomDomainsClient.List method.
type APIPortalCustomDomainsClientListOptions struct {
	// placeholder for future optional parameters
}

// APIPortalInstance - Collection of instances belong to the API portal
type APIPortalInstance struct {
	// READ-ONLY; Name of the API portal instance
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the API portal instance
	Status *string `json:"status,omitempty" azure:"ro"`
}

// APIPortalProperties - API portal properties payload
type APIPortalProperties struct {
	// The array of resource Ids of gateway to integrate with API portal.
	GatewayIDs []*string `json:"gatewayIds,omitempty"`

	// Indicate if only https is allowed.
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`

	// Indicates whether the API portal exposes endpoint.
	Public *bool `json:"public,omitempty"`

	// Collection of OpenAPI source URL locations.
	SourceUrls []*string `json:"sourceUrls,omitempty"`

	// Single sign-on related configuration
	SsoProperties *SsoProperties `json:"ssoProperties,omitempty"`

	// READ-ONLY; Collection of instances belong to API portal.
	Instances []*APIPortalInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; State of the API portal.
	ProvisioningState *APIPortalProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *APIPortalResourceRequests `json:"resourceRequests,omitempty" azure:"ro"`

	// READ-ONLY; URL of the API portal, exposed when 'public' is true.
	URL *string `json:"url,omitempty" azure:"ro"`
}

// APIPortalResource - API portal resource
type APIPortalResource struct {
	// API portal properties payload
	Properties *APIPortalProperties `json:"properties,omitempty"`

	// Sku of the API portal resource
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// APIPortalResourceCollection - Object that includes an array of API portal resources and a possible link for next set
type APIPortalResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of API portal resources
	Value []*APIPortalResource `json:"value,omitempty"`
}

// APIPortalResourceRequests - Resource requests of the API portal
type APIPortalResourceRequests struct {
	// READ-ONLY; Cpu allocated to each API portal instance
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Memory allocated to each API portal instance
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// APIPortalsClientBeginCreateOrUpdateOptions contains the optional parameters for the APIPortalsClient.BeginCreateOrUpdate
// method.
type APIPortalsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APIPortalsClientBeginDeleteOptions contains the optional parameters for the APIPortalsClient.BeginDelete method.
type APIPortalsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APIPortalsClientGetOptions contains the optional parameters for the APIPortalsClient.Get method.
type APIPortalsClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIPortalsClientListOptions contains the optional parameters for the APIPortalsClient.List method.
type APIPortalsClientListOptions struct {
	// placeholder for future optional parameters
}

// APIPortalsClientValidateDomainOptions contains the optional parameters for the APIPortalsClient.ValidateDomain method.
type APIPortalsClientValidateDomainOptions struct {
	// placeholder for future optional parameters
}

// AcceleratorAuthSettingClassification provides polymorphic access to related types.
// Call the interface's GetAcceleratorAuthSetting() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AcceleratorAuthSetting, *AcceleratorBasicAuthSetting, *AcceleratorPublicSetting, *AcceleratorSSHSetting
type AcceleratorAuthSettingClassification interface {
	// GetAcceleratorAuthSetting returns the AcceleratorAuthSetting content of the underlying type.
	GetAcceleratorAuthSetting() *AcceleratorAuthSetting
}

// AcceleratorAuthSetting - Auth setting payload.
type AcceleratorAuthSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string `json:"authType,omitempty"`
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorAuthSetting.
func (a *AcceleratorAuthSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting { return a }

// AcceleratorBasicAuthSetting - Auth setting for basic auth.
type AcceleratorBasicAuthSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string `json:"authType,omitempty"`

	// REQUIRED; Username of git repository basic auth.
	Username *string `json:"username,omitempty"`

	// Password of git repository basic auth.
	Password *string `json:"password,omitempty"`
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorBasicAuthSetting.
func (a *AcceleratorBasicAuthSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting {
	return &AcceleratorAuthSetting{
		AuthType: a.AuthType,
	}
}

type AcceleratorGitRepository struct {
	// REQUIRED; Properties of the auth setting payload.
	AuthSetting AcceleratorAuthSettingClassification `json:"authSetting,omitempty"`

	// REQUIRED; Git repository URL for the accelerator.
	URL *string `json:"url,omitempty"`

	// Git repository branch to be used.
	Branch *string `json:"branch,omitempty"`

	// Git repository commit to be used.
	Commit *string `json:"commit,omitempty"`

	// Git repository tag to be used.
	GitTag *string `json:"gitTag,omitempty"`

	// Interval for checking for updates to Git or image repository.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
}

// AcceleratorPublicSetting - Auth setting for public url.
type AcceleratorPublicSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string `json:"authType,omitempty"`
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorPublicSetting.
func (a *AcceleratorPublicSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting {
	return &AcceleratorAuthSetting{
		AuthType: a.AuthType,
	}
}

// AcceleratorSSHSetting - Auth setting for SSH auth.
type AcceleratorSSHSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string `json:"authType,omitempty"`

	// Public SSH Key of git repository.
	HostKey *string `json:"hostKey,omitempty"`

	// SSH Key algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`

	// Private SSH Key algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorSSHSetting.
func (a *AcceleratorSSHSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting {
	return &AcceleratorAuthSetting{
		AuthType: a.AuthType,
	}
}

// ActiveDeploymentCollection - Object that includes an array of Deployment resource name and set them as active.
type ActiveDeploymentCollection struct {
	// Collection of Deployment name.
	ActiveDeploymentNames []*string `json:"activeDeploymentNames,omitempty"`
}

// AppResource - App resource payload
type AppResource struct {
	// The Managed Identity type of the app resource
	Identity *ManagedIdentityProperties `json:"identity,omitempty"`

	// The GEO location of the application, always the same with its parent resource
	Location *string `json:"location,omitempty"`

	// Properties of the App resource
	Properties *AppResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AppResourceCollection - Object that includes an array of App resources and a possible link for next set
type AppResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of App resources
	Value []*AppResource `json:"value,omitempty"`
}

// AppResourceProperties - App resource properties payload
type AppResourceProperties struct {
	// Collection of addons
	AddonConfigs map[string]map[string]interface{} `json:"addonConfigs,omitempty"`

	// List of custom persistent disks
	CustomPersistentDisks []*CustomPersistentDiskResource `json:"customPersistentDisks,omitempty"`

	// Indicate if end to end TLS is enabled.
	EnableEndToEndTLS *bool `json:"enableEndToEndTLS,omitempty"`

	// Indicate if only https is allowed.
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`

	// App ingress settings payload.
	IngressSettings *IngressSettings `json:"ingressSettings,omitempty"`

	// Collection of loaded certificates
	LoadedCertificates []*LoadedCertificate `json:"loadedCertificates,omitempty"`

	// Persistent disk settings
	PersistentDisk *PersistentDisk `json:"persistentDisk,omitempty"`

	// Indicates whether the App exposes public endpoint
	Public *bool `json:"public,omitempty"`

	// Temporary disk settings
	TemporaryDisk *TemporaryDisk `json:"temporaryDisk,omitempty"`

	// Additional App settings in vnet injection instance
	VnetAddons *AppVNetAddons `json:"vnetAddons,omitempty"`

	// READ-ONLY; Fully qualified dns Name.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the App
	ProvisioningState *AppResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; URL of the App
	URL *string `json:"url,omitempty" azure:"ro"`
}

// AppVNetAddons - Additional App settings in vnet injection instance
type AppVNetAddons struct {
	// Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
	PublicEndpoint *bool `json:"publicEndpoint,omitempty"`

	// READ-ONLY; URL of the App in vnet injection instance which could be accessed from internet
	PublicEndpointURL *string `json:"publicEndpointUrl,omitempty" azure:"ro"`
}

type ApplicationAcceleratorComponent struct {
	ResourceRequests *ApplicationAcceleratorResourceRequests `json:"resourceRequests,omitempty"`

	// READ-ONLY
	Instances []*ApplicationAcceleratorInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`
}

type ApplicationAcceleratorInstance struct {
	// READ-ONLY; Name of the Application Accelerator instance.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Application Accelerator instance. It can be Pending, Running, Succeeded, Failed, Unknown.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ApplicationAcceleratorProperties - Application accelerator properties payload
type ApplicationAcceleratorProperties struct {
	// READ-ONLY; Collection of components belong to application accelerator.
	Components []*ApplicationAcceleratorComponent `json:"components,omitempty" azure:"ro"`

	// READ-ONLY; State of the application accelerator.
	ProvisioningState *ApplicationAcceleratorProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationAcceleratorResource - Application accelerator resource
type ApplicationAcceleratorResource struct {
	// Application accelerator properties payload
	Properties *ApplicationAcceleratorProperties `json:"properties,omitempty"`

	// Sku of the application accelerator resource
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationAcceleratorResourceCollection - Object that includes an array of application accelerator resources and a possible
// link for next set
type ApplicationAcceleratorResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of application accelerator resources
	Value []*ApplicationAcceleratorResource `json:"value,omitempty"`
}

type ApplicationAcceleratorResourceRequests struct {
	// READ-ONLY; Cpu allocated to each application accelerator component. 1 core can be represented by 1 or 1000m
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Instance count of the application accelerator component.
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Memory allocated to each application accelerator component. 1 GB can be represented by 1Gi or 1024Mi.
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// ApplicationAcceleratorsClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationAcceleratorsClient.BeginCreateOrUpdate
// method.
type ApplicationAcceleratorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationAcceleratorsClientBeginDeleteOptions contains the optional parameters for the ApplicationAcceleratorsClient.BeginDelete
// method.
type ApplicationAcceleratorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationAcceleratorsClientGetOptions contains the optional parameters for the ApplicationAcceleratorsClient.Get method.
type ApplicationAcceleratorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationAcceleratorsClientListOptions contains the optional parameters for the ApplicationAcceleratorsClient.List method.
type ApplicationAcceleratorsClientListOptions struct {
	// placeholder for future optional parameters
}

// ApplicationInsightsAgentVersions - Application Insights agent versions properties payload
type ApplicationInsightsAgentVersions struct {
	// READ-ONLY; Indicates the version of application insight java agent
	Java *string `json:"java,omitempty" azure:"ro"`
}

// ApplicationLiveViewComponent - Application Live View properties payload
type ApplicationLiveViewComponent struct {
	// READ-ONLY; Collection of instances belong to Application Live View.
	Instances []*ApplicationLiveViewInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; Name of the component.
	Name interface{} `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *ApplicationLiveViewResourceRequests `json:"resourceRequests,omitempty" azure:"ro"`
}

// ApplicationLiveViewInstance - Collection of instances belong to the Application Live View
type ApplicationLiveViewInstance struct {
	// READ-ONLY; Name of the Application Live View instance.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Application Live View instance. It can be Pending, Running, Succeeded, Failed, Unknown.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ApplicationLiveViewProperties - Application Live View properties payload
type ApplicationLiveViewProperties struct {
	// READ-ONLY; Component details of Application Live View
	Components []*ApplicationLiveViewComponent `json:"components,omitempty" azure:"ro"`

	// READ-ONLY; State of the Application Live View.
	ProvisioningState *ApplicationLiveViewProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationLiveViewResource - Application Live View resource
type ApplicationLiveViewResource struct {
	// Application Live View properties payload
	Properties *ApplicationLiveViewProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationLiveViewResourceCollection - Object that includes an array of Application Live View resources and a possible
// link for next set
type ApplicationLiveViewResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Application Live View resources
	Value []*ApplicationLiveViewResource `json:"value,omitempty"`
}

// ApplicationLiveViewResourceRequests - The resource quantity for required CPU and Memory of Application Live View component
type ApplicationLiveViewResourceRequests struct {
	// READ-ONLY; Cpu quantity allocated to each Application Live View component instance. 1 core can be represented by 1 or 1000m.
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Desired instance count of Application Live View component instance.
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Memory quantity allocated to each Application Live View component instance. 1 GB can be represented by 1Gi or
	// 1024Mi.
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// ApplicationLiveViewsClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationLiveViewsClient.BeginCreateOrUpdate
// method.
type ApplicationLiveViewsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationLiveViewsClientBeginDeleteOptions contains the optional parameters for the ApplicationLiveViewsClient.BeginDelete
// method.
type ApplicationLiveViewsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationLiveViewsClientGetOptions contains the optional parameters for the ApplicationLiveViewsClient.Get method.
type ApplicationLiveViewsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationLiveViewsClientListOptions contains the optional parameters for the ApplicationLiveViewsClient.List method.
type ApplicationLiveViewsClientListOptions struct {
	// placeholder for future optional parameters
}

// AppsClientBeginCreateOrUpdateOptions contains the optional parameters for the AppsClient.BeginCreateOrUpdate method.
type AppsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AppsClientBeginDeleteOptions contains the optional parameters for the AppsClient.BeginDelete method.
type AppsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AppsClientBeginSetActiveDeploymentsOptions contains the optional parameters for the AppsClient.BeginSetActiveDeployments
// method.
type AppsClientBeginSetActiveDeploymentsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AppsClientBeginUpdateOptions contains the optional parameters for the AppsClient.BeginUpdate method.
type AppsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AppsClientGetOptions contains the optional parameters for the AppsClient.Get method.
type AppsClientGetOptions struct {
	// Indicates whether sync status
	SyncStatus *string
}

// AppsClientGetResourceUploadURLOptions contains the optional parameters for the AppsClient.GetResourceUploadURL method.
type AppsClientGetResourceUploadURLOptions struct {
	// placeholder for future optional parameters
}

// AppsClientListOptions contains the optional parameters for the AppsClient.List method.
type AppsClientListOptions struct {
	// placeholder for future optional parameters
}

// AppsClientValidateDomainOptions contains the optional parameters for the AppsClient.ValidateDomain method.
type AppsClientValidateDomainOptions struct {
	// placeholder for future optional parameters
}

// AvailableOperations - Available operations of the service
type AvailableOperations struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of available operation details
	Value []*OperationDetail `json:"value,omitempty"`
}

type AvailableRuntimeVersions struct {
	// READ-ONLY; A list of all supported runtime versions.
	Value []*SupportedRuntimeVersion `json:"value,omitempty" azure:"ro"`
}

// AzureFileVolume - The properties of the Azure File volume. Azure File shares are mounted as volumes.
type AzureFileVolume struct {
	// REQUIRED; The mount path of the persistent disk.
	MountPath *string `json:"mountPath,omitempty"`

	// REQUIRED; The share name of the Azure File share.
	ShareName *string `json:"shareName,omitempty"`

	// REQUIRED; The type of the underlying resource to mount as a persistent disk.
	Type *Type `json:"type,omitempty"`

	// These are the mount options for a persistent disk.
	MountOptions []*string `json:"mountOptions,omitempty"`

	// Indicates whether the persistent disk is a readOnly one.
	ReadOnly *bool `json:"readOnly,omitempty"`
}

// GetCustomPersistentDiskProperties implements the CustomPersistentDiskPropertiesClassification interface for type AzureFileVolume.
func (a *AzureFileVolume) GetCustomPersistentDiskProperties() *CustomPersistentDiskProperties {
	return &CustomPersistentDiskProperties{
		Type:         a.Type,
		MountPath:    a.MountPath,
		ReadOnly:     a.ReadOnly,
		MountOptions: a.MountOptions,
	}
}

// BindingResource - Binding resource payload
type BindingResource struct {
	// Properties of the Binding resource
	Properties *BindingResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BindingResourceCollection - Object that includes an array of Binding resources and a possible link for next set
type BindingResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Binding resources
	Value []*BindingResource `json:"value,omitempty"`
}

// BindingResourceProperties - Binding resource properties payload
type BindingResourceProperties struct {
	// Binding parameters of the Binding resource
	BindingParameters map[string]interface{} `json:"bindingParameters,omitempty"`

	// The key of the bound resource
	Key *string `json:"key,omitempty"`

	// The Azure resource id of the bound resource
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; Creation time of the Binding resource
	CreatedAt *string `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; The generated Spring Boot property file for this binding. The secret will be deducted.
	GeneratedProperties *string `json:"generatedProperties,omitempty" azure:"ro"`

	// READ-ONLY; The name of the bound resource
	ResourceName *string `json:"resourceName,omitempty" azure:"ro"`

	// READ-ONLY; The standard Azure resource type of the bound resource
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Update time of the Binding resource
	UpdatedAt *string `json:"updatedAt,omitempty" azure:"ro"`
}

// BindingsClientBeginCreateOrUpdateOptions contains the optional parameters for the BindingsClient.BeginCreateOrUpdate method.
type BindingsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BindingsClientBeginDeleteOptions contains the optional parameters for the BindingsClient.BeginDelete method.
type BindingsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BindingsClientBeginUpdateOptions contains the optional parameters for the BindingsClient.BeginUpdate method.
type BindingsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BindingsClientGetOptions contains the optional parameters for the BindingsClient.Get method.
type BindingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BindingsClientListOptions contains the optional parameters for the BindingsClient.List method.
type BindingsClientListOptions struct {
	// placeholder for future optional parameters
}

// Build resource payload
type Build struct {
	// Properties of the build resource
	Properties *BuildProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BuildCollection - Object that includes an array of Build resources and a possible link for next set
type BuildCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Build resources
	Value []*Build `json:"value,omitempty"`
}

// BuildProperties - Build resource properties payload
type BuildProperties struct {
	// The resource id of agent pool
	AgentPool *string `json:"agentPool,omitempty"`

	// The resource id of builder to build the source code
	Builder *string `json:"builder,omitempty"`

	// The environment variables for this build
	Env map[string]*string `json:"env,omitempty"`

	// The relative path of source code
	RelativePath *string `json:"relativePath,omitempty"`

	// The customized build resource for this build
	ResourceRequests *BuildResourceRequests `json:"resourceRequests,omitempty"`

	// READ-ONLY; Provisioning state of the KPack build result
	ProvisioningState *BuildProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The build result triggered by this build
	TriggeredBuildResult *TriggeredBuildResult `json:"triggeredBuildResult,omitempty" azure:"ro"`
}

// BuildResourceRequests - Resource request payload of Build Resource.
type BuildResourceRequests struct {
	// Optional Cpu allocated to the build resource. 1 core can be represented by 1 or 1000m. The default value is 1, this should
	// not exceed build service agent pool cpu size.
	CPU *string `json:"cpu,omitempty"`

	// Optional Memory allocated to the build resource. 1 GB can be represented by 1Gi or 1024Mi. The default value is 2Gi, this
	// should not exceed build service agent pool memory size.
	Memory *string `json:"memory,omitempty"`
}

// BuildResult - Build result resource payload
type BuildResult struct {
	// Properties of the build result resource
	Properties *BuildResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BuildResultCollection - Object that includes an array of Build result resources and a possible link for next set
type BuildResultCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Build result resources
	Value []*BuildResult `json:"value,omitempty"`
}

// BuildResultLog - Build result log resource properties payload
type BuildResultLog struct {
	// The public download URL of this build result log
	BlobURL *string `json:"blobUrl,omitempty"`
}

// BuildResultProperties - Build result resource properties payload
type BuildResultProperties struct {
	// The build pod name which can be used to get the build log streaming.
	BuildPodName *string `json:"buildPodName,omitempty"`

	// Error when build is failed.
	Error *Error `json:"error,omitempty"`

	// The name of this build result
	Name *string `json:"name,omitempty"`

	// READ-ONLY; All of the build stage (init-container and container) resources in build pod.
	BuildStages []*BuildStageProperties `json:"buildStages,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the KPack build result
	ProvisioningState *BuildResultProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BuildResultUserSourceInfo - Reference to a build result
type BuildResultUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string `json:"type,omitempty"`

	// Resource id of an existing succeeded build result under the same Spring instance.
	BuildResultID *string `json:"buildResultId,omitempty"`

	// Version of the source
	Version *string `json:"version,omitempty"`
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type BuildResultUserSourceInfo.
func (b *BuildResultUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    b.Type,
		Version: b.Version,
	}
}

// BuildService - Build service resource payload
type BuildService struct {
	// Properties of the build resource
	Properties *BuildServiceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BuildServiceAgentPoolClientBeginUpdatePutOptions contains the optional parameters for the BuildServiceAgentPoolClient.BeginUpdatePut
// method.
type BuildServiceAgentPoolClientBeginUpdatePutOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BuildServiceAgentPoolClientGetOptions contains the optional parameters for the BuildServiceAgentPoolClient.Get method.
type BuildServiceAgentPoolClientGetOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceAgentPoolClientListOptions contains the optional parameters for the BuildServiceAgentPoolClient.List method.
type BuildServiceAgentPoolClientListOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceAgentPoolProperties - Build service agent pool properties
type BuildServiceAgentPoolProperties struct {
	// build service agent pool size properties
	PoolSize *BuildServiceAgentPoolSizeProperties `json:"poolSize,omitempty"`

	// READ-ONLY; Provisioning state of the build service agent pool
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// BuildServiceAgentPoolResource - The build service agent pool resource
type BuildServiceAgentPoolResource struct {
	// build service agent pool properties
	Properties *BuildServiceAgentPoolProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BuildServiceAgentPoolResourceCollection - Object that includes an array of build service agent pool resources and a possible
// link for next set
type BuildServiceAgentPoolResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of build service agent pool resource
	Value []*BuildServiceAgentPoolResource `json:"value,omitempty"`
}

// BuildServiceAgentPoolSizeProperties - Build service agent pool size properties
type BuildServiceAgentPoolSizeProperties struct {
	// The name of build service agent pool size
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The cpu property of build service agent pool size
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; The memory property of build service agent pool size
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// BuildServiceBuilderClientBeginCreateOrUpdateOptions contains the optional parameters for the BuildServiceBuilderClient.BeginCreateOrUpdate
// method.
type BuildServiceBuilderClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BuildServiceBuilderClientBeginDeleteOptions contains the optional parameters for the BuildServiceBuilderClient.BeginDelete
// method.
type BuildServiceBuilderClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BuildServiceBuilderClientGetOptions contains the optional parameters for the BuildServiceBuilderClient.Get method.
type BuildServiceBuilderClientGetOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceBuilderClientListDeploymentsOptions contains the optional parameters for the BuildServiceBuilderClient.ListDeployments
// method.
type BuildServiceBuilderClientListDeploymentsOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceBuilderClientListOptions contains the optional parameters for the BuildServiceBuilderClient.List method.
type BuildServiceBuilderClientListOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientCreateOrUpdateBuildOptions contains the optional parameters for the BuildServiceClient.CreateOrUpdateBuild
// method.
type BuildServiceClientCreateOrUpdateBuildOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientGetBuildOptions contains the optional parameters for the BuildServiceClient.GetBuild method.
type BuildServiceClientGetBuildOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientGetBuildResultLogOptions contains the optional parameters for the BuildServiceClient.GetBuildResultLog
// method.
type BuildServiceClientGetBuildResultLogOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientGetBuildResultOptions contains the optional parameters for the BuildServiceClient.GetBuildResult method.
type BuildServiceClientGetBuildResultOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientGetBuildServiceOptions contains the optional parameters for the BuildServiceClient.GetBuildService method.
type BuildServiceClientGetBuildServiceOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientGetResourceUploadURLOptions contains the optional parameters for the BuildServiceClient.GetResourceUploadURL
// method.
type BuildServiceClientGetResourceUploadURLOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientGetSupportedBuildpackOptions contains the optional parameters for the BuildServiceClient.GetSupportedBuildpack
// method.
type BuildServiceClientGetSupportedBuildpackOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientGetSupportedStackOptions contains the optional parameters for the BuildServiceClient.GetSupportedStack
// method.
type BuildServiceClientGetSupportedStackOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientListBuildResultsOptions contains the optional parameters for the BuildServiceClient.ListBuildResults
// method.
type BuildServiceClientListBuildResultsOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientListBuildServicesOptions contains the optional parameters for the BuildServiceClient.ListBuildServices
// method.
type BuildServiceClientListBuildServicesOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientListBuildsOptions contains the optional parameters for the BuildServiceClient.ListBuilds method.
type BuildServiceClientListBuildsOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientListSupportedBuildpacksOptions contains the optional parameters for the BuildServiceClient.ListSupportedBuildpacks
// method.
type BuildServiceClientListSupportedBuildpacksOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceClientListSupportedStacksOptions contains the optional parameters for the BuildServiceClient.ListSupportedStacks
// method.
type BuildServiceClientListSupportedStacksOptions struct {
	// placeholder for future optional parameters
}

// BuildServiceCollection - Object that includes an array of Build service resources and a possible link for next set
type BuildServiceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Build service resources
	Value []*BuildService `json:"value,omitempty"`
}

// BuildServiceProperties - Build service resource properties payload
type BuildServiceProperties struct {
	// The installed KPack version in this build service.
	KPackVersion *string `json:"kPackVersion,omitempty"`

	// The runtime resource configuration of this build service.
	ResourceRequests *BuildServicePropertiesResourceRequests `json:"resourceRequests,omitempty"`

	// READ-ONLY; Provisioning state of the KPack build result
	ProvisioningState *BuildServiceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BuildServicePropertiesResourceRequests - The runtime resource configuration of this build service.
type BuildServicePropertiesResourceRequests struct {
	// READ-ONLY; vCPU allocated to the entire build service node pool.
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Memory allocated to the entire build service node pool.
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// BuildStageProperties - The build stage (init-container and container) resources in build pod.
type BuildStageProperties struct {
	// READ-ONLY; The exit code of this build init container.
	ExitCode *string `json:"exitCode,omitempty" azure:"ro"`

	// READ-ONLY; The name of this build stage resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The reason of this build init container.
	Reason *string `json:"reason,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of this build stage resource.
	Status *KPackBuildStageProvisioningState `json:"status,omitempty" azure:"ro"`
}

// BuilderProperties - KPack Builder properties payload
type BuilderProperties struct {
	// Builder buildpack groups.
	BuildpackGroups []*BuildpacksGroupProperties `json:"buildpackGroups,omitempty"`

	// Builder cluster stack property.
	Stack *StackProperties `json:"stack,omitempty"`

	// READ-ONLY; Builder provision status.
	ProvisioningState *BuilderProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BuilderResource - KPack Builder resource
type BuilderResource struct {
	// Property of the Builder resource.
	Properties *BuilderProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BuilderResourceCollection - Object that includes an array of Builder resources and a possible link for next set
type BuilderResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Builder resources
	Value []*BuilderResource `json:"value,omitempty"`
}

// BuildpackBindingClientBeginCreateOrUpdateOptions contains the optional parameters for the BuildpackBindingClient.BeginCreateOrUpdate
// method.
type BuildpackBindingClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BuildpackBindingClientBeginDeleteOptions contains the optional parameters for the BuildpackBindingClient.BeginDelete method.
type BuildpackBindingClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BuildpackBindingClientGetOptions contains the optional parameters for the BuildpackBindingClient.Get method.
type BuildpackBindingClientGetOptions struct {
	// placeholder for future optional parameters
}

// BuildpackBindingClientListOptions contains the optional parameters for the BuildpackBindingClient.List method.
type BuildpackBindingClientListOptions struct {
	// placeholder for future optional parameters
}

// BuildpackBindingLaunchProperties - Buildpack Binding Launch Properties
type BuildpackBindingLaunchProperties struct {
	// Non-sensitive properties for launchProperties
	Properties map[string]*string `json:"properties,omitempty"`

	// Sensitive properties for launchProperties
	Secrets map[string]*string `json:"secrets,omitempty"`
}

// BuildpackBindingProperties - Properties of a buildpack binding
type BuildpackBindingProperties struct {
	// Buildpack Binding Type
	BindingType *BindingType `json:"bindingType,omitempty"`

	// The object describes the buildpack binding launch properties
	LaunchProperties *BuildpackBindingLaunchProperties `json:"launchProperties,omitempty"`

	// READ-ONLY; State of the Buildpack Binding.
	ProvisioningState *BuildpackBindingProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BuildpackBindingResource - Buildpack Binding Resource object
type BuildpackBindingResource struct {
	// Properties of a buildpack binding
	Properties *BuildpackBindingProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BuildpackBindingResourceCollection - Object that includes an array of BuildpackBinding resources and a possible link for
// next set
type BuildpackBindingResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of BuildpackBinding resources
	Value []*BuildpackBindingResource `json:"value,omitempty"`
}

// BuildpackProperties - Buildpack properties payload
type BuildpackProperties struct {
	// Id of the buildpack
	ID *string `json:"id,omitempty"`
}

// BuildpacksGroupProperties - Buildpack group properties of the Builder
type BuildpacksGroupProperties struct {
	// Buildpacks in the buildpack group
	Buildpacks []*BuildpackProperties `json:"buildpacks,omitempty"`

	// Buildpack group name
	Name *string `json:"name,omitempty"`
}

// CertificatePropertiesClassification provides polymorphic access to related types.
// Call the interface's GetCertificateProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CertificateProperties, *ContentCertificateProperties, *KeyVaultCertificateProperties
type CertificatePropertiesClassification interface {
	// GetCertificateProperties returns the CertificateProperties content of the underlying type.
	GetCertificateProperties() *CertificateProperties
}

// CertificateProperties - Certificate resource payload.
type CertificateProperties struct {
	// REQUIRED; The type of the certificate source.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The activate date of certificate.
	ActivateDate *string `json:"activateDate,omitempty" azure:"ro"`

	// READ-ONLY; The domain list of certificate.
	DNSNames []*string `json:"dnsNames,omitempty" azure:"ro"`

	// READ-ONLY; The expiration date of certificate.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The issue date of certificate.
	IssuedDate *string `json:"issuedDate,omitempty" azure:"ro"`

	// READ-ONLY; The issuer of certificate.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Certificate
	ProvisioningState *CertificateResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The subject name of certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; The thumbprint of certificate.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// GetCertificateProperties implements the CertificatePropertiesClassification interface for type CertificateProperties.
func (c *CertificateProperties) GetCertificateProperties() *CertificateProperties { return c }

// CertificateResource - Certificate resource payload.
type CertificateResource struct {
	// Properties of the certificate resource payload.
	Properties CertificatePropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificateResourceCollection - Collection compose of certificate resources list and a possible link for next page.
type CertificateResourceCollection struct {
	// The link to next page of certificate list.
	NextLink *string `json:"nextLink,omitempty"`

	// The certificate resources list.
	Value []*CertificateResource `json:"value,omitempty"`
}

// CertificatesClientBeginCreateOrUpdateOptions contains the optional parameters for the CertificatesClient.BeginCreateOrUpdate
// method.
type CertificatesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CertificatesClientBeginDeleteOptions contains the optional parameters for the CertificatesClient.BeginDelete method.
type CertificatesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CertificatesClientGetOptions contains the optional parameters for the CertificatesClient.Get method.
type CertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientListOptions contains the optional parameters for the CertificatesClient.List method.
type CertificatesClientListOptions struct {
	// placeholder for future optional parameters
}

// ClusterResourceProperties - Service properties payload
type ClusterResourceProperties struct {
	// Purchasing 3rd party product of the Service resource.
	MarketplaceResource *MarketplaceResource `json:"marketplaceResource,omitempty"`

	// Network profile of the Service
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// Additional Service settings in vnet injection instance
	VnetAddons    *ServiceVNetAddons `json:"vnetAddons,omitempty"`
	ZoneRedundant *bool              `json:"zoneRedundant,omitempty"`

	// READ-ONLY; Fully qualified dns name of the service instance
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; Power state of the Service
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Service
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; ServiceInstanceEntity GUID which uniquely identifies a created resource
	ServiceID *string `json:"serviceId,omitempty" azure:"ro"`

	// READ-ONLY; Version of the Service
	Version *int32 `json:"version,omitempty" azure:"ro"`
}

// ConfigServerGitProperty - Property of git.
type ConfigServerGitProperty struct {
	// REQUIRED; URI of the repository
	URI *string `json:"uri,omitempty"`

	// Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`

	// SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`

	// Label of the repository
	Label *string `json:"label,omitempty"`

	// Password of git repository basic auth.
	Password *string `json:"password,omitempty"`

	// Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`

	// Repositories of git.
	Repositories []*GitPatternRepository `json:"repositories,omitempty"`

	// Searching path of the repository
	SearchPaths []*string `json:"searchPaths,omitempty"`

	// Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`

	// Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
}

// ConfigServerProperties - Config server git properties payload
type ConfigServerProperties struct {
	// Settings of config server.
	ConfigServer *ConfigServerSettings `json:"configServer,omitempty"`

	// Error when apply config server settings.
	Error *Error `json:"error,omitempty"`

	// READ-ONLY; State of the config server.
	ProvisioningState *ConfigServerState `json:"provisioningState,omitempty" azure:"ro"`
}

// ConfigServerResource - Config Server resource
type ConfigServerResource struct {
	// Properties of the Config Server resource
	Properties *ConfigServerProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConfigServerSettings - The settings of config server.
type ConfigServerSettings struct {
	// Property of git environment.
	GitProperty *ConfigServerGitProperty `json:"gitProperty,omitempty"`
}

// ConfigServerSettingsErrorRecord - Error record of the config server settings
type ConfigServerSettingsErrorRecord struct {
	// The detail error messages of the record
	Messages []*string `json:"messages,omitempty"`

	// The name of the config server settings error record
	Name *string `json:"name,omitempty"`

	// The uri of the config server settings error record
	URI *string `json:"uri,omitempty"`
}

// ConfigServerSettingsValidateResult - Validation result for config server settings
type ConfigServerSettingsValidateResult struct {
	// The detail validation results
	Details []*ConfigServerSettingsErrorRecord `json:"details,omitempty"`

	// Indicate if the config server settings are valid
	IsValid *bool `json:"isValid,omitempty"`
}

// ConfigServersClientBeginUpdatePatchOptions contains the optional parameters for the ConfigServersClient.BeginUpdatePatch
// method.
type ConfigServersClientBeginUpdatePatchOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigServersClientBeginUpdatePutOptions contains the optional parameters for the ConfigServersClient.BeginUpdatePut method.
type ConfigServersClientBeginUpdatePutOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigServersClientBeginValidateOptions contains the optional parameters for the ConfigServersClient.BeginValidate method.
type ConfigServersClientBeginValidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigServersClientGetOptions contains the optional parameters for the ConfigServersClient.Get method.
type ConfigServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationServiceGitProperty - Property of git environment.
type ConfigurationServiceGitProperty struct {
	// Repositories of Application Configuration Service git property.
	Repositories []*ConfigurationServiceGitRepository `json:"repositories,omitempty"`
}

// ConfigurationServiceGitPropertyValidateResult - Validation result for configuration service settings
type ConfigurationServiceGitPropertyValidateResult struct {
	// The detail validation results
	GitReposValidationResult []*ValidationMessages `json:"gitReposValidationResult,omitempty"`

	// Indicate if the configuration service settings are valid
	IsValid *bool `json:"isValid,omitempty"`
}

// ConfigurationServiceGitRepository - Git repository property payload for Application Configuration Service
type ConfigurationServiceGitRepository struct {
	// REQUIRED; Label of the repository
	Label *string `json:"label,omitempty"`

	// REQUIRED; Name of the repository
	Name *string `json:"name,omitempty"`

	// REQUIRED; Collection of patterns of the repository
	Patterns []*string `json:"patterns,omitempty"`

	// REQUIRED; URI of the repository
	URI *string `json:"uri,omitempty"`

	// Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`

	// SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`

	// Password of git repository basic auth.
	Password *string `json:"password,omitempty"`

	// Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`

	// Searching path of the repository
	SearchPaths []*string `json:"searchPaths,omitempty"`

	// Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`

	// Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
}

// ConfigurationServiceInstance - Collection of instances belong to the Application Configuration Service
type ConfigurationServiceInstance struct {
	// READ-ONLY; Name of the Application Configuration Service instance
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Application Configuration Service instance
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ConfigurationServiceProperties - Application Configuration Service properties payload
type ConfigurationServiceProperties struct {
	// The settings of Application Configuration Service.
	Settings *ConfigurationServiceSettings `json:"settings,omitempty"`

	// READ-ONLY; Collection of instances belong to Application Configuration Service.
	Instances []*ConfigurationServiceInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; State of the Application Configuration Service.
	ProvisioningState *ConfigurationServiceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *ConfigurationServiceResourceRequests `json:"resourceRequests,omitempty" azure:"ro"`
}

// ConfigurationServiceResource - Application Configuration Service resource
type ConfigurationServiceResource struct {
	// Application Configuration Service properties payload
	Properties *ConfigurationServiceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConfigurationServiceResourceCollection - Object that includes an array of configuration service resources and a possible
// link for next set
type ConfigurationServiceResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of configuration service resources
	Value []*ConfigurationServiceResource `json:"value,omitempty"`
}

// ConfigurationServiceResourceRequests - Resource request payload of Application Configuration Service
type ConfigurationServiceResourceRequests struct {
	// READ-ONLY; Cpu allocated to each Application Configuration Service instance
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Instance count of the Application Configuration Service
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Memory allocated to each Application Configuration Service instance
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// ConfigurationServiceSettings - The settings of Application Configuration Service.
type ConfigurationServiceSettings struct {
	// Property of git environment.
	GitProperty *ConfigurationServiceGitProperty `json:"gitProperty,omitempty"`
}

// ConfigurationServiceSettingsValidateResult - Validation result for configuration service settings
type ConfigurationServiceSettingsValidateResult struct {
	// Validation result for configuration service settings
	GitPropertyValidationResult *ConfigurationServiceGitPropertyValidateResult `json:"gitPropertyValidationResult,omitempty"`
}

// ConfigurationServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the ConfigurationServicesClient.BeginCreateOrUpdate
// method.
type ConfigurationServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationServicesClientBeginDeleteOptions contains the optional parameters for the ConfigurationServicesClient.BeginDelete
// method.
type ConfigurationServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationServicesClientBeginValidateOptions contains the optional parameters for the ConfigurationServicesClient.BeginValidate
// method.
type ConfigurationServicesClientBeginValidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationServicesClientGetOptions contains the optional parameters for the ConfigurationServicesClient.Get method.
type ConfigurationServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationServicesClientListOptions contains the optional parameters for the ConfigurationServicesClient.List method.
type ConfigurationServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// ContainerProbeSettings - Container liveness and readiness probe settings
type ContainerProbeSettings struct {
	// Indicates whether disable the liveness and readiness probe
	DisableProbe *bool `json:"disableProbe,omitempty"`
}

// ContentCertificateProperties - Properties of certificate imported from key vault.
type ContentCertificateProperties struct {
	// REQUIRED; The type of the certificate source.
	Type *string `json:"type,omitempty"`

	// The content of uploaded certificate.
	Content *string `json:"content,omitempty"`

	// READ-ONLY; The activate date of certificate.
	ActivateDate *string `json:"activateDate,omitempty" azure:"ro"`

	// READ-ONLY; The domain list of certificate.
	DNSNames []*string `json:"dnsNames,omitempty" azure:"ro"`

	// READ-ONLY; The expiration date of certificate.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The issue date of certificate.
	IssuedDate *string `json:"issuedDate,omitempty" azure:"ro"`

	// READ-ONLY; The issuer of certificate.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Certificate
	ProvisioningState *CertificateResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The subject name of certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; The thumbprint of certificate.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// GetCertificateProperties implements the CertificatePropertiesClassification interface for type ContentCertificateProperties.
func (c *ContentCertificateProperties) GetCertificateProperties() *CertificateProperties {
	return &CertificateProperties{
		Type:              c.Type,
		Thumbprint:        c.Thumbprint,
		Issuer:            c.Issuer,
		IssuedDate:        c.IssuedDate,
		ExpirationDate:    c.ExpirationDate,
		ActivateDate:      c.ActivateDate,
		SubjectName:       c.SubjectName,
		DNSNames:          c.DNSNames,
		ProvisioningState: c.ProvisioningState,
	}
}

// CustomContainer - Custom container payload
type CustomContainer struct {
	// Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
	Args []*string `json:"args,omitempty"`

	// Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
	Command []*string `json:"command,omitempty"`

	// Container image of the custom container. This should be in the form of : without the server name of the registry
	ContainerImage *string `json:"containerImage,omitempty"`

	// Credential of the image registry
	ImageRegistryCredential *ImageRegistryCredential `json:"imageRegistryCredential,omitempty"`

	// Language framework of the container image uploaded
	LanguageFramework *string `json:"languageFramework,omitempty"`

	// The name of the registry that contains the container image
	Server *string `json:"server,omitempty"`
}

// CustomContainerUserSourceInfo - Custom container user source info
type CustomContainerUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string `json:"type,omitempty"`

	// Custom container payload
	CustomContainer *CustomContainer `json:"customContainer,omitempty"`

	// Version of the source
	Version *string `json:"version,omitempty"`
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type CustomContainerUserSourceInfo.
func (c *CustomContainerUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    c.Type,
		Version: c.Version,
	}
}

// CustomDomainProperties - Custom domain of app resource payload.
type CustomDomainProperties struct {
	// The bound certificate name of domain.
	CertName *string `json:"certName,omitempty"`

	// The thumbprint of bound certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// READ-ONLY; The app name of domain.
	AppName *string `json:"appName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Domain
	ProvisioningState *CustomDomainResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// CustomDomainResource - Custom domain resource payload.
type CustomDomainResource struct {
	// Properties of the custom domain resource.
	Properties *CustomDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomDomainResourceCollection - Collection compose of a custom domain resources list and a possible link for next page.
type CustomDomainResourceCollection struct {
	// The link to next page of custom domain list.
	NextLink *string `json:"nextLink,omitempty"`

	// The custom domain resources list.
	Value []*CustomDomainResource `json:"value,omitempty"`
}

// CustomDomainValidatePayload - Custom domain validate payload.
type CustomDomainValidatePayload struct {
	// REQUIRED; Name to be validated
	Name *string `json:"name,omitempty"`
}

// CustomDomainValidateResult - Validation result for custom domain.
type CustomDomainValidateResult struct {
	// Indicates if domain name is valid.
	IsValid *bool `json:"isValid,omitempty"`

	// Message of why domain name is invalid.
	Message *string `json:"message,omitempty"`
}

// CustomDomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the CustomDomainsClient.BeginCreateOrUpdate
// method.
type CustomDomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomDomainsClientBeginDeleteOptions contains the optional parameters for the CustomDomainsClient.BeginDelete method.
type CustomDomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomDomainsClientBeginUpdateOptions contains the optional parameters for the CustomDomainsClient.BeginUpdate method.
type CustomDomainsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomDomainsClientGetOptions contains the optional parameters for the CustomDomainsClient.Get method.
type CustomDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomDomainsClientListOptions contains the optional parameters for the CustomDomainsClient.List method.
type CustomDomainsClientListOptions struct {
	// placeholder for future optional parameters
}

// CustomPersistentDiskPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetCustomPersistentDiskProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileVolume, *CustomPersistentDiskProperties
type CustomPersistentDiskPropertiesClassification interface {
	// GetCustomPersistentDiskProperties returns the CustomPersistentDiskProperties content of the underlying type.
	GetCustomPersistentDiskProperties() *CustomPersistentDiskProperties
}

// CustomPersistentDiskProperties - Custom persistent disk resource payload.
type CustomPersistentDiskProperties struct {
	// REQUIRED; The mount path of the persistent disk.
	MountPath *string `json:"mountPath,omitempty"`

	// REQUIRED; The type of the underlying resource to mount as a persistent disk.
	Type *Type `json:"type,omitempty"`

	// These are the mount options for a persistent disk.
	MountOptions []*string `json:"mountOptions,omitempty"`

	// Indicates whether the persistent disk is a readOnly one.
	ReadOnly *bool `json:"readOnly,omitempty"`
}

// GetCustomPersistentDiskProperties implements the CustomPersistentDiskPropertiesClassification interface for type CustomPersistentDiskProperties.
func (c *CustomPersistentDiskProperties) GetCustomPersistentDiskProperties() *CustomPersistentDiskProperties {
	return c
}

// CustomPersistentDiskResource - Custom persistent disk resource payload.
type CustomPersistentDiskResource struct {
	// REQUIRED; The resource id of Azure Spring Apps Storage resource.
	StorageID *string `json:"storageId,omitempty"`

	// Properties of the custom persistent disk resource payload.
	CustomPersistentDiskProperties CustomPersistentDiskPropertiesClassification `json:"customPersistentDiskProperties,omitempty"`
}

// CustomizedAcceleratorProperties - Customized accelerator properties payload
type CustomizedAcceleratorProperties struct {
	// REQUIRED
	GitRepository   *AcceleratorGitRepository `json:"gitRepository,omitempty"`
	AcceleratorTags []*string                 `json:"acceleratorTags,omitempty"`
	Description     *string                   `json:"description,omitempty"`
	DisplayName     *string                   `json:"displayName,omitempty"`
	IconURL         *string                   `json:"iconUrl,omitempty"`

	// READ-ONLY; State of the customized accelerator.
	ProvisioningState *CustomizedAcceleratorProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// CustomizedAcceleratorResource - Customized accelerator resource
type CustomizedAcceleratorResource struct {
	// Customized accelerator properties payload
	Properties *CustomizedAcceleratorProperties `json:"properties,omitempty"`

	// Sku of the customized accelerator resource
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type CustomizedAcceleratorResourceCollection struct {
	NextLink *string                          `json:"nextLink,omitempty"`
	Value    []*CustomizedAcceleratorResource `json:"value,omitempty"`
}

// CustomizedAcceleratorValidateResult - Validation result for customized accelerator properties
type CustomizedAcceleratorValidateResult struct {
	// The detail validation results
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// State of the customized accelerator validation result
	State *CustomizedAcceleratorValidateResultState `json:"state,omitempty"`
}

// CustomizedAcceleratorsClientBeginCreateOrUpdateOptions contains the optional parameters for the CustomizedAcceleratorsClient.BeginCreateOrUpdate
// method.
type CustomizedAcceleratorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomizedAcceleratorsClientBeginDeleteOptions contains the optional parameters for the CustomizedAcceleratorsClient.BeginDelete
// method.
type CustomizedAcceleratorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomizedAcceleratorsClientGetOptions contains the optional parameters for the CustomizedAcceleratorsClient.Get method.
type CustomizedAcceleratorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomizedAcceleratorsClientListOptions contains the optional parameters for the CustomizedAcceleratorsClient.List method.
type CustomizedAcceleratorsClientListOptions struct {
	// placeholder for future optional parameters
}

// CustomizedAcceleratorsClientValidateOptions contains the optional parameters for the CustomizedAcceleratorsClient.Validate
// method.
type CustomizedAcceleratorsClientValidateOptions struct {
	// placeholder for future optional parameters
}

// DeploymentInstance - Deployment instance payload
type DeploymentInstance struct {
	// READ-ONLY; Discovery status of the deployment instance
	DiscoveryStatus *string `json:"discoveryStatus,omitempty" azure:"ro"`

	// READ-ONLY; Name of the deployment instance
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Failed reason of the deployment instance
	Reason *string `json:"reason,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the deployment instance
	StartTime *string `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Status of the deployment instance
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Availability zone information of the deployment instance
	Zone *string `json:"zone,omitempty" azure:"ro"`
}

// DeploymentList - A list of deployments resource ids.
type DeploymentList struct {
	// A list of deployment resource ids.
	Deployments []*string `json:"deployments,omitempty"`
}

// DeploymentResource - Deployment resource payload
type DeploymentResource struct {
	// Properties of the Deployment resource
	Properties *DeploymentResourceProperties `json:"properties,omitempty"`

	// Sku of the Deployment resource
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeploymentResourceCollection - Object that includes an array of App resources and a possible link for next set
type DeploymentResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Deployment resources
	Value []*DeploymentResource `json:"value,omitempty"`
}

// DeploymentResourceProperties - Deployment resource properties payload
type DeploymentResourceProperties struct {
	// Indicates whether the Deployment is active
	Active *bool `json:"active,omitempty"`

	// Deployment settings of the Deployment
	DeploymentSettings *DeploymentSettings `json:"deploymentSettings,omitempty"`

	// Uploaded source information of the deployment.
	Source UserSourceInfoClassification `json:"source,omitempty"`

	// READ-ONLY; Collection of instances belong to the Deployment
	Instances []*DeploymentInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Deployment
	ProvisioningState *DeploymentResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Deployment
	Status *DeploymentResourceStatus `json:"status,omitempty" azure:"ro"`
}

// DeploymentSettings - Deployment settings payload
type DeploymentSettings struct {
	// Collection of addons
	AddonConfigs map[string]map[string]interface{} `json:"addonConfigs,omitempty"`

	// Container liveness and readiness probe settings
	ContainerProbeSettings *ContainerProbeSettings `json:"containerProbeSettings,omitempty"`

	// Collection of environment variables
	EnvironmentVariables map[string]*string `json:"environmentVariables,omitempty"`

	// Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	LivenessProbe *Probe `json:"livenessProbe,omitempty"`

	// Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails.
	// More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	ReadinessProbe *Probe `json:"readinessProbe,omitempty"`

	// The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required
	// CPU and Memory, the old field cpu and memoryInGB will be deprecated
	// later.
	ResourceRequests *ResourceRequests `json:"resourceRequests,omitempty"`

	// StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until
	// this completes successfully. If this probe fails, the Pod will be restarted,
	// just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's
	// lifecycle, when it might take a long time to load data or warm a cache,
	// than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	StartupProbe *Probe `json:"startupProbe,omitempty"`

	// Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value
	// must be non-negative integer. The value zero indicates stop immediately via the
	// kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace
	// period is the duration in seconds after the processes running in the App
	// Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this
	// value longer than the expected cleanup time for your process. Defaults to 90
	// seconds.
	TerminationGracePeriodSeconds *int32 `json:"terminationGracePeriodSeconds,omitempty"`
}

// DeploymentsClientBeginCreateOrUpdateOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdate
// method.
type DeploymentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDeleteOptions contains the optional parameters for the DeploymentsClient.BeginDelete method.
type DeploymentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDisableRemoteDebuggingOptions contains the optional parameters for the DeploymentsClient.BeginDisableRemoteDebugging
// method.
type DeploymentsClientBeginDisableRemoteDebuggingOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginEnableRemoteDebuggingOptions contains the optional parameters for the DeploymentsClient.BeginEnableRemoteDebugging
// method.
type DeploymentsClientBeginEnableRemoteDebuggingOptions struct {
	// Parameters for enable remote debugging
	RemoteDebuggingPayload *RemoteDebuggingPayload
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginGenerateHeapDumpOptions contains the optional parameters for the DeploymentsClient.BeginGenerateHeapDump
// method.
type DeploymentsClientBeginGenerateHeapDumpOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginGenerateThreadDumpOptions contains the optional parameters for the DeploymentsClient.BeginGenerateThreadDump
// method.
type DeploymentsClientBeginGenerateThreadDumpOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginRestartOptions contains the optional parameters for the DeploymentsClient.BeginRestart method.
type DeploymentsClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginStartJFROptions contains the optional parameters for the DeploymentsClient.BeginStartJFR method.
type DeploymentsClientBeginStartJFROptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginStartOptions contains the optional parameters for the DeploymentsClient.BeginStart method.
type DeploymentsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginStopOptions contains the optional parameters for the DeploymentsClient.BeginStop method.
type DeploymentsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginUpdateOptions contains the optional parameters for the DeploymentsClient.BeginUpdate method.
type DeploymentsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientGetLogFileURLOptions contains the optional parameters for the DeploymentsClient.GetLogFileURL method.
type DeploymentsClientGetLogFileURLOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetOptions contains the optional parameters for the DeploymentsClient.Get method.
type DeploymentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetRemoteDebuggingConfigOptions contains the optional parameters for the DeploymentsClient.GetRemoteDebuggingConfig
// method.
type DeploymentsClientGetRemoteDebuggingConfigOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientListForClusterOptions contains the optional parameters for the DeploymentsClient.ListForCluster method.
type DeploymentsClientListForClusterOptions struct {
	// Version of the deployments to be listed
	Version []string
}

// DeploymentsClientListOptions contains the optional parameters for the DeploymentsClient.List method.
type DeploymentsClientListOptions struct {
	// Version of the deployments to be listed
	Version []string
}

// DevToolPortalFeatureDetail - Detail settings for Dev Tool Portal feature
type DevToolPortalFeatureDetail struct {
	// State of the plugin
	State *DevToolPortalFeatureState `json:"state,omitempty"`

	// READ-ONLY; Route path to visit the plugin
	Route *string `json:"route,omitempty" azure:"ro"`
}

// DevToolPortalFeatureSettings - Settings for Dev Tool Portal
type DevToolPortalFeatureSettings struct {
	// Detail of Accelerator plugin
	ApplicationAccelerator *DevToolPortalFeatureDetail `json:"applicationAccelerator,omitempty"`

	// Detail of App Live View plugin
	ApplicationLiveView *DevToolPortalFeatureDetail `json:"applicationLiveView,omitempty"`
}

// DevToolPortalInstance - Collection of instances belong to the Dev Tool Portal.
type DevToolPortalInstance struct {
	// READ-ONLY; Name of the Dev Tool Portal instance.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Dev Tool Portal instance. It can be Pending, Running, Succeeded, Failed, Unknown.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// DevToolPortalProperties - Dev Tool Portal properties payload
type DevToolPortalProperties struct {
	// Settings for Dev Tool Portal
	Features *DevToolPortalFeatureSettings `json:"features,omitempty"`

	// Indicates whether the resource exposes public endpoint
	Public *bool `json:"public,omitempty"`

	// Single sign-on related configuration
	SsoProperties *DevToolPortalSsoProperties `json:"ssoProperties,omitempty"`

	// READ-ONLY; Collection of instances belong to Dev Tool Portal.
	Instances []*DevToolPortalInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; State of the Dev Tool Portal.
	ProvisioningState *DevToolPortalProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *DevToolPortalResourceRequests `json:"resourceRequests,omitempty" azure:"ro"`

	// READ-ONLY; URL of the resource, exposed when 'public' is true.
	URL *string `json:"url,omitempty" azure:"ro"`
}

// DevToolPortalResource - Dev Tool Portal resource
type DevToolPortalResource struct {
	// Dev Tool Portal properties payload
	Properties *DevToolPortalProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DevToolPortalResourceCollection - Object that includes an array of Dev Tool Portal resources and a possible link for next
// set
type DevToolPortalResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Dev Tool Portal resources
	Value []*DevToolPortalResource `json:"value,omitempty"`
}

// DevToolPortalResourceRequests - The resource quantity for required CPU and Memory of Dev Tool Portal
type DevToolPortalResourceRequests struct {
	// READ-ONLY; Cpu quantity allocated to each Dev Tool Portal instance. 1 core can be represented by 1 or 1000m
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Desired instance count of Dev Tool Portal.
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Memory quantity allocated to each Dev Tool Portal instance. 1 GB can be represented by 1Gi or 1024Mi.
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// DevToolPortalSsoProperties - Single sign-on related configuration
type DevToolPortalSsoProperties struct {
	// The public identifier for the application
	ClientID *string `json:"clientId,omitempty"`

	// The secret known only to the application and the authorization server
	ClientSecret *string `json:"clientSecret,omitempty"`

	// The URI of a JSON file with generic OIDC provider configuration.
	MetadataURL *string `json:"metadataUrl,omitempty"`

	// It defines the specific actions applications can be allowed to do on a user's behalf
	Scopes []*string `json:"scopes,omitempty"`
}

// DevToolPortalsClientBeginCreateOrUpdateOptions contains the optional parameters for the DevToolPortalsClient.BeginCreateOrUpdate
// method.
type DevToolPortalsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevToolPortalsClientBeginDeleteOptions contains the optional parameters for the DevToolPortalsClient.BeginDelete method.
type DevToolPortalsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevToolPortalsClientGetOptions contains the optional parameters for the DevToolPortalsClient.Get method.
type DevToolPortalsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DevToolPortalsClientListOptions contains the optional parameters for the DevToolPortalsClient.List method.
type DevToolPortalsClientListOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticParameters - Diagnostic parameters of diagnostic operations
type DiagnosticParameters struct {
	// App instance name
	AppInstance *string `json:"appInstance,omitempty"`

	// Duration of your JFR. 1 min can be represented by 1m or 60s.
	Duration *string `json:"duration,omitempty"`

	// Your target file path in your own BYOS
	FilePath *string `json:"filePath,omitempty"`
}

// Error - The error code compose of code and message.
type Error struct {
	// The code of error.
	Code *string `json:"code,omitempty"`

	// The message of error.
	Message *string `json:"message,omitempty"`
}

// ExecAction describes a "run in container" action.
type ExecAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType `json:"type,omitempty"`

	// Command is the command line to execute inside the container, the working directory for the command is root ('/') in the
	// container's filesystem. The command is not run inside a shell, so traditional
	// shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of
	// 0 is treated as live/healthy and non-zero is unhealthy.
	Command []*string `json:"command,omitempty"`
}

// GetProbeAction implements the ProbeActionClassification interface for type ExecAction.
func (e *ExecAction) GetProbeAction() *ProbeAction {
	return &ProbeAction{
		Type: e.Type,
	}
}

// GatewayAPIMetadataProperties - API metadata property for Spring Cloud Gateway
type GatewayAPIMetadataProperties struct {
	// Detailed description of the APIs available on the Gateway instance (default: Generated OpenAPI 3 document that describes
	// the API routes configured.)
	Description *string `json:"description,omitempty"`

	// Location of additional documentation for the APIs available on the Gateway instance
	Documentation *string `json:"documentation,omitempty"`

	// Base URL that API consumers will use to access APIs on the Gateway instance.
	ServerURL *string `json:"serverUrl,omitempty"`

	// Title describing the context of the APIs available on the Gateway instance (default: Spring Cloud Gateway for K8S)
	Title *string `json:"title,omitempty"`

	// Version of APIs available on this Gateway instance (default: unspecified).
	Version *string `json:"version,omitempty"`
}

// GatewayAPIRoute - API route config of the Spring Cloud Gateway
type GatewayAPIRoute struct {
	// A description, will be applied to methods in the generated OpenAPI documentation.
	Description *string `json:"description,omitempty"`

	// To modify the request before sending it to the target endpoint, or the received response.
	Filters []*string `json:"filters,omitempty"`

	// Route processing order.
	Order *int32 `json:"order,omitempty"`

	// A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and
	// parameter values. All of the predicates associated with a route must evaluate
	// to true for the route to be matched to the request.
	Predicates []*string `json:"predicates,omitempty"`

	// Enable sso validation.
	SsoEnabled *bool `json:"ssoEnabled,omitempty"`

	// Classification tags, will be applied to methods in the generated OpenAPI documentation.
	Tags []*string `json:"tags,omitempty"`

	// A title, will be applied to methods in the generated OpenAPI documentation.
	Title *string `json:"title,omitempty"`

	// Pass currently-authenticated user's identity token to application service, default is 'false'
	TokenRelay *bool `json:"tokenRelay,omitempty"`

	// Full uri, will override appName.
	URI *string `json:"uri,omitempty"`
}

// GatewayCorsProperties - Cross-Origin Resource Sharing property
type GatewayCorsProperties struct {
	// Whether user credentials are supported on cross-site requests. Valid values: true, false.
	AllowCredentials *bool `json:"allowCredentials,omitempty"`

	// Allowed headers in cross-site requests. The special value * allows actual requests to send any header.
	AllowedHeaders []*string `json:"allowedHeaders,omitempty"`

	// Allowed HTTP methods on cross-site requests. The special value * allows all methods. If not set, GET and HEAD are allowed
	// by default.
	AllowedMethods []*string `json:"allowedMethods,omitempty"`

	// Allowed origins to make cross-site requests. The special value * allows all domains.
	AllowedOrigins []*string `json:"allowedOrigins,omitempty"`

	// HTTP response headers to expose for cross-site requests.
	ExposedHeaders []*string `json:"exposedHeaders,omitempty"`

	// How long, in seconds, the response from a pre-flight request can be cached by clients.
	MaxAge *int32 `json:"maxAge,omitempty"`
}

// GatewayCustomDomainProperties - The properties of custom domain for Spring Cloud Gateway
type GatewayCustomDomainProperties struct {
	// The thumbprint of bound certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// GatewayCustomDomainResource - Custom domain of the Spring Cloud Gateway
type GatewayCustomDomainResource struct {
	// The properties of custom domain for Spring Cloud Gateway
	Properties *GatewayCustomDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GatewayCustomDomainResourceCollection - Object that includes an array of Spring Cloud Gateway custom domain resources and
// a possible link for next set
type GatewayCustomDomainResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Spring Cloud Gateway custom domain resources
	Value []*GatewayCustomDomainResource `json:"value,omitempty"`
}

// GatewayCustomDomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the GatewayCustomDomainsClient.BeginCreateOrUpdate
// method.
type GatewayCustomDomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GatewayCustomDomainsClientBeginDeleteOptions contains the optional parameters for the GatewayCustomDomainsClient.BeginDelete
// method.
type GatewayCustomDomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GatewayCustomDomainsClientGetOptions contains the optional parameters for the GatewayCustomDomainsClient.Get method.
type GatewayCustomDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayCustomDomainsClientListOptions contains the optional parameters for the GatewayCustomDomainsClient.List method.
type GatewayCustomDomainsClientListOptions struct {
	// placeholder for future optional parameters
}

// GatewayInstance - Collection of instances belong to the Spring Cloud Gateway
type GatewayInstance struct {
	// READ-ONLY; Name of the Spring Cloud Gateway instance
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Spring Cloud Gateway instance
	Status *string `json:"status,omitempty" azure:"ro"`
}

// GatewayOperatorProperties - Properties of the Spring Cloud Gateway Operator.
type GatewayOperatorProperties struct {
	// READ-ONLY; Collection of instances belong to Spring Cloud Gateway operator.
	Instances []*GatewayInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *GatewayOperatorResourceRequests `json:"resourceRequests,omitempty" azure:"ro"`
}

// GatewayOperatorResourceRequests - Properties of the Spring Cloud Gateway Operator.
type GatewayOperatorResourceRequests struct {
	// READ-ONLY; Cpu allocated to each Spring Cloud Gateway Operator instance.
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Instance count of the Spring Cloud Gateway Operator.
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Memory allocated to each Spring Cloud Gateway Operator instance.
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// GatewayProperties - Spring Cloud Gateway properties payload
type GatewayProperties struct {
	// API metadata property for Spring Cloud Gateway
	APIMetadataProperties *GatewayAPIMetadataProperties `json:"apiMetadataProperties,omitempty"`

	// Collection of APM type used in Spring Cloud Gateway
	ApmTypes []*ApmType `json:"apmTypes,omitempty"`

	// Cross-Origin Resource Sharing property
	CorsProperties *GatewayCorsProperties `json:"corsProperties,omitempty"`

	// Environment variables of Spring Cloud Gateway
	EnvironmentVariables *GatewayPropertiesEnvironmentVariables `json:"environmentVariables,omitempty"`

	// Indicate if only https is allowed.
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`

	// Indicates whether the Spring Cloud Gateway exposes endpoint.
	Public *bool `json:"public,omitempty"`

	// The requested resource quantity for required CPU and Memory.
	ResourceRequests *GatewayResourceRequests `json:"resourceRequests,omitempty"`

	// Single sign-on related configuration
	SsoProperties *SsoProperties `json:"ssoProperties,omitempty"`

	// READ-ONLY; Collection of instances belong to Spring Cloud Gateway.
	Instances []*GatewayInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; Properties of the Spring Cloud Gateway Operator.
	OperatorProperties *GatewayOperatorProperties `json:"operatorProperties,omitempty" azure:"ro"`

	// READ-ONLY; State of the Spring Cloud Gateway.
	ProvisioningState *GatewayProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; URL of the Spring Cloud Gateway, exposed when 'public' is true.
	URL *string `json:"url,omitempty" azure:"ro"`
}

// GatewayPropertiesEnvironmentVariables - Environment variables of Spring Cloud Gateway
type GatewayPropertiesEnvironmentVariables struct {
	// Non-sensitive properties
	Properties map[string]*string `json:"properties,omitempty"`

	// Sensitive properties
	Secrets map[string]*string `json:"secrets,omitempty"`
}

// GatewayResource - Spring Cloud Gateway resource
type GatewayResource struct {
	// Spring Cloud Gateway properties payload
	Properties *GatewayProperties `json:"properties,omitempty"`

	// Sku of the Spring Cloud Gateway resource
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GatewayResourceCollection - Object that includes an array of gateway resources and a possible link for next set
type GatewayResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of gateway resources
	Value []*GatewayResource `json:"value,omitempty"`
}

// GatewayResourceRequests - Resource request payload of Spring Cloud Gateway.
type GatewayResourceRequests struct {
	// Cpu allocated to each Spring Cloud Gateway instance.
	CPU *string `json:"cpu,omitempty"`

	// Memory allocated to each Spring Cloud Gateway instance.
	Memory *string `json:"memory,omitempty"`
}

// GatewayRouteConfigOpenAPIProperties - OpenAPI properties of Spring Cloud Gateway route config.
type GatewayRouteConfigOpenAPIProperties struct {
	// The URI of OpenAPI specification.
	URI *string `json:"uri,omitempty"`
}

// GatewayRouteConfigProperties - API route config of the Spring Cloud Gateway
type GatewayRouteConfigProperties struct {
	// The resource Id of the Azure Spring Apps app, required unless route defines uri.
	AppResourceID *string `json:"appResourceId,omitempty"`

	// To modify the request before sending it to the target endpoint, or the received response in app level.
	Filters []*string `json:"filters,omitempty"`

	// OpenAPI properties of Spring Cloud Gateway route config.
	OpenAPI *GatewayRouteConfigOpenAPIProperties `json:"openApi,omitempty"`

	// A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request
	// headers and parameter values. All of the predicates associated with a route
	// must evaluate to true for the route to be matched to the request.
	Predicates []*string `json:"predicates,omitempty"`

	// Protocol of routed Azure Spring Apps applications.
	Protocol *GatewayRouteConfigProtocol `json:"protocol,omitempty"`

	// Array of API routes, each route contains properties such as title, uri, ssoEnabled, predicates, filters.
	Routes []*GatewayAPIRoute `json:"routes,omitempty"`

	// Enable Single Sign-On in app level.
	SsoEnabled *bool `json:"ssoEnabled,omitempty"`

	// READ-ONLY; State of the Spring Cloud Gateway route config.
	ProvisioningState *GatewayProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GatewayRouteConfigResource - Spring Cloud Gateway route config resource
type GatewayRouteConfigResource struct {
	// API route config of the Spring Cloud Gateway
	Properties *GatewayRouteConfigProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GatewayRouteConfigResourceCollection - Object that includes an array of Spring Cloud Gateway route config resources and
// a possible link for next set
type GatewayRouteConfigResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Spring Cloud Gateway route config resources
	Value []*GatewayRouteConfigResource `json:"value,omitempty"`
}

// GatewayRouteConfigsClientBeginCreateOrUpdateOptions contains the optional parameters for the GatewayRouteConfigsClient.BeginCreateOrUpdate
// method.
type GatewayRouteConfigsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GatewayRouteConfigsClientBeginDeleteOptions contains the optional parameters for the GatewayRouteConfigsClient.BeginDelete
// method.
type GatewayRouteConfigsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GatewayRouteConfigsClientGetOptions contains the optional parameters for the GatewayRouteConfigsClient.Get method.
type GatewayRouteConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayRouteConfigsClientListOptions contains the optional parameters for the GatewayRouteConfigsClient.List method.
type GatewayRouteConfigsClientListOptions struct {
	// placeholder for future optional parameters
}

// GatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the GatewaysClient.BeginCreateOrUpdate method.
type GatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GatewaysClientBeginDeleteOptions contains the optional parameters for the GatewaysClient.BeginDelete method.
type GatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GatewaysClientGetOptions contains the optional parameters for the GatewaysClient.Get method.
type GatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewaysClientListEnvSecretsOptions contains the optional parameters for the GatewaysClient.ListEnvSecrets method.
type GatewaysClientListEnvSecretsOptions struct {
	// placeholder for future optional parameters
}

// GatewaysClientListOptions contains the optional parameters for the GatewaysClient.List method.
type GatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// GatewaysClientValidateDomainOptions contains the optional parameters for the GatewaysClient.ValidateDomain method.
type GatewaysClientValidateDomainOptions struct {
	// placeholder for future optional parameters
}

// GitPatternRepository - Git repository property payload for config server
type GitPatternRepository struct {
	// REQUIRED; Name of the repository
	Name *string `json:"name,omitempty"`

	// REQUIRED; URI of the repository
	URI *string `json:"uri,omitempty"`

	// Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`

	// SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`

	// Label of the repository
	Label *string `json:"label,omitempty"`

	// Password of git repository basic auth.
	Password *string `json:"password,omitempty"`

	// Collection of pattern of the repository
	Pattern []*string `json:"pattern,omitempty"`

	// Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`

	// Searching path of the repository
	SearchPaths []*string `json:"searchPaths,omitempty"`

	// Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`

	// Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
}

// HTTPGetAction describes an action based on HTTP Get requests.
type HTTPGetAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType `json:"type,omitempty"`

	// Path to access on the HTTP server.
	Path *string `json:"path,omitempty"`

	// Scheme to use for connecting to the host. Defaults to HTTP.
	// Possible enum values:
	// * "HTTP" means that the scheme used will be http://
	// * "HTTPS" means that the scheme used will be https://
	Scheme *HTTPSchemeType `json:"scheme,omitempty"`
}

// GetProbeAction implements the ProbeActionClassification interface for type HTTPGetAction.
func (h *HTTPGetAction) GetProbeAction() *ProbeAction {
	return &ProbeAction{
		Type: h.Type,
	}
}

// ImageRegistryCredential - Credential of the image registry
type ImageRegistryCredential struct {
	// The password of the image registry credential
	Password *string `json:"password,omitempty"`

	// The username of the image registry credential
	Username *string `json:"username,omitempty"`
}

// IngressConfig - Ingress configuration payload for Azure Spring Apps resource.
type IngressConfig struct {
	// Ingress read time out in seconds.
	ReadTimeoutInSeconds *int32 `json:"readTimeoutInSeconds,omitempty"`
}

// IngressSettings - App ingress settings payload.
type IngressSettings struct {
	// How ingress should communicate with this app backend service.
	BackendProtocol *BackendProtocol `json:"backendProtocol,omitempty"`

	// Client-Certification Authentication.
	ClientAuth *IngressSettingsClientAuth `json:"clientAuth,omitempty"`

	// Ingress read time out in seconds.
	ReadTimeoutInSeconds *int32 `json:"readTimeoutInSeconds,omitempty"`

	// Ingress send time out in seconds.
	SendTimeoutInSeconds *int32 `json:"sendTimeoutInSeconds,omitempty"`

	// Type of the affinity, set this to Cookie to enable session affinity.
	SessionAffinity *SessionAffinity `json:"sessionAffinity,omitempty"`

	// Time in seconds until the cookie expires.
	SessionCookieMaxAge *int32 `json:"sessionCookieMaxAge,omitempty"`
}

// IngressSettingsClientAuth - Client-Certification Authentication.
type IngressSettingsClientAuth struct {
	// Collection of certificate resource id.
	Certificates []*string `json:"certificates,omitempty"`
}

// JarUploadedUserSourceInfo - Uploaded Jar binary for a deployment
type JarUploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string `json:"type,omitempty"`

	// JVM parameter
	JvmOptions *string `json:"jvmOptions,omitempty"`

	// Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`

	// Runtime version of the Jar file
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`

	// Version of the source
	Version *string `json:"version,omitempty"`
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type JarUploadedUserSourceInfo.
func (j *JarUploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo {
	return &UploadedUserSourceInfo{
		RelativePath: j.RelativePath,
		Type:         j.Type,
		Version:      j.Version,
	}
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type JarUploadedUserSourceInfo.
func (j *JarUploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    j.Type,
		Version: j.Version,
	}
}

// KeyVaultCertificateProperties - Properties of certificate imported from key vault.
type KeyVaultCertificateProperties struct {
	// REQUIRED; The certificate name of key vault.
	KeyVaultCertName *string `json:"keyVaultCertName,omitempty"`

	// REQUIRED; The type of the certificate source.
	Type *string `json:"type,omitempty"`

	// REQUIRED; The vault uri of user key vault.
	VaultURI *string `json:"vaultUri,omitempty"`

	// The certificate version of key vault.
	CertVersion *string `json:"certVersion,omitempty"`

	// Optional. If set to true, it will not import private key from key vault.
	ExcludePrivateKey *bool `json:"excludePrivateKey,omitempty"`

	// READ-ONLY; The activate date of certificate.
	ActivateDate *string `json:"activateDate,omitempty" azure:"ro"`

	// READ-ONLY; The domain list of certificate.
	DNSNames []*string `json:"dnsNames,omitempty" azure:"ro"`

	// READ-ONLY; The expiration date of certificate.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The issue date of certificate.
	IssuedDate *string `json:"issuedDate,omitempty" azure:"ro"`

	// READ-ONLY; The issuer of certificate.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Certificate
	ProvisioningState *CertificateResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The subject name of certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; The thumbprint of certificate.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// GetCertificateProperties implements the CertificatePropertiesClassification interface for type KeyVaultCertificateProperties.
func (k *KeyVaultCertificateProperties) GetCertificateProperties() *CertificateProperties {
	return &CertificateProperties{
		Type:              k.Type,
		Thumbprint:        k.Thumbprint,
		Issuer:            k.Issuer,
		IssuedDate:        k.IssuedDate,
		ExpirationDate:    k.ExpirationDate,
		ActivateDate:      k.ActivateDate,
		SubjectName:       k.SubjectName,
		DNSNames:          k.DNSNames,
		ProvisioningState: k.ProvisioningState,
	}
}

// LoadedCertificate - Loaded certificate payload
type LoadedCertificate struct {
	// REQUIRED; Resource Id of loaded certificate
	ResourceID *string `json:"resourceId,omitempty"`

	// Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
	LoadTrustStore *bool `json:"loadTrustStore,omitempty"`
}

// LogFileURLResponse - Log file URL payload
type LogFileURLResponse struct {
	// REQUIRED; URL of the log file
	URL *string `json:"url,omitempty"`
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the log
	Name *string `json:"name,omitempty"`
}

// ManagedIdentityProperties - Managed identity properties retrieved from ARM request headers.
type ManagedIdentityProperties struct {
	// Principal Id of system-assigned managed identity.
	PrincipalID *string `json:"principalId,omitempty"`

	// Tenant Id of system-assigned managed identity.
	TenantID *string `json:"tenantId,omitempty"`

	// Type of the managed identity
	Type *ManagedIdentityType `json:"type,omitempty"`

	// Properties of user-assigned managed identities
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity `json:"userAssignedIdentities,omitempty"`
}

// MarketplaceResource - Purchasing 3rd Party product for one Azure Spring Apps instance
type MarketplaceResource struct {
	// The plan id of the 3rd Party Artifact that is being procured.
	Plan *string `json:"plan,omitempty"`

	// The 3rd Party artifact that is being procured.
	Product *string `json:"product,omitempty"`

	// The publisher id of the 3rd Party Artifact that is being bought.
	Publisher *string `json:"publisher,omitempty"`
}

// MetricDimension - Specifications of the Dimension of metrics
type MetricDimension struct {
	// Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the dimension
	Name *string `json:"name,omitempty"`

	// Whether this dimension should be included for the Shoebox export scenario
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`

	// Dimensions of the metric
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`

	// Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of the metric
	Name *string `json:"name,omitempty"`

	// Name of the MDM namespace. Optional.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// Supported aggregation types
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// Supported time grain types
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
}

// MonitoringSettingProperties - Monitoring Setting properties payload
type MonitoringSettingProperties struct {
	// Indicates the versions of application insight agent
	AppInsightsAgentVersions *ApplicationInsightsAgentVersions `json:"appInsightsAgentVersions,omitempty"`

	// Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
	AppInsightsInstrumentationKey *string `json:"appInsightsInstrumentationKey,omitempty"`

	// Indicates the sampling rate of application insight agent, should be in range [0.0, 100.0]
	AppInsightsSamplingRate *float64 `json:"appInsightsSamplingRate,omitempty"`

	// Error when apply Monitoring Setting changes.
	Error *Error `json:"error,omitempty"`

	// Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please
	// leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled
	// or not
	TraceEnabled *bool `json:"traceEnabled,omitempty"`

	// READ-ONLY; State of the Monitoring Setting.
	ProvisioningState *MonitoringSettingState `json:"provisioningState,omitempty" azure:"ro"`
}

// MonitoringSettingResource - Monitoring Setting resource
type MonitoringSettingResource struct {
	// Properties of the Monitoring Setting resource
	Properties *MonitoringSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MonitoringSettingsClientBeginUpdatePatchOptions contains the optional parameters for the MonitoringSettingsClient.BeginUpdatePatch
// method.
type MonitoringSettingsClientBeginUpdatePatchOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitoringSettingsClientBeginUpdatePutOptions contains the optional parameters for the MonitoringSettingsClient.BeginUpdatePut
// method.
type MonitoringSettingsClientBeginUpdatePutOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitoringSettingsClientGetOptions contains the optional parameters for the MonitoringSettingsClient.Get method.
type MonitoringSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// NameAvailability - Name availability result payload
type NameAvailability struct {
	// Message why the name is not available
	Message *string `json:"message,omitempty"`

	// Indicates whether the name is available
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Reason why the name is not available
	Reason *string `json:"reason,omitempty"`
}

// NameAvailabilityParameters - Name availability parameters payload
type NameAvailabilityParameters struct {
	// REQUIRED; Name to be checked
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of the resource to check name availability
	Type *string `json:"type,omitempty"`
}

// NetCoreZipUploadedUserSourceInfo - Uploaded Jar binary for a deployment
type NetCoreZipUploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string `json:"type,omitempty"`

	// The path to the .NET executable relative to zip root
	NetCoreMainEntryPath *string `json:"netCoreMainEntryPath,omitempty"`

	// Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`

	// Runtime version of the .Net file
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`

	// Version of the source
	Version *string `json:"version,omitempty"`
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type NetCoreZipUploadedUserSourceInfo.
func (n *NetCoreZipUploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo {
	return &UploadedUserSourceInfo{
		RelativePath: n.RelativePath,
		Type:         n.Type,
		Version:      n.Version,
	}
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type NetCoreZipUploadedUserSourceInfo.
func (n *NetCoreZipUploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    n.Type,
		Version: n.Version,
	}
}

// NetworkProfile - Service network profile payload
type NetworkProfile struct {
	// Name of the resource group containing network resources for customer apps in Azure Spring Apps
	AppNetworkResourceGroup *string `json:"appNetworkResourceGroup,omitempty"`

	// Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
	AppSubnetID *string `json:"appSubnetId,omitempty"`

	// Ingress configuration payload for Azure Spring Apps resource.
	IngressConfig *IngressConfig `json:"ingressConfig,omitempty"`

	// The egress traffic type of Azure Spring Apps VNet instances.
	OutboundType *string `json:"outboundType,omitempty"`

	// Azure Spring Apps service reserved CIDR
	ServiceCidr *string `json:"serviceCidr,omitempty"`

	// Name of the resource group containing network resources of Azure Spring Apps Service Runtime
	ServiceRuntimeNetworkResourceGroup *string `json:"serviceRuntimeNetworkResourceGroup,omitempty"`

	// Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
	ServiceRuntimeSubnetID *string `json:"serviceRuntimeSubnetId,omitempty"`

	// READ-ONLY; Desired outbound IP resources for Azure Spring Apps resource.
	OutboundIPs *NetworkProfileOutboundIPs `json:"outboundIPs,omitempty" azure:"ro"`

	// READ-ONLY; Required inbound or outbound traffics for Azure Spring Apps resource.
	RequiredTraffics []*RequiredTraffic `json:"requiredTraffics,omitempty" azure:"ro"`
}

// NetworkProfileOutboundIPs - Desired outbound IP resources for Azure Spring Apps resource.
type NetworkProfileOutboundIPs struct {
	// READ-ONLY; A list of public IP addresses.
	PublicIPs []*string `json:"publicIPs,omitempty" azure:"ro"`
}

// OperationDetail - Operation detail payload
type OperationDetail struct {
	// Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation
	Name *string `json:"name,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string `json:"description,omitempty"`

	// Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`

	// Resource provider of the operation
	Provider *string `json:"provider,omitempty"`

	// Resource of the operation
	Resource *string `json:"resource,omitempty"`
}

// OperationProperties - Extra Operation properties
type OperationProperties struct {
	// Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PersistentDisk - Persistent disk payload
type PersistentDisk struct {
	// Mount path of the persistent disk
	MountPath *string `json:"mountPath,omitempty"`

	// Size of the persistent disk in GB
	SizeInGB *int32 `json:"sizeInGB,omitempty"`

	// READ-ONLY; Size of the used persistent disk in GB
	UsedInGB *int32 `json:"usedInGB,omitempty" azure:"ro"`
}

// PredefinedAcceleratorProperties - Predefined accelerator properties payload
type PredefinedAcceleratorProperties struct {
	// State of the predefined accelerator.
	State *PredefinedAcceleratorState `json:"state,omitempty"`

	// READ-ONLY
	AcceleratorTags []*string `json:"acceleratorTags,omitempty" azure:"ro"`

	// READ-ONLY
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY
	IconURL *string `json:"iconUrl,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the predefined accelerator.
	ProvisioningState *PredefinedAcceleratorProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PredefinedAcceleratorResource - Predefined accelerator resource
type PredefinedAcceleratorResource struct {
	// Predefined accelerator properties payload
	Properties *PredefinedAcceleratorProperties `json:"properties,omitempty"`

	// Sku of the predefined accelerator resource
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type PredefinedAcceleratorResourceCollection struct {
	NextLink *string                          `json:"nextLink,omitempty"`
	Value    []*PredefinedAcceleratorResource `json:"value,omitempty"`
}

// PredefinedAcceleratorsClientBeginDisableOptions contains the optional parameters for the PredefinedAcceleratorsClient.BeginDisable
// method.
type PredefinedAcceleratorsClientBeginDisableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PredefinedAcceleratorsClientBeginEnableOptions contains the optional parameters for the PredefinedAcceleratorsClient.BeginEnable
// method.
type PredefinedAcceleratorsClientBeginEnableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PredefinedAcceleratorsClientGetOptions contains the optional parameters for the PredefinedAcceleratorsClient.Get method.
type PredefinedAcceleratorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PredefinedAcceleratorsClientListOptions contains the optional parameters for the PredefinedAcceleratorsClient.List method.
type PredefinedAcceleratorsClientListOptions struct {
	// placeholder for future optional parameters
}

// Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to receive
// traffic.
type Probe struct {
	// REQUIRED; Indicate whether the probe is disabled.
	DisableProbe *bool `json:"disableProbe,omitempty"`

	// Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
	FailureThreshold *int32 `json:"failureThreshold,omitempty"`

	// Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	InitialDelaySeconds *int32 `json:"initialDelaySeconds,omitempty"`

	// How often (in seconds) to perform the probe. Minimum value is 1.
	PeriodSeconds *int32 `json:"periodSeconds,omitempty"`

	// The action of the probe.
	ProbeAction ProbeActionClassification `json:"probeAction,omitempty"`

	// Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and
	// startup. Minimum value is 1.
	SuccessThreshold *int32 `json:"successThreshold,omitempty"`

	// Number of seconds after which the probe times out. Minimum value is 1.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
}

// ProbeActionClassification provides polymorphic access to related types.
// Call the interface's GetProbeAction() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExecAction, *HTTPGetAction, *ProbeAction, *TCPSocketAction
type ProbeActionClassification interface {
	// GetProbeAction returns the ProbeAction content of the underlying type.
	GetProbeAction() *ProbeAction
}

// ProbeAction - The action of the probe.
type ProbeAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType `json:"type,omitempty"`
}

// GetProbeAction implements the ProbeActionClassification interface for type ProbeAction.
func (p *ProbeAction) GetProbeAction() *ProbeAction { return p }

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags.
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegenerateTestKeyRequestPayload - Regenerate test key request payload
type RegenerateTestKeyRequestPayload struct {
	// REQUIRED; Type of the test key
	KeyType *TestKeyType `json:"keyType,omitempty"`
}

// RemoteDebugging - Remote debugging config.
type RemoteDebugging struct {
	// Indicate if remote debugging is enabled
	Enabled *bool `json:"enabled,omitempty"`

	// Application debugging port
	Port *int32 `json:"port,omitempty"`
}

// RemoteDebuggingPayload - Remote debugging payload.
type RemoteDebuggingPayload struct {
	// Application debugging port.
	Port *int32 `json:"port,omitempty"`
}

// RequiredTraffic - Required inbound or outbound traffic for Azure Spring Apps resource.
type RequiredTraffic struct {
	// READ-ONLY; The direction of required traffic
	Direction *TrafficDirection `json:"direction,omitempty" azure:"ro"`

	// READ-ONLY; The FQDN list of required traffic
	Fqdns []*string `json:"fqdns,omitempty" azure:"ro"`

	// READ-ONLY; The ip list of required traffic
	IPs []*string `json:"ips,omitempty" azure:"ro"`

	// READ-ONLY; The port of required traffic
	Port *int32 `json:"port,omitempty" azure:"ro"`

	// READ-ONLY; The protocol of required traffic
	Protocol *string `json:"protocol,omitempty" azure:"ro"`
}

// Resource - The core properties of ARM resources.
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceRequests - Deployment resource request payload
type ResourceRequests struct {
	// Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4}
	// for Standard tier.
	CPU *string `json:"cpu,omitempty"`

	// Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi,
	// 1Gi, 2Gi, …, 8Gi} for Standard tier.
	Memory *string `json:"memory,omitempty"`
}

// ResourceSKU - Describes an available Azure Spring Apps SKU.
type ResourceSKU struct {
	// Gets the capacity of SKU.
	Capacity *SKUCapacity `json:"capacity,omitempty"`

	// Gets a list of locations and availability zones in those locations where the SKU is available.
	LocationInfo []*ResourceSKULocationInfo `json:"locationInfo,omitempty"`

	// Gets the set of locations that the SKU is available.
	Locations []*string `json:"locations,omitempty"`

	// Gets the name of SKU.
	Name *string `json:"name,omitempty"`

	// Gets the type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`

	// Gets the restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*ResourceSKURestrictions `json:"restrictions,omitempty"`

	// Gets the tier of SKU.
	Tier *string `json:"tier,omitempty"`
}

type ResourceSKUCapabilities struct {
	// Gets an invariant to describe the feature.
	Name *string `json:"name,omitempty"`

	// Gets an invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// ResourceSKUCollection - Object that includes an array of Azure Spring Apps SKU and a possible link for next set
type ResourceSKUCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of resource SKU
	Value []*ResourceSKU `json:"value,omitempty"`
}

// ResourceSKULocationInfo - Locations and availability zones where the SKU is available
type ResourceSKULocationInfo struct {
	// Gets location of the SKU
	Location *string `json:"location,omitempty"`

	// Gets details of capabilities available to a SKU in specific zones.
	ZoneDetails []*ResourceSKUZoneDetails `json:"zoneDetails,omitempty"`

	// Gets list of availability zones where the SKU is supported.
	Zones []*string `json:"zones,omitempty"`
}

// ResourceSKURestrictionInfo - Information about the restriction where the SKU cannot be used
type ResourceSKURestrictionInfo struct {
	// Gets locations where the SKU is restricted
	Locations []*string `json:"locations,omitempty"`

	// Gets list of availability zones where the SKU is restricted.
	Zones []*string `json:"zones,omitempty"`
}

// ResourceSKURestrictions - Restrictions where the SKU cannot be used
type ResourceSKURestrictions struct {
	// Gets the reason for restriction. Possible values include: 'QuotaId', 'NotAvailableForSubscription'
	ReasonCode *ResourceSKURestrictionsReasonCode `json:"reasonCode,omitempty"`

	// Gets the information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSKURestrictionInfo `json:"restrictionInfo,omitempty"`

	// Gets the type of restrictions. Possible values include: 'Location', 'Zone'
	Type *ResourceSKURestrictionsType `json:"type,omitempty"`

	// Gets the value of restrictions. If the restriction type is set to location. This would be different locations where the
	// SKU is restricted.
	Values []*string `json:"values,omitempty"`
}

// ResourceSKUZoneDetails - Details of capabilities available to a SKU in specific zones
type ResourceSKUZoneDetails struct {
	// Gets a list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities []*ResourceSKUCapabilities `json:"capabilities,omitempty"`

	// Gets the set of zones that the SKU is available in with the specified capabilities.
	Name []*string `json:"name,omitempty"`
}

// ResourceUploadDefinition - Resource upload definition payload
type ResourceUploadDefinition struct {
	// Source relative path
	RelativePath *string `json:"relativePath,omitempty"`

	// Upload URL
	UploadURL *string `json:"uploadUrl,omitempty"`
}

// RuntimeVersionsClientListRuntimeVersionsOptions contains the optional parameters for the RuntimeVersionsClient.ListRuntimeVersions
// method.
type RuntimeVersionsClientListRuntimeVersionsOptions struct {
	// placeholder for future optional parameters
}

// SKU - Sku of Azure Spring Apps
type SKU struct {
	// Current capacity of the target resource
	Capacity *int32 `json:"capacity,omitempty"`

	// Name of the Sku
	Name *string `json:"name,omitempty"`

	// Tier of the Sku
	Tier *string `json:"tier,omitempty"`
}

// SKUCapacity - The SKU capacity
type SKUCapacity struct {
	// REQUIRED; Gets or sets the minimum.
	Minimum *int32 `json:"minimum,omitempty"`

	// Gets or sets the default.
	Default *int32 `json:"default,omitempty"`

	// Gets or sets the maximum.
	Maximum *int32 `json:"maximum,omitempty"`

	// Gets or sets the type of the scale.
	ScaleType *SKUScaleType `json:"scaleType,omitempty"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.List method.
type SKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceRegistriesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceRegistriesClient.BeginCreateOrUpdate
// method.
type ServiceRegistriesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceRegistriesClientBeginDeleteOptions contains the optional parameters for the ServiceRegistriesClient.BeginDelete
// method.
type ServiceRegistriesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceRegistriesClientGetOptions contains the optional parameters for the ServiceRegistriesClient.Get method.
type ServiceRegistriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceRegistriesClientListOptions contains the optional parameters for the ServiceRegistriesClient.List method.
type ServiceRegistriesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceRegistryInstance - Collection of instances belong to the Service Registry
type ServiceRegistryInstance struct {
	// READ-ONLY; Name of the Service Registry instance
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Service Registry instance
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ServiceRegistryProperties - Service Registry properties payload
type ServiceRegistryProperties struct {
	// READ-ONLY; Collection of instances belong to Service Registry.
	Instances []*ServiceRegistryInstance `json:"instances,omitempty" azure:"ro"`

	// READ-ONLY; State of the Service Registry.
	ProvisioningState *ServiceRegistryProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *ServiceRegistryResourceRequests `json:"resourceRequests,omitempty" azure:"ro"`
}

// ServiceRegistryResource - Service Registry resource
type ServiceRegistryResource struct {
	// Service Registry properties payload
	Properties *ServiceRegistryProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceRegistryResourceCollection - Object that includes an array of Service Registry resources and a possible link for
// next set
type ServiceRegistryResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Service Registry resources
	Value []*ServiceRegistryResource `json:"value,omitempty"`
}

// ServiceRegistryResourceRequests - Resource request payload of Service Registry
type ServiceRegistryResourceRequests struct {
	// READ-ONLY; Cpu allocated to each Service Registry instance
	CPU *string `json:"cpu,omitempty" azure:"ro"`

	// READ-ONLY; Instance count of the Service Registry
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Memory allocated to each Service Registry instance
	Memory *string `json:"memory,omitempty" azure:"ro"`
}

// ServiceResource - Service resource
type ServiceResource struct {
	// The GEO location of the resource.
	Location *string `json:"location,omitempty"`

	// Properties of the Service resource
	Properties *ClusterResourceProperties `json:"properties,omitempty"`

	// Sku of the Service resource
	SKU *SKU `json:"sku,omitempty"`

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceResourceList - Object that includes an array of Service resources and a possible link for next set
type ServiceResourceList struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of Service resources
	Value []*ServiceResource `json:"value,omitempty"`
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Specifications of the Metrics for Azure Monitoring
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// ServiceVNetAddons - Additional Service settings in vnet injection instance
type ServiceVNetAddons struct {
	// Indicates whether the log stream in vnet injection instance could be accessed from internet.
	LogStreamPublicEndpoint *bool `json:"logStreamPublicEndpoint,omitempty"`
}

// ServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServicesClient.BeginCreateOrUpdate method.
type ServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginDeleteOptions contains the optional parameters for the ServicesClient.BeginDelete method.
type ServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginStartOptions contains the optional parameters for the ServicesClient.BeginStart method.
type ServicesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginStopOptions contains the optional parameters for the ServicesClient.BeginStop method.
type ServicesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginUpdateOptions contains the optional parameters for the ServicesClient.BeginUpdate method.
type ServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientCheckNameAvailabilityOptions contains the optional parameters for the ServicesClient.CheckNameAvailability
// method.
type ServicesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientDisableTestEndpointOptions contains the optional parameters for the ServicesClient.DisableTestEndpoint method.
type ServicesClientDisableTestEndpointOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientEnableTestEndpointOptions contains the optional parameters for the ServicesClient.EnableTestEndpoint method.
type ServicesClientEnableTestEndpointOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListBySubscriptionOptions contains the optional parameters for the ServicesClient.ListBySubscription method.
type ServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListOptions contains the optional parameters for the ServicesClient.List method.
type ServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListTestKeysOptions contains the optional parameters for the ServicesClient.ListTestKeys method.
type ServicesClientListTestKeysOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientRegenerateTestKeyOptions contains the optional parameters for the ServicesClient.RegenerateTestKey method.
type ServicesClientRegenerateTestKeyOptions struct {
	// placeholder for future optional parameters
}

// SourceUploadedUserSourceInfo - Uploaded Java source code binary for a deployment
type SourceUploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string `json:"type,omitempty"`

	// Selector for the artifact to be used for the deployment for multi-module projects. This should be the relative path to
	// the target module/project.
	ArtifactSelector *string `json:"artifactSelector,omitempty"`

	// Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`

	// Runtime version of the source file
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`

	// Version of the source
	Version *string `json:"version,omitempty"`
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type SourceUploadedUserSourceInfo.
func (s *SourceUploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo {
	return &UploadedUserSourceInfo{
		RelativePath: s.RelativePath,
		Type:         s.Type,
		Version:      s.Version,
	}
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type SourceUploadedUserSourceInfo.
func (s *SourceUploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    s.Type,
		Version: s.Version,
	}
}

// SsoProperties - Single sign-on related configuration
type SsoProperties struct {
	// The public identifier for the application
	ClientID *string `json:"clientId,omitempty"`

	// The secret known only to the application and the authorization server
	ClientSecret *string `json:"clientSecret,omitempty"`

	// The URI of Issuer Identifier
	IssuerURI *string `json:"issuerUri,omitempty"`

	// It defines the specific actions applications can be allowed to do on a user's behalf
	Scope []*string `json:"scope,omitempty"`
}

// StackProperties - KPack ClusterStack properties payload
type StackProperties struct {
	// Id of the ClusterStack.
	ID *string `json:"id,omitempty"`

	// Version of the ClusterStack
	Version *string `json:"version,omitempty"`
}

// StorageAccount - storage resource of type Azure Storage Account.
type StorageAccount struct {
	// REQUIRED; The account key of the Azure Storage Account.
	AccountKey *string `json:"accountKey,omitempty"`

	// REQUIRED; The account name of the Azure Storage Account.
	AccountName *string `json:"accountName,omitempty"`

	// REQUIRED; The type of the storage.
	StorageType *StorageType `json:"storageType,omitempty"`
}

// GetStorageProperties implements the StoragePropertiesClassification interface for type StorageAccount.
func (s *StorageAccount) GetStorageProperties() *StorageProperties {
	return &StorageProperties{
		StorageType: s.StorageType,
	}
}

// StoragePropertiesClassification provides polymorphic access to related types.
// Call the interface's GetStorageProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *StorageAccount, *StorageProperties
type StoragePropertiesClassification interface {
	// GetStorageProperties returns the StorageProperties content of the underlying type.
	GetStorageProperties() *StorageProperties
}

// StorageProperties - Storage resource payload.
type StorageProperties struct {
	// REQUIRED; The type of the storage.
	StorageType *StorageType `json:"storageType,omitempty"`
}

// GetStorageProperties implements the StoragePropertiesClassification interface for type StorageProperties.
func (s *StorageProperties) GetStorageProperties() *StorageProperties { return s }

// StorageResource - Storage resource payload.
type StorageResource struct {
	// Properties of the storage resource payload.
	Properties StoragePropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageResourceCollection - Collection compose of storage resources list and a possible link for next page.
type StorageResourceCollection struct {
	// The link to next page of storage list.
	NextLink *string `json:"nextLink,omitempty"`

	// The storage resources list.
	Value []*StorageResource `json:"value,omitempty"`
}

// StoragesClientBeginCreateOrUpdateOptions contains the optional parameters for the StoragesClient.BeginCreateOrUpdate method.
type StoragesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StoragesClientBeginDeleteOptions contains the optional parameters for the StoragesClient.BeginDelete method.
type StoragesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StoragesClientGetOptions contains the optional parameters for the StoragesClient.Get method.
type StoragesClientGetOptions struct {
	// placeholder for future optional parameters
}

// StoragesClientListOptions contains the optional parameters for the StoragesClient.List method.
type StoragesClientListOptions struct {
	// placeholder for future optional parameters
}

// SupportedBuildpackResource - Supported buildpack resource payload
type SupportedBuildpackResource struct {
	// Supported buildpack resource properties
	Properties *SupportedBuildpackResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SupportedBuildpackResourceProperties - Supported buildpack resource properties
type SupportedBuildpackResourceProperties struct {
	// The id of supported buildpack
	BuildpackID *string `json:"buildpackId,omitempty"`
}

// SupportedBuildpacksCollection - Object that includes an array of supported buildpacks resources and a possible link for
// next set
type SupportedBuildpacksCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of supported buildpacks resources
	Value []*SupportedBuildpackResource `json:"value,omitempty"`
}

// SupportedRuntimeVersion - Supported deployment runtime version descriptor.
type SupportedRuntimeVersion struct {
	// The platform of this runtime version (possible values: "Java" or ".NET").
	Platform *SupportedRuntimePlatform `json:"platform,omitempty"`

	// The raw value which could be passed to deployment CRUD operations.
	Value *SupportedRuntimeValue `json:"value,omitempty"`

	// The detailed version (major.minor) of the platform.
	Version *string `json:"version,omitempty"`
}

// SupportedStackResource - Supported stack resource payload
type SupportedStackResource struct {
	// Supported stack resource properties
	Properties *SupportedStackResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SupportedStackResourceProperties - Supported stack resource properties
type SupportedStackResourceProperties struct {
	// The id of supported stack
	StackID *string `json:"stackId,omitempty"`

	// The version of supported stack
	Version *string `json:"version,omitempty"`
}

// SupportedStacksCollection - Object that includes an array of supported stacks resources and a possible link for next set
type SupportedStacksCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of supported stacks resources
	Value []*SupportedStackResource `json:"value,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource modification (UTC).
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *LastModifiedByType `json:"lastModifiedByType,omitempty"`
}

// TCPSocketAction describes an action based on opening a socket
type TCPSocketAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType `json:"type,omitempty"`
}

// GetProbeAction implements the ProbeActionClassification interface for type TCPSocketAction.
func (t *TCPSocketAction) GetProbeAction() *ProbeAction {
	return &ProbeAction{
		Type: t.Type,
	}
}

// TemporaryDisk - Temporary disk payload
type TemporaryDisk struct {
	// Mount path of the temporary disk
	MountPath *string `json:"mountPath,omitempty"`

	// Size of the temporary disk in GB
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
}

// TestKeys - Test keys payload
type TestKeys struct {
	// Indicates whether the test endpoint feature enabled or not
	Enabled *bool `json:"enabled,omitempty"`

	// Primary key
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Primary test endpoint
	PrimaryTestEndpoint *string `json:"primaryTestEndpoint,omitempty"`

	// Secondary key
	SecondaryKey *string `json:"secondaryKey,omitempty"`

	// Secondary test endpoint
	SecondaryTestEndpoint *string `json:"secondaryTestEndpoint,omitempty"`
}

// TrackedResource - The resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// The GEO location of the resource.
	Location *string `json:"location,omitempty"`

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggeredBuildResult - The build result triggered by a build
type TriggeredBuildResult struct {
	// The unique build id of this build result
	ID *string `json:"id,omitempty"`
}

// UploadedUserSourceInfoClassification provides polymorphic access to related types.
// Call the interface's GetUploadedUserSourceInfo() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *JarUploadedUserSourceInfo, *NetCoreZipUploadedUserSourceInfo, *SourceUploadedUserSourceInfo, *UploadedUserSourceInfo
type UploadedUserSourceInfoClassification interface {
	UserSourceInfoClassification
	// GetUploadedUserSourceInfo returns the UploadedUserSourceInfo content of the underlying type.
	GetUploadedUserSourceInfo() *UploadedUserSourceInfo
}

// UploadedUserSourceInfo - Source with uploaded location
type UploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string `json:"type,omitempty"`

	// Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`

	// Version of the source
	Version *string `json:"version,omitempty"`
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type UploadedUserSourceInfo.
func (u *UploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo { return u }

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type UploadedUserSourceInfo.
func (u *UploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    u.Type,
		Version: u.Version,
	}
}

// UserAssignedManagedIdentity - The details of the user-assigned managed identity assigned to an App.
type UserAssignedManagedIdentity struct {
	// READ-ONLY; Client Id of user-assigned managed identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Principal Id of user-assigned managed identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// UserSourceInfoClassification provides polymorphic access to related types.
// Call the interface's GetUserSourceInfo() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BuildResultUserSourceInfo, *CustomContainerUserSourceInfo, *JarUploadedUserSourceInfo, *NetCoreZipUploadedUserSourceInfo,
// - *SourceUploadedUserSourceInfo, *UploadedUserSourceInfo, *UserSourceInfo
type UserSourceInfoClassification interface {
	// GetUserSourceInfo returns the UserSourceInfo content of the underlying type.
	GetUserSourceInfo() *UserSourceInfo
}

// UserSourceInfo - Source information for a deployment
type UserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string `json:"type,omitempty"`

	// Version of the source
	Version *string `json:"version,omitempty"`
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type UserSourceInfo.
func (u *UserSourceInfo) GetUserSourceInfo() *UserSourceInfo { return u }

// ValidationMessages - Validate messages of the configuration service git repositories
type ValidationMessages struct {
	// Detailed validation messages.
	Messages []*string `json:"messages,omitempty"`

	// The name of the configuration service git repository.
	Name *string `json:"name,omitempty"`
}
