// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devopsguru

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddNotificationChannel = "AddNotificationChannel"

// AddNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the AddNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddNotificationChannel for more information on using the AddNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddNotificationChannelRequest method.
//	req, resp := client.AddNotificationChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel
func (c *DevOpsGuru) AddNotificationChannelRequest(input *AddNotificationChannelInput) (req *request.Request, output *AddNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opAddNotificationChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &AddNotificationChannelInput{}
	}

	output = &AddNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddNotificationChannel API operation for Amazon DevOps Guru.
//
// Adds a notification channel to DevOps Guru. A notification channel is used
// to notify you about important DevOps Guru events, such as when an insight
// is generated.
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. DevOps Guru only supports standard SNS topics. For more
// information, see Permissions for cross account Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. For more information, see Permissions for cross account
// Amazon SNS topics.
//
// If you use an Amazon SNS topic that is encrypted by an Amazon Web Services
// Key Management Service customer-managed key (CMK), then you must add permissions
// to the CMK. For more information, see Permissions for Amazon Web Services
// KMS–encrypted Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation AddNotificationChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - ConflictException
//     An exception that is thrown when a conflict occurs.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ServiceQuotaExceededException
//     The request contains a value that exceeds a maximum quota.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel
func (c *DevOpsGuru) AddNotificationChannel(input *AddNotificationChannelInput) (*AddNotificationChannelOutput, error) {
	req, out := c.AddNotificationChannelRequest(input)
	return out, req.Send()
}

// AddNotificationChannelWithContext is the same as AddNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See AddNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) AddNotificationChannelWithContext(ctx aws.Context, input *AddNotificationChannelInput, opts ...request.Option) (*AddNotificationChannelOutput, error) {
	req, out := c.AddNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInsight = "DeleteInsight"

// DeleteInsightRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInsight for more information on using the DeleteInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInsightRequest method.
//	req, resp := client.DeleteInsightRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DeleteInsight
func (c *DevOpsGuru) DeleteInsightRequest(input *DeleteInsightInput) (req *request.Request, output *DeleteInsightOutput) {
	op := &request.Operation{
		Name:       opDeleteInsight,
		HTTPMethod: "DELETE",
		HTTPPath:   "/insights/{Id}",
	}

	if input == nil {
		input = &DeleteInsightInput{}
	}

	output = &DeleteInsightOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInsight API operation for Amazon DevOps Guru.
//
// Deletes the insight along with the associated anomalies, events and recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DeleteInsight for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ConflictException
//     An exception that is thrown when a conflict occurs.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DeleteInsight
func (c *DevOpsGuru) DeleteInsight(input *DeleteInsightInput) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	return out, req.Send()
}

// DeleteInsightWithContext is the same as DeleteInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DeleteInsightWithContext(ctx aws.Context, input *DeleteInsightInput, opts ...request.Option) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountHealth = "DescribeAccountHealth"

// DescribeAccountHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountHealth for more information on using the DescribeAccountHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountHealthRequest method.
//	req, resp := client.DescribeAccountHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth
func (c *DevOpsGuru) DescribeAccountHealthRequest(input *DescribeAccountHealthInput) (req *request.Request, output *DescribeAccountHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/health",
	}

	if input == nil {
		input = &DescribeAccountHealthInput{}
	}

	output = &DescribeAccountHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountHealth API operation for Amazon DevOps Guru.
//
// Returns the number of open reactive insights, the number of open proactive
// insights, and the number of metrics analyzed in your Amazon Web Services
// account. Use these numbers to gauge the health of operations in your Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAccountHealth for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth
func (c *DevOpsGuru) DescribeAccountHealth(input *DescribeAccountHealthInput) (*DescribeAccountHealthOutput, error) {
	req, out := c.DescribeAccountHealthRequest(input)
	return out, req.Send()
}

// DescribeAccountHealthWithContext is the same as DescribeAccountHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAccountHealthWithContext(ctx aws.Context, input *DescribeAccountHealthInput, opts ...request.Option) (*DescribeAccountHealthOutput, error) {
	req, out := c.DescribeAccountHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountOverview = "DescribeAccountOverview"

// DescribeAccountOverviewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountOverview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountOverview for more information on using the DescribeAccountOverview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountOverviewRequest method.
//	req, resp := client.DescribeAccountOverviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview
func (c *DevOpsGuru) DescribeAccountOverviewRequest(input *DescribeAccountOverviewInput) (req *request.Request, output *DescribeAccountOverviewOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountOverview,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/overview",
	}

	if input == nil {
		input = &DescribeAccountOverviewInput{}
	}

	output = &DescribeAccountOverviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountOverview API operation for Amazon DevOps Guru.
//
// For the time range passed in, returns the number of open reactive insight
// that were created, the number of open proactive insights that were created,
// and the Mean Time to Recover (MTTR) for all closed reactive insights.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAccountOverview for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview
func (c *DevOpsGuru) DescribeAccountOverview(input *DescribeAccountOverviewInput) (*DescribeAccountOverviewOutput, error) {
	req, out := c.DescribeAccountOverviewRequest(input)
	return out, req.Send()
}

// DescribeAccountOverviewWithContext is the same as DescribeAccountOverview with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountOverview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAccountOverviewWithContext(ctx aws.Context, input *DescribeAccountOverviewInput, opts ...request.Option) (*DescribeAccountOverviewOutput, error) {
	req, out := c.DescribeAccountOverviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnomaly = "DescribeAnomaly"

// DescribeAnomalyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnomaly operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnomaly for more information on using the DescribeAnomaly
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnomalyRequest method.
//	req, resp := client.DescribeAnomalyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly
func (c *DevOpsGuru) DescribeAnomalyRequest(input *DescribeAnomalyInput) (req *request.Request, output *DescribeAnomalyOutput) {
	op := &request.Operation{
		Name:       opDescribeAnomaly,
		HTTPMethod: "GET",
		HTTPPath:   "/anomalies/{Id}",
	}

	if input == nil {
		input = &DescribeAnomalyInput{}
	}

	output = &DescribeAnomalyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnomaly API operation for Amazon DevOps Guru.
//
// Returns details about an anomaly that you specify using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAnomaly for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly
func (c *DevOpsGuru) DescribeAnomaly(input *DescribeAnomalyInput) (*DescribeAnomalyOutput, error) {
	req, out := c.DescribeAnomalyRequest(input)
	return out, req.Send()
}

// DescribeAnomalyWithContext is the same as DescribeAnomaly with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnomaly for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAnomalyWithContext(ctx aws.Context, input *DescribeAnomalyInput, opts ...request.Option) (*DescribeAnomalyOutput, error) {
	req, out := c.DescribeAnomalyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSourcesConfig = "DescribeEventSourcesConfig"

// DescribeEventSourcesConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSourcesConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSourcesConfig for more information on using the DescribeEventSourcesConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventSourcesConfigRequest method.
//	req, resp := client.DescribeEventSourcesConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeEventSourcesConfig
func (c *DevOpsGuru) DescribeEventSourcesConfigRequest(input *DescribeEventSourcesConfigInput) (req *request.Request, output *DescribeEventSourcesConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSourcesConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/event-sources",
	}

	if input == nil {
		input = &DescribeEventSourcesConfigInput{}
	}

	output = &DescribeEventSourcesConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSourcesConfig API operation for Amazon DevOps Guru.
//
// Returns the integration status of services that are integrated with DevOps
// Guru as Consumer via EventBridge. The one service that can be integrated
// with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive
// recommendations which can be stored and viewed in DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeEventSourcesConfig for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeEventSourcesConfig
func (c *DevOpsGuru) DescribeEventSourcesConfig(input *DescribeEventSourcesConfigInput) (*DescribeEventSourcesConfigOutput, error) {
	req, out := c.DescribeEventSourcesConfigRequest(input)
	return out, req.Send()
}

// DescribeEventSourcesConfigWithContext is the same as DescribeEventSourcesConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSourcesConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeEventSourcesConfigWithContext(ctx aws.Context, input *DescribeEventSourcesConfigInput, opts ...request.Option) (*DescribeEventSourcesConfigOutput, error) {
	req, out := c.DescribeEventSourcesConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFeedback = "DescribeFeedback"

// DescribeFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFeedback for more information on using the DescribeFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFeedbackRequest method.
//	req, resp := client.DescribeFeedbackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeFeedback
func (c *DevOpsGuru) DescribeFeedbackRequest(input *DescribeFeedbackInput) (req *request.Request, output *DescribeFeedbackOutput) {
	op := &request.Operation{
		Name:       opDescribeFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/feedback",
	}

	if input == nil {
		input = &DescribeFeedbackInput{}
	}

	output = &DescribeFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFeedback API operation for Amazon DevOps Guru.
//
// Returns the most recent feedback submitted in the current Amazon Web Services
// account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeFeedback for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeFeedback
func (c *DevOpsGuru) DescribeFeedback(input *DescribeFeedbackInput) (*DescribeFeedbackOutput, error) {
	req, out := c.DescribeFeedbackRequest(input)
	return out, req.Send()
}

// DescribeFeedbackWithContext is the same as DescribeFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeFeedbackWithContext(ctx aws.Context, input *DescribeFeedbackInput, opts ...request.Option) (*DescribeFeedbackOutput, error) {
	req, out := c.DescribeFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInsight = "DescribeInsight"

// DescribeInsightRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInsight for more information on using the DescribeInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInsightRequest method.
//	req, resp := client.DescribeInsightRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight
func (c *DevOpsGuru) DescribeInsightRequest(input *DescribeInsightInput) (req *request.Request, output *DescribeInsightOutput) {
	op := &request.Operation{
		Name:       opDescribeInsight,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/{Id}",
	}

	if input == nil {
		input = &DescribeInsightInput{}
	}

	output = &DescribeInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInsight API operation for Amazon DevOps Guru.
//
// Returns details about an insight that you specify using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeInsight for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight
func (c *DevOpsGuru) DescribeInsight(input *DescribeInsightInput) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	return out, req.Send()
}

// DescribeInsightWithContext is the same as DescribeInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeInsightWithContext(ctx aws.Context, input *DescribeInsightInput, opts ...request.Option) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationHealth = "DescribeOrganizationHealth"

// DescribeOrganizationHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationHealth for more information on using the DescribeOrganizationHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrganizationHealthRequest method.
//	req, resp := client.DescribeOrganizationHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationHealth
func (c *DevOpsGuru) DescribeOrganizationHealthRequest(input *DescribeOrganizationHealthInput) (req *request.Request, output *DescribeOrganizationHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/health",
	}

	if input == nil {
		input = &DescribeOrganizationHealthInput{}
	}

	output = &DescribeOrganizationHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationHealth API operation for Amazon DevOps Guru.
//
// Returns active insights, predictive insights, and resource hours analyzed
// in last hour.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeOrganizationHealth for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationHealth
func (c *DevOpsGuru) DescribeOrganizationHealth(input *DescribeOrganizationHealthInput) (*DescribeOrganizationHealthOutput, error) {
	req, out := c.DescribeOrganizationHealthRequest(input)
	return out, req.Send()
}

// DescribeOrganizationHealthWithContext is the same as DescribeOrganizationHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeOrganizationHealthWithContext(ctx aws.Context, input *DescribeOrganizationHealthInput, opts ...request.Option) (*DescribeOrganizationHealthOutput, error) {
	req, out := c.DescribeOrganizationHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationOverview = "DescribeOrganizationOverview"

// DescribeOrganizationOverviewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationOverview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationOverview for more information on using the DescribeOrganizationOverview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrganizationOverviewRequest method.
//	req, resp := client.DescribeOrganizationOverviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationOverview
func (c *DevOpsGuru) DescribeOrganizationOverviewRequest(input *DescribeOrganizationOverviewInput) (req *request.Request, output *DescribeOrganizationOverviewOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationOverview,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/overview",
	}

	if input == nil {
		input = &DescribeOrganizationOverviewInput{}
	}

	output = &DescribeOrganizationOverviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationOverview API operation for Amazon DevOps Guru.
//
// Returns an overview of your organization's history based on the specified
// time range. The overview includes the total reactive and proactive insights.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeOrganizationOverview for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationOverview
func (c *DevOpsGuru) DescribeOrganizationOverview(input *DescribeOrganizationOverviewInput) (*DescribeOrganizationOverviewOutput, error) {
	req, out := c.DescribeOrganizationOverviewRequest(input)
	return out, req.Send()
}

// DescribeOrganizationOverviewWithContext is the same as DescribeOrganizationOverview with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationOverview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeOrganizationOverviewWithContext(ctx aws.Context, input *DescribeOrganizationOverviewInput, opts ...request.Option) (*DescribeOrganizationOverviewOutput, error) {
	req, out := c.DescribeOrganizationOverviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationResourceCollectionHealth = "DescribeOrganizationResourceCollectionHealth"

// DescribeOrganizationResourceCollectionHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationResourceCollectionHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationResourceCollectionHealth for more information on using the DescribeOrganizationResourceCollectionHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrganizationResourceCollectionHealthRequest method.
//	req, resp := client.DescribeOrganizationResourceCollectionHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth
func (c *DevOpsGuru) DescribeOrganizationResourceCollectionHealthRequest(input *DescribeOrganizationResourceCollectionHealthInput) (req *request.Request, output *DescribeOrganizationResourceCollectionHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationResourceCollectionHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/health/resource-collection",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrganizationResourceCollectionHealthInput{}
	}

	output = &DescribeOrganizationResourceCollectionHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationResourceCollectionHealth API operation for Amazon DevOps Guru.
//
// Provides an overview of your system's health. If additional member accounts
// are part of your organization, you can filter those accounts using the AccountIds
// field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeOrganizationResourceCollectionHealth for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth
func (c *DevOpsGuru) DescribeOrganizationResourceCollectionHealth(input *DescribeOrganizationResourceCollectionHealthInput) (*DescribeOrganizationResourceCollectionHealthOutput, error) {
	req, out := c.DescribeOrganizationResourceCollectionHealthRequest(input)
	return out, req.Send()
}

// DescribeOrganizationResourceCollectionHealthWithContext is the same as DescribeOrganizationResourceCollectionHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationResourceCollectionHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeOrganizationResourceCollectionHealthWithContext(ctx aws.Context, input *DescribeOrganizationResourceCollectionHealthInput, opts ...request.Option) (*DescribeOrganizationResourceCollectionHealthOutput, error) {
	req, out := c.DescribeOrganizationResourceCollectionHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrganizationResourceCollectionHealthPages iterates over the pages of a DescribeOrganizationResourceCollectionHealth operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrganizationResourceCollectionHealth method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeOrganizationResourceCollectionHealth operation.
//	pageNum := 0
//	err := client.DescribeOrganizationResourceCollectionHealthPages(params,
//	    func(page *devopsguru.DescribeOrganizationResourceCollectionHealthOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) DescribeOrganizationResourceCollectionHealthPages(input *DescribeOrganizationResourceCollectionHealthInput, fn func(*DescribeOrganizationResourceCollectionHealthOutput, bool) bool) error {
	return c.DescribeOrganizationResourceCollectionHealthPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrganizationResourceCollectionHealthPagesWithContext same as DescribeOrganizationResourceCollectionHealthPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeOrganizationResourceCollectionHealthPagesWithContext(ctx aws.Context, input *DescribeOrganizationResourceCollectionHealthInput, fn func(*DescribeOrganizationResourceCollectionHealthOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrganizationResourceCollectionHealthInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrganizationResourceCollectionHealthRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrganizationResourceCollectionHealthOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeResourceCollectionHealth = "DescribeResourceCollectionHealth"

// DescribeResourceCollectionHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourceCollectionHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourceCollectionHealth for more information on using the DescribeResourceCollectionHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeResourceCollectionHealthRequest method.
//	req, resp := client.DescribeResourceCollectionHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth
func (c *DevOpsGuru) DescribeResourceCollectionHealthRequest(input *DescribeResourceCollectionHealthInput) (req *request.Request, output *DescribeResourceCollectionHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceCollectionHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/health/resource-collection/{ResourceCollectionType}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeResourceCollectionHealthInput{}
	}

	output = &DescribeResourceCollectionHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourceCollectionHealth API operation for Amazon DevOps Guru.
//
// Returns the number of open proactive insights, open reactive insights, and
// the Mean Time to Recover (MTTR) for all closed insights in resource collections
// in your account. You specify the type of Amazon Web Services resources collection.
// The two types of Amazon Web Services resource collections supported are Amazon
// Web Services CloudFormation stacks and Amazon Web Services resources that
// contain the same Amazon Web Services tag. DevOps Guru can be configured to
// analyze the Amazon Web Services resources that are defined in the stacks
// or that are tagged using the same tag key. You can specify up to 500 Amazon
// Web Services CloudFormation stacks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeResourceCollectionHealth for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth
func (c *DevOpsGuru) DescribeResourceCollectionHealth(input *DescribeResourceCollectionHealthInput) (*DescribeResourceCollectionHealthOutput, error) {
	req, out := c.DescribeResourceCollectionHealthRequest(input)
	return out, req.Send()
}

// DescribeResourceCollectionHealthWithContext is the same as DescribeResourceCollectionHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourceCollectionHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeResourceCollectionHealthWithContext(ctx aws.Context, input *DescribeResourceCollectionHealthInput, opts ...request.Option) (*DescribeResourceCollectionHealthOutput, error) {
	req, out := c.DescribeResourceCollectionHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeResourceCollectionHealthPages iterates over the pages of a DescribeResourceCollectionHealth operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeResourceCollectionHealth method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeResourceCollectionHealth operation.
//	pageNum := 0
//	err := client.DescribeResourceCollectionHealthPages(params,
//	    func(page *devopsguru.DescribeResourceCollectionHealthOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) DescribeResourceCollectionHealthPages(input *DescribeResourceCollectionHealthInput, fn func(*DescribeResourceCollectionHealthOutput, bool) bool) error {
	return c.DescribeResourceCollectionHealthPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeResourceCollectionHealthPagesWithContext same as DescribeResourceCollectionHealthPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeResourceCollectionHealthPagesWithContext(ctx aws.Context, input *DescribeResourceCollectionHealthInput, fn func(*DescribeResourceCollectionHealthOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeResourceCollectionHealthInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeResourceCollectionHealthRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeResourceCollectionHealthOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeServiceIntegration = "DescribeServiceIntegration"

// DescribeServiceIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServiceIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServiceIntegration for more information on using the DescribeServiceIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeServiceIntegrationRequest method.
//	req, resp := client.DescribeServiceIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration
func (c *DevOpsGuru) DescribeServiceIntegrationRequest(input *DescribeServiceIntegrationInput) (req *request.Request, output *DescribeServiceIntegrationOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/service-integrations",
	}

	if input == nil {
		input = &DescribeServiceIntegrationInput{}
	}

	output = &DescribeServiceIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServiceIntegration API operation for Amazon DevOps Guru.
//
// Returns the integration status of services that are integrated with DevOps
// Guru. The one service that can be integrated with DevOps Guru is Amazon Web
// Services Systems Manager, which can be used to create an OpsItem for each
// generated insight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeServiceIntegration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration
func (c *DevOpsGuru) DescribeServiceIntegration(input *DescribeServiceIntegrationInput) (*DescribeServiceIntegrationOutput, error) {
	req, out := c.DescribeServiceIntegrationRequest(input)
	return out, req.Send()
}

// DescribeServiceIntegrationWithContext is the same as DescribeServiceIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServiceIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeServiceIntegrationWithContext(ctx aws.Context, input *DescribeServiceIntegrationInput, opts ...request.Option) (*DescribeServiceIntegrationOutput, error) {
	req, out := c.DescribeServiceIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostEstimation = "GetCostEstimation"

// GetCostEstimationRequest generates a "aws/request.Request" representing the
// client's request for the GetCostEstimation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostEstimation for more information on using the GetCostEstimation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCostEstimationRequest method.
//	req, resp := client.GetCostEstimationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation
func (c *DevOpsGuru) GetCostEstimationRequest(input *GetCostEstimationInput) (req *request.Request, output *GetCostEstimationOutput) {
	op := &request.Operation{
		Name:       opGetCostEstimation,
		HTTPMethod: "GET",
		HTTPPath:   "/cost-estimation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCostEstimationInput{}
	}

	output = &GetCostEstimationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostEstimation API operation for Amazon DevOps Guru.
//
// Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon
// Web Services resources. For more information, see Estimate your Amazon DevOps
// Guru costs (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation GetCostEstimation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation
func (c *DevOpsGuru) GetCostEstimation(input *GetCostEstimationInput) (*GetCostEstimationOutput, error) {
	req, out := c.GetCostEstimationRequest(input)
	return out, req.Send()
}

// GetCostEstimationWithContext is the same as GetCostEstimation with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostEstimation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetCostEstimationWithContext(ctx aws.Context, input *GetCostEstimationInput, opts ...request.Option) (*GetCostEstimationOutput, error) {
	req, out := c.GetCostEstimationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCostEstimationPages iterates over the pages of a GetCostEstimation operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCostEstimation method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetCostEstimation operation.
//	pageNum := 0
//	err := client.GetCostEstimationPages(params,
//	    func(page *devopsguru.GetCostEstimationOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) GetCostEstimationPages(input *GetCostEstimationInput, fn func(*GetCostEstimationOutput, bool) bool) error {
	return c.GetCostEstimationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCostEstimationPagesWithContext same as GetCostEstimationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetCostEstimationPagesWithContext(ctx aws.Context, input *GetCostEstimationInput, fn func(*GetCostEstimationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCostEstimationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCostEstimationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCostEstimationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceCollection = "GetResourceCollection"

// GetResourceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceCollection for more information on using the GetResourceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceCollectionRequest method.
//	req, resp := client.GetResourceCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection
func (c *DevOpsGuru) GetResourceCollectionRequest(input *GetResourceCollectionInput) (req *request.Request, output *GetResourceCollectionOutput) {
	op := &request.Operation{
		Name:       opGetResourceCollection,
		HTTPMethod: "GET",
		HTTPPath:   "/resource-collections/{ResourceCollectionType}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceCollectionInput{}
	}

	output = &GetResourceCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceCollection API operation for Amazon DevOps Guru.
//
// Returns lists Amazon Web Services resources that are of the specified resource
// collection type. The two types of Amazon Web Services resource collections
// supported are Amazon Web Services CloudFormation stacks and Amazon Web Services
// resources that contain the same Amazon Web Services tag. DevOps Guru can
// be configured to analyze the Amazon Web Services resources that are defined
// in the stacks or that are tagged using the same tag key. You can specify
// up to 500 Amazon Web Services CloudFormation stacks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation GetResourceCollection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection
func (c *DevOpsGuru) GetResourceCollection(input *GetResourceCollectionInput) (*GetResourceCollectionOutput, error) {
	req, out := c.GetResourceCollectionRequest(input)
	return out, req.Send()
}

// GetResourceCollectionWithContext is the same as GetResourceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetResourceCollectionWithContext(ctx aws.Context, input *GetResourceCollectionInput, opts ...request.Option) (*GetResourceCollectionOutput, error) {
	req, out := c.GetResourceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceCollectionPages iterates over the pages of a GetResourceCollection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceCollection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourceCollection operation.
//	pageNum := 0
//	err := client.GetResourceCollectionPages(params,
//	    func(page *devopsguru.GetResourceCollectionOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) GetResourceCollectionPages(input *GetResourceCollectionInput, fn func(*GetResourceCollectionOutput, bool) bool) error {
	return c.GetResourceCollectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceCollectionPagesWithContext same as GetResourceCollectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetResourceCollectionPagesWithContext(ctx aws.Context, input *GetResourceCollectionInput, fn func(*GetResourceCollectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceCollectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceCollectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceCollectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomaliesForInsight = "ListAnomaliesForInsight"

// ListAnomaliesForInsightRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomaliesForInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomaliesForInsight for more information on using the ListAnomaliesForInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnomaliesForInsightRequest method.
//	req, resp := client.ListAnomaliesForInsightRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight
func (c *DevOpsGuru) ListAnomaliesForInsightRequest(input *ListAnomaliesForInsightInput) (req *request.Request, output *ListAnomaliesForInsightOutput) {
	op := &request.Operation{
		Name:       opListAnomaliesForInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/anomalies/insight/{InsightId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomaliesForInsightInput{}
	}

	output = &ListAnomaliesForInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomaliesForInsight API operation for Amazon DevOps Guru.
//
// Returns a list of the anomalies that belong to an insight that you specify
// using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListAnomaliesForInsight for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight
func (c *DevOpsGuru) ListAnomaliesForInsight(input *ListAnomaliesForInsightInput) (*ListAnomaliesForInsightOutput, error) {
	req, out := c.ListAnomaliesForInsightRequest(input)
	return out, req.Send()
}

// ListAnomaliesForInsightWithContext is the same as ListAnomaliesForInsight with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomaliesForInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomaliesForInsightWithContext(ctx aws.Context, input *ListAnomaliesForInsightInput, opts ...request.Option) (*ListAnomaliesForInsightOutput, error) {
	req, out := c.ListAnomaliesForInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomaliesForInsightPages iterates over the pages of a ListAnomaliesForInsight operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomaliesForInsight method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnomaliesForInsight operation.
//	pageNum := 0
//	err := client.ListAnomaliesForInsightPages(params,
//	    func(page *devopsguru.ListAnomaliesForInsightOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListAnomaliesForInsightPages(input *ListAnomaliesForInsightInput, fn func(*ListAnomaliesForInsightOutput, bool) bool) error {
	return c.ListAnomaliesForInsightPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomaliesForInsightPagesWithContext same as ListAnomaliesForInsightPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomaliesForInsightPagesWithContext(ctx aws.Context, input *ListAnomaliesForInsightInput, fn func(*ListAnomaliesForInsightOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomaliesForInsightInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomaliesForInsightRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomaliesForInsightOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomalousLogGroups = "ListAnomalousLogGroups"

// ListAnomalousLogGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomalousLogGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomalousLogGroups for more information on using the ListAnomalousLogGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnomalousLogGroupsRequest method.
//	req, resp := client.ListAnomalousLogGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups
func (c *DevOpsGuru) ListAnomalousLogGroupsRequest(input *ListAnomalousLogGroupsInput) (req *request.Request, output *ListAnomalousLogGroupsOutput) {
	op := &request.Operation{
		Name:       opListAnomalousLogGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/list-log-anomalies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomalousLogGroupsInput{}
	}

	output = &ListAnomalousLogGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomalousLogGroups API operation for Amazon DevOps Guru.
//
// Returns the list of log groups that contain log anomalies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListAnomalousLogGroups for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups
func (c *DevOpsGuru) ListAnomalousLogGroups(input *ListAnomalousLogGroupsInput) (*ListAnomalousLogGroupsOutput, error) {
	req, out := c.ListAnomalousLogGroupsRequest(input)
	return out, req.Send()
}

// ListAnomalousLogGroupsWithContext is the same as ListAnomalousLogGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomalousLogGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomalousLogGroupsWithContext(ctx aws.Context, input *ListAnomalousLogGroupsInput, opts ...request.Option) (*ListAnomalousLogGroupsOutput, error) {
	req, out := c.ListAnomalousLogGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomalousLogGroupsPages iterates over the pages of a ListAnomalousLogGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomalousLogGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnomalousLogGroups operation.
//	pageNum := 0
//	err := client.ListAnomalousLogGroupsPages(params,
//	    func(page *devopsguru.ListAnomalousLogGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListAnomalousLogGroupsPages(input *ListAnomalousLogGroupsInput, fn func(*ListAnomalousLogGroupsOutput, bool) bool) error {
	return c.ListAnomalousLogGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomalousLogGroupsPagesWithContext same as ListAnomalousLogGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomalousLogGroupsPagesWithContext(ctx aws.Context, input *ListAnomalousLogGroupsInput, fn func(*ListAnomalousLogGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomalousLogGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomalousLogGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomalousLogGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEvents = "ListEvents"

// ListEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEvents for more information on using the ListEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventsRequest method.
//	req, resp := client.ListEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents
func (c *DevOpsGuru) ListEventsRequest(input *ListEventsInput) (req *request.Request, output *ListEventsOutput) {
	op := &request.Operation{
		Name:       opListEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/events",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventsInput{}
	}

	output = &ListEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEvents API operation for Amazon DevOps Guru.
//
// Returns a list of the events emitted by the resources that are evaluated
// by DevOps Guru. You can use filters to specify which events are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListEvents for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents
func (c *DevOpsGuru) ListEvents(input *ListEventsInput) (*ListEventsOutput, error) {
	req, out := c.ListEventsRequest(input)
	return out, req.Send()
}

// ListEventsWithContext is the same as ListEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListEventsWithContext(ctx aws.Context, input *ListEventsInput, opts ...request.Option) (*ListEventsOutput, error) {
	req, out := c.ListEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventsPages iterates over the pages of a ListEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEvents operation.
//	pageNum := 0
//	err := client.ListEventsPages(params,
//	    func(page *devopsguru.ListEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListEventsPages(input *ListEventsInput, fn func(*ListEventsOutput, bool) bool) error {
	return c.ListEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventsPagesWithContext same as ListEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListEventsPagesWithContext(ctx aws.Context, input *ListEventsInput, fn func(*ListEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInsights = "ListInsights"

// ListInsightsRequest generates a "aws/request.Request" representing the
// client's request for the ListInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInsights for more information on using the ListInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInsightsRequest method.
//	req, resp := client.ListInsightsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights
func (c *DevOpsGuru) ListInsightsRequest(input *ListInsightsInput) (req *request.Request, output *ListInsightsOutput) {
	op := &request.Operation{
		Name:       opListInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInsightsInput{}
	}

	output = &ListInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInsights API operation for Amazon DevOps Guru.
//
// Returns a list of insights in your Amazon Web Services account. You can specify
// which insights are returned by their start time and status (ONGOING, CLOSED,
// or ANY).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListInsights for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights
func (c *DevOpsGuru) ListInsights(input *ListInsightsInput) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	return out, req.Send()
}

// ListInsightsWithContext is the same as ListInsights with the addition of
// the ability to pass a context and additional request options.
//
// See ListInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListInsightsWithContext(ctx aws.Context, input *ListInsightsInput, opts ...request.Option) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInsightsPages iterates over the pages of a ListInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInsights operation.
//	pageNum := 0
//	err := client.ListInsightsPages(params,
//	    func(page *devopsguru.ListInsightsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListInsightsPages(input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool) error {
	return c.ListInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInsightsPagesWithContext same as ListInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListInsightsPagesWithContext(ctx aws.Context, input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMonitoredResources = "ListMonitoredResources"

// ListMonitoredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitoredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitoredResources for more information on using the ListMonitoredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMonitoredResourcesRequest method.
//	req, resp := client.ListMonitoredResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources
func (c *DevOpsGuru) ListMonitoredResourcesRequest(input *ListMonitoredResourcesInput) (req *request.Request, output *ListMonitoredResourcesOutput) {
	op := &request.Operation{
		Name:       opListMonitoredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/monitoredResources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitoredResourcesInput{}
	}

	output = &ListMonitoredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMonitoredResources API operation for Amazon DevOps Guru.
//
// Returns the list of all log groups that are being monitored and tagged by
// DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListMonitoredResources for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources
func (c *DevOpsGuru) ListMonitoredResources(input *ListMonitoredResourcesInput) (*ListMonitoredResourcesOutput, error) {
	req, out := c.ListMonitoredResourcesRequest(input)
	return out, req.Send()
}

// ListMonitoredResourcesWithContext is the same as ListMonitoredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitoredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListMonitoredResourcesWithContext(ctx aws.Context, input *ListMonitoredResourcesInput, opts ...request.Option) (*ListMonitoredResourcesOutput, error) {
	req, out := c.ListMonitoredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitoredResourcesPages iterates over the pages of a ListMonitoredResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitoredResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMonitoredResources operation.
//	pageNum := 0
//	err := client.ListMonitoredResourcesPages(params,
//	    func(page *devopsguru.ListMonitoredResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListMonitoredResourcesPages(input *ListMonitoredResourcesInput, fn func(*ListMonitoredResourcesOutput, bool) bool) error {
	return c.ListMonitoredResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitoredResourcesPagesWithContext same as ListMonitoredResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListMonitoredResourcesPagesWithContext(ctx aws.Context, input *ListMonitoredResourcesInput, fn func(*ListMonitoredResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitoredResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitoredResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitoredResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotificationChannels = "ListNotificationChannels"

// ListNotificationChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotificationChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotificationChannels for more information on using the ListNotificationChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNotificationChannelsRequest method.
//	req, resp := client.ListNotificationChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels
func (c *DevOpsGuru) ListNotificationChannelsRequest(input *ListNotificationChannelsInput) (req *request.Request, output *ListNotificationChannelsOutput) {
	op := &request.Operation{
		Name:       opListNotificationChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationChannelsInput{}
	}

	output = &ListNotificationChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotificationChannels API operation for Amazon DevOps Guru.
//
// Returns a list of notification channels configured for DevOps Guru. Each
// notification channel is used to notify you when DevOps Guru generates an
// insight that contains information about how to improve your operations. The
// one supported notification channel is Amazon Simple Notification Service
// (Amazon SNS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListNotificationChannels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels
func (c *DevOpsGuru) ListNotificationChannels(input *ListNotificationChannelsInput) (*ListNotificationChannelsOutput, error) {
	req, out := c.ListNotificationChannelsRequest(input)
	return out, req.Send()
}

// ListNotificationChannelsWithContext is the same as ListNotificationChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotificationChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListNotificationChannelsWithContext(ctx aws.Context, input *ListNotificationChannelsInput, opts ...request.Option) (*ListNotificationChannelsOutput, error) {
	req, out := c.ListNotificationChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationChannelsPages iterates over the pages of a ListNotificationChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotificationChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNotificationChannels operation.
//	pageNum := 0
//	err := client.ListNotificationChannelsPages(params,
//	    func(page *devopsguru.ListNotificationChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListNotificationChannelsPages(input *ListNotificationChannelsInput, fn func(*ListNotificationChannelsOutput, bool) bool) error {
	return c.ListNotificationChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationChannelsPagesWithContext same as ListNotificationChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListNotificationChannelsPagesWithContext(ctx aws.Context, input *ListNotificationChannelsInput, fn func(*ListNotificationChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationInsights = "ListOrganizationInsights"

// ListOrganizationInsightsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationInsights for more information on using the ListOrganizationInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOrganizationInsightsRequest method.
//	req, resp := client.ListOrganizationInsightsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights
func (c *DevOpsGuru) ListOrganizationInsightsRequest(input *ListOrganizationInsightsInput) (req *request.Request, output *ListOrganizationInsightsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/insights",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationInsightsInput{}
	}

	output = &ListOrganizationInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationInsights API operation for Amazon DevOps Guru.
//
// Returns a list of insights associated with the account or OU Id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListOrganizationInsights for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights
func (c *DevOpsGuru) ListOrganizationInsights(input *ListOrganizationInsightsInput) (*ListOrganizationInsightsOutput, error) {
	req, out := c.ListOrganizationInsightsRequest(input)
	return out, req.Send()
}

// ListOrganizationInsightsWithContext is the same as ListOrganizationInsights with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListOrganizationInsightsWithContext(ctx aws.Context, input *ListOrganizationInsightsInput, opts ...request.Option) (*ListOrganizationInsightsOutput, error) {
	req, out := c.ListOrganizationInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationInsightsPages iterates over the pages of a ListOrganizationInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOrganizationInsights operation.
//	pageNum := 0
//	err := client.ListOrganizationInsightsPages(params,
//	    func(page *devopsguru.ListOrganizationInsightsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListOrganizationInsightsPages(input *ListOrganizationInsightsInput, fn func(*ListOrganizationInsightsOutput, bool) bool) error {
	return c.ListOrganizationInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationInsightsPagesWithContext same as ListOrganizationInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListOrganizationInsightsPagesWithContext(ctx aws.Context, input *ListOrganizationInsightsInput, fn func(*ListOrganizationInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendations = "ListRecommendations"

// ListRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendations for more information on using the ListRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendationsRequest method.
//	req, resp := client.ListRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations
func (c *DevOpsGuru) ListRecommendationsRequest(input *ListRecommendationsInput) (req *request.Request, output *ListRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationsInput{}
	}

	output = &ListRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendations API operation for Amazon DevOps Guru.
//
// Returns a list of a specified insight's recommendations. Each recommendation
// includes a list of related metrics and a list of related events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations
func (c *DevOpsGuru) ListRecommendations(input *ListRecommendationsInput) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	return out, req.Send()
}

// ListRecommendationsWithContext is the same as ListRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListRecommendationsWithContext(ctx aws.Context, input *ListRecommendationsInput, opts ...request.Option) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationsPages iterates over the pages of a ListRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendations operation.
//	pageNum := 0
//	err := client.ListRecommendationsPages(params,
//	    func(page *devopsguru.ListRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) ListRecommendationsPages(input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool) error {
	return c.ListRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationsPagesWithContext same as ListRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListRecommendationsPagesWithContext(ctx aws.Context, input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutFeedback = "PutFeedback"

// PutFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the PutFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFeedback for more information on using the PutFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutFeedbackRequest method.
//	req, resp := client.PutFeedbackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback
func (c *DevOpsGuru) PutFeedbackRequest(input *PutFeedbackInput) (req *request.Request, output *PutFeedbackOutput) {
	op := &request.Operation{
		Name:       opPutFeedback,
		HTTPMethod: "PUT",
		HTTPPath:   "/feedback",
	}

	if input == nil {
		input = &PutFeedbackInput{}
	}

	output = &PutFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutFeedback API operation for Amazon DevOps Guru.
//
// Collects customer feedback about the specified insight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation PutFeedback for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - ConflictException
//     An exception that is thrown when a conflict occurs.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback
func (c *DevOpsGuru) PutFeedback(input *PutFeedbackInput) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	return out, req.Send()
}

// PutFeedbackWithContext is the same as PutFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See PutFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) PutFeedbackWithContext(ctx aws.Context, input *PutFeedbackInput, opts ...request.Option) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveNotificationChannel = "RemoveNotificationChannel"

// RemoveNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the RemoveNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveNotificationChannel for more information on using the RemoveNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveNotificationChannelRequest method.
//	req, resp := client.RemoveNotificationChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel
func (c *DevOpsGuru) RemoveNotificationChannelRequest(input *RemoveNotificationChannelInput) (req *request.Request, output *RemoveNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opRemoveNotificationChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{Id}",
	}

	if input == nil {
		input = &RemoveNotificationChannelInput{}
	}

	output = &RemoveNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveNotificationChannel API operation for Amazon DevOps Guru.
//
// Removes a notification channel from DevOps Guru. A notification channel is
// used to notify you when DevOps Guru generates an insight that contains information
// about how to improve your operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation RemoveNotificationChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - ConflictException
//     An exception that is thrown when a conflict occurs.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel
func (c *DevOpsGuru) RemoveNotificationChannel(input *RemoveNotificationChannelInput) (*RemoveNotificationChannelOutput, error) {
	req, out := c.RemoveNotificationChannelRequest(input)
	return out, req.Send()
}

// RemoveNotificationChannelWithContext is the same as RemoveNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) RemoveNotificationChannelWithContext(ctx aws.Context, input *RemoveNotificationChannelInput, opts ...request.Option) (*RemoveNotificationChannelOutput, error) {
	req, out := c.RemoveNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchInsights = "SearchInsights"

// SearchInsightsRequest generates a "aws/request.Request" representing the
// client's request for the SearchInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchInsights for more information on using the SearchInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchInsightsRequest method.
//	req, resp := client.SearchInsightsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights
func (c *DevOpsGuru) SearchInsightsRequest(input *SearchInsightsInput) (req *request.Request, output *SearchInsightsOutput) {
	op := &request.Operation{
		Name:       opSearchInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInsightsInput{}
	}

	output = &SearchInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchInsights API operation for Amazon DevOps Guru.
//
// Returns a list of insights in your Amazon Web Services account. You can specify
// which insights are returned by their start time, one or more statuses (ONGOING
// or CLOSED), one or more severities (LOW, MEDIUM, and HIGH), and type (REACTIVE
// or PROACTIVE).
//
// Use the Filters parameter to specify status and severity search parameters.
// Use the Type parameter to specify REACTIVE or PROACTIVE in your search.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation SearchInsights for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights
func (c *DevOpsGuru) SearchInsights(input *SearchInsightsInput) (*SearchInsightsOutput, error) {
	req, out := c.SearchInsightsRequest(input)
	return out, req.Send()
}

// SearchInsightsWithContext is the same as SearchInsights with the addition of
// the ability to pass a context and additional request options.
//
// See SearchInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchInsightsWithContext(ctx aws.Context, input *SearchInsightsInput, opts ...request.Option) (*SearchInsightsOutput, error) {
	req, out := c.SearchInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchInsightsPages iterates over the pages of a SearchInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchInsights operation.
//	pageNum := 0
//	err := client.SearchInsightsPages(params,
//	    func(page *devopsguru.SearchInsightsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) SearchInsightsPages(input *SearchInsightsInput, fn func(*SearchInsightsOutput, bool) bool) error {
	return c.SearchInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchInsightsPagesWithContext same as SearchInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchInsightsPagesWithContext(ctx aws.Context, input *SearchInsightsInput, fn func(*SearchInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchOrganizationInsights = "SearchOrganizationInsights"

// SearchOrganizationInsightsRequest generates a "aws/request.Request" representing the
// client's request for the SearchOrganizationInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchOrganizationInsights for more information on using the SearchOrganizationInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchOrganizationInsightsRequest method.
//	req, resp := client.SearchOrganizationInsightsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights
func (c *DevOpsGuru) SearchOrganizationInsightsRequest(input *SearchOrganizationInsightsInput) (req *request.Request, output *SearchOrganizationInsightsOutput) {
	op := &request.Operation{
		Name:       opSearchOrganizationInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/insights/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchOrganizationInsightsInput{}
	}

	output = &SearchOrganizationInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchOrganizationInsights API operation for Amazon DevOps Guru.
//
// Returns a list of insights in your organization. You can specify which insights
// are returned by their start time, one or more statuses (ONGOING, CLOSED,
// and CLOSED), one or more severities (LOW, MEDIUM, and HIGH), and type (REACTIVE
// or PROACTIVE).
//
// Use the Filters parameter to specify status and severity search parameters.
// Use the Type parameter to specify REACTIVE or PROACTIVE in your search.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation SearchOrganizationInsights for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights
func (c *DevOpsGuru) SearchOrganizationInsights(input *SearchOrganizationInsightsInput) (*SearchOrganizationInsightsOutput, error) {
	req, out := c.SearchOrganizationInsightsRequest(input)
	return out, req.Send()
}

// SearchOrganizationInsightsWithContext is the same as SearchOrganizationInsights with the addition of
// the ability to pass a context and additional request options.
//
// See SearchOrganizationInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchOrganizationInsightsWithContext(ctx aws.Context, input *SearchOrganizationInsightsInput, opts ...request.Option) (*SearchOrganizationInsightsOutput, error) {
	req, out := c.SearchOrganizationInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchOrganizationInsightsPages iterates over the pages of a SearchOrganizationInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchOrganizationInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchOrganizationInsights operation.
//	pageNum := 0
//	err := client.SearchOrganizationInsightsPages(params,
//	    func(page *devopsguru.SearchOrganizationInsightsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DevOpsGuru) SearchOrganizationInsightsPages(input *SearchOrganizationInsightsInput, fn func(*SearchOrganizationInsightsOutput, bool) bool) error {
	return c.SearchOrganizationInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchOrganizationInsightsPagesWithContext same as SearchOrganizationInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchOrganizationInsightsPagesWithContext(ctx aws.Context, input *SearchOrganizationInsightsInput, fn func(*SearchOrganizationInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchOrganizationInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchOrganizationInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchOrganizationInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartCostEstimation = "StartCostEstimation"

// StartCostEstimationRequest generates a "aws/request.Request" representing the
// client's request for the StartCostEstimation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCostEstimation for more information on using the StartCostEstimation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartCostEstimationRequest method.
//	req, resp := client.StartCostEstimationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/StartCostEstimation
func (c *DevOpsGuru) StartCostEstimationRequest(input *StartCostEstimationInput) (req *request.Request, output *StartCostEstimationOutput) {
	op := &request.Operation{
		Name:       opStartCostEstimation,
		HTTPMethod: "PUT",
		HTTPPath:   "/cost-estimation",
	}

	if input == nil {
		input = &StartCostEstimationInput{}
	}

	output = &StartCostEstimationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartCostEstimation API operation for Amazon DevOps Guru.
//
// Starts the creation of an estimate of the monthly cost to analyze your Amazon
// Web Services resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation StartCostEstimation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - ConflictException
//     An exception that is thrown when a conflict occurs.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ResourceNotFoundException
//     A requested resource could not be found
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/StartCostEstimation
func (c *DevOpsGuru) StartCostEstimation(input *StartCostEstimationInput) (*StartCostEstimationOutput, error) {
	req, out := c.StartCostEstimationRequest(input)
	return out, req.Send()
}

// StartCostEstimationWithContext is the same as StartCostEstimation with the addition of
// the ability to pass a context and additional request options.
//
// See StartCostEstimation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) StartCostEstimationWithContext(ctx aws.Context, input *StartCostEstimationInput, opts ...request.Option) (*StartCostEstimationOutput, error) {
	req, out := c.StartCostEstimationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventSourcesConfig = "UpdateEventSourcesConfig"

// UpdateEventSourcesConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventSourcesConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventSourcesConfig for more information on using the UpdateEventSourcesConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEventSourcesConfigRequest method.
//	req, resp := client.UpdateEventSourcesConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateEventSourcesConfig
func (c *DevOpsGuru) UpdateEventSourcesConfigRequest(input *UpdateEventSourcesConfigInput) (req *request.Request, output *UpdateEventSourcesConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateEventSourcesConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/event-sources",
	}

	if input == nil {
		input = &UpdateEventSourcesConfigInput{}
	}

	output = &UpdateEventSourcesConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEventSourcesConfig API operation for Amazon DevOps Guru.
//
// Enables or disables integration with a service that can be integrated with
// DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon
// CodeGuru Profiler, which can produce proactive recommendations which can
// be stored and viewed in DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation UpdateEventSourcesConfig for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateEventSourcesConfig
func (c *DevOpsGuru) UpdateEventSourcesConfig(input *UpdateEventSourcesConfigInput) (*UpdateEventSourcesConfigOutput, error) {
	req, out := c.UpdateEventSourcesConfigRequest(input)
	return out, req.Send()
}

// UpdateEventSourcesConfigWithContext is the same as UpdateEventSourcesConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventSourcesConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) UpdateEventSourcesConfigWithContext(ctx aws.Context, input *UpdateEventSourcesConfigInput, opts ...request.Option) (*UpdateEventSourcesConfigOutput, error) {
	req, out := c.UpdateEventSourcesConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceCollection = "UpdateResourceCollection"

// UpdateResourceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceCollection for more information on using the UpdateResourceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResourceCollectionRequest method.
//	req, resp := client.UpdateResourceCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection
func (c *DevOpsGuru) UpdateResourceCollectionRequest(input *UpdateResourceCollectionInput) (req *request.Request, output *UpdateResourceCollectionOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceCollection,
		HTTPMethod: "PUT",
		HTTPPath:   "/resource-collections",
	}

	if input == nil {
		input = &UpdateResourceCollectionInput{}
	}

	output = &UpdateResourceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResourceCollection API operation for Amazon DevOps Guru.
//
// Updates the collection of resources that DevOps Guru analyzes. The two types
// of Amazon Web Services resource collections supported are Amazon Web Services
// CloudFormation stacks and Amazon Web Services resources that contain the
// same Amazon Web Services tag. DevOps Guru can be configured to analyze the
// Amazon Web Services resources that are defined in the stacks or that are
// tagged using the same tag key. You can specify up to 500 Amazon Web Services
// CloudFormation stacks. This method also creates the IAM role required for
// you to use DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation UpdateResourceCollection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - ConflictException
//     An exception that is thrown when a conflict occurs.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection
func (c *DevOpsGuru) UpdateResourceCollection(input *UpdateResourceCollectionInput) (*UpdateResourceCollectionOutput, error) {
	req, out := c.UpdateResourceCollectionRequest(input)
	return out, req.Send()
}

// UpdateResourceCollectionWithContext is the same as UpdateResourceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) UpdateResourceCollectionWithContext(ctx aws.Context, input *UpdateResourceCollectionInput, opts ...request.Option) (*UpdateResourceCollectionOutput, error) {
	req, out := c.UpdateResourceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceIntegration = "UpdateServiceIntegration"

// UpdateServiceIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceIntegration for more information on using the UpdateServiceIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceIntegrationRequest method.
//	req, resp := client.UpdateServiceIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration
func (c *DevOpsGuru) UpdateServiceIntegrationRequest(input *UpdateServiceIntegrationInput) (req *request.Request, output *UpdateServiceIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceIntegration,
		HTTPMethod: "PUT",
		HTTPPath:   "/service-integrations",
	}

	if input == nil {
		input = &UpdateServiceIntegrationInput{}
	}

	output = &UpdateServiceIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServiceIntegration API operation for Amazon DevOps Guru.
//
// Enables or disables integration with a service that can be integrated with
// DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon
// Web Services Systems Manager, which can be used to create an OpsItem for
// each generated insight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation UpdateServiceIntegration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//     in the IAM User Guide.
//
//   - ConflictException
//     An exception that is thrown when a conflict occurs.
//
//   - InternalServerException
//     An internal failure in an Amazon service occurred.
//
//   - ThrottlingException
//     The request was denied due to a request throttling.
//
//   - ValidationException
//     Contains information about data passed in to a field during a request that
//     is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration
func (c *DevOpsGuru) UpdateServiceIntegration(input *UpdateServiceIntegrationInput) (*UpdateServiceIntegrationOutput, error) {
	req, out := c.UpdateServiceIntegrationRequest(input)
	return out, req.Send()
}

// UpdateServiceIntegrationWithContext is the same as UpdateServiceIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) UpdateServiceIntegrationWithContext(ctx aws.Context, input *UpdateServiceIntegrationInput, opts ...request.Option) (*UpdateServiceIntegrationOutput, error) {
	req, out := c.UpdateServiceIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to perform the requested operation. The user or
// role that is making the request must have at least one IAM permissions policy
// attached that grants the required permissions. For more information, see
// Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
// in the IAM User Guide.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returns the number of open reactive insights, the number of open proactive
// insights, and the number of metrics analyzed in your Amazon Web Services
// account. Use these numbers to gauge the health of operations in your Amazon
// Web Services account.
type AccountHealth struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// Information about the health of the Amazon Web Services resources in your
	// account, including the number of open proactive, open reactive insights,
	// and the Mean Time to Recover (MTTR) of closed insights.
	Insight *AccountInsightHealth `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountHealth) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountHealth) SetAccountId(v string) *AccountHealth {
	s.AccountId = &v
	return s
}

// SetInsight sets the Insight field's value.
func (s *AccountHealth) SetInsight(v *AccountInsightHealth) *AccountHealth {
	s.Insight = v
	return s
}

// Information about the number of open reactive and proactive insights that
// can be used to gauge the health of your system.
type AccountInsightHealth struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	OpenProactiveInsights *int64 `type:"integer"`

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	OpenReactiveInsights *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountInsightHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountInsightHealth) GoString() string {
	return s.String()
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *AccountInsightHealth) SetOpenProactiveInsights(v int64) *AccountInsightHealth {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *AccountInsightHealth) SetOpenReactiveInsights(v int64) *AccountInsightHealth {
	s.OpenReactiveInsights = &v
	return s
}

type AddNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// A NotificationChannelConfig object that specifies what type of notification
	// channel to add. The one supported notification channel is Amazon Simple Notification
	// Service (Amazon SNS).
	//
	// Config is a required field
	Config *NotificationChannelConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddNotificationChannelInput"}
	if s.Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Config"))
	}
	if s.Config != nil {
		if err := s.Config.Validate(); err != nil {
			invalidParams.AddNested("Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig sets the Config field's value.
func (s *AddNotificationChannelInput) SetConfig(v *NotificationChannelConfig) *AddNotificationChannelInput {
	s.Config = v
	return s
}

type AddNotificationChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the added notification channel.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddNotificationChannelOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AddNotificationChannelOutput) SetId(v string) *AddNotificationChannelOutput {
	s.Id = &v
	return s
}

// Information about your account's integration with Amazon CodeGuru Profiler.
// This returns whether DevOps Guru is configured to consume recommendations
// generated from Amazon CodeGuru Profiler.
type AmazonCodeGuruProfilerIntegration struct {
	_ struct{} `type:"structure"`

	// The status of the CodeGuru Profiler integration. Specifies if DevOps Guru
	// is enabled to consume recommendations that are generated from Amazon CodeGuru
	// Profiler.
	Status *string `type:"string" enum:"EventSourceOptInStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonCodeGuruProfilerIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonCodeGuruProfilerIntegration) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AmazonCodeGuruProfilerIntegration) SetStatus(v string) *AmazonCodeGuruProfilerIntegration {
	s.Status = &v
	return s
}

// An Amazon CloudWatch log group that contains log anomalies and is used to
// generate an insight.
type AnomalousLogGroup struct {
	_ struct{} `type:"structure"`

	// The time the anomalous log events stopped.
	ImpactEndTime *time.Time `type:"timestamp"`

	// The time the anomalous log events began. The impact start time indicates
	// the time of the first log anomaly event that occurs.
	ImpactStartTime *time.Time `type:"timestamp"`

	// The log anomalies in the log group. Each log anomaly displayed represents
	// a cluster of similar anomalous log events.
	LogAnomalyShowcases []*LogAnomalyShowcase `type:"list"`

	// The name of the CloudWatch log group.
	LogGroupName *string `min:"1" type:"string"`

	// The number of log lines that were scanned for anomalous log events.
	NumberOfLogLinesScanned *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalousLogGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalousLogGroup) GoString() string {
	return s.String()
}

// SetImpactEndTime sets the ImpactEndTime field's value.
func (s *AnomalousLogGroup) SetImpactEndTime(v time.Time) *AnomalousLogGroup {
	s.ImpactEndTime = &v
	return s
}

// SetImpactStartTime sets the ImpactStartTime field's value.
func (s *AnomalousLogGroup) SetImpactStartTime(v time.Time) *AnomalousLogGroup {
	s.ImpactStartTime = &v
	return s
}

// SetLogAnomalyShowcases sets the LogAnomalyShowcases field's value.
func (s *AnomalousLogGroup) SetLogAnomalyShowcases(v []*LogAnomalyShowcase) *AnomalousLogGroup {
	s.LogAnomalyShowcases = v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *AnomalousLogGroup) SetLogGroupName(v string) *AnomalousLogGroup {
	s.LogGroupName = &v
	return s
}

// SetNumberOfLogLinesScanned sets the NumberOfLogLinesScanned field's value.
func (s *AnomalousLogGroup) SetNumberOfLogLinesScanned(v int64) *AnomalousLogGroup {
	s.NumberOfLogLinesScanned = &v
	return s
}

// A time range that specifies when DevOps Guru opens and then closes an anomaly.
// This is different from AnomalyTimeRange, which specifies the time range when
// DevOps Guru actually observes the anomalous behavior.
type AnomalyReportedTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when an anomaly is closed.
	CloseTime *time.Time `type:"timestamp"`

	// The time when an anomaly is opened.
	//
	// OpenTime is a required field
	OpenTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyReportedTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyReportedTimeRange) GoString() string {
	return s.String()
}

// SetCloseTime sets the CloseTime field's value.
func (s *AnomalyReportedTimeRange) SetCloseTime(v time.Time) *AnomalyReportedTimeRange {
	s.CloseTime = &v
	return s
}

// SetOpenTime sets the OpenTime field's value.
func (s *AnomalyReportedTimeRange) SetOpenTime(v time.Time) *AnomalyReportedTimeRange {
	s.OpenTime = &v
	return s
}

// The Amazon Web Services resources in which DevOps Guru detected unusual behavior
// that resulted in the generation of an anomaly. When DevOps Guru detects multiple
// related anomalies, it creates and insight with details about the anomalous
// behavior and suggestions about how to correct the problem.
type AnomalyResource struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Web Services resource.
	Name *string `type:"string"`

	// The type of the Amazon Web Services resource.
	Type *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyResource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnomalyResource) SetName(v string) *AnomalyResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AnomalyResource) SetType(v string) *AnomalyResource {
	s.Type = &v
	return s
}

// Details about the source of the anomalous operational data that triggered
// the anomaly.
type AnomalySourceDetails struct {
	_ struct{} `type:"structure"`

	// An array of CloudWatchMetricsDetail objects that contain information about
	// analyzed CloudWatch metrics that show anomalous behavior.
	CloudWatchMetrics []*CloudWatchMetricsDetail `type:"list"`

	// An array of PerformanceInsightsMetricsDetail objects that contain information
	// about analyzed Performance Insights metrics that show anomalous behavior.
	PerformanceInsightsMetrics []*PerformanceInsightsMetricsDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalySourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalySourceDetails) GoString() string {
	return s.String()
}

// SetCloudWatchMetrics sets the CloudWatchMetrics field's value.
func (s *AnomalySourceDetails) SetCloudWatchMetrics(v []*CloudWatchMetricsDetail) *AnomalySourceDetails {
	s.CloudWatchMetrics = v
	return s
}

// SetPerformanceInsightsMetrics sets the PerformanceInsightsMetrics field's value.
func (s *AnomalySourceDetails) SetPerformanceInsightsMetrics(v []*PerformanceInsightsMetricsDetail) *AnomalySourceDetails {
	s.PerformanceInsightsMetrics = v
	return s
}

// Metadata about the detection source that generates proactive anomalies. The
// anomaly is detected using analysis of the metric data over a period of time
type AnomalySourceMetadata struct {
	_ struct{} `type:"structure"`

	// The source of the anomaly.
	Source *string `type:"string"`

	// The name of the anomaly's resource.
	SourceResourceName *string `type:"string"`

	// The anomaly's resource type.
	SourceResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalySourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalySourceMetadata) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *AnomalySourceMetadata) SetSource(v string) *AnomalySourceMetadata {
	s.Source = &v
	return s
}

// SetSourceResourceName sets the SourceResourceName field's value.
func (s *AnomalySourceMetadata) SetSourceResourceName(v string) *AnomalySourceMetadata {
	s.SourceResourceName = &v
	return s
}

// SetSourceResourceType sets the SourceResourceType field's value.
func (s *AnomalySourceMetadata) SetSourceResourceType(v string) *AnomalySourceMetadata {
	s.SourceResourceType = &v
	return s
}

// A time range that specifies when the observed unusual behavior in an anomaly
// started and ended. This is different from AnomalyReportedTimeRange, which
// specifies the time range when DevOps Guru opens and then closes an anomaly.
type AnomalyTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the anomalous behavior ended.
	EndTime *time.Time `type:"timestamp"`

	// The time when the anomalous behavior started.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *AnomalyTimeRange) SetEndTime(v time.Time) *AnomalyTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AnomalyTimeRange) SetStartTime(v time.Time) *AnomalyTimeRange {
	s.StartTime = &v
	return s
}

// Information about Amazon Web Services CloudFormation stacks. You can use
// up to 500 stacks to specify which Amazon Web Services resources in your account
// to analyze. For more information, see Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
// in the Amazon Web Services CloudFormation User Guide.
type CloudFormationCollection struct {
	_ struct{} `type:"structure"`

	// An array of CloudFormation stack names.
	StackNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationCollection) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *CloudFormationCollection) SetStackNames(v []*string) *CloudFormationCollection {
	s.StackNames = v
	return s
}

// Information about Amazon Web Services CloudFormation stacks. You can use
// up to 500 stacks to specify which Amazon Web Services resources in your account
// to analyze. For more information, see Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
// in the Amazon Web Services CloudFormation User Guide.
type CloudFormationCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An array of CloudFormation stack names.
	StackNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationCollectionFilter) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *CloudFormationCollectionFilter) SetStackNames(v []*string) *CloudFormationCollectionFilter {
	s.StackNames = v
	return s
}

// Information about an Amazon Web Services CloudFormation stack used to create
// a monthly cost estimate for DevOps Guru to analyze Amazon Web Services resources.
// The maximum number of stacks you can specify for a cost estimate is one.
// The estimate created is for the cost to analyze the Amazon Web Services resources
// defined by the stack. For more information, see Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
// in the Amazon Web Services CloudFormation User Guide.
type CloudFormationCostEstimationResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An array of CloudFormation stack names. Its size is fixed at 1 item.
	StackNames []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationCostEstimationResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationCostEstimationResourceCollectionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudFormationCostEstimationResourceCollectionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudFormationCostEstimationResourceCollectionFilter"}
	if s.StackNames != nil && len(s.StackNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackNames sets the StackNames field's value.
func (s *CloudFormationCostEstimationResourceCollectionFilter) SetStackNames(v []*string) *CloudFormationCostEstimationResourceCollectionFilter {
	s.StackNames = v
	return s
}

// Information about the health of Amazon Web Services resources in your account
// that are specified by an Amazon Web Services CloudFormation stack.
type CloudFormationHealth struct {
	_ struct{} `type:"structure"`

	// Number of resources that DevOps Guru is monitoring in your account that are
	// specified by an Amazon Web Services CloudFormation stack.
	AnalyzedResourceCount *int64 `type:"long"`

	// Information about the health of the Amazon Web Services resources in your
	// account that are specified by an Amazon Web Services CloudFormation stack,
	// including the number of open proactive, open reactive insights, and the Mean
	// Time to Recover (MTTR) of closed insights.
	Insight *InsightHealth `type:"structure"`

	// The name of the CloudFormation stack.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationHealth) GoString() string {
	return s.String()
}

// SetAnalyzedResourceCount sets the AnalyzedResourceCount field's value.
func (s *CloudFormationHealth) SetAnalyzedResourceCount(v int64) *CloudFormationHealth {
	s.AnalyzedResourceCount = &v
	return s
}

// SetInsight sets the Insight field's value.
func (s *CloudFormationHealth) SetInsight(v *InsightHealth) *CloudFormationHealth {
	s.Insight = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CloudFormationHealth) SetStackName(v string) *CloudFormationHealth {
	s.StackName = &v
	return s
}

// Contains information about the analyzed metrics that displayed anomalous
// behavior.
type CloudWatchMetricsDataSummary struct {
	_ struct{} `type:"structure"`

	// This is an enum of the status showing whether the metric value pair list
	// has partial or complete data, or if there was an error.
	StatusCode *string `type:"string" enum:"CloudWatchMetricDataStatusCode"`

	// This is a list of Amazon CloudWatch metric values at given timestamp.
	TimestampMetricValuePairList []*TimestampMetricValuePair `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetricsDataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetricsDataSummary) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *CloudWatchMetricsDataSummary) SetStatusCode(v string) *CloudWatchMetricsDataSummary {
	s.StatusCode = &v
	return s
}

// SetTimestampMetricValuePairList sets the TimestampMetricValuePairList field's value.
func (s *CloudWatchMetricsDataSummary) SetTimestampMetricValuePairList(v []*TimestampMetricValuePair) *CloudWatchMetricsDataSummary {
	s.TimestampMetricValuePairList = v
	return s
}

// Information about an Amazon CloudWatch metric.
type CloudWatchMetricsDetail struct {
	_ struct{} `type:"structure"`

	// An array of CloudWatch dimensions associated with
	Dimensions []*CloudWatchMetricsDimension `type:"list"`

	// This object returns anomaly metric data.
	MetricDataSummary *CloudWatchMetricsDataSummary `type:"structure"`

	// The name of the CloudWatch metric.
	MetricName *string `type:"string"`

	// The namespace of the CloudWatch metric. A namespace is a container for CloudWatch
	// metrics.
	Namespace *string `type:"string"`

	// The length of time associated with the CloudWatch metric in number of seconds.
	Period *int64 `type:"integer"`

	// The type of statistic associated with the CloudWatch metric. For more information,
	// see Statistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch User Guide.
	Stat *string `type:"string" enum:"CloudWatchMetricsStat"`

	// The unit of measure used for the CloudWatch metric. For example, Bytes, Seconds,
	// Count, and Percent.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetricsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetricsDetail) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *CloudWatchMetricsDetail) SetDimensions(v []*CloudWatchMetricsDimension) *CloudWatchMetricsDetail {
	s.Dimensions = v
	return s
}

// SetMetricDataSummary sets the MetricDataSummary field's value.
func (s *CloudWatchMetricsDetail) SetMetricDataSummary(v *CloudWatchMetricsDataSummary) *CloudWatchMetricsDetail {
	s.MetricDataSummary = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CloudWatchMetricsDetail) SetMetricName(v string) *CloudWatchMetricsDetail {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CloudWatchMetricsDetail) SetNamespace(v string) *CloudWatchMetricsDetail {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CloudWatchMetricsDetail) SetPeriod(v int64) *CloudWatchMetricsDetail {
	s.Period = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *CloudWatchMetricsDetail) SetStat(v string) *CloudWatchMetricsDetail {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CloudWatchMetricsDetail) SetUnit(v string) *CloudWatchMetricsDetail {
	s.Unit = &v
	return s
}

// The dimension of an Amazon CloudWatch metric that is used when DevOps Guru
// analyzes the resources in your account for operational problems and anomalous
// behavior. A dimension is a name/value pair that is part of the identity of
// a metric. A metric can have up to 10 dimensions. For more information, see
// Dimensions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension)
// in the Amazon CloudWatch User Guide.
type CloudWatchMetricsDimension struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch dimension.
	Name *string `type:"string"`

	// The value of the CloudWatch dimension.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetricsDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetricsDimension) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CloudWatchMetricsDimension) SetName(v string) *CloudWatchMetricsDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CloudWatchMetricsDimension) SetValue(v string) *CloudWatchMetricsDimension {
	s.Value = &v
	return s
}

// An exception that is thrown when a conflict occurs.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the Amazon Web Services resource in which a conflict occurred.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of the Amazon Web Services resource in which a conflict occurred.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a filter used to specify which Amazon Web Services resources
// are analyzed to create a monthly DevOps Guru cost estimate. For more information,
// see Estimate your Amazon DevOps Guru costs (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
type CostEstimationResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An object that specifies the CloudFormation stack that defines the Amazon
	// Web Services resources used to create a monthly estimate for DevOps Guru.
	CloudFormation *CloudFormationCostEstimationResourceCollectionFilter `type:"structure"`

	// The Amazon Web Services tags used to filter the resource collection that
	// is used for a cost estimate.
	//
	// Tags help you identify and organize your Amazon Web Services resources. Many
	// Amazon Web Services services support tagging, so you can assign the same
	// tag to resources from different services to indicate that the resources are
	// related. For example, you can assign the same tag to an Amazon DynamoDB table
	// resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper.
	//
	// Each Amazon Web Services tag has two parts.
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case-sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case-sensitive.
	//
	// Together these are known as key-value pairs.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	Tags []*TagCostEstimationResourceCollectionFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostEstimationResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostEstimationResourceCollectionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostEstimationResourceCollectionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostEstimationResourceCollectionFilter"}
	if s.CloudFormation != nil {
		if err := s.CloudFormation.Validate(); err != nil {
			invalidParams.AddNested("CloudFormation", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *CostEstimationResourceCollectionFilter) SetCloudFormation(v *CloudFormationCostEstimationResourceCollectionFilter) *CostEstimationResourceCollectionFilter {
	s.CloudFormation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CostEstimationResourceCollectionFilter) SetTags(v []*TagCostEstimationResourceCollectionFilter) *CostEstimationResourceCollectionFilter {
	s.Tags = v
	return s
}

// The time range of a cost estimation.
type CostEstimationTimeRange struct {
	_ struct{} `type:"structure"`

	// The end time of the cost estimation.
	EndTime *time.Time `type:"timestamp"`

	// The start time of the cost estimation.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostEstimationTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostEstimationTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *CostEstimationTimeRange) SetEndTime(v time.Time) *CostEstimationTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CostEstimationTimeRange) SetStartTime(v time.Time) *CostEstimationTimeRange {
	s.StartTime = &v
	return s
}

type DeleteInsightInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the insight.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInsightInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteInsightInput) SetId(v string) *DeleteInsightInput {
	s.Id = &v
	return s
}

type DeleteInsightOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightOutput) GoString() string {
	return s.String()
}

type DescribeAccountHealthInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountHealthInput) GoString() string {
	return s.String()
}

type DescribeAccountHealthOutput struct {
	_ struct{} `type:"structure"`

	// Number of resources that DevOps Guru is monitoring in your Amazon Web Services
	// account.
	AnalyzedResourceCount *int64 `type:"long"`

	// An integer that specifies the number of metrics that have been analyzed in
	// your Amazon Web Services account.
	//
	// MetricsAnalyzed is a required field
	MetricsAnalyzed *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	//
	// OpenProactiveInsights is a required field
	OpenProactiveInsights *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	//
	// OpenReactiveInsights is a required field
	OpenReactiveInsights *int64 `type:"integer" required:"true"`

	// The number of Amazon DevOps Guru resource analysis hours billed to the current
	// Amazon Web Services account in the last hour.
	//
	// ResourceHours is a required field
	ResourceHours *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountHealthOutput) GoString() string {
	return s.String()
}

// SetAnalyzedResourceCount sets the AnalyzedResourceCount field's value.
func (s *DescribeAccountHealthOutput) SetAnalyzedResourceCount(v int64) *DescribeAccountHealthOutput {
	s.AnalyzedResourceCount = &v
	return s
}

// SetMetricsAnalyzed sets the MetricsAnalyzed field's value.
func (s *DescribeAccountHealthOutput) SetMetricsAnalyzed(v int64) *DescribeAccountHealthOutput {
	s.MetricsAnalyzed = &v
	return s
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *DescribeAccountHealthOutput) SetOpenProactiveInsights(v int64) *DescribeAccountHealthOutput {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *DescribeAccountHealthOutput) SetOpenReactiveInsights(v int64) *DescribeAccountHealthOutput {
	s.OpenReactiveInsights = &v
	return s
}

// SetResourceHours sets the ResourceHours field's value.
func (s *DescribeAccountHealthOutput) SetResourceHours(v int64) *DescribeAccountHealthOutput {
	s.ResourceHours = &v
	return s
}

type DescribeAccountOverviewInput struct {
	_ struct{} `type:"structure"`

	// The start of the time range passed in. The start time granularity is at the
	// day level. The floor of the start time is used. Returned information occurred
	// after this day.
	//
	// FromTime is a required field
	FromTime *time.Time `type:"timestamp" required:"true"`

	// The end of the time range passed in. The start time granularity is at the
	// day level. The floor of the start time is used. Returned information occurred
	// before this day. If this is not specified, then the current day is used.
	ToTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOverviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOverviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountOverviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountOverviewInput"}
	if s.FromTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromTime sets the FromTime field's value.
func (s *DescribeAccountOverviewInput) SetFromTime(v time.Time) *DescribeAccountOverviewInput {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *DescribeAccountOverviewInput) SetToTime(v time.Time) *DescribeAccountOverviewInput {
	s.ToTime = &v
	return s
}

type DescribeAccountOverviewOutput struct {
	_ struct{} `type:"structure"`

	// The Mean Time to Recover (MTTR) for all closed insights that were created
	// during the time range passed in.
	//
	// MeanTimeToRecoverInMilliseconds is a required field
	MeanTimeToRecoverInMilliseconds *int64 `type:"long" required:"true"`

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account that were created during the time range passed in.
	//
	// ProactiveInsights is a required field
	ProactiveInsights *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account that were created during the time range passed in.
	//
	// ReactiveInsights is a required field
	ReactiveInsights *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOverviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOverviewOutput) GoString() string {
	return s.String()
}

// SetMeanTimeToRecoverInMilliseconds sets the MeanTimeToRecoverInMilliseconds field's value.
func (s *DescribeAccountOverviewOutput) SetMeanTimeToRecoverInMilliseconds(v int64) *DescribeAccountOverviewOutput {
	s.MeanTimeToRecoverInMilliseconds = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *DescribeAccountOverviewOutput) SetProactiveInsights(v int64) *DescribeAccountOverviewOutput {
	s.ProactiveInsights = &v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *DescribeAccountOverviewOutput) SetReactiveInsights(v int64) *DescribeAccountOverviewOutput {
	s.ReactiveInsights = &v
	return s
}

type DescribeAnomalyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the member account.
	AccountId *string `location:"querystring" locationName:"AccountId" min:"12" type:"string"`

	// The ID of the anomaly.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnomalyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnomalyInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeAnomalyInput) SetAccountId(v string) *DescribeAnomalyInput {
	s.AccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeAnomalyInput) SetId(v string) *DescribeAnomalyInput {
	s.Id = &v
	return s
}

type DescribeAnomalyOutput struct {
	_ struct{} `type:"structure"`

	// A ProactiveAnomaly object that represents the requested anomaly.
	ProactiveAnomaly *ProactiveAnomaly `type:"structure"`

	// A ReactiveAnomaly object that represents the requested anomaly.
	ReactiveAnomaly *ReactiveAnomaly `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyOutput) GoString() string {
	return s.String()
}

// SetProactiveAnomaly sets the ProactiveAnomaly field's value.
func (s *DescribeAnomalyOutput) SetProactiveAnomaly(v *ProactiveAnomaly) *DescribeAnomalyOutput {
	s.ProactiveAnomaly = v
	return s
}

// SetReactiveAnomaly sets the ReactiveAnomaly field's value.
func (s *DescribeAnomalyOutput) SetReactiveAnomaly(v *ReactiveAnomaly) *DescribeAnomalyOutput {
	s.ReactiveAnomaly = v
	return s
}

type DescribeEventSourcesConfigInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourcesConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourcesConfigInput) GoString() string {
	return s.String()
}

type DescribeEventSourcesConfigOutput struct {
	_ struct{} `type:"structure"`

	// Lists the event sources in the configuration.
	EventSources *EventSourcesConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourcesConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourcesConfigOutput) GoString() string {
	return s.String()
}

// SetEventSources sets the EventSources field's value.
func (s *DescribeEventSourcesConfigOutput) SetEventSources(v *EventSourcesConfig) *DescribeEventSourcesConfigOutput {
	s.EventSources = v
	return s
}

type DescribeFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The ID of the insight for which the feedback was provided.
	InsightId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFeedbackInput"}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightId sets the InsightId field's value.
func (s *DescribeFeedbackInput) SetInsightId(v string) *DescribeFeedbackInput {
	s.InsightId = &v
	return s
}

type DescribeFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// Information about insight feedback received from a customer.
	InsightFeedback *InsightFeedback `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeedbackOutput) GoString() string {
	return s.String()
}

// SetInsightFeedback sets the InsightFeedback field's value.
func (s *DescribeFeedbackOutput) SetInsightFeedback(v *InsightFeedback) *DescribeFeedbackOutput {
	s.InsightFeedback = v
	return s
}

type DescribeInsightInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the member account in the organization.
	AccountId *string `location:"querystring" locationName:"AccountId" min:"12" type:"string"`

	// The ID of the insight.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInsightInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeInsightInput) SetAccountId(v string) *DescribeInsightInput {
	s.AccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInsightInput) SetId(v string) *DescribeInsightInput {
	s.Id = &v
	return s
}

type DescribeInsightOutput struct {
	_ struct{} `type:"structure"`

	// A ProactiveInsight object that represents the requested insight.
	ProactiveInsight *ProactiveInsight `type:"structure"`

	// A ReactiveInsight object that represents the requested insight.
	ReactiveInsight *ReactiveInsight `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightOutput) GoString() string {
	return s.String()
}

// SetProactiveInsight sets the ProactiveInsight field's value.
func (s *DescribeInsightOutput) SetProactiveInsight(v *ProactiveInsight) *DescribeInsightOutput {
	s.ProactiveInsight = v
	return s
}

// SetReactiveInsight sets the ReactiveInsight field's value.
func (s *DescribeInsightOutput) SetReactiveInsight(v *ReactiveInsight) *DescribeInsightOutput {
	s.ReactiveInsight = v
	return s
}

type DescribeOrganizationHealthInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountIds []*string `type:"list"`

	// The ID of the organizational unit.
	OrganizationalUnitIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationHealthInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DescribeOrganizationHealthInput) SetAccountIds(v []*string) *DescribeOrganizationHealthInput {
	s.AccountIds = v
	return s
}

// SetOrganizationalUnitIds sets the OrganizationalUnitIds field's value.
func (s *DescribeOrganizationHealthInput) SetOrganizationalUnitIds(v []*string) *DescribeOrganizationHealthInput {
	s.OrganizationalUnitIds = v
	return s
}

type DescribeOrganizationHealthOutput struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the number of metrics that have been analyzed in
	// your organization.
	//
	// MetricsAnalyzed is a required field
	MetricsAnalyzed *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	//
	// OpenProactiveInsights is a required field
	OpenProactiveInsights *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	//
	// OpenReactiveInsights is a required field
	OpenReactiveInsights *int64 `type:"integer" required:"true"`

	// The number of Amazon DevOps Guru resource analysis hours billed to the current
	// Amazon Web Services account in the last hour.
	//
	// ResourceHours is a required field
	ResourceHours *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationHealthOutput) GoString() string {
	return s.String()
}

// SetMetricsAnalyzed sets the MetricsAnalyzed field's value.
func (s *DescribeOrganizationHealthOutput) SetMetricsAnalyzed(v int64) *DescribeOrganizationHealthOutput {
	s.MetricsAnalyzed = &v
	return s
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *DescribeOrganizationHealthOutput) SetOpenProactiveInsights(v int64) *DescribeOrganizationHealthOutput {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *DescribeOrganizationHealthOutput) SetOpenReactiveInsights(v int64) *DescribeOrganizationHealthOutput {
	s.OpenReactiveInsights = &v
	return s
}

// SetResourceHours sets the ResourceHours field's value.
func (s *DescribeOrganizationHealthOutput) SetResourceHours(v int64) *DescribeOrganizationHealthOutput {
	s.ResourceHours = &v
	return s
}

type DescribeOrganizationOverviewInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountIds []*string `type:"list"`

	// The start of the time range passed in. The start time granularity is at the
	// day level. The floor of the start time is used. Returned information occurred
	// after this day.
	//
	// FromTime is a required field
	FromTime *time.Time `type:"timestamp" required:"true"`

	// The ID of the organizational unit.
	OrganizationalUnitIds []*string `type:"list"`

	// The end of the time range passed in. The start time granularity is at the
	// day level. The floor of the start time is used. Returned information occurred
	// before this day. If this is not specified, then the current day is used.
	ToTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationOverviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationOverviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationOverviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationOverviewInput"}
	if s.FromTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DescribeOrganizationOverviewInput) SetAccountIds(v []*string) *DescribeOrganizationOverviewInput {
	s.AccountIds = v
	return s
}

// SetFromTime sets the FromTime field's value.
func (s *DescribeOrganizationOverviewInput) SetFromTime(v time.Time) *DescribeOrganizationOverviewInput {
	s.FromTime = &v
	return s
}

// SetOrganizationalUnitIds sets the OrganizationalUnitIds field's value.
func (s *DescribeOrganizationOverviewInput) SetOrganizationalUnitIds(v []*string) *DescribeOrganizationOverviewInput {
	s.OrganizationalUnitIds = v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *DescribeOrganizationOverviewInput) SetToTime(v time.Time) *DescribeOrganizationOverviewInput {
	s.ToTime = &v
	return s
}

type DescribeOrganizationOverviewOutput struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	//
	// ProactiveInsights is a required field
	ProactiveInsights *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	//
	// ReactiveInsights is a required field
	ReactiveInsights *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationOverviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationOverviewOutput) GoString() string {
	return s.String()
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *DescribeOrganizationOverviewOutput) SetProactiveInsights(v int64) *DescribeOrganizationOverviewOutput {
	s.ProactiveInsights = &v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *DescribeOrganizationOverviewOutput) SetReactiveInsights(v int64) *DescribeOrganizationOverviewOutput {
	s.ReactiveInsights = &v
	return s
}

type DescribeOrganizationResourceCollectionHealthInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountIds []*string `type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// An Amazon Web Services resource collection type. This type specifies how
	// analyzed Amazon Web Services resources are defined. The two types of Amazon
	// Web Services resource collections supported are Amazon Web Services CloudFormation
	// stacks and Amazon Web Services resources that contain the same Amazon Web
	// Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
	// resources that are defined in the stacks or that are tagged using the same
	// tag key. You can specify up to 500 Amazon Web Services CloudFormation stacks.
	//
	// OrganizationResourceCollectionType is a required field
	OrganizationResourceCollectionType *string `type:"string" required:"true" enum:"OrganizationResourceCollectionType"`

	// The ID of the organizational unit.
	OrganizationalUnitIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationResourceCollectionHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationResourceCollectionHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationResourceCollectionHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationResourceCollectionHealthInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.OrganizationResourceCollectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationResourceCollectionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DescribeOrganizationResourceCollectionHealthInput) SetAccountIds(v []*string) *DescribeOrganizationResourceCollectionHealthInput {
	s.AccountIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeOrganizationResourceCollectionHealthInput) SetMaxResults(v int64) *DescribeOrganizationResourceCollectionHealthInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationResourceCollectionHealthInput) SetNextToken(v string) *DescribeOrganizationResourceCollectionHealthInput {
	s.NextToken = &v
	return s
}

// SetOrganizationResourceCollectionType sets the OrganizationResourceCollectionType field's value.
func (s *DescribeOrganizationResourceCollectionHealthInput) SetOrganizationResourceCollectionType(v string) *DescribeOrganizationResourceCollectionHealthInput {
	s.OrganizationResourceCollectionType = &v
	return s
}

// SetOrganizationalUnitIds sets the OrganizationalUnitIds field's value.
func (s *DescribeOrganizationResourceCollectionHealthInput) SetOrganizationalUnitIds(v []*string) *DescribeOrganizationResourceCollectionHealthInput {
	s.OrganizationalUnitIds = v
	return s
}

type DescribeOrganizationResourceCollectionHealthOutput struct {
	_ struct{} `type:"structure"`

	// The name of the organization's account.
	Account []*AccountHealth `type:"list"`

	// The returned CloudFormationHealthOverview object that contains an InsightHealthOverview
	// object with the requested system health information.
	CloudFormation []*CloudFormationHealth `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An array of ServiceHealth objects that describes the health of the Amazon
	// Web Services services associated with the resources in the collection.
	Service []*ServiceHealth `type:"list"`

	// Tags help you identify and organize your Amazon Web Services resources. Many
	// Amazon Web Services services support tagging, so you can assign the same
	// tag to resources from different services to indicate that the resources are
	// related. For example, you can assign the same tag to an Amazon DynamoDB table
	// resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper.
	//
	// Each Amazon Web Services tag has two parts.
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case-sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case-sensitive.
	//
	// Together these are known as key-value pairs.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	Tags []*TagHealth `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationResourceCollectionHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationResourceCollectionHealthOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *DescribeOrganizationResourceCollectionHealthOutput) SetAccount(v []*AccountHealth) *DescribeOrganizationResourceCollectionHealthOutput {
	s.Account = v
	return s
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *DescribeOrganizationResourceCollectionHealthOutput) SetCloudFormation(v []*CloudFormationHealth) *DescribeOrganizationResourceCollectionHealthOutput {
	s.CloudFormation = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationResourceCollectionHealthOutput) SetNextToken(v string) *DescribeOrganizationResourceCollectionHealthOutput {
	s.NextToken = &v
	return s
}

// SetService sets the Service field's value.
func (s *DescribeOrganizationResourceCollectionHealthOutput) SetService(v []*ServiceHealth) *DescribeOrganizationResourceCollectionHealthOutput {
	s.Service = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeOrganizationResourceCollectionHealthOutput) SetTags(v []*TagHealth) *DescribeOrganizationResourceCollectionHealthOutput {
	s.Tags = v
	return s
}

type DescribeResourceCollectionHealthInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"36" type:"string"`

	// An Amazon Web Services resource collection type. This type specifies how
	// analyzed Amazon Web Services resources are defined. The two types of Amazon
	// Web Services resource collections supported are Amazon Web Services CloudFormation
	// stacks and Amazon Web Services resources that contain the same Amazon Web
	// Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
	// resources that are defined in the stacks or that are tagged using the same
	// tag key. You can specify up to 500 Amazon Web Services CloudFormation stacks.
	//
	// ResourceCollectionType is a required field
	ResourceCollectionType *string `location:"uri" locationName:"ResourceCollectionType" type:"string" required:"true" enum:"ResourceCollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceCollectionHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceCollectionHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceCollectionHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceCollectionHealthInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.ResourceCollectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollectionType"))
	}
	if s.ResourceCollectionType != nil && len(*s.ResourceCollectionType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceCollectionType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeResourceCollectionHealthInput) SetNextToken(v string) *DescribeResourceCollectionHealthInput {
	s.NextToken = &v
	return s
}

// SetResourceCollectionType sets the ResourceCollectionType field's value.
func (s *DescribeResourceCollectionHealthInput) SetResourceCollectionType(v string) *DescribeResourceCollectionHealthInput {
	s.ResourceCollectionType = &v
	return s
}

type DescribeResourceCollectionHealthOutput struct {
	_ struct{} `type:"structure"`

	// The returned CloudFormationHealthOverview object that contains an InsightHealthOverview
	// object with the requested system health information.
	CloudFormation []*CloudFormationHealth `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An array of ServiceHealth objects that describes the health of the Amazon
	// Web Services services associated with the resources in the collection.
	Service []*ServiceHealth `type:"list"`

	// The Amazon Web Services tags that are used by resources in the resource collection.
	//
	// Tags help you identify and organize your Amazon Web Services resources. Many
	// Amazon Web Services services support tagging, so you can assign the same
	// tag to resources from different services to indicate that the resources are
	// related. For example, you can assign the same tag to an Amazon DynamoDB table
	// resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper.
	//
	// Each Amazon Web Services tag has two parts.
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case-sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case-sensitive.
	//
	// Together these are known as key-value pairs.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	Tags []*TagHealth `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceCollectionHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceCollectionHealthOutput) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *DescribeResourceCollectionHealthOutput) SetCloudFormation(v []*CloudFormationHealth) *DescribeResourceCollectionHealthOutput {
	s.CloudFormation = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeResourceCollectionHealthOutput) SetNextToken(v string) *DescribeResourceCollectionHealthOutput {
	s.NextToken = &v
	return s
}

// SetService sets the Service field's value.
func (s *DescribeResourceCollectionHealthOutput) SetService(v []*ServiceHealth) *DescribeResourceCollectionHealthOutput {
	s.Service = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeResourceCollectionHealthOutput) SetTags(v []*TagHealth) *DescribeResourceCollectionHealthOutput {
	s.Tags = v
	return s
}

type DescribeServiceIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceIntegrationInput) GoString() string {
	return s.String()
}

type DescribeServiceIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the integration of DevOps Guru with another Amazon Web
	// Services service, such as Amazon Web Services Systems Manager.
	ServiceIntegration *ServiceIntegrationConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceIntegrationOutput) GoString() string {
	return s.String()
}

// SetServiceIntegration sets the ServiceIntegration field's value.
func (s *DescribeServiceIntegrationOutput) SetServiceIntegration(v *ServiceIntegrationConfig) *DescribeServiceIntegrationOutput {
	s.ServiceIntegration = v
	return s
}

// A range of time that specifies when anomalous behavior in an anomaly or insight
// ended.
type EndTimeRange struct {
	_ struct{} `type:"structure"`

	// The earliest end time in the time range.
	FromTime *time.Time `type:"timestamp"`

	// The latest end time in the time range.
	ToTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndTimeRange) GoString() string {
	return s.String()
}

// SetFromTime sets the FromTime field's value.
func (s *EndTimeRange) SetFromTime(v time.Time) *EndTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *EndTimeRange) SetToTime(v time.Time) *EndTimeRange {
	s.ToTime = &v
	return s
}

// An Amazon Web Services resource event. Amazon Web Services resource events
// and metrics are analyzed by DevOps Guru to find anomalous behavior and provide
// recommendations to improve your operational solutions.
type Event struct {
	_ struct{} `type:"structure"`

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, where DevOps Guru analysis
	// found the event.
	DataSource *string `type:"string" enum:"EventDataSource"`

	// The class of the event. The class specifies what the event is related to,
	// such as an infrastructure change, a deployment, or a schema change.
	EventClass *string `type:"string" enum:"EventClass"`

	// The Amazon Web Services source that emitted the event.
	EventSource *string `min:"10" type:"string"`

	// The ID of the event.
	Id *string `type:"string"`

	// The name of the event.
	Name *string `type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// An EventResource object that contains information about the resource that
	// emitted the event.
	Resources []*EventResource `type:"list"`

	// A Timestamp that specifies the time the event occurred.
	Time *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *Event) SetDataSource(v string) *Event {
	s.DataSource = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *Event) SetEventClass(v string) *Event {
	s.EventClass = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *Event) SetEventSource(v string) *Event {
	s.EventSource = &v
	return s
}

// SetId sets the Id field's value.
func (s *Event) SetId(v string) *Event {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Event) SetName(v string) *Event {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *Event) SetResourceCollection(v *ResourceCollection) *Event {
	s.ResourceCollection = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Event) SetResources(v []*EventResource) *Event {
	s.Resources = v
	return s
}

// SetTime sets the Time field's value.
func (s *Event) SetTime(v time.Time) *Event {
	s.Time = &v
	return s
}

// The Amazon Web Services resource that emitted an event. Amazon Web Services
// resource events and metrics are analyzed by DevOps Guru to find anomalous
// behavior and provide recommendations to improve your operational solutions.
type EventResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that emitted an event.
	Arn *string `min:"36" type:"string"`

	// The name of the resource that emitted an event.
	Name *string `type:"string"`

	// The type of resource that emitted an event.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventResource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventResource) SetArn(v string) *EventResource {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventResource) SetName(v string) *EventResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *EventResource) SetType(v string) *EventResource {
	s.Type = &v
	return s
}

// Information about the integration of DevOps Guru as consumer with another
// AWS service, such as AWS CodeGuru Profiler via EventBridge.
type EventSourcesConfig struct {
	_ struct{} `type:"structure"`

	// Information about whether DevOps Guru is configured to consume recommendations
	// which are generated from AWS CodeGuru Profiler.
	AmazonCodeGuruProfiler *AmazonCodeGuruProfilerIntegration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSourcesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSourcesConfig) GoString() string {
	return s.String()
}

// SetAmazonCodeGuruProfiler sets the AmazonCodeGuruProfiler field's value.
func (s *EventSourcesConfig) SetAmazonCodeGuruProfiler(v *AmazonCodeGuruProfilerIntegration) *EventSourcesConfig {
	s.AmazonCodeGuruProfiler = v
	return s
}

// The time range during which an Amazon Web Services event occurred. Amazon
// Web Services resource events and metrics are analyzed by DevOps Guru to find
// anomalous behavior and provide recommendations to improve your operational
// solutions.
type EventTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the event started.
	//
	// FromTime is a required field
	FromTime *time.Time `type:"timestamp" required:"true"`

	// The time when the event ended.
	//
	// ToTime is a required field
	ToTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTimeRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventTimeRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventTimeRange"}
	if s.FromTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTime"))
	}
	if s.ToTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ToTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromTime sets the FromTime field's value.
func (s *EventTimeRange) SetFromTime(v time.Time) *EventTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *EventTimeRange) SetToTime(v time.Time) *EventTimeRange {
	s.ToTime = &v
	return s
}

type GetCostEstimationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostEstimationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostEstimationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostEstimationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostEstimationInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetCostEstimationInput) SetNextToken(v string) *GetCostEstimationInput {
	s.NextToken = &v
	return s
}

type GetCostEstimationOutput struct {
	_ struct{} `type:"structure"`

	// An array of ResourceCost objects that each contains details about the monthly
	// cost estimate to analyze one of your Amazon Web Services resources.
	Costs []*ServiceResourceCost `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// The collection of the Amazon Web Services resources used to create your monthly
	// DevOps Guru cost estimate.
	ResourceCollection *CostEstimationResourceCollectionFilter `type:"structure"`

	// The status of creating this cost estimate. If it's still in progress, the
	// status ONGOING is returned. If it is finished, the status COMPLETED is returned.
	Status *string `type:"string" enum:"CostEstimationStatus"`

	// The start and end time of the cost estimation.
	TimeRange *CostEstimationTimeRange `type:"structure"`

	// The estimated monthly cost to analyze the Amazon Web Services resources.
	// This value is the sum of the estimated costs to analyze each resource in
	// the Costs object in this response.
	TotalCost *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostEstimationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostEstimationOutput) GoString() string {
	return s.String()
}

// SetCosts sets the Costs field's value.
func (s *GetCostEstimationOutput) SetCosts(v []*ServiceResourceCost) *GetCostEstimationOutput {
	s.Costs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCostEstimationOutput) SetNextToken(v string) *GetCostEstimationOutput {
	s.NextToken = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *GetCostEstimationOutput) SetResourceCollection(v *CostEstimationResourceCollectionFilter) *GetCostEstimationOutput {
	s.ResourceCollection = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetCostEstimationOutput) SetStatus(v string) *GetCostEstimationOutput {
	s.Status = &v
	return s
}

// SetTimeRange sets the TimeRange field's value.
func (s *GetCostEstimationOutput) SetTimeRange(v *CostEstimationTimeRange) *GetCostEstimationOutput {
	s.TimeRange = v
	return s
}

// SetTotalCost sets the TotalCost field's value.
func (s *GetCostEstimationOutput) SetTotalCost(v float64) *GetCostEstimationOutput {
	s.TotalCost = &v
	return s
}

type GetResourceCollectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"36" type:"string"`

	// The type of Amazon Web Services resource collections to return. The one valid
	// value is CLOUD_FORMATION for Amazon Web Services CloudFormation stacks.
	//
	// ResourceCollectionType is a required field
	ResourceCollectionType *string `location:"uri" locationName:"ResourceCollectionType" type:"string" required:"true" enum:"ResourceCollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceCollectionInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.ResourceCollectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollectionType"))
	}
	if s.ResourceCollectionType != nil && len(*s.ResourceCollectionType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceCollectionType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceCollectionInput) SetNextToken(v string) *GetResourceCollectionInput {
	s.NextToken = &v
	return s
}

// SetResourceCollectionType sets the ResourceCollectionType field's value.
func (s *GetResourceCollectionInput) SetResourceCollectionType(v string) *GetResourceCollectionInput {
	s.ResourceCollectionType = &v
	return s
}

type GetResourceCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// The requested list of Amazon Web Services resource collections. The two types
	// of Amazon Web Services resource collections supported are Amazon Web Services
	// CloudFormation stacks and Amazon Web Services resources that contain the
	// same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are
	// tagged using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollectionFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceCollectionOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceCollectionOutput) SetNextToken(v string) *GetResourceCollectionOutput {
	s.NextToken = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *GetResourceCollectionOutput) SetResourceCollection(v *ResourceCollectionFilter) *GetResourceCollectionOutput {
	s.ResourceCollection = v
	return s
}

// Information about insight feedback received from a customer.
type InsightFeedback struct {
	_ struct{} `type:"structure"`

	// The feedback provided by the customer.
	Feedback *string `type:"string" enum:"InsightFeedbackOption"`

	// The insight feedback ID.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InsightFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InsightFeedback"}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeedback sets the Feedback field's value.
func (s *InsightFeedback) SetFeedback(v string) *InsightFeedback {
	s.Feedback = &v
	return s
}

// SetId sets the Id field's value.
func (s *InsightFeedback) SetId(v string) *InsightFeedback {
	s.Id = &v
	return s
}

// Information about the number of open reactive and proactive insights that
// can be used to gauge the health of your system.
type InsightHealth struct {
	_ struct{} `type:"structure"`

	// The Meant Time to Recover (MTTR) for the insight.
	MeanTimeToRecoverInMilliseconds *int64 `type:"long"`

	// The number of open proactive insights.
	OpenProactiveInsights *int64 `type:"integer"`

	// The number of open reactive insights.
	OpenReactiveInsights *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightHealth) GoString() string {
	return s.String()
}

// SetMeanTimeToRecoverInMilliseconds sets the MeanTimeToRecoverInMilliseconds field's value.
func (s *InsightHealth) SetMeanTimeToRecoverInMilliseconds(v int64) *InsightHealth {
	s.MeanTimeToRecoverInMilliseconds = &v
	return s
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *InsightHealth) SetOpenProactiveInsights(v int64) *InsightHealth {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *InsightHealth) SetOpenReactiveInsights(v int64) *InsightHealth {
	s.OpenReactiveInsights = &v
	return s
}

// A time ranged that specifies when the observed behavior in an insight started
// and ended.
type InsightTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the behavior described in an insight ended.
	EndTime *time.Time `type:"timestamp"`

	// The time when the behavior described in an insight started.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *InsightTimeRange) SetEndTime(v time.Time) *InsightTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *InsightTimeRange) SetStartTime(v time.Time) *InsightTimeRange {
	s.StartTime = &v
	return s
}

// An internal failure in an Amazon service occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The number of seconds after which the action that caused the internal server
	// exception can be retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAnomaliesForInsightInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// The ID of the insight. The returned anomalies belong to this insight.
	//
	// InsightId is a required field
	InsightId *string `location:"uri" locationName:"InsightId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// A time range used to specify when the requested anomalies started. All returned
	// anomalies started during this time range.
	StartTimeRange *StartTimeRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomaliesForInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomaliesForInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomaliesForInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomaliesForInsightInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.InsightId == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightId"))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAnomaliesForInsightInput) SetAccountId(v string) *ListAnomaliesForInsightInput {
	s.AccountId = &v
	return s
}

// SetInsightId sets the InsightId field's value.
func (s *ListAnomaliesForInsightInput) SetInsightId(v string) *ListAnomaliesForInsightInput {
	s.InsightId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomaliesForInsightInput) SetMaxResults(v int64) *ListAnomaliesForInsightInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomaliesForInsightInput) SetNextToken(v string) *ListAnomaliesForInsightInput {
	s.NextToken = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *ListAnomaliesForInsightInput) SetStartTimeRange(v *StartTimeRange) *ListAnomaliesForInsightInput {
	s.StartTimeRange = v
	return s
}

type ListAnomaliesForInsightOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An array of ProactiveAnomalySummary objects that represent the requested
	// anomalies
	ProactiveAnomalies []*ProactiveAnomalySummary `type:"list"`

	// An array of ReactiveAnomalySummary objects that represent the requested anomalies
	ReactiveAnomalies []*ReactiveAnomalySummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomaliesForInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomaliesForInsightOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomaliesForInsightOutput) SetNextToken(v string) *ListAnomaliesForInsightOutput {
	s.NextToken = &v
	return s
}

// SetProactiveAnomalies sets the ProactiveAnomalies field's value.
func (s *ListAnomaliesForInsightOutput) SetProactiveAnomalies(v []*ProactiveAnomalySummary) *ListAnomaliesForInsightOutput {
	s.ProactiveAnomalies = v
	return s
}

// SetReactiveAnomalies sets the ReactiveAnomalies field's value.
func (s *ListAnomaliesForInsightOutput) SetReactiveAnomalies(v []*ReactiveAnomalySummary) *ListAnomaliesForInsightOutput {
	s.ReactiveAnomalies = v
	return s
}

type ListAnomalousLogGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the insight containing the log groups.
	//
	// InsightId is a required field
	InsightId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalousLogGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalousLogGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomalousLogGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomalousLogGroupsInput"}
	if s.InsightId == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightId"))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightId sets the InsightId field's value.
func (s *ListAnomalousLogGroupsInput) SetInsightId(v string) *ListAnomalousLogGroupsInput {
	s.InsightId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomalousLogGroupsInput) SetMaxResults(v int64) *ListAnomalousLogGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalousLogGroupsInput) SetNextToken(v string) *ListAnomalousLogGroupsInput {
	s.NextToken = &v
	return s
}

type ListAnomalousLogGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon CloudWatch log groups that are related to an insight.
	//
	// AnomalousLogGroups is a required field
	AnomalousLogGroups []*AnomalousLogGroup `type:"list" required:"true"`

	// The ID of the insight containing the log groups.
	//
	// InsightId is a required field
	InsightId *string `min:"1" type:"string" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalousLogGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalousLogGroupsOutput) GoString() string {
	return s.String()
}

// SetAnomalousLogGroups sets the AnomalousLogGroups field's value.
func (s *ListAnomalousLogGroupsOutput) SetAnomalousLogGroups(v []*AnomalousLogGroup) *ListAnomalousLogGroupsOutput {
	s.AnomalousLogGroups = v
	return s
}

// SetInsightId sets the InsightId field's value.
func (s *ListAnomalousLogGroupsOutput) SetInsightId(v string) *ListAnomalousLogGroupsOutput {
	s.InsightId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalousLogGroupsOutput) SetNextToken(v string) *ListAnomalousLogGroupsOutput {
	s.NextToken = &v
	return s
}

// Filters you can use to specify which events are returned when ListEvents
// is called.
type ListEventsFilters struct {
	_ struct{} `type:"structure"`

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, of the events you want returned.
	DataSource *string `type:"string" enum:"EventDataSource"`

	// The class of the events you want to filter for, such as an infrastructure
	// change, a deployment, or a schema change.
	EventClass *string `type:"string" enum:"EventClass"`

	// The Amazon Web Services source that emitted the events you want to filter
	// for.
	EventSource *string `min:"10" type:"string"`

	// A time range during which you want the filtered events to have occurred.
	EventTimeRange *EventTimeRange `type:"structure"`

	// An ID of an insight that is related to the events you want to filter for.
	InsightId *string `min:"1" type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventsFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventsFilters"}
	if s.EventSource != nil && len(*s.EventSource) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("EventSource", 10))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.EventTimeRange != nil {
		if err := s.EventTimeRange.Validate(); err != nil {
			invalidParams.AddNested("EventTimeRange", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceCollection != nil {
		if err := s.ResourceCollection.Validate(); err != nil {
			invalidParams.AddNested("ResourceCollection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *ListEventsFilters) SetDataSource(v string) *ListEventsFilters {
	s.DataSource = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *ListEventsFilters) SetEventClass(v string) *ListEventsFilters {
	s.EventClass = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *ListEventsFilters) SetEventSource(v string) *ListEventsFilters {
	s.EventSource = &v
	return s
}

// SetEventTimeRange sets the EventTimeRange field's value.
func (s *ListEventsFilters) SetEventTimeRange(v *EventTimeRange) *ListEventsFilters {
	s.EventTimeRange = v
	return s
}

// SetInsightId sets the InsightId field's value.
func (s *ListEventsFilters) SetInsightId(v string) *ListEventsFilters {
	s.InsightId = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ListEventsFilters) SetResourceCollection(v *ResourceCollection) *ListEventsFilters {
	s.ResourceCollection = v
	return s
}

type ListEventsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// A ListEventsFilters object used to specify which events to return.
	//
	// Filters is a required field
	Filters *ListEventsFilters `type:"structure" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventsInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListEventsInput) SetAccountId(v string) *ListEventsInput {
	s.AccountId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListEventsInput) SetFilters(v *ListEventsFilters) *ListEventsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventsInput) SetMaxResults(v int64) *ListEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsInput) SetNextToken(v string) *ListEventsInput {
	s.NextToken = &v
	return s
}

type ListEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the requested events.
	//
	// Events is a required field
	Events []*Event `type:"list" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListEventsOutput) SetEvents(v []*Event) *ListEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsOutput) SetNextToken(v string) *ListEventsOutput {
	s.NextToken = &v
	return s
}

// Used to filter for insights that have any status.
type ListInsightsAnyStatusFilter struct {
	_ struct{} `type:"structure"`

	// A time range used to specify when the behavior of the filtered insights started.
	//
	// StartTimeRange is a required field
	StartTimeRange *StartTimeRange `type:"structure" required:"true"`

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsAnyStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsAnyStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsAnyStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsAnyStatusFilter"}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *ListInsightsAnyStatusFilter) SetStartTimeRange(v *StartTimeRange) *ListInsightsAnyStatusFilter {
	s.StartTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *ListInsightsAnyStatusFilter) SetType(v string) *ListInsightsAnyStatusFilter {
	s.Type = &v
	return s
}

// Used to filter for insights that have the status CLOSED.
type ListInsightsClosedStatusFilter struct {
	_ struct{} `type:"structure"`

	// A time range used to specify when the behavior of the filtered insights ended.
	//
	// EndTimeRange is a required field
	EndTimeRange *EndTimeRange `type:"structure" required:"true"`

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsClosedStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsClosedStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsClosedStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsClosedStatusFilter"}
	if s.EndTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTimeRange sets the EndTimeRange field's value.
func (s *ListInsightsClosedStatusFilter) SetEndTimeRange(v *EndTimeRange) *ListInsightsClosedStatusFilter {
	s.EndTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *ListInsightsClosedStatusFilter) SetType(v string) *ListInsightsClosedStatusFilter {
	s.Type = &v
	return s
}

type ListInsightsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// A filter used to filter the returned insights by their status. You can specify
	// one status filter.
	//
	// StatusFilter is a required field
	StatusFilter *ListInsightsStatusFilter `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StatusFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusFilter"))
	}
	if s.StatusFilter != nil {
		if err := s.StatusFilter.Validate(); err != nil {
			invalidParams.AddNested("StatusFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInsightsInput) SetMaxResults(v int64) *ListInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsInput) SetNextToken(v string) *ListInsightsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListInsightsInput) SetStatusFilter(v *ListInsightsStatusFilter) *ListInsightsInput {
	s.StatusFilter = v
	return s
}

// Used to filter for insights that have the status ONGOING.
type ListInsightsOngoingStatusFilter struct {
	_ struct{} `type:"structure"`

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsOngoingStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsOngoingStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsOngoingStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsOngoingStatusFilter"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *ListInsightsOngoingStatusFilter) SetType(v string) *ListInsightsOngoingStatusFilter {
	s.Type = &v
	return s
}

type ListInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// The returned list of proactive insights.
	ProactiveInsights []*ProactiveInsightSummary `type:"list"`

	// The returned list of reactive insights.
	ReactiveInsights []*ReactiveInsightSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsOutput) SetNextToken(v string) *ListInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *ListInsightsOutput) SetProactiveInsights(v []*ProactiveInsightSummary) *ListInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *ListInsightsOutput) SetReactiveInsights(v []*ReactiveInsightSummary) *ListInsightsOutput {
	s.ReactiveInsights = v
	return s
}

// A filter used by ListInsights to specify which insights to return.
type ListInsightsStatusFilter struct {
	_ struct{} `type:"structure"`

	// A ListInsightsAnyStatusFilter that specifies insights of any status that
	// are either REACTIVE or PROACTIVE.
	Any *ListInsightsAnyStatusFilter `type:"structure"`

	// A ListInsightsClosedStatusFilter that specifies closed insights that are
	// either REACTIVE or PROACTIVE.
	Closed *ListInsightsClosedStatusFilter `type:"structure"`

	// A ListInsightsAnyStatusFilter that specifies ongoing insights that are either
	// REACTIVE or PROACTIVE.
	Ongoing *ListInsightsOngoingStatusFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsStatusFilter"}
	if s.Any != nil {
		if err := s.Any.Validate(); err != nil {
			invalidParams.AddNested("Any", err.(request.ErrInvalidParams))
		}
	}
	if s.Closed != nil {
		if err := s.Closed.Validate(); err != nil {
			invalidParams.AddNested("Closed", err.(request.ErrInvalidParams))
		}
	}
	if s.Ongoing != nil {
		if err := s.Ongoing.Validate(); err != nil {
			invalidParams.AddNested("Ongoing", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAny sets the Any field's value.
func (s *ListInsightsStatusFilter) SetAny(v *ListInsightsAnyStatusFilter) *ListInsightsStatusFilter {
	s.Any = v
	return s
}

// SetClosed sets the Closed field's value.
func (s *ListInsightsStatusFilter) SetClosed(v *ListInsightsClosedStatusFilter) *ListInsightsStatusFilter {
	s.Closed = v
	return s
}

// SetOngoing sets the Ongoing field's value.
func (s *ListInsightsStatusFilter) SetOngoing(v *ListInsightsOngoingStatusFilter) *ListInsightsStatusFilter {
	s.Ongoing = v
	return s
}

// Filters to determine which monitored resources you want to retrieve. You
// can filter by resource type or resource permission status.
type ListMonitoredResourcesFilters struct {
	_ struct{} `type:"structure"`

	// The permission status of a resource.
	//
	// ResourcePermission is a required field
	ResourcePermission *string `type:"string" required:"true" enum:"ResourcePermission"`

	// The type of resource that you wish to retrieve, such as log groups.
	//
	// ResourceTypeFilters is a required field
	ResourceTypeFilters []*string `type:"list" required:"true" enum:"ResourceTypeFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitoredResourcesFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitoredResourcesFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMonitoredResourcesFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMonitoredResourcesFilters"}
	if s.ResourcePermission == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcePermission"))
	}
	if s.ResourceTypeFilters == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTypeFilters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourcePermission sets the ResourcePermission field's value.
func (s *ListMonitoredResourcesFilters) SetResourcePermission(v string) *ListMonitoredResourcesFilters {
	s.ResourcePermission = &v
	return s
}

// SetResourceTypeFilters sets the ResourceTypeFilters field's value.
func (s *ListMonitoredResourcesFilters) SetResourceTypeFilters(v []*string) *ListMonitoredResourcesFilters {
	s.ResourceTypeFilters = v
	return s
}

type ListMonitoredResourcesInput struct {
	_ struct{} `type:"structure"`

	// Filters to determine which monitored resources you want to retrieve. You
	// can filter by resource type or resource permission status.
	Filters *ListMonitoredResourcesFilters `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitoredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitoredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMonitoredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMonitoredResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListMonitoredResourcesInput) SetFilters(v *ListMonitoredResourcesFilters) *ListMonitoredResourcesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMonitoredResourcesInput) SetMaxResults(v int64) *ListMonitoredResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitoredResourcesInput) SetNextToken(v string) *ListMonitoredResourcesInput {
	s.NextToken = &v
	return s
}

type ListMonitoredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resource that is being monitored, including the name
	// of the resource, the type of resource, and whether or not permission is given
	// to DevOps Guru to access that resource.
	//
	// MonitoredResourceIdentifiers is a required field
	MonitoredResourceIdentifiers []*MonitoredResourceIdentifier `type:"list" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitoredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitoredResourcesOutput) GoString() string {
	return s.String()
}

// SetMonitoredResourceIdentifiers sets the MonitoredResourceIdentifiers field's value.
func (s *ListMonitoredResourcesOutput) SetMonitoredResourceIdentifiers(v []*MonitoredResourceIdentifier) *ListMonitoredResourcesOutput {
	s.MonitoredResourceIdentifiers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitoredResourcesOutput) SetNextToken(v string) *ListMonitoredResourcesOutput {
	s.NextToken = &v
	return s
}

type ListNotificationChannelsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationChannelsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationChannelsInput) SetNextToken(v string) *ListNotificationChannelsInput {
	s.NextToken = &v
	return s
}

type ListNotificationChannelsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains the requested notification channels.
	Channels []*NotificationChannel `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListNotificationChannelsOutput) SetChannels(v []*NotificationChannel) *ListNotificationChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationChannelsOutput) SetNextToken(v string) *ListNotificationChannelsOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationInsightsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountIds []*string `type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// The ID of the organizational unit.
	OrganizationalUnitIds []*string `type:"list"`

	// A filter used by ListInsights to specify which insights to return.
	//
	// StatusFilter is a required field
	StatusFilter *ListInsightsStatusFilter `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StatusFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusFilter"))
	}
	if s.StatusFilter != nil {
		if err := s.StatusFilter.Validate(); err != nil {
			invalidParams.AddNested("StatusFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *ListOrganizationInsightsInput) SetAccountIds(v []*string) *ListOrganizationInsightsInput {
	s.AccountIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationInsightsInput) SetMaxResults(v int64) *ListOrganizationInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationInsightsInput) SetNextToken(v string) *ListOrganizationInsightsInput {
	s.NextToken = &v
	return s
}

// SetOrganizationalUnitIds sets the OrganizationalUnitIds field's value.
func (s *ListOrganizationInsightsInput) SetOrganizationalUnitIds(v []*string) *ListOrganizationInsightsInput {
	s.OrganizationalUnitIds = v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListOrganizationInsightsInput) SetStatusFilter(v *ListInsightsStatusFilter) *ListOrganizationInsightsInput {
	s.StatusFilter = v
	return s
}

type ListOrganizationInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	ProactiveInsights []*ProactiveOrganizationInsightSummary `type:"list"`

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	ReactiveInsights []*ReactiveOrganizationInsightSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationInsightsOutput) SetNextToken(v string) *ListOrganizationInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *ListOrganizationInsightsOutput) SetProactiveInsights(v []*ProactiveOrganizationInsightSummary) *ListOrganizationInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *ListOrganizationInsightsOutput) SetReactiveInsights(v []*ReactiveOrganizationInsightSummary) *ListOrganizationInsightsOutput {
	s.ReactiveInsights = v
	return s
}

type ListRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// The ID of the requested insight.
	//
	// InsightId is a required field
	InsightId *string `min:"1" type:"string" required:"true"`

	// A locale that specifies the language to use for recommendations.
	Locale *string `type:"string" enum:"Locale"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationsInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.InsightId == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightId"))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListRecommendationsInput) SetAccountId(v string) *ListRecommendationsInput {
	s.AccountId = &v
	return s
}

// SetInsightId sets the InsightId field's value.
func (s *ListRecommendationsInput) SetInsightId(v string) *ListRecommendationsInput {
	s.InsightId = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *ListRecommendationsInput) SetLocale(v string) *ListRecommendationsInput {
	s.Locale = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsInput) SetNextToken(v string) *ListRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An array of the requested recommendations.
	Recommendations []*Recommendation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsOutput) SetNextToken(v string) *ListRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *ListRecommendationsOutput) SetRecommendations(v []*Recommendation) *ListRecommendationsOutput {
	s.Recommendations = v
	return s
}

// Information about an anomalous log event found within a log group.
type LogAnomalyClass struct {
	_ struct{} `type:"structure"`

	// The explanation for why the log event is considered an anomaly.
	Explanation *string `min:"1" type:"string"`

	// The token where the anomaly was detected. This may refer to an exception
	// or another location, or it may be blank for log anomalies such as format
	// anomalies.
	LogAnomalyToken *string `min:"1" type:"string"`

	// The type of log anomaly that has been detected.
	LogAnomalyType *string `type:"string" enum:"LogAnomalyType"`

	// The ID of the log event.
	LogEventId *string `min:"1" type:"string"`

	// The time of the first occurrence of the anomalous log event.
	LogEventTimestamp *time.Time `type:"timestamp"`

	// The name of the Amazon CloudWatch log stream that the anomalous log event
	// belongs to. A log stream is a sequence of log events that share the same
	// source.
	LogStreamName *string `min:"1" type:"string"`

	// The number of log lines where this anomalous log event occurs.
	NumberOfLogLinesOccurrences *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogAnomalyClass) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogAnomalyClass) GoString() string {
	return s.String()
}

// SetExplanation sets the Explanation field's value.
func (s *LogAnomalyClass) SetExplanation(v string) *LogAnomalyClass {
	s.Explanation = &v
	return s
}

// SetLogAnomalyToken sets the LogAnomalyToken field's value.
func (s *LogAnomalyClass) SetLogAnomalyToken(v string) *LogAnomalyClass {
	s.LogAnomalyToken = &v
	return s
}

// SetLogAnomalyType sets the LogAnomalyType field's value.
func (s *LogAnomalyClass) SetLogAnomalyType(v string) *LogAnomalyClass {
	s.LogAnomalyType = &v
	return s
}

// SetLogEventId sets the LogEventId field's value.
func (s *LogAnomalyClass) SetLogEventId(v string) *LogAnomalyClass {
	s.LogEventId = &v
	return s
}

// SetLogEventTimestamp sets the LogEventTimestamp field's value.
func (s *LogAnomalyClass) SetLogEventTimestamp(v time.Time) *LogAnomalyClass {
	s.LogEventTimestamp = &v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *LogAnomalyClass) SetLogStreamName(v string) *LogAnomalyClass {
	s.LogStreamName = &v
	return s
}

// SetNumberOfLogLinesOccurrences sets the NumberOfLogLinesOccurrences field's value.
func (s *LogAnomalyClass) SetNumberOfLogLinesOccurrences(v int64) *LogAnomalyClass {
	s.NumberOfLogLinesOccurrences = &v
	return s
}

// A cluster of similar anomalous log events found within a log group.
type LogAnomalyShowcase struct {
	_ struct{} `type:"structure"`

	// A list of anomalous log events that may be related.
	LogAnomalyClasses []*LogAnomalyClass `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogAnomalyShowcase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogAnomalyShowcase) GoString() string {
	return s.String()
}

// SetLogAnomalyClasses sets the LogAnomalyClasses field's value.
func (s *LogAnomalyShowcase) SetLogAnomalyClasses(v []*LogAnomalyClass) *LogAnomalyShowcase {
	s.LogAnomalyClasses = v
	return s
}

// Information about the integration of DevOps Guru with CloudWatch log groups
// for log anomaly detection.
type LogsAnomalyDetectionIntegration struct {
	_ struct{} `type:"structure"`

	// Specifies if DevOps Guru is configured to perform log anomaly detection on
	// CloudWatch log groups.
	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogsAnomalyDetectionIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogsAnomalyDetectionIntegration) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *LogsAnomalyDetectionIntegration) SetOptInStatus(v string) *LogsAnomalyDetectionIntegration {
	s.OptInStatus = &v
	return s
}

// Information about the integration of DevOps Guru with CloudWatch log groups
// for log anomaly detection. You can use this to update the configuration.
type LogsAnomalyDetectionIntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Specifies if DevOps Guru is configured to perform log anomaly detection on
	// CloudWatch log groups.
	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogsAnomalyDetectionIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogsAnomalyDetectionIntegrationConfig) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *LogsAnomalyDetectionIntegrationConfig) SetOptInStatus(v string) *LogsAnomalyDetectionIntegrationConfig {
	s.OptInStatus = &v
	return s
}

// Information about the resource that is being monitored, including the name
// of the resource, the type of resource, and whether or not permission is given
// to DevOps Guru to access that resource.
type MonitoredResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The time at which DevOps Guru last updated this resource.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the resource being monitored.
	MonitoredResourceName *string `min:"1" type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The permission status of a resource.
	ResourcePermission *string `type:"string" enum:"ResourcePermission"`

	// The type of resource being monitored.
	Type *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoredResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoredResourceIdentifier) GoString() string {
	return s.String()
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *MonitoredResourceIdentifier) SetLastUpdated(v time.Time) *MonitoredResourceIdentifier {
	s.LastUpdated = &v
	return s
}

// SetMonitoredResourceName sets the MonitoredResourceName field's value.
func (s *MonitoredResourceIdentifier) SetMonitoredResourceName(v string) *MonitoredResourceIdentifier {
	s.MonitoredResourceName = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *MonitoredResourceIdentifier) SetResourceCollection(v *ResourceCollection) *MonitoredResourceIdentifier {
	s.ResourceCollection = v
	return s
}

// SetResourcePermission sets the ResourcePermission field's value.
func (s *MonitoredResourceIdentifier) SetResourcePermission(v string) *MonitoredResourceIdentifier {
	s.ResourcePermission = &v
	return s
}

// SetType sets the Type field's value.
func (s *MonitoredResourceIdentifier) SetType(v string) *MonitoredResourceIdentifier {
	s.Type = &v
	return s
}

// Information about a notification channel. A notification channel is used
// to notify you when DevOps Guru creates an insight. The one supported notification
// channel is Amazon Simple Notification Service (Amazon SNS).
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. DevOps Guru only supports standard SNS topics. For more
// information, see Permissions for cross account Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. For more information, see Permissions for cross account
// Amazon SNS topics.
//
// If you use an Amazon SNS topic that is encrypted by an Amazon Web Services
// Key Management Service customer-managed key (CMK), then you must add permissions
// to the CMK. For more information, see Permissions for Amazon Web Services
// KMS–encrypted Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type NotificationChannel struct {
	_ struct{} `type:"structure"`

	// A NotificationChannelConfig object that contains information about configured
	// notification channels.
	Config *NotificationChannelConfig `type:"structure"`

	// The ID of a notification channel.
	Id *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannel) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *NotificationChannel) SetConfig(v *NotificationChannelConfig) *NotificationChannel {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *NotificationChannel) SetId(v string) *NotificationChannel {
	s.Id = &v
	return s
}

// Information about notification channels you have configured with DevOps Guru.
// The one supported notification channel is Amazon Simple Notification Service
// (Amazon SNS).
type NotificationChannelConfig struct {
	_ struct{} `type:"structure"`

	// The filter configurations for the Amazon SNS notification topic you use with
	// DevOps Guru. If you do not provide filter configurations, the default configurations
	// are to receive notifications for all message types of High or Medium severity.
	Filters *NotificationFilterConfig `type:"structure"`

	// Information about a notification channel configured in DevOps Guru to send
	// notifications when insights are created.
	//
	// If you use an Amazon SNS topic in another account, you must attach a policy
	// to it that grants DevOps Guru permission to it notifications. DevOps Guru
	// adds the required policy on your behalf to send notifications using Amazon
	// SNS in your account. DevOps Guru only supports standard SNS topics. For more
	// information, see Permissions for cross account Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
	//
	// If you use an Amazon SNS topic in another account, you must attach a policy
	// to it that grants DevOps Guru permission to it notifications. DevOps Guru
	// adds the required policy on your behalf to send notifications using Amazon
	// SNS in your account. For more information, see Permissions for cross account
	// Amazon SNS topics.
	//
	// If you use an Amazon SNS topic that is encrypted by an Amazon Web Services
	// Key Management Service customer-managed key (CMK), then you must add permissions
	// to the CMK. For more information, see Permissions for Amazon Web Services
	// KMS–encrypted Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
	//
	// Sns is a required field
	Sns *SnsChannelConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannelConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannelConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationChannelConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationChannelConfig"}
	if s.Sns == nil {
		invalidParams.Add(request.NewErrParamRequired("Sns"))
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *NotificationChannelConfig) SetFilters(v *NotificationFilterConfig) *NotificationChannelConfig {
	s.Filters = v
	return s
}

// SetSns sets the Sns field's value.
func (s *NotificationChannelConfig) SetSns(v *SnsChannelConfig) *NotificationChannelConfig {
	s.Sns = v
	return s
}

// The filter configurations for the Amazon SNS notification topic you use with
// DevOps Guru. You can choose to specify which events or message types to receive
// notifications for. You can also choose to specify which severity levels to
// receive notifications for.
type NotificationFilterConfig struct {
	_ struct{} `type:"structure"`

	// The events that you want to receive notifications for. For example, you can
	// choose to receive notifications only when the severity level is upgraded
	// or a new insight is created.
	MessageTypes []*string `type:"list" enum:"NotificationMessageType"`

	// The severity levels that you want to receive notifications for. For example,
	// you can choose to receive notifications only for insights with HIGH and MEDIUM
	// severity levels. For more information, see Understanding insight severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities).
	Severities []*string `type:"list" enum:"InsightSeverity"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationFilterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationFilterConfig) GoString() string {
	return s.String()
}

// SetMessageTypes sets the MessageTypes field's value.
func (s *NotificationFilterConfig) SetMessageTypes(v []*string) *NotificationFilterConfig {
	s.MessageTypes = v
	return s
}

// SetSeverities sets the Severities field's value.
func (s *NotificationFilterConfig) SetSeverities(v []*string) *NotificationFilterConfig {
	s.Severities = v
	return s
}

// Information about whether DevOps Guru is configured to create an OpsItem
// in Amazon Web Services Systems Manager OpsCenter for each created insight.
type OpsCenterIntegration struct {
	_ struct{} `type:"structure"`

	// Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems
	// Manager OpsItem for each created insight.
	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpsCenterIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpsCenterIntegration) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *OpsCenterIntegration) SetOptInStatus(v string) *OpsCenterIntegration {
	s.OptInStatus = &v
	return s
}

// Information about whether DevOps Guru is configured to create an OpsItem
// in Amazon Web Services Systems Manager OpsCenter for each created insight.
// You can use this to update the configuration.
type OpsCenterIntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems
	// Manager OpsItem for each created insight.
	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpsCenterIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpsCenterIntegrationConfig) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *OpsCenterIntegrationConfig) SetOptInStatus(v string) *OpsCenterIntegrationConfig {
	s.OptInStatus = &v
	return s
}

// A logical grouping of Performance Insights metrics for a related subject
// area. For example, the db.sql dimension group consists of the following dimensions:
// db.sql.id, db.sql.db_id, db.sql.statement, and db.sql.tokenized_id.
//
// Each response element returns a maximum of 500 bytes. For larger elements,
// such as SQL statements, only the first 500 bytes are returned.
//
// Amazon RDS Performance Insights enables you to monitor and explore different
// dimensions of database load based on data captured from a running DB instance.
// DB load is measured as average active sessions. Performance Insights provides
// the data to API consumers as a two-dimensional time-series dataset. The time
// dimension provides DB load data for each time point in the queried time range.
// Each time point decomposes overall load in relation to the requested dimensions,
// measured at that time point. Examples include SQL, Wait event, User, and
// Host.
//
//   - To learn more about Performance Insights and Amazon Aurora DB instances,
//     go to the Amazon Aurora User Guide (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
//
//   - To learn more about Performance Insights and Amazon RDS DB instances,
//     go to the Amazon RDS User Guide (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
type PerformanceInsightsMetricDimensionGroup struct {
	_ struct{} `type:"structure"`

	// A list of specific dimensions from a dimension group. If this parameter is
	// not present, then it signifies that all of the dimensions in the group were
	// requested or are present in the response.
	//
	// Valid values for elements in the Dimensions array are:
	//
	//    * db.application.name - The name of the application that is connected
	//    to the database (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	//    * db.host.id - The host ID of the connected client (all engines)
	//
	//    * db.host.name - The host name of the connected client (all engines)
	//
	//    * db.name - The name of the database to which the client is connected
	//    (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS
	//    MySQL, and MariaDB)
	//
	//    * db.session_type.name - The type of the current session (only Aurora
	//    PostgreSQL and RDS PostgreSQL)
	//
	//    * db.sql.id - The SQL ID generated by Performance Insights (all engines)
	//
	//    * db.sql.db_id - The SQL ID generated by the database (all engines)
	//
	//    * db.sql.statement - The SQL text that is being executed (all engines)
	//
	//    * db.sql.tokenized_id
	//
	//    * db.sql_tokenized.id - The SQL digest ID generated by Performance Insights
	//    (all engines)
	//
	//    * db.sql_tokenized.db_id - SQL digest ID generated by the database (all
	//    engines)
	//
	//    * db.sql_tokenized.statement - The SQL digest text (all engines)
	//
	//    * db.user.id - The ID of the user logged in to the database (all engines)
	//
	//    * db.user.name - The name of the user logged in to the database (all engines)
	//
	//    * db.wait_event.name - The event for which the backend is waiting (all
	//    engines)
	//
	//    * db.wait_event.type - The type of event for which the backend is waiting
	//    (all engines)
	//
	//    * db.wait_event_type.name - The name of the event type for which the backend
	//    is waiting (all engines)
	Dimensions []*string `type:"list"`

	// The name of the dimension group. Its valid values are:
	//
	//    * db - The name of the database to which the client is connected (only
	//    Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL,
	//    and MariaDB)
	//
	//    * db.application - The name of the application that is connected to the
	//    database (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	//    * db.host - The host name of the connected client (all engines)
	//
	//    * db.session_type - The type of the current session (only Aurora PostgreSQL
	//    and RDS PostgreSQL)
	//
	//    * db.sql - The SQL that is currently executing (all engines)
	//
	//    * db.sql_tokenized - The SQL digest (all engines)
	//
	//    * db.wait_event - The event for which the database backend is waiting
	//    (all engines)
	//
	//    * db.wait_event_type - The type of event for which the database backend
	//    is waiting (all engines)
	//
	//    * db.user - The user logged in to the database (all engines)
	Group *string `type:"string"`

	// The maximum number of items to fetch for this dimension group.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetricDimensionGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetricDimensionGroup) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *PerformanceInsightsMetricDimensionGroup) SetDimensions(v []*string) *PerformanceInsightsMetricDimensionGroup {
	s.Dimensions = v
	return s
}

// SetGroup sets the Group field's value.
func (s *PerformanceInsightsMetricDimensionGroup) SetGroup(v string) *PerformanceInsightsMetricDimensionGroup {
	s.Group = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *PerformanceInsightsMetricDimensionGroup) SetLimit(v int64) *PerformanceInsightsMetricDimensionGroup {
	s.Limit = &v
	return s
}

// A single query to be processed. Use these parameters to query the Performance
// Insights GetResourceMetrics API to retrieve the metrics for an anomaly. For
// more information, see GetResourceMetrics (https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetResourceMetrics.html)
// in the Amazon RDS Performance Insights API Reference.
//
// Amazon RDS Performance Insights enables you to monitor and explore different
// dimensions of database load based on data captured from a running DB instance.
// DB load is measured as average active sessions. Performance Insights provides
// the data to API consumers as a two-dimensional time-series dataset. The time
// dimension provides DB load data for each time point in the queried time range.
// Each time point decomposes overall load in relation to the requested dimensions,
// measured at that time point. Examples include SQL, Wait event, User, and
// Host.
//
//   - To learn more about Performance Insights and Amazon Aurora DB instances,
//     go to the Amazon Aurora User Guide (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
//
//   - To learn more about Performance Insights and Amazon RDS DB instances,
//     go to the Amazon RDS User Guide (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
type PerformanceInsightsMetricQuery struct {
	_ struct{} `type:"structure"`

	// One or more filters to apply to a Performance Insights GetResourceMetrics
	// API query. Restrictions:
	//
	//    * Any number of filters by the same dimension, as specified in the GroupBy
	//    parameter.
	//
	//    * A single filter for any other dimension in this dimension group.
	Filter map[string]*string `type:"map"`

	// The specification for how to aggregate the data points from a Performance
	// Insights GetResourceMetrics API query. The Performance Insights query returns
	// all of the dimensions within that group, unless you provide the names of
	// specific dimensions within that group. You can also request that Performance
	// Insights return a limited number of values for a dimension.
	GroupBy *PerformanceInsightsMetricDimensionGroup `type:"structure"`

	// The name of the meteric used used when querying an Performance Insights GetResourceMetrics
	// API for anomaly metrics.
	//
	// Valid values for Metric are:
	//
	//    * db.load.avg - a scaled representation of the number of active sessions
	//    for the database engine.
	//
	//    * db.sampledload.avg - the raw number of active sessions for the database
	//    engine.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the
	// number of active sessions is greater than the internal threshold, Performance
	// Insights samples the active sessions, with db.load.avg showing the scaled
	// values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	Metric *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetricQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetricQuery) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *PerformanceInsightsMetricQuery) SetFilter(v map[string]*string) *PerformanceInsightsMetricQuery {
	s.Filter = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *PerformanceInsightsMetricQuery) SetGroupBy(v *PerformanceInsightsMetricDimensionGroup) *PerformanceInsightsMetricQuery {
	s.GroupBy = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *PerformanceInsightsMetricQuery) SetMetric(v string) *PerformanceInsightsMetricQuery {
	s.Metric = &v
	return s
}

// Details about Performance Insights metrics.
//
// Amazon RDS Performance Insights enables you to monitor and explore different
// dimensions of database load based on data captured from a running DB instance.
// DB load is measured as average active sessions. Performance Insights provides
// the data to API consumers as a two-dimensional time-series dataset. The time
// dimension provides DB load data for each time point in the queried time range.
// Each time point decomposes overall load in relation to the requested dimensions,
// measured at that time point. Examples include SQL, Wait event, User, and
// Host.
//
//   - To learn more about Performance Insights and Amazon Aurora DB instances,
//     go to the Amazon Aurora User Guide (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
//
//   - To learn more about Performance Insights and Amazon RDS DB instances,
//     go to the Amazon RDS User Guide (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
type PerformanceInsightsMetricsDetail struct {
	_ struct{} `type:"structure"`

	// The name used for a specific Performance Insights metric.
	MetricDisplayName *string `type:"string"`

	// A single query to be processed for the metric. For more information, see
	// PerformanceInsightsMetricQuery (https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html) .
	MetricQuery *PerformanceInsightsMetricQuery `type:"structure"`

	// For more information, see PerformanceInsightsReferenceData (https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html) .
	ReferenceData []*PerformanceInsightsReferenceData `type:"list"`

	// The metric statistics during the anomalous period detected by DevOps Guru;
	StatsAtAnomaly []*PerformanceInsightsStat `type:"list"`

	// Typical metric statistics that are not considered anomalous. When DevOps
	// Guru analyzes metrics, it compares them to StatsAtBaseline to help determine
	// if they are anomalous.
	StatsAtBaseline []*PerformanceInsightsStat `type:"list"`

	// The unit of measure for a metric. For example, a session or a process.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetricsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetricsDetail) GoString() string {
	return s.String()
}

// SetMetricDisplayName sets the MetricDisplayName field's value.
func (s *PerformanceInsightsMetricsDetail) SetMetricDisplayName(v string) *PerformanceInsightsMetricsDetail {
	s.MetricDisplayName = &v
	return s
}

// SetMetricQuery sets the MetricQuery field's value.
func (s *PerformanceInsightsMetricsDetail) SetMetricQuery(v *PerformanceInsightsMetricQuery) *PerformanceInsightsMetricsDetail {
	s.MetricQuery = v
	return s
}

// SetReferenceData sets the ReferenceData field's value.
func (s *PerformanceInsightsMetricsDetail) SetReferenceData(v []*PerformanceInsightsReferenceData) *PerformanceInsightsMetricsDetail {
	s.ReferenceData = v
	return s
}

// SetStatsAtAnomaly sets the StatsAtAnomaly field's value.
func (s *PerformanceInsightsMetricsDetail) SetStatsAtAnomaly(v []*PerformanceInsightsStat) *PerformanceInsightsMetricsDetail {
	s.StatsAtAnomaly = v
	return s
}

// SetStatsAtBaseline sets the StatsAtBaseline field's value.
func (s *PerformanceInsightsMetricsDetail) SetStatsAtBaseline(v []*PerformanceInsightsStat) *PerformanceInsightsMetricsDetail {
	s.StatsAtBaseline = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *PerformanceInsightsMetricsDetail) SetUnit(v string) *PerformanceInsightsMetricsDetail {
	s.Unit = &v
	return s
}

// Reference scalar values and other metrics that DevOps Guru displays on a
// graph in its console along with the actual metrics it analyzed. Compare these
// reference values to your actual metrics to help you understand anomalous
// behavior that DevOps Guru detected.
type PerformanceInsightsReferenceComparisonValues struct {
	_ struct{} `type:"structure"`

	// A metric that DevOps Guru compares to actual metric values. This reference
	// metric is used to determine if an actual metric should be considered anomalous.
	ReferenceMetric *PerformanceInsightsReferenceMetric `type:"structure"`

	// A scalar value DevOps Guru for a metric that DevOps Guru compares to actual
	// metric values. This reference value is used to determine if an actual metric
	// value should be considered anomalous.
	ReferenceScalar *PerformanceInsightsReferenceScalar `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceComparisonValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceComparisonValues) GoString() string {
	return s.String()
}

// SetReferenceMetric sets the ReferenceMetric field's value.
func (s *PerformanceInsightsReferenceComparisonValues) SetReferenceMetric(v *PerformanceInsightsReferenceMetric) *PerformanceInsightsReferenceComparisonValues {
	s.ReferenceMetric = v
	return s
}

// SetReferenceScalar sets the ReferenceScalar field's value.
func (s *PerformanceInsightsReferenceComparisonValues) SetReferenceScalar(v *PerformanceInsightsReferenceScalar) *PerformanceInsightsReferenceComparisonValues {
	s.ReferenceScalar = v
	return s
}

// Reference data used to evaluate Performance Insights to determine if its
// performance is anomalous or not.
type PerformanceInsightsReferenceData struct {
	_ struct{} `type:"structure"`

	// The specific reference values used to evaluate the Performance Insights.
	// For more information, see PerformanceInsightsReferenceComparisonValues (https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html) .
	ComparisonValues *PerformanceInsightsReferenceComparisonValues `type:"structure"`

	// The name of the reference data.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceData) GoString() string {
	return s.String()
}

// SetComparisonValues sets the ComparisonValues field's value.
func (s *PerformanceInsightsReferenceData) SetComparisonValues(v *PerformanceInsightsReferenceComparisonValues) *PerformanceInsightsReferenceData {
	s.ComparisonValues = v
	return s
}

// SetName sets the Name field's value.
func (s *PerformanceInsightsReferenceData) SetName(v string) *PerformanceInsightsReferenceData {
	s.Name = &v
	return s
}

// Information about a reference metric used to evaluate Performance Insights.
type PerformanceInsightsReferenceMetric struct {
	_ struct{} `type:"structure"`

	// A query to be processed on the metric.
	MetricQuery *PerformanceInsightsMetricQuery `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceMetric) GoString() string {
	return s.String()
}

// SetMetricQuery sets the MetricQuery field's value.
func (s *PerformanceInsightsReferenceMetric) SetMetricQuery(v *PerformanceInsightsMetricQuery) *PerformanceInsightsReferenceMetric {
	s.MetricQuery = v
	return s
}

// A reference value to compare Performance Insights metrics against to determine
// if the metrics demonstrate anomalous behavior.
type PerformanceInsightsReferenceScalar struct {
	_ struct{} `type:"structure"`

	// The reference value.
	Value *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceScalar) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsReferenceScalar) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *PerformanceInsightsReferenceScalar) SetValue(v float64) *PerformanceInsightsReferenceScalar {
	s.Value = &v
	return s
}

// A statistic in a Performance Insights collection.
type PerformanceInsightsStat struct {
	_ struct{} `type:"structure"`

	// The statistic type.
	Type *string `type:"string"`

	// The value of the statistic.
	Value *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsStat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsStat) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *PerformanceInsightsStat) SetType(v string) *PerformanceInsightsStat {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PerformanceInsightsStat) SetValue(v float64) *PerformanceInsightsStat {
	s.Value = &v
	return s
}

// The time range during which anomalous behavior in a proactive anomaly or
// an insight is expected to occur.
type PredictionTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the behavior in a proactive insight is expected to end.
	EndTime *time.Time `type:"timestamp"`

	// The time range during which a metric limit is expected to be exceeded. This
	// applies to proactive insights only.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictionTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictionTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *PredictionTimeRange) SetEndTime(v time.Time) *PredictionTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PredictionTimeRange) SetStartTime(v time.Time) *PredictionTimeRange {
	s.StartTime = &v
	return s
}

// Information about an anomaly. This object is returned by ListAnomalies.
type ProactiveAnomaly struct {
	_ struct{} `type:"structure"`

	// An AnomalyReportedTimeRange object that specifies the time range between
	// when the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange `type:"structure"`

	// Information about a resource in which DevOps Guru detected anomalous behavior.
	AnomalyResources []*AnomalyResource `type:"list"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of a proactive anomaly.
	Id *string `min:"1" type:"string"`

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding
	// this threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64 `type:"double"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The metadata for the anomaly.
	SourceMetadata *AnomalySourceMetadata `type:"structure"`

	// The status of a proactive anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveAnomaly) GoString() string {
	return s.String()
}

// SetAnomalyReportedTimeRange sets the AnomalyReportedTimeRange field's value.
func (s *ProactiveAnomaly) SetAnomalyReportedTimeRange(v *AnomalyReportedTimeRange) *ProactiveAnomaly {
	s.AnomalyReportedTimeRange = v
	return s
}

// SetAnomalyResources sets the AnomalyResources field's value.
func (s *ProactiveAnomaly) SetAnomalyResources(v []*AnomalyResource) *ProactiveAnomaly {
	s.AnomalyResources = v
	return s
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ProactiveAnomaly) SetAnomalyTimeRange(v *AnomalyTimeRange) *ProactiveAnomaly {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ProactiveAnomaly) SetAssociatedInsightId(v string) *ProactiveAnomaly {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveAnomaly) SetId(v string) *ProactiveAnomaly {
	s.Id = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ProactiveAnomaly) SetLimit(v float64) *ProactiveAnomaly {
	s.Limit = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveAnomaly) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveAnomaly {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveAnomaly) SetResourceCollection(v *ResourceCollection) *ProactiveAnomaly {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveAnomaly) SetSeverity(v string) *ProactiveAnomaly {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ProactiveAnomaly) SetSourceDetails(v *AnomalySourceDetails) *ProactiveAnomaly {
	s.SourceDetails = v
	return s
}

// SetSourceMetadata sets the SourceMetadata field's value.
func (s *ProactiveAnomaly) SetSourceMetadata(v *AnomalySourceMetadata) *ProactiveAnomaly {
	s.SourceMetadata = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveAnomaly) SetStatus(v string) *ProactiveAnomaly {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ProactiveAnomaly) SetUpdateTime(v time.Time) *ProactiveAnomaly {
	s.UpdateTime = &v
	return s
}

// Details about a proactive anomaly. This object is returned by DescribeAnomaly.
type ProactiveAnomalySummary struct {
	_ struct{} `type:"structure"`

	// An AnomalyReportedTimeRange object that specifies the time range between
	// when the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange `type:"structure"`

	// Information about a resource in which DevOps Guru detected anomalous behavior.
	AnomalyResources []*AnomalyResource `type:"list"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of the anomaly.
	Id *string `min:"1" type:"string"`

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding
	// this threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64 `type:"double"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The metadata of the source which detects proactive anomalies.
	SourceMetadata *AnomalySourceMetadata `type:"structure"`

	// The status of the anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveAnomalySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveAnomalySummary) GoString() string {
	return s.String()
}

// SetAnomalyReportedTimeRange sets the AnomalyReportedTimeRange field's value.
func (s *ProactiveAnomalySummary) SetAnomalyReportedTimeRange(v *AnomalyReportedTimeRange) *ProactiveAnomalySummary {
	s.AnomalyReportedTimeRange = v
	return s
}

// SetAnomalyResources sets the AnomalyResources field's value.
func (s *ProactiveAnomalySummary) SetAnomalyResources(v []*AnomalyResource) *ProactiveAnomalySummary {
	s.AnomalyResources = v
	return s
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ProactiveAnomalySummary) SetAnomalyTimeRange(v *AnomalyTimeRange) *ProactiveAnomalySummary {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ProactiveAnomalySummary) SetAssociatedInsightId(v string) *ProactiveAnomalySummary {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveAnomalySummary) SetId(v string) *ProactiveAnomalySummary {
	s.Id = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ProactiveAnomalySummary) SetLimit(v float64) *ProactiveAnomalySummary {
	s.Limit = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveAnomalySummary) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveAnomalySummary {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveAnomalySummary) SetResourceCollection(v *ResourceCollection) *ProactiveAnomalySummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveAnomalySummary) SetSeverity(v string) *ProactiveAnomalySummary {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ProactiveAnomalySummary) SetSourceDetails(v *AnomalySourceDetails) *ProactiveAnomalySummary {
	s.SourceDetails = v
	return s
}

// SetSourceMetadata sets the SourceMetadata field's value.
func (s *ProactiveAnomalySummary) SetSourceMetadata(v *AnomalySourceMetadata) *ProactiveAnomalySummary {
	s.SourceMetadata = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveAnomalySummary) SetStatus(v string) *ProactiveAnomalySummary {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ProactiveAnomalySummary) SetUpdateTime(v time.Time) *ProactiveAnomalySummary {
	s.UpdateTime = &v
	return s
}

// Details about a proactive insight. This object is returned by ListInsights.
type ProactiveInsight struct {
	_ struct{} `type:"structure"`

	// Describes the proactive insight.
	Description *string `type:"string"`

	// The ID of the proactive insight.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of the proactive insight.
	Name *string `min:"1" type:"string"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the insight. For more information, see Understanding insight
	// severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The ID of the Amazon Web Services System Manager OpsItem created for this
	// insight. You must enable the creation of OpstItems insights before they are
	// created for each insight.
	SsmOpsItemId *string `min:"1" type:"string"`

	// The status of the proactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveInsight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveInsight) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ProactiveInsight) SetDescription(v string) *ProactiveInsight {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveInsight) SetId(v string) *ProactiveInsight {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ProactiveInsight) SetInsightTimeRange(v *InsightTimeRange) *ProactiveInsight {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ProactiveInsight) SetName(v string) *ProactiveInsight {
	s.Name = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveInsight) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveInsight {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveInsight) SetResourceCollection(v *ResourceCollection) *ProactiveInsight {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveInsight) SetSeverity(v string) *ProactiveInsight {
	s.Severity = &v
	return s
}

// SetSsmOpsItemId sets the SsmOpsItemId field's value.
func (s *ProactiveInsight) SetSsmOpsItemId(v string) *ProactiveInsight {
	s.SsmOpsItemId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveInsight) SetStatus(v string) *ProactiveInsight {
	s.Status = &v
	return s
}

// Details about a proactive insight. This object is returned by DescribeInsight.
type ProactiveInsightSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the Amazon Web Services resources that
	// generated this insight.
	AssociatedResourceArns []*string `type:"list"`

	// The ID of the proactive insight.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of the proactive insight.
	Name *string `min:"1" type:"string"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection `type:"structure"`

	// The severity of the insight. For more information, see Understanding insight
	// severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The status of the proactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveInsightSummary) GoString() string {
	return s.String()
}

// SetAssociatedResourceArns sets the AssociatedResourceArns field's value.
func (s *ProactiveInsightSummary) SetAssociatedResourceArns(v []*string) *ProactiveInsightSummary {
	s.AssociatedResourceArns = v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveInsightSummary) SetId(v string) *ProactiveInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ProactiveInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ProactiveInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ProactiveInsightSummary) SetName(v string) *ProactiveInsightSummary {
	s.Name = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveInsightSummary) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveInsightSummary {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveInsightSummary) SetResourceCollection(v *ResourceCollection) *ProactiveInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetServiceCollection sets the ServiceCollection field's value.
func (s *ProactiveInsightSummary) SetServiceCollection(v *ServiceCollection) *ProactiveInsightSummary {
	s.ServiceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveInsightSummary) SetSeverity(v string) *ProactiveInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveInsightSummary) SetStatus(v string) *ProactiveInsightSummary {
	s.Status = &v
	return s
}

// Details about a proactive insight. This object is returned by DescribeInsight.
type ProactiveOrganizationInsightSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// The ID of the insight summary.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of the insight summary.
	Name *string `min:"1" type:"string"`

	// The ID of the organizational unit.
	OrganizationalUnitId *string `type:"string"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection `type:"structure"`

	// An array of severity values used to search for insights. For more information,
	// see Understanding insight severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// An array of status values used to search for insights.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveOrganizationInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProactiveOrganizationInsightSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ProactiveOrganizationInsightSummary) SetAccountId(v string) *ProactiveOrganizationInsightSummary {
	s.AccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveOrganizationInsightSummary) SetId(v string) *ProactiveOrganizationInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ProactiveOrganizationInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ProactiveOrganizationInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ProactiveOrganizationInsightSummary) SetName(v string) *ProactiveOrganizationInsightSummary {
	s.Name = &v
	return s
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *ProactiveOrganizationInsightSummary) SetOrganizationalUnitId(v string) *ProactiveOrganizationInsightSummary {
	s.OrganizationalUnitId = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveOrganizationInsightSummary) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveOrganizationInsightSummary {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveOrganizationInsightSummary) SetResourceCollection(v *ResourceCollection) *ProactiveOrganizationInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetServiceCollection sets the ServiceCollection field's value.
func (s *ProactiveOrganizationInsightSummary) SetServiceCollection(v *ServiceCollection) *ProactiveOrganizationInsightSummary {
	s.ServiceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveOrganizationInsightSummary) SetSeverity(v string) *ProactiveOrganizationInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveOrganizationInsightSummary) SetStatus(v string) *ProactiveOrganizationInsightSummary {
	s.Status = &v
	return s
}

type PutFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The feedback from customers is about the recommendations in this insight.
	InsightFeedback *InsightFeedback `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFeedbackInput"}
	if s.InsightFeedback != nil {
		if err := s.InsightFeedback.Validate(); err != nil {
			invalidParams.AddNested("InsightFeedback", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightFeedback sets the InsightFeedback field's value.
func (s *PutFeedbackInput) SetInsightFeedback(v *InsightFeedback) *PutFeedbackInput {
	s.InsightFeedback = v
	return s
}

type PutFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackOutput) GoString() string {
	return s.String()
}

// Details about a reactive anomaly. This object is returned by ListAnomalies.
type ReactiveAnomaly struct {
	_ struct{} `type:"structure"`

	// An AnomalyReportedTimeRange object that specifies the time range between
	// when the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange `type:"structure"`

	// The Amazon Web Services resources in which anomalous behavior was detected
	// by DevOps Guru.
	AnomalyResources []*AnomalyResource `type:"list"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of the causal anomaly that is associated with this reactive anomaly.
	// The ID of a `CAUSAL` anomaly is always `NULL`.
	CausalAnomalyId *string `min:"1" type:"string"`

	// A description of the reactive anomaly.
	Description *string `type:"string"`

	// The ID of the reactive anomaly.
	Id *string `min:"1" type:"string"`

	// The name of the reactive anomaly.
	Name *string `type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The status of the anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`

	// The type of the reactive anomaly. It can be one of the following types.
	//
	//    * CAUSAL - the anomaly can cause a new insight.
	//
	//    * CONTEXTUAL - the anomaly contains additional information about an insight
	//    or its causal anomaly.
	Type *string `type:"string" enum:"AnomalyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveAnomaly) GoString() string {
	return s.String()
}

// SetAnomalyReportedTimeRange sets the AnomalyReportedTimeRange field's value.
func (s *ReactiveAnomaly) SetAnomalyReportedTimeRange(v *AnomalyReportedTimeRange) *ReactiveAnomaly {
	s.AnomalyReportedTimeRange = v
	return s
}

// SetAnomalyResources sets the AnomalyResources field's value.
func (s *ReactiveAnomaly) SetAnomalyResources(v []*AnomalyResource) *ReactiveAnomaly {
	s.AnomalyResources = v
	return s
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ReactiveAnomaly) SetAnomalyTimeRange(v *AnomalyTimeRange) *ReactiveAnomaly {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ReactiveAnomaly) SetAssociatedInsightId(v string) *ReactiveAnomaly {
	s.AssociatedInsightId = &v
	return s
}

// SetCausalAnomalyId sets the CausalAnomalyId field's value.
func (s *ReactiveAnomaly) SetCausalAnomalyId(v string) *ReactiveAnomaly {
	s.CausalAnomalyId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReactiveAnomaly) SetDescription(v string) *ReactiveAnomaly {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveAnomaly) SetId(v string) *ReactiveAnomaly {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveAnomaly) SetName(v string) *ReactiveAnomaly {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveAnomaly) SetResourceCollection(v *ResourceCollection) *ReactiveAnomaly {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveAnomaly) SetSeverity(v string) *ReactiveAnomaly {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ReactiveAnomaly) SetSourceDetails(v *AnomalySourceDetails) *ReactiveAnomaly {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveAnomaly) SetStatus(v string) *ReactiveAnomaly {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *ReactiveAnomaly) SetType(v string) *ReactiveAnomaly {
	s.Type = &v
	return s
}

// Details about a reactive anomaly. This object is returned by DescribeAnomaly.
type ReactiveAnomalySummary struct {
	_ struct{} `type:"structure"`

	// An AnomalyReportedTimeRange object that specifies the time range between
	// when the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange `type:"structure"`

	// The Amazon Web Services resources in which anomalous behavior was detected
	// by DevOps Guru.
	AnomalyResources []*AnomalyResource `type:"list"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of the causal anomaly that is associated with this reactive anomaly.
	// The ID of a `CAUSAL` anomaly is always `NULL`.
	CausalAnomalyId *string `min:"1" type:"string"`

	// A description of the reactive anomaly.
	Description *string `type:"string"`

	// The ID of the reactive anomaly.
	Id *string `min:"1" type:"string"`

	// The name of the reactive anomaly.
	Name *string `type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The status of the reactive anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`

	// The type of the reactive anomaly. It can be one of the following types.
	//
	//    * CAUSAL - the anomaly can cause a new insight.
	//
	//    * CONTEXTUAL - the anomaly contains additional information about an insight
	//    or its causal anomaly.
	Type *string `type:"string" enum:"AnomalyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveAnomalySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveAnomalySummary) GoString() string {
	return s.String()
}

// SetAnomalyReportedTimeRange sets the AnomalyReportedTimeRange field's value.
func (s *ReactiveAnomalySummary) SetAnomalyReportedTimeRange(v *AnomalyReportedTimeRange) *ReactiveAnomalySummary {
	s.AnomalyReportedTimeRange = v
	return s
}

// SetAnomalyResources sets the AnomalyResources field's value.
func (s *ReactiveAnomalySummary) SetAnomalyResources(v []*AnomalyResource) *ReactiveAnomalySummary {
	s.AnomalyResources = v
	return s
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ReactiveAnomalySummary) SetAnomalyTimeRange(v *AnomalyTimeRange) *ReactiveAnomalySummary {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ReactiveAnomalySummary) SetAssociatedInsightId(v string) *ReactiveAnomalySummary {
	s.AssociatedInsightId = &v
	return s
}

// SetCausalAnomalyId sets the CausalAnomalyId field's value.
func (s *ReactiveAnomalySummary) SetCausalAnomalyId(v string) *ReactiveAnomalySummary {
	s.CausalAnomalyId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReactiveAnomalySummary) SetDescription(v string) *ReactiveAnomalySummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveAnomalySummary) SetId(v string) *ReactiveAnomalySummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveAnomalySummary) SetName(v string) *ReactiveAnomalySummary {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveAnomalySummary) SetResourceCollection(v *ResourceCollection) *ReactiveAnomalySummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveAnomalySummary) SetSeverity(v string) *ReactiveAnomalySummary {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ReactiveAnomalySummary) SetSourceDetails(v *AnomalySourceDetails) *ReactiveAnomalySummary {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveAnomalySummary) SetStatus(v string) *ReactiveAnomalySummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *ReactiveAnomalySummary) SetType(v string) *ReactiveAnomalySummary {
	s.Type = &v
	return s
}

// Information about a reactive insight. This object is returned by ListInsights.
type ReactiveInsight struct {
	_ struct{} `type:"structure"`

	// Describes the reactive insight.
	Description *string `type:"string"`

	// The ID of a reactive insight.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of a reactive insight.
	Name *string `min:"1" type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the insight. For more information, see Understanding insight
	// severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The ID of the Amazon Web Services System Manager OpsItem created for this
	// insight. You must enable the creation of OpstItems insights before they are
	// created for each insight.
	SsmOpsItemId *string `min:"1" type:"string"`

	// The status of a reactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveInsight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveInsight) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ReactiveInsight) SetDescription(v string) *ReactiveInsight {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveInsight) SetId(v string) *ReactiveInsight {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ReactiveInsight) SetInsightTimeRange(v *InsightTimeRange) *ReactiveInsight {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveInsight) SetName(v string) *ReactiveInsight {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveInsight) SetResourceCollection(v *ResourceCollection) *ReactiveInsight {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveInsight) SetSeverity(v string) *ReactiveInsight {
	s.Severity = &v
	return s
}

// SetSsmOpsItemId sets the SsmOpsItemId field's value.
func (s *ReactiveInsight) SetSsmOpsItemId(v string) *ReactiveInsight {
	s.SsmOpsItemId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveInsight) SetStatus(v string) *ReactiveInsight {
	s.Status = &v
	return s
}

// Information about a reactive insight. This object is returned by DescribeInsight.
type ReactiveInsightSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the Amazon Web Services resources that
	// generated this insight.
	AssociatedResourceArns []*string `type:"list"`

	// The ID of a reactive summary.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of a reactive insight.
	Name *string `min:"1" type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection `type:"structure"`

	// The severity of the insight. For more information, see Understanding insight
	// severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The status of a reactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveInsightSummary) GoString() string {
	return s.String()
}

// SetAssociatedResourceArns sets the AssociatedResourceArns field's value.
func (s *ReactiveInsightSummary) SetAssociatedResourceArns(v []*string) *ReactiveInsightSummary {
	s.AssociatedResourceArns = v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveInsightSummary) SetId(v string) *ReactiveInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ReactiveInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ReactiveInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveInsightSummary) SetName(v string) *ReactiveInsightSummary {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveInsightSummary) SetResourceCollection(v *ResourceCollection) *ReactiveInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetServiceCollection sets the ServiceCollection field's value.
func (s *ReactiveInsightSummary) SetServiceCollection(v *ServiceCollection) *ReactiveInsightSummary {
	s.ServiceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveInsightSummary) SetSeverity(v string) *ReactiveInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveInsightSummary) SetStatus(v string) *ReactiveInsightSummary {
	s.Status = &v
	return s
}

// Information about a reactive insight. This object is returned by DescribeInsight.
type ReactiveOrganizationInsightSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// The ID of the insight summary.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of the insight summary.
	Name *string `min:"1" type:"string"`

	// The ID of the organizational unit.
	OrganizationalUnitId *string `type:"string"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection `type:"structure"`

	// An array of severity values used to search for insights. For more information,
	// see Understanding insight severities (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// An array of status values used to search for insights.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveOrganizationInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReactiveOrganizationInsightSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ReactiveOrganizationInsightSummary) SetAccountId(v string) *ReactiveOrganizationInsightSummary {
	s.AccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveOrganizationInsightSummary) SetId(v string) *ReactiveOrganizationInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ReactiveOrganizationInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ReactiveOrganizationInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveOrganizationInsightSummary) SetName(v string) *ReactiveOrganizationInsightSummary {
	s.Name = &v
	return s
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *ReactiveOrganizationInsightSummary) SetOrganizationalUnitId(v string) *ReactiveOrganizationInsightSummary {
	s.OrganizationalUnitId = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveOrganizationInsightSummary) SetResourceCollection(v *ResourceCollection) *ReactiveOrganizationInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetServiceCollection sets the ServiceCollection field's value.
func (s *ReactiveOrganizationInsightSummary) SetServiceCollection(v *ServiceCollection) *ReactiveOrganizationInsightSummary {
	s.ServiceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveOrganizationInsightSummary) SetSeverity(v string) *ReactiveOrganizationInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveOrganizationInsightSummary) SetStatus(v string) *ReactiveOrganizationInsightSummary {
	s.Status = &v
	return s
}

// Recommendation information to help you remediate detected anomalous behavior
// that generated an insight.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The category type of the recommendation.
	Category *string `type:"string"`

	// A description of the problem.
	Description *string `type:"string"`

	// A hyperlink to information to help you address the problem.
	Link *string `type:"string"`

	// The name of the recommendation.
	Name *string `type:"string"`

	// The reason DevOps Guru flagged the anomalous behavior as a problem.
	Reason *string `type:"string"`

	// Anomalies that are related to the problem. Use these Anomalies to learn more
	// about what's happening and to help address the issue.
	RelatedAnomalies []*RecommendationRelatedAnomaly `type:"list"`

	// Events that are related to the problem. Use these events to learn more about
	// what's happening and to help address the issue.
	RelatedEvents []*RecommendationRelatedEvent `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *Recommendation) SetCategory(v string) *Recommendation {
	s.Category = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Recommendation) SetDescription(v string) *Recommendation {
	s.Description = &v
	return s
}

// SetLink sets the Link field's value.
func (s *Recommendation) SetLink(v string) *Recommendation {
	s.Link = &v
	return s
}

// SetName sets the Name field's value.
func (s *Recommendation) SetName(v string) *Recommendation {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Recommendation) SetReason(v string) *Recommendation {
	s.Reason = &v
	return s
}

// SetRelatedAnomalies sets the RelatedAnomalies field's value.
func (s *Recommendation) SetRelatedAnomalies(v []*RecommendationRelatedAnomaly) *Recommendation {
	s.RelatedAnomalies = v
	return s
}

// SetRelatedEvents sets the RelatedEvents field's value.
func (s *Recommendation) SetRelatedEvents(v []*RecommendationRelatedEvent) *Recommendation {
	s.RelatedEvents = v
	return s
}

// Information about an anomaly that is related to a recommendation.
type RecommendationRelatedAnomaly struct {
	_ struct{} `type:"structure"`

	// The ID of an anomaly that generated the insight with this recommendation.
	AnomalyId *string `min:"1" type:"string"`

	// An array of objects that represent resources in which DevOps Guru detected
	// anomalous behavior. Each object contains the name and type of the resource.
	Resources []*RecommendationRelatedAnomalyResource `type:"list"`

	// Information about where the anomalous behavior related the recommendation
	// was found. For example, details in Amazon CloudWatch metrics.
	SourceDetails []*RecommendationRelatedAnomalySourceDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedAnomaly) GoString() string {
	return s.String()
}

// SetAnomalyId sets the AnomalyId field's value.
func (s *RecommendationRelatedAnomaly) SetAnomalyId(v string) *RecommendationRelatedAnomaly {
	s.AnomalyId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *RecommendationRelatedAnomaly) SetResources(v []*RecommendationRelatedAnomalyResource) *RecommendationRelatedAnomaly {
	s.Resources = v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *RecommendationRelatedAnomaly) SetSourceDetails(v []*RecommendationRelatedAnomalySourceDetail) *RecommendationRelatedAnomaly {
	s.SourceDetails = v
	return s
}

// Information about a resource in which DevOps Guru detected anomalous behavior.
type RecommendationRelatedAnomalyResource struct {
	_ struct{} `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// The type of the resource. Resource types take the same form that is used
	// by Amazon Web Services CloudFormation resource type identifiers, service-provider::service-name::data-type-name.
	// For example, AWS::RDS::DBCluster. For more information, see Amazon Web Services
	// resource and property types reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the Amazon Web Services CloudFormation User Guide.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedAnomalyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedAnomalyResource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedAnomalyResource) SetName(v string) *RecommendationRelatedAnomalyResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecommendationRelatedAnomalyResource) SetType(v string) *RecommendationRelatedAnomalyResource {
	s.Type = &v
	return s
}

// Contains an array of RecommendationRelatedCloudWatchMetricsSourceDetail objects
// that contain the name and namespace of an Amazon CloudWatch metric.
type RecommendationRelatedAnomalySourceDetail struct {
	_ struct{} `type:"structure"`

	// An array of CloudWatchMetricsDetail objects that contains information about
	// the analyzed metrics that displayed anomalous behavior.
	CloudWatchMetrics []*RecommendationRelatedCloudWatchMetricsSourceDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedAnomalySourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedAnomalySourceDetail) GoString() string {
	return s.String()
}

// SetCloudWatchMetrics sets the CloudWatchMetrics field's value.
func (s *RecommendationRelatedAnomalySourceDetail) SetCloudWatchMetrics(v []*RecommendationRelatedCloudWatchMetricsSourceDetail) *RecommendationRelatedAnomalySourceDetail {
	s.CloudWatchMetrics = v
	return s
}

// Information about an Amazon CloudWatch metric that is analyzed by DevOps
// Guru. It is one of many analyzed metrics that are used to generate insights.
type RecommendationRelatedCloudWatchMetricsSourceDetail struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch metric.
	MetricName *string `type:"string"`

	// The namespace of the CloudWatch metric. A namespace is a container for CloudWatch
	// metrics.
	Namespace *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedCloudWatchMetricsSourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedCloudWatchMetricsSourceDetail) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *RecommendationRelatedCloudWatchMetricsSourceDetail) SetMetricName(v string) *RecommendationRelatedCloudWatchMetricsSourceDetail {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *RecommendationRelatedCloudWatchMetricsSourceDetail) SetNamespace(v string) *RecommendationRelatedCloudWatchMetricsSourceDetail {
	s.Namespace = &v
	return s
}

// Information about an event that is related to a recommendation.
type RecommendationRelatedEvent struct {
	_ struct{} `type:"structure"`

	// The name of the event. This corresponds to the Name field in an Event object.
	Name *string `type:"string"`

	// A ResourceCollection object that contains arrays of the names of Amazon Web
	// Services CloudFormation stacks. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	Resources []*RecommendationRelatedEventResource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedEvent) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedEvent) SetName(v string) *RecommendationRelatedEvent {
	s.Name = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *RecommendationRelatedEvent) SetResources(v []*RecommendationRelatedEventResource) *RecommendationRelatedEvent {
	s.Resources = v
	return s
}

// Information about an Amazon Web Services resource that emitted and event
// that is related to a recommendation in an insight.
type RecommendationRelatedEventResource struct {
	_ struct{} `type:"structure"`

	// The name of the resource that emitted the event. This corresponds to the
	// Name field in an EventResource object.
	Name *string `type:"string"`

	// The type of the resource that emitted the event. This corresponds to the
	// Type field in an EventResource object.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedEventResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationRelatedEventResource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedEventResource) SetName(v string) *RecommendationRelatedEventResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecommendationRelatedEventResource) SetType(v string) *RecommendationRelatedEventResource {
	s.Type = &v
	return s
}

type RemoveNotificationChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the notification channel to be removed.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveNotificationChannelInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RemoveNotificationChannelInput) SetId(v string) *RemoveNotificationChannelInput {
	s.Id = &v
	return s
}

type RemoveNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveNotificationChannelOutput) GoString() string {
	return s.String()
}

// A collection of Amazon Web Services resources supported by DevOps Guru. The
// two types of Amazon Web Services resource collections supported are Amazon
// Web Services CloudFormation stacks and Amazon Web Services resources that
// contain the same Amazon Web Services tag. DevOps Guru can be configured to
// analyze the Amazon Web Services resources that are defined in the stacks
// or that are tagged using the same tag key. You can specify up to 500 Amazon
// Web Services CloudFormation stacks.
type ResourceCollection struct {
	_ struct{} `type:"structure"`

	// An array of the names of Amazon Web Services CloudFormation stacks. The stacks
	// define Amazon Web Services resources that DevOps Guru analyzes. You can specify
	// up to 500 Amazon Web Services CloudFormation stacks.
	CloudFormation *CloudFormationCollection `type:"structure"`

	// The Amazon Web Services tags that are used by resources in the resource collection.
	//
	// Tags help you identify and organize your Amazon Web Services resources. Many
	// Amazon Web Services services support tagging, so you can assign the same
	// tag to resources from different services to indicate that the resources are
	// related. For example, you can assign the same tag to an Amazon DynamoDB table
	// resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper.
	//
	// Each Amazon Web Services tag has two parts.
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case-sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case-sensitive.
	//
	// Together these are known as key-value pairs.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	Tags []*TagCollection `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCollection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceCollection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceCollection"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceCollection) SetCloudFormation(v *CloudFormationCollection) *ResourceCollection {
	s.CloudFormation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceCollection) SetTags(v []*TagCollection) *ResourceCollection {
	s.Tags = v
	return s
}

// Information about a filter used to specify which Amazon Web Services resources
// are analyzed for anomalous behavior by DevOps Guru.
type ResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	// Information about Amazon Web Services CloudFormation stacks. You can use
	// up to 500 stacks to specify which Amazon Web Services resources in your account
	// to analyze. For more information, see Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
	// in the Amazon Web Services CloudFormation User Guide.
	CloudFormation *CloudFormationCollectionFilter `type:"structure"`

	// The Amazon Web Services tags used to filter the resources in the resource
	// collection.
	//
	// Tags help you identify and organize your Amazon Web Services resources. Many
	// Amazon Web Services services support tagging, so you can assign the same
	// tag to resources from different services to indicate that the resources are
	// related. For example, you can assign the same tag to an Amazon DynamoDB table
	// resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper.
	//
	// Each Amazon Web Services tag has two parts.
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case-sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case-sensitive.
	//
	// Together these are known as key-value pairs.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	Tags []*TagCollectionFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCollectionFilter) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceCollectionFilter) SetCloudFormation(v *CloudFormationCollectionFilter) *ResourceCollectionFilter {
	s.CloudFormation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceCollectionFilter) SetTags(v []*TagCollectionFilter) *ResourceCollectionFilter {
	s.Tags = v
	return s
}

// A requested resource could not be found
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the Amazon Web Services resource that could not be found.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of the Amazon Web Services resource that could not be found.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies one or more severity values and one or more status values that
// are used to search for insights.
type SearchInsightsFilters struct {
	_ struct{} `type:"structure"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection `type:"structure"`

	// An array of severity values used to search for insights.
	Severities []*string `type:"list" enum:"InsightSeverity"`

	// An array of status values used to search for insights.
	Statuses []*string `type:"list" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInsightsFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInsightsFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchInsightsFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchInsightsFilters"}
	if s.ResourceCollection != nil {
		if err := s.ResourceCollection.Validate(); err != nil {
			invalidParams.AddNested("ResourceCollection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *SearchInsightsFilters) SetResourceCollection(v *ResourceCollection) *SearchInsightsFilters {
	s.ResourceCollection = v
	return s
}

// SetServiceCollection sets the ServiceCollection field's value.
func (s *SearchInsightsFilters) SetServiceCollection(v *ServiceCollection) *SearchInsightsFilters {
	s.ServiceCollection = v
	return s
}

// SetSeverities sets the Severities field's value.
func (s *SearchInsightsFilters) SetSeverities(v []*string) *SearchInsightsFilters {
	s.Severities = v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *SearchInsightsFilters) SetStatuses(v []*string) *SearchInsightsFilters {
	s.Statuses = v
	return s
}

type SearchInsightsInput struct {
	_ struct{} `type:"structure"`

	// A SearchInsightsFilters object that is used to set the severity and status
	// filters on your insight search.
	Filters *SearchInsightsFilters `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// The start of the time range passed in. Returned insights occurred after this
	// time.
	//
	// StartTimeRange is a required field
	StartTimeRange *StartTimeRange `type:"structure" required:"true"`

	// The type of insights you are searching for (REACTIVE or PROACTIVE).
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchInsightsInput) SetFilters(v *SearchInsightsFilters) *SearchInsightsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchInsightsInput) SetMaxResults(v int64) *SearchInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchInsightsInput) SetNextToken(v string) *SearchInsightsInput {
	s.NextToken = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *SearchInsightsInput) SetStartTimeRange(v *StartTimeRange) *SearchInsightsInput {
	s.StartTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *SearchInsightsInput) SetType(v string) *SearchInsightsInput {
	s.Type = &v
	return s
}

type SearchInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// The returned proactive insights.
	ProactiveInsights []*ProactiveInsightSummary `type:"list"`

	// The returned reactive insights.
	ReactiveInsights []*ReactiveInsightSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchInsightsOutput) SetNextToken(v string) *SearchInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *SearchInsightsOutput) SetProactiveInsights(v []*ProactiveInsightSummary) *SearchInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *SearchInsightsOutput) SetReactiveInsights(v []*ReactiveInsightSummary) *SearchInsightsOutput {
	s.ReactiveInsights = v
	return s
}

// Filters you can use to specify which events are returned when ListEvents
// is called.
type SearchOrganizationInsightsFilters struct {
	_ struct{} `type:"structure"`

	// A collection of Amazon Web Services resources supported by DevOps Guru. The
	// two types of Amazon Web Services resource collections supported are Amazon
	// Web Services CloudFormation stacks and Amazon Web Services resources that
	// contain the same Amazon Web Services tag. DevOps Guru can be configured to
	// analyze the Amazon Web Services resources that are defined in the stacks
	// or that are tagged using the same tag key. You can specify up to 500 Amazon
	// Web Services CloudFormation stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection `type:"structure"`

	// An array of severity values used to search for insights.
	Severities []*string `type:"list" enum:"InsightSeverity"`

	// An array of status values used to search for insights.
	Statuses []*string `type:"list" enum:"InsightStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOrganizationInsightsFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOrganizationInsightsFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchOrganizationInsightsFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchOrganizationInsightsFilters"}
	if s.ResourceCollection != nil {
		if err := s.ResourceCollection.Validate(); err != nil {
			invalidParams.AddNested("ResourceCollection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *SearchOrganizationInsightsFilters) SetResourceCollection(v *ResourceCollection) *SearchOrganizationInsightsFilters {
	s.ResourceCollection = v
	return s
}

// SetServiceCollection sets the ServiceCollection field's value.
func (s *SearchOrganizationInsightsFilters) SetServiceCollection(v *ServiceCollection) *SearchOrganizationInsightsFilters {
	s.ServiceCollection = v
	return s
}

// SetSeverities sets the Severities field's value.
func (s *SearchOrganizationInsightsFilters) SetSeverities(v []*string) *SearchOrganizationInsightsFilters {
	s.Severities = v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *SearchOrganizationInsightsFilters) SetStatuses(v []*string) *SearchOrganizationInsightsFilters {
	s.Statuses = v
	return s
}

type SearchOrganizationInsightsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// A SearchOrganizationInsightsFilters object that is used to set the severity
	// and status filters on your insight search.
	Filters *SearchOrganizationInsightsFilters `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// A time range used to specify when the behavior of an insight or anomaly started.
	//
	// StartTimeRange is a required field
	StartTimeRange *StartTimeRange `type:"structure" required:"true"`

	// The type of insights you are searching for (REACTIVE or PROACTIVE).
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOrganizationInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOrganizationInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchOrganizationInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchOrganizationInsightsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *SearchOrganizationInsightsInput) SetAccountIds(v []*string) *SearchOrganizationInsightsInput {
	s.AccountIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *SearchOrganizationInsightsInput) SetFilters(v *SearchOrganizationInsightsFilters) *SearchOrganizationInsightsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchOrganizationInsightsInput) SetMaxResults(v int64) *SearchOrganizationInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchOrganizationInsightsInput) SetNextToken(v string) *SearchOrganizationInsightsInput {
	s.NextToken = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *SearchOrganizationInsightsInput) SetStartTimeRange(v *StartTimeRange) *SearchOrganizationInsightsInput {
	s.StartTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *SearchOrganizationInsightsInput) SetType(v string) *SearchOrganizationInsightsInput {
	s.Type = &v
	return s
}

type SearchOrganizationInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	ProactiveInsights []*ProactiveInsightSummary `type:"list"`

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	ReactiveInsights []*ReactiveInsightSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOrganizationInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOrganizationInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchOrganizationInsightsOutput) SetNextToken(v string) *SearchOrganizationInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *SearchOrganizationInsightsOutput) SetProactiveInsights(v []*ProactiveInsightSummary) *SearchOrganizationInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *SearchOrganizationInsightsOutput) SetReactiveInsights(v []*ReactiveInsightSummary) *SearchOrganizationInsightsOutput {
	s.ReactiveInsights = v
	return s
}

// A collection of the names of Amazon Web Services services.
type ServiceCollection struct {
	_ struct{} `type:"structure"`

	// An array of strings that each specifies the name of an Amazon Web Services
	// service.
	ServiceNames []*string `type:"list" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceCollection) GoString() string {
	return s.String()
}

// SetServiceNames sets the ServiceNames field's value.
func (s *ServiceCollection) SetServiceNames(v []*string) *ServiceCollection {
	s.ServiceNames = v
	return s
}

// Represents the health of an Amazon Web Services service.
type ServiceHealth struct {
	_ struct{} `type:"structure"`

	// Number of resources that DevOps Guru is monitoring in an analyzed Amazon
	// Web Services service.
	AnalyzedResourceCount *int64 `type:"long"`

	// Represents the health of an Amazon Web Services service. This is a ServiceInsightHealth
	// that contains the number of open proactive and reactive insights for this
	// service.
	Insight *ServiceInsightHealth `type:"structure"`

	// The name of the Amazon Web Services service.
	ServiceName *string `type:"string" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceHealth) GoString() string {
	return s.String()
}

// SetAnalyzedResourceCount sets the AnalyzedResourceCount field's value.
func (s *ServiceHealth) SetAnalyzedResourceCount(v int64) *ServiceHealth {
	s.AnalyzedResourceCount = &v
	return s
}

// SetInsight sets the Insight field's value.
func (s *ServiceHealth) SetInsight(v *ServiceInsightHealth) *ServiceHealth {
	s.Insight = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceHealth) SetServiceName(v string) *ServiceHealth {
	s.ServiceName = &v
	return s
}

// Contains the number of open proactive and reactive insights in an analyzed
// Amazon Web Services service.
type ServiceInsightHealth struct {
	_ struct{} `type:"structure"`

	// The number of open proactive insights in the Amazon Web Services service
	OpenProactiveInsights *int64 `type:"integer"`

	// The number of open reactive insights in the Amazon Web Services service
	OpenReactiveInsights *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInsightHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInsightHealth) GoString() string {
	return s.String()
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *ServiceInsightHealth) SetOpenProactiveInsights(v int64) *ServiceInsightHealth {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *ServiceInsightHealth) SetOpenReactiveInsights(v int64) *ServiceInsightHealth {
	s.OpenReactiveInsights = &v
	return s
}

// Information about the integration of DevOps Guru with another Amazon Web
// Services service, such as Amazon Web Services Systems Manager.
type ServiceIntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Information about whether DevOps Guru is configured to perform log anomaly
	// detection on Amazon CloudWatch log groups.
	LogsAnomalyDetection *LogsAnomalyDetectionIntegration `type:"structure"`

	// Information about whether DevOps Guru is configured to create an OpsItem
	// in Amazon Web Services Systems Manager OpsCenter for each created insight.
	OpsCenter *OpsCenterIntegration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceIntegrationConfig) GoString() string {
	return s.String()
}

// SetLogsAnomalyDetection sets the LogsAnomalyDetection field's value.
func (s *ServiceIntegrationConfig) SetLogsAnomalyDetection(v *LogsAnomalyDetectionIntegration) *ServiceIntegrationConfig {
	s.LogsAnomalyDetection = v
	return s
}

// SetOpsCenter sets the OpsCenter field's value.
func (s *ServiceIntegrationConfig) SetOpsCenter(v *OpsCenterIntegration) *ServiceIntegrationConfig {
	s.OpsCenter = v
	return s
}

// The request contains a value that exceeds a maximum quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains information about the estimated monthly cost to analyze
// an Amazon Web Services resource. For more information, see Estimate your
// Amazon DevOps Guru costs (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
type ServiceResourceCost struct {
	_ struct{} `type:"structure"`

	// The total estimated monthly cost to analyze the active resources for this
	// resource.
	Cost *float64 `type:"double"`

	// The number of active resources analyzed for this service to create a monthly
	// cost estimate.
	Count *int64 `type:"integer"`

	// The state of the resource. The resource is ACTIVE if it produces metrics,
	// events, or logs within an hour, otherwise it is INACTIVE. You pay for the
	// number of active Amazon Web Services resource hours analyzed for each resource.
	// Inactive resources are not charged.
	State *string `type:"string" enum:"CostEstimationServiceResourceState"`

	// The type of the Amazon Web Services resource.
	Type *string `min:"1" type:"string"`

	// The price per hour to analyze the resources in the service. For more information,
	// see Estimate your Amazon DevOps Guru costs (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
	// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
	UnitCost *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceResourceCost) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceResourceCost) GoString() string {
	return s.String()
}

// SetCost sets the Cost field's value.
func (s *ServiceResourceCost) SetCost(v float64) *ServiceResourceCost {
	s.Cost = &v
	return s
}

// SetCount sets the Count field's value.
func (s *ServiceResourceCost) SetCount(v int64) *ServiceResourceCost {
	s.Count = &v
	return s
}

// SetState sets the State field's value.
func (s *ServiceResourceCost) SetState(v string) *ServiceResourceCost {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *ServiceResourceCost) SetType(v string) *ServiceResourceCost {
	s.Type = &v
	return s
}

// SetUnitCost sets the UnitCost field's value.
func (s *ServiceResourceCost) SetUnitCost(v float64) *ServiceResourceCost {
	s.UnitCost = &v
	return s
}

// Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification
// Service topic.
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. DevOps Guru only supports standard SNS topics. For more
// information, see Permissions for cross account Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. For more information, see Permissions for cross account
// Amazon SNS topics.
//
// If you use an Amazon SNS topic that is encrypted by an Amazon Web Services
// Key Management Service customer-managed key (CMK), then you must add permissions
// to the CMK. For more information, see Permissions for Amazon Web Services
// KMS–encrypted Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type SnsChannelConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
	TopicArn *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsChannelConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsChannelConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsChannelConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsChannelConfig"}
	if s.TopicArn != nil && len(*s.TopicArn) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TopicArn", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsChannelConfig) SetTopicArn(v string) *SnsChannelConfig {
	s.TopicArn = &v
	return s
}

type StartCostEstimationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to identify each cost estimate request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The collection of Amazon Web Services resources used to create a monthly
	// DevOps Guru cost estimate.
	//
	// ResourceCollection is a required field
	ResourceCollection *CostEstimationResourceCollectionFilter `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCostEstimationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCostEstimationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCostEstimationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCostEstimationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ResourceCollection == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollection"))
	}
	if s.ResourceCollection != nil {
		if err := s.ResourceCollection.Validate(); err != nil {
			invalidParams.AddNested("ResourceCollection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartCostEstimationInput) SetClientToken(v string) *StartCostEstimationInput {
	s.ClientToken = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *StartCostEstimationInput) SetResourceCollection(v *CostEstimationResourceCollectionFilter) *StartCostEstimationInput {
	s.ResourceCollection = v
	return s
}

type StartCostEstimationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCostEstimationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCostEstimationOutput) GoString() string {
	return s.String()
}

// A time range used to specify when the behavior of an insight or anomaly started.
type StartTimeRange struct {
	_ struct{} `type:"structure"`

	// The start time of the time range.
	FromTime *time.Time `type:"timestamp"`

	// The end time of the time range.
	ToTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTimeRange) GoString() string {
	return s.String()
}

// SetFromTime sets the FromTime field's value.
func (s *StartTimeRange) SetFromTime(v time.Time) *StartTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *StartTimeRange) SetToTime(v time.Time) *StartTimeRange {
	s.ToTime = &v
	return s
}

// A collection of Amazon Web Services tags.
//
// Tags help you identify and organize your Amazon Web Services resources. Many
// Amazon Web Services services support tagging, so you can assign the same
// tag to resources from different services to indicate that the resources are
// related. For example, you can assign the same tag to an Amazon DynamoDB table
// resource that you assign to an Lambda function. For more information about
// using tags, see the Tagging best practices (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
// whitepaper.
//
// Each Amazon Web Services tag has two parts.
//
//   - A tag key (for example, CostCenter, Environment, Project, or Secret).
//     Tag keys are case-sensitive.
//
//   - An optional field known as a tag value (for example, 111122223333, Production,
//     or a team name). Omitting the tag value is the same as using an empty
//     string. Like tag keys, tag values are case-sensitive.
//
// Together these are known as key-value pairs.
//
// The string used for a key in a tag that you use to define your resource coverage
// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
// or devops-guru-rds-application. When you create a key, the case of characters
// in the key can be whatever you choose. After you create a key, it is case-sensitive.
// For example, DevOps Guru works with a key named devops-guru-rds and a key
// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
// pairs in your application might be Devops-Guru-production-application/RDS
// or Devops-Guru-production-application/containers.
type TagCollection struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in
	// your account and Region tagged with this key make up your DevOps Guru application
	// and analysis boundary.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	//
	// AppBoundaryKey is a required field
	AppBoundaryKey *string `min:"1" type:"string" required:"true"`

	// The values in an Amazon Web Services tag collection.
	//
	// The tag's value is an optional field used to associate a string with the
	// tag key (for example, 111122223333, Production, or a team name). The key
	// and value are the tag's key pair. Omitting the tag value is the same as using
	// an empty string. Like tag keys, tag values are case-sensitive. You can specify
	// a maximum of 256 characters for a tag value.
	//
	// TagValues is a required field
	TagValues []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCollection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagCollection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagCollection"}
	if s.AppBoundaryKey == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBoundaryKey"))
	}
	if s.AppBoundaryKey != nil && len(*s.AppBoundaryKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBoundaryKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBoundaryKey sets the AppBoundaryKey field's value.
func (s *TagCollection) SetAppBoundaryKey(v string) *TagCollection {
	s.AppBoundaryKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *TagCollection) SetTagValues(v []*string) *TagCollection {
	s.TagValues = v
	return s
}

// A collection of Amazon Web Services tags used to filter insights. This is
// used to return insights generated from only resources that contain the tags
// in the tag collection.
type TagCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in
	// your account and Region tagged with this key make up your DevOps Guru application
	// and analysis boundary.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	//
	// AppBoundaryKey is a required field
	AppBoundaryKey *string `min:"1" type:"string" required:"true"`

	// The values in an Amazon Web Services tag collection.
	//
	// The tag's value is an optional field used to associate a string with the
	// tag key (for example, 111122223333, Production, or a team name). The key
	// and value are the tag's key pair. Omitting the tag value is the same as using
	// an empty string. Like tag keys, tag values are case-sensitive. You can specify
	// a maximum of 256 characters for a tag value.
	//
	// TagValues is a required field
	TagValues []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCollectionFilter) GoString() string {
	return s.String()
}

// SetAppBoundaryKey sets the AppBoundaryKey field's value.
func (s *TagCollectionFilter) SetAppBoundaryKey(v string) *TagCollectionFilter {
	s.AppBoundaryKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *TagCollectionFilter) SetTagValues(v []*string) *TagCollectionFilter {
	s.TagValues = v
	return s
}

// Information about a collection of Amazon Web Services resources that are
// identified by an Amazon Web Services tag. This collection of resources is
// used to create a monthly cost estimate for DevOps Guru to analyze Amazon
// Web Services resources. The maximum number of tags you can specify for a
// cost estimate is one. The estimate created is for the cost to analyze the
// Amazon Web Services resources defined by the tag. For more information, see
// Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
// in the Amazon Web Services CloudFormation User Guide.
type TagCostEstimationResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in
	// your account and Region tagged with this key make up your DevOps Guru application
	// and analysis boundary.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	//
	// AppBoundaryKey is a required field
	AppBoundaryKey *string `min:"1" type:"string" required:"true"`

	// The values in an Amazon Web Services tag collection.
	//
	// The tag's value is an optional field used to associate a string with the
	// tag key (for example, 111122223333, Production, or a team name). The key
	// and value are the tag's key pair. Omitting the tag value is the same as using
	// an empty string. Like tag keys, tag values are case-sensitive. You can specify
	// a maximum of 256 characters for a tag value.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCostEstimationResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCostEstimationResourceCollectionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagCostEstimationResourceCollectionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagCostEstimationResourceCollectionFilter"}
	if s.AppBoundaryKey == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBoundaryKey"))
	}
	if s.AppBoundaryKey != nil && len(*s.AppBoundaryKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBoundaryKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBoundaryKey sets the AppBoundaryKey field's value.
func (s *TagCostEstimationResourceCollectionFilter) SetAppBoundaryKey(v string) *TagCostEstimationResourceCollectionFilter {
	s.AppBoundaryKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *TagCostEstimationResourceCollectionFilter) SetTagValues(v []*string) *TagCostEstimationResourceCollectionFilter {
	s.TagValues = v
	return s
}

// Information about the health of Amazon Web Services resources in your account
// that are specified by an Amazon Web Services tag key.
type TagHealth struct {
	_ struct{} `type:"structure"`

	// Number of resources that DevOps Guru is monitoring in your account that are
	// specified by an Amazon Web Services tag.
	AnalyzedResourceCount *int64 `type:"long"`

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in
	// your account and Region tagged with this key make up your DevOps Guru application
	// and analysis boundary.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	AppBoundaryKey *string `min:"1" type:"string"`

	// Information about the health of the Amazon Web Services resources in your
	// account that are specified by an Amazon Web Services tag, including the number
	// of open proactive, open reactive insights, and the Mean Time to Recover (MTTR)
	// of closed insights.
	Insight *InsightHealth `type:"structure"`

	// The value in an Amazon Web Services tag.
	//
	// The tag's value is an optional field used to associate a string with the
	// tag key (for example, 111122223333, Production, or a team name). The key
	// and value are the tag's key pair. Omitting the tag value is the same as using
	// an empty string. Like tag keys, tag values are case-sensitive. You can specify
	// a maximum of 256 characters for a tag value.
	TagValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagHealth) GoString() string {
	return s.String()
}

// SetAnalyzedResourceCount sets the AnalyzedResourceCount field's value.
func (s *TagHealth) SetAnalyzedResourceCount(v int64) *TagHealth {
	s.AnalyzedResourceCount = &v
	return s
}

// SetAppBoundaryKey sets the AppBoundaryKey field's value.
func (s *TagHealth) SetAppBoundaryKey(v string) *TagHealth {
	s.AppBoundaryKey = &v
	return s
}

// SetInsight sets the Insight field's value.
func (s *TagHealth) SetInsight(v *InsightHealth) *TagHealth {
	s.Insight = v
	return s
}

// SetTagValue sets the TagValue field's value.
func (s *TagHealth) SetTagValue(v string) *TagHealth {
	s.TagValue = &v
	return s
}

// The request was denied due to a request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The code of the quota that was exceeded, causing the throttling exception.
	QuotaCode *string `type:"string"`

	// The number of seconds after which the action that caused the throttling exception
	// can be retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code of the service that caused the throttling exception.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A pair that contains metric values at the respective timestamp.
type TimestampMetricValuePair struct {
	_ struct{} `type:"structure"`

	// Value of the anomalous metric data point at respective Timestamp.
	MetricValue *float64 `type:"double"`

	// A Timestamp that specifies the time the event occurred.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampMetricValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampMetricValuePair) GoString() string {
	return s.String()
}

// SetMetricValue sets the MetricValue field's value.
func (s *TimestampMetricValuePair) SetMetricValue(v float64) *TimestampMetricValuePair {
	s.MetricValue = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TimestampMetricValuePair) SetTimestamp(v time.Time) *TimestampMetricValuePair {
	s.Timestamp = &v
	return s
}

// Contains the names of Amazon Web Services CloudFormation stacks used to update
// a collection of stacks. You can specify up to 500 Amazon Web Services CloudFormation
// stacks.
type UpdateCloudFormationCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An array of the names of the Amazon Web Services CloudFormation stacks to
	// update. You can specify up to 500 Amazon Web Services CloudFormation stacks.
	StackNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCloudFormationCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCloudFormationCollectionFilter) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *UpdateCloudFormationCollectionFilter) SetStackNames(v []*string) *UpdateCloudFormationCollectionFilter {
	s.StackNames = v
	return s
}

type UpdateEventSourcesConfigInput struct {
	_ struct{} `type:"structure"`

	// Configuration information about the integration of DevOps Guru as the Consumer
	// via EventBridge with another AWS Service.
	EventSources *EventSourcesConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventSourcesConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventSourcesConfigInput) GoString() string {
	return s.String()
}

// SetEventSources sets the EventSources field's value.
func (s *UpdateEventSourcesConfigInput) SetEventSources(v *EventSourcesConfig) *UpdateEventSourcesConfigInput {
	s.EventSources = v
	return s
}

type UpdateEventSourcesConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventSourcesConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventSourcesConfigOutput) GoString() string {
	return s.String()
}

// Contains information used to update a collection of Amazon Web Services resources.
type UpdateResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	// A collection of Amazon Web Services CloudFormation stacks. You can specify
	// up to 500 Amazon Web Services CloudFormation stacks.
	CloudFormation *UpdateCloudFormationCollectionFilter `type:"structure"`

	// The updated Amazon Web Services tags used to filter the resources in the
	// resource collection.
	//
	// Tags help you identify and organize your Amazon Web Services resources. Many
	// Amazon Web Services services support tagging, so you can assign the same
	// tag to resources from different services to indicate that the resources are
	// related. For example, you can assign the same tag to an Amazon DynamoDB table
	// resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper.
	//
	// Each Amazon Web Services tag has two parts.
	//
	//    * A tag key (for example, CostCenter, Environment, Project, or Secret).
	//    Tag keys are case-sensitive.
	//
	//    * An optional field known as a tag value (for example, 111122223333, Production,
	//    or a team name). Omitting the tag value is the same as using an empty
	//    string. Like tag keys, tag values are case-sensitive.
	//
	// Together these are known as key-value pairs.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	Tags []*UpdateTagCollectionFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceCollectionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceCollectionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceCollectionFilter"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *UpdateResourceCollectionFilter) SetCloudFormation(v *UpdateCloudFormationCollectionFilter) *UpdateResourceCollectionFilter {
	s.CloudFormation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateResourceCollectionFilter) SetTags(v []*UpdateTagCollectionFilter) *UpdateResourceCollectionFilter {
	s.Tags = v
	return s
}

type UpdateResourceCollectionInput struct {
	_ struct{} `type:"structure"`

	// Specifies if the resource collection in the request is added or deleted to
	// the resource collection.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"UpdateResourceCollectionAction"`

	// Contains information used to update a collection of Amazon Web Services resources.
	//
	// ResourceCollection is a required field
	ResourceCollection *UpdateResourceCollectionFilter `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceCollectionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ResourceCollection == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollection"))
	}
	if s.ResourceCollection != nil {
		if err := s.ResourceCollection.Validate(); err != nil {
			invalidParams.AddNested("ResourceCollection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateResourceCollectionInput) SetAction(v string) *UpdateResourceCollectionInput {
	s.Action = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *UpdateResourceCollectionInput) SetResourceCollection(v *UpdateResourceCollectionFilter) *UpdateResourceCollectionInput {
	s.ResourceCollection = v
	return s
}

type UpdateResourceCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceCollectionOutput) GoString() string {
	return s.String()
}

// Information about updating the integration status of an Amazon Web Services
// service, such as Amazon Web Services Systems Manager, with DevOps Guru.
type UpdateServiceIntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Information about whether DevOps Guru is configured to perform log anomaly
	// detection on Amazon CloudWatch log groups.
	LogsAnomalyDetection *LogsAnomalyDetectionIntegrationConfig `type:"structure"`

	// Information about whether DevOps Guru is configured to create an OpsItem
	// in Amazon Web Services Systems Manager OpsCenter for each created insight.
	// You can use this to update the configuration.
	OpsCenter *OpsCenterIntegrationConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceIntegrationConfig) GoString() string {
	return s.String()
}

// SetLogsAnomalyDetection sets the LogsAnomalyDetection field's value.
func (s *UpdateServiceIntegrationConfig) SetLogsAnomalyDetection(v *LogsAnomalyDetectionIntegrationConfig) *UpdateServiceIntegrationConfig {
	s.LogsAnomalyDetection = v
	return s
}

// SetOpsCenter sets the OpsCenter field's value.
func (s *UpdateServiceIntegrationConfig) SetOpsCenter(v *OpsCenterIntegrationConfig) *UpdateServiceIntegrationConfig {
	s.OpsCenter = v
	return s
}

type UpdateServiceIntegrationInput struct {
	_ struct{} `type:"structure"`

	// An IntegratedServiceConfig object used to specify the integrated service
	// you want to update, and whether you want to update it to enabled or disabled.
	//
	// ServiceIntegration is a required field
	ServiceIntegration *UpdateServiceIntegrationConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceIntegrationInput"}
	if s.ServiceIntegration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIntegration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceIntegration sets the ServiceIntegration field's value.
func (s *UpdateServiceIntegrationInput) SetServiceIntegration(v *UpdateServiceIntegrationConfig) *UpdateServiceIntegrationInput {
	s.ServiceIntegration = v
	return s
}

type UpdateServiceIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceIntegrationOutput) GoString() string {
	return s.String()
}

// A new collection of Amazon Web Services resources that are defined by an
// Amazon Web Services tag or tag key/value pair.
type UpdateTagCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in
	// your account and Region tagged with this key make up your DevOps Guru application
	// and analysis boundary.
	//
	// The string used for a key in a tag that you use to define your resource coverage
	// must begin with the prefix Devops-guru-. The tag key might be DevOps-Guru-deployment-application
	// or devops-guru-rds-application. When you create a key, the case of characters
	// in the key can be whatever you choose. After you create a key, it is case-sensitive.
	// For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS, and these act as two different keys. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS
	// or Devops-Guru-production-application/containers.
	//
	// AppBoundaryKey is a required field
	AppBoundaryKey *string `min:"1" type:"string" required:"true"`

	// The values in an Amazon Web Services tag collection.
	//
	// The tag's value is an optional field used to associate a string with the
	// tag key (for example, 111122223333, Production, or a team name). The key
	// and value are the tag's key pair. Omitting the tag value is the same as using
	// an empty string. Like tag keys, tag values are case-sensitive. You can specify
	// a maximum of 256 characters for a tag value.
	//
	// TagValues is a required field
	TagValues []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTagCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTagCollectionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTagCollectionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTagCollectionFilter"}
	if s.AppBoundaryKey == nil {
		invalidParams.Add(request.NewErrParamRequired("AppBoundaryKey"))
	}
	if s.AppBoundaryKey != nil && len(*s.AppBoundaryKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppBoundaryKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppBoundaryKey sets the AppBoundaryKey field's value.
func (s *UpdateTagCollectionFilter) SetAppBoundaryKey(v string) *UpdateTagCollectionFilter {
	s.AppBoundaryKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *UpdateTagCollectionFilter) SetTagValues(v []*string) *UpdateTagCollectionFilter {
	s.TagValues = v
	return s
}

// Contains information about data passed in to a field during a request that
// is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// An array of fields that are associated with the validation exception.
	Fields []*ValidationExceptionField `type:"list"`

	// A message that describes the validation exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The reason the validation exception was thrown.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The field associated with the validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message associated with the validation exception with information to
	// help determine its cause.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AnomalySeverityLow is a AnomalySeverity enum value
	AnomalySeverityLow = "LOW"

	// AnomalySeverityMedium is a AnomalySeverity enum value
	AnomalySeverityMedium = "MEDIUM"

	// AnomalySeverityHigh is a AnomalySeverity enum value
	AnomalySeverityHigh = "HIGH"
)

// AnomalySeverity_Values returns all elements of the AnomalySeverity enum
func AnomalySeverity_Values() []string {
	return []string{
		AnomalySeverityLow,
		AnomalySeverityMedium,
		AnomalySeverityHigh,
	}
}

const (
	// AnomalyStatusOngoing is a AnomalyStatus enum value
	AnomalyStatusOngoing = "ONGOING"

	// AnomalyStatusClosed is a AnomalyStatus enum value
	AnomalyStatusClosed = "CLOSED"
)

// AnomalyStatus_Values returns all elements of the AnomalyStatus enum
func AnomalyStatus_Values() []string {
	return []string{
		AnomalyStatusOngoing,
		AnomalyStatusClosed,
	}
}

const (
	// AnomalyTypeCausal is a AnomalyType enum value
	AnomalyTypeCausal = "CAUSAL"

	// AnomalyTypeContextual is a AnomalyType enum value
	AnomalyTypeContextual = "CONTEXTUAL"
)

// AnomalyType_Values returns all elements of the AnomalyType enum
func AnomalyType_Values() []string {
	return []string{
		AnomalyTypeCausal,
		AnomalyTypeContextual,
	}
}

const (
	// CloudWatchMetricDataStatusCodeComplete is a CloudWatchMetricDataStatusCode enum value
	CloudWatchMetricDataStatusCodeComplete = "Complete"

	// CloudWatchMetricDataStatusCodeInternalError is a CloudWatchMetricDataStatusCode enum value
	CloudWatchMetricDataStatusCodeInternalError = "InternalError"

	// CloudWatchMetricDataStatusCodePartialData is a CloudWatchMetricDataStatusCode enum value
	CloudWatchMetricDataStatusCodePartialData = "PartialData"
)

// CloudWatchMetricDataStatusCode_Values returns all elements of the CloudWatchMetricDataStatusCode enum
func CloudWatchMetricDataStatusCode_Values() []string {
	return []string{
		CloudWatchMetricDataStatusCodeComplete,
		CloudWatchMetricDataStatusCodeInternalError,
		CloudWatchMetricDataStatusCodePartialData,
	}
}

const (
	// CloudWatchMetricsStatSum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatSum = "Sum"

	// CloudWatchMetricsStatAverage is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatAverage = "Average"

	// CloudWatchMetricsStatSampleCount is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatSampleCount = "SampleCount"

	// CloudWatchMetricsStatMinimum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatMinimum = "Minimum"

	// CloudWatchMetricsStatMaximum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatMaximum = "Maximum"

	// CloudWatchMetricsStatP99 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP99 = "p99"

	// CloudWatchMetricsStatP90 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP90 = "p90"

	// CloudWatchMetricsStatP50 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP50 = "p50"
)

// CloudWatchMetricsStat_Values returns all elements of the CloudWatchMetricsStat enum
func CloudWatchMetricsStat_Values() []string {
	return []string{
		CloudWatchMetricsStatSum,
		CloudWatchMetricsStatAverage,
		CloudWatchMetricsStatSampleCount,
		CloudWatchMetricsStatMinimum,
		CloudWatchMetricsStatMaximum,
		CloudWatchMetricsStatP99,
		CloudWatchMetricsStatP90,
		CloudWatchMetricsStatP50,
	}
}

const (
	// CostEstimationServiceResourceStateActive is a CostEstimationServiceResourceState enum value
	CostEstimationServiceResourceStateActive = "ACTIVE"

	// CostEstimationServiceResourceStateInactive is a CostEstimationServiceResourceState enum value
	CostEstimationServiceResourceStateInactive = "INACTIVE"
)

// CostEstimationServiceResourceState_Values returns all elements of the CostEstimationServiceResourceState enum
func CostEstimationServiceResourceState_Values() []string {
	return []string{
		CostEstimationServiceResourceStateActive,
		CostEstimationServiceResourceStateInactive,
	}
}

const (
	// CostEstimationStatusOngoing is a CostEstimationStatus enum value
	CostEstimationStatusOngoing = "ONGOING"

	// CostEstimationStatusCompleted is a CostEstimationStatus enum value
	CostEstimationStatusCompleted = "COMPLETED"
)

// CostEstimationStatus_Values returns all elements of the CostEstimationStatus enum
func CostEstimationStatus_Values() []string {
	return []string{
		CostEstimationStatusOngoing,
		CostEstimationStatusCompleted,
	}
}

const (
	// EventClassInfrastructure is a EventClass enum value
	EventClassInfrastructure = "INFRASTRUCTURE"

	// EventClassDeployment is a EventClass enum value
	EventClassDeployment = "DEPLOYMENT"

	// EventClassSecurityChange is a EventClass enum value
	EventClassSecurityChange = "SECURITY_CHANGE"

	// EventClassConfigChange is a EventClass enum value
	EventClassConfigChange = "CONFIG_CHANGE"

	// EventClassSchemaChange is a EventClass enum value
	EventClassSchemaChange = "SCHEMA_CHANGE"
)

// EventClass_Values returns all elements of the EventClass enum
func EventClass_Values() []string {
	return []string{
		EventClassInfrastructure,
		EventClassDeployment,
		EventClassSecurityChange,
		EventClassConfigChange,
		EventClassSchemaChange,
	}
}

const (
	// EventDataSourceAwsCloudTrail is a EventDataSource enum value
	EventDataSourceAwsCloudTrail = "AWS_CLOUD_TRAIL"

	// EventDataSourceAwsCodeDeploy is a EventDataSource enum value
	EventDataSourceAwsCodeDeploy = "AWS_CODE_DEPLOY"
)

// EventDataSource_Values returns all elements of the EventDataSource enum
func EventDataSource_Values() []string {
	return []string{
		EventDataSourceAwsCloudTrail,
		EventDataSourceAwsCodeDeploy,
	}
}

const (
	// EventSourceOptInStatusEnabled is a EventSourceOptInStatus enum value
	EventSourceOptInStatusEnabled = "ENABLED"

	// EventSourceOptInStatusDisabled is a EventSourceOptInStatus enum value
	EventSourceOptInStatusDisabled = "DISABLED"
)

// EventSourceOptInStatus_Values returns all elements of the EventSourceOptInStatus enum
func EventSourceOptInStatus_Values() []string {
	return []string{
		EventSourceOptInStatusEnabled,
		EventSourceOptInStatusDisabled,
	}
}

const (
	// InsightFeedbackOptionValidCollection is a InsightFeedbackOption enum value
	InsightFeedbackOptionValidCollection = "VALID_COLLECTION"

	// InsightFeedbackOptionRecommendationUseful is a InsightFeedbackOption enum value
	InsightFeedbackOptionRecommendationUseful = "RECOMMENDATION_USEFUL"

	// InsightFeedbackOptionAlertTooSensitive is a InsightFeedbackOption enum value
	InsightFeedbackOptionAlertTooSensitive = "ALERT_TOO_SENSITIVE"

	// InsightFeedbackOptionDataNoisyAnomaly is a InsightFeedbackOption enum value
	InsightFeedbackOptionDataNoisyAnomaly = "DATA_NOISY_ANOMALY"

	// InsightFeedbackOptionDataIncorrect is a InsightFeedbackOption enum value
	InsightFeedbackOptionDataIncorrect = "DATA_INCORRECT"
)

// InsightFeedbackOption_Values returns all elements of the InsightFeedbackOption enum
func InsightFeedbackOption_Values() []string {
	return []string{
		InsightFeedbackOptionValidCollection,
		InsightFeedbackOptionRecommendationUseful,
		InsightFeedbackOptionAlertTooSensitive,
		InsightFeedbackOptionDataNoisyAnomaly,
		InsightFeedbackOptionDataIncorrect,
	}
}

const (
	// InsightSeverityLow is a InsightSeverity enum value
	InsightSeverityLow = "LOW"

	// InsightSeverityMedium is a InsightSeverity enum value
	InsightSeverityMedium = "MEDIUM"

	// InsightSeverityHigh is a InsightSeverity enum value
	InsightSeverityHigh = "HIGH"
)

// InsightSeverity_Values returns all elements of the InsightSeverity enum
func InsightSeverity_Values() []string {
	return []string{
		InsightSeverityLow,
		InsightSeverityMedium,
		InsightSeverityHigh,
	}
}

const (
	// InsightStatusOngoing is a InsightStatus enum value
	InsightStatusOngoing = "ONGOING"

	// InsightStatusClosed is a InsightStatus enum value
	InsightStatusClosed = "CLOSED"
)

// InsightStatus_Values returns all elements of the InsightStatus enum
func InsightStatus_Values() []string {
	return []string{
		InsightStatusOngoing,
		InsightStatusClosed,
	}
}

const (
	// InsightTypeReactive is a InsightType enum value
	InsightTypeReactive = "REACTIVE"

	// InsightTypeProactive is a InsightType enum value
	InsightTypeProactive = "PROACTIVE"
)

// InsightType_Values returns all elements of the InsightType enum
func InsightType_Values() []string {
	return []string{
		InsightTypeReactive,
		InsightTypeProactive,
	}
}

const (
	// LocaleDeDe is a Locale enum value
	LocaleDeDe = "DE_DE"

	// LocaleEnUs is a Locale enum value
	LocaleEnUs = "EN_US"

	// LocaleEnGb is a Locale enum value
	LocaleEnGb = "EN_GB"

	// LocaleEsEs is a Locale enum value
	LocaleEsEs = "ES_ES"

	// LocaleFrFr is a Locale enum value
	LocaleFrFr = "FR_FR"

	// LocaleItIt is a Locale enum value
	LocaleItIt = "IT_IT"

	// LocaleJaJp is a Locale enum value
	LocaleJaJp = "JA_JP"

	// LocaleKoKr is a Locale enum value
	LocaleKoKr = "KO_KR"

	// LocalePtBr is a Locale enum value
	LocalePtBr = "PT_BR"

	// LocaleZhCn is a Locale enum value
	LocaleZhCn = "ZH_CN"

	// LocaleZhTw is a Locale enum value
	LocaleZhTw = "ZH_TW"
)

// Locale_Values returns all elements of the Locale enum
func Locale_Values() []string {
	return []string{
		LocaleDeDe,
		LocaleEnUs,
		LocaleEnGb,
		LocaleEsEs,
		LocaleFrFr,
		LocaleItIt,
		LocaleJaJp,
		LocaleKoKr,
		LocalePtBr,
		LocaleZhCn,
		LocaleZhTw,
	}
}

const (
	// LogAnomalyTypeKeyword is a LogAnomalyType enum value
	LogAnomalyTypeKeyword = "KEYWORD"

	// LogAnomalyTypeKeywordToken is a LogAnomalyType enum value
	LogAnomalyTypeKeywordToken = "KEYWORD_TOKEN"

	// LogAnomalyTypeFormat is a LogAnomalyType enum value
	LogAnomalyTypeFormat = "FORMAT"

	// LogAnomalyTypeHttpCode is a LogAnomalyType enum value
	LogAnomalyTypeHttpCode = "HTTP_CODE"

	// LogAnomalyTypeBlockFormat is a LogAnomalyType enum value
	LogAnomalyTypeBlockFormat = "BLOCK_FORMAT"

	// LogAnomalyTypeNumericalPoint is a LogAnomalyType enum value
	LogAnomalyTypeNumericalPoint = "NUMERICAL_POINT"

	// LogAnomalyTypeNumericalNan is a LogAnomalyType enum value
	LogAnomalyTypeNumericalNan = "NUMERICAL_NAN"

	// LogAnomalyTypeNewFieldName is a LogAnomalyType enum value
	LogAnomalyTypeNewFieldName = "NEW_FIELD_NAME"
)

// LogAnomalyType_Values returns all elements of the LogAnomalyType enum
func LogAnomalyType_Values() []string {
	return []string{
		LogAnomalyTypeKeyword,
		LogAnomalyTypeKeywordToken,
		LogAnomalyTypeFormat,
		LogAnomalyTypeHttpCode,
		LogAnomalyTypeBlockFormat,
		LogAnomalyTypeNumericalPoint,
		LogAnomalyTypeNumericalNan,
		LogAnomalyTypeNewFieldName,
	}
}

const (
	// NotificationMessageTypeNewInsight is a NotificationMessageType enum value
	NotificationMessageTypeNewInsight = "NEW_INSIGHT"

	// NotificationMessageTypeClosedInsight is a NotificationMessageType enum value
	NotificationMessageTypeClosedInsight = "CLOSED_INSIGHT"

	// NotificationMessageTypeNewAssociation is a NotificationMessageType enum value
	NotificationMessageTypeNewAssociation = "NEW_ASSOCIATION"

	// NotificationMessageTypeSeverityUpgraded is a NotificationMessageType enum value
	NotificationMessageTypeSeverityUpgraded = "SEVERITY_UPGRADED"

	// NotificationMessageTypeNewRecommendation is a NotificationMessageType enum value
	NotificationMessageTypeNewRecommendation = "NEW_RECOMMENDATION"
)

// NotificationMessageType_Values returns all elements of the NotificationMessageType enum
func NotificationMessageType_Values() []string {
	return []string{
		NotificationMessageTypeNewInsight,
		NotificationMessageTypeClosedInsight,
		NotificationMessageTypeNewAssociation,
		NotificationMessageTypeSeverityUpgraded,
		NotificationMessageTypeNewRecommendation,
	}
}

// Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems
// Manager OpsItem for each created insight.
const (
	// OptInStatusEnabled is a OptInStatus enum value
	OptInStatusEnabled = "ENABLED"

	// OptInStatusDisabled is a OptInStatus enum value
	OptInStatusDisabled = "DISABLED"
)

// OptInStatus_Values returns all elements of the OptInStatus enum
func OptInStatus_Values() []string {
	return []string{
		OptInStatusEnabled,
		OptInStatusDisabled,
	}
}

const (
	// OrganizationResourceCollectionTypeAwsCloudFormation is a OrganizationResourceCollectionType enum value
	OrganizationResourceCollectionTypeAwsCloudFormation = "AWS_CLOUD_FORMATION"

	// OrganizationResourceCollectionTypeAwsService is a OrganizationResourceCollectionType enum value
	OrganizationResourceCollectionTypeAwsService = "AWS_SERVICE"

	// OrganizationResourceCollectionTypeAwsAccount is a OrganizationResourceCollectionType enum value
	OrganizationResourceCollectionTypeAwsAccount = "AWS_ACCOUNT"

	// OrganizationResourceCollectionTypeAwsTags is a OrganizationResourceCollectionType enum value
	OrganizationResourceCollectionTypeAwsTags = "AWS_TAGS"
)

// OrganizationResourceCollectionType_Values returns all elements of the OrganizationResourceCollectionType enum
func OrganizationResourceCollectionType_Values() []string {
	return []string{
		OrganizationResourceCollectionTypeAwsCloudFormation,
		OrganizationResourceCollectionTypeAwsService,
		OrganizationResourceCollectionTypeAwsAccount,
		OrganizationResourceCollectionTypeAwsTags,
	}
}

const (
	// ResourceCollectionTypeAwsCloudFormation is a ResourceCollectionType enum value
	ResourceCollectionTypeAwsCloudFormation = "AWS_CLOUD_FORMATION"

	// ResourceCollectionTypeAwsService is a ResourceCollectionType enum value
	ResourceCollectionTypeAwsService = "AWS_SERVICE"

	// ResourceCollectionTypeAwsTags is a ResourceCollectionType enum value
	ResourceCollectionTypeAwsTags = "AWS_TAGS"
)

// ResourceCollectionType_Values returns all elements of the ResourceCollectionType enum
func ResourceCollectionType_Values() []string {
	return []string{
		ResourceCollectionTypeAwsCloudFormation,
		ResourceCollectionTypeAwsService,
		ResourceCollectionTypeAwsTags,
	}
}

const (
	// ResourcePermissionFullPermission is a ResourcePermission enum value
	ResourcePermissionFullPermission = "FULL_PERMISSION"

	// ResourcePermissionMissingPermission is a ResourcePermission enum value
	ResourcePermissionMissingPermission = "MISSING_PERMISSION"
)

// ResourcePermission_Values returns all elements of the ResourcePermission enum
func ResourcePermission_Values() []string {
	return []string{
		ResourcePermissionFullPermission,
		ResourcePermissionMissingPermission,
	}
}

const (
	// ResourceTypeFilterLogGroups is a ResourceTypeFilter enum value
	ResourceTypeFilterLogGroups = "LOG_GROUPS"

	// ResourceTypeFilterCloudfrontDistribution is a ResourceTypeFilter enum value
	ResourceTypeFilterCloudfrontDistribution = "CLOUDFRONT_DISTRIBUTION"

	// ResourceTypeFilterDynamodbTable is a ResourceTypeFilter enum value
	ResourceTypeFilterDynamodbTable = "DYNAMODB_TABLE"

	// ResourceTypeFilterEc2NatGateway is a ResourceTypeFilter enum value
	ResourceTypeFilterEc2NatGateway = "EC2_NAT_GATEWAY"

	// ResourceTypeFilterEcsCluster is a ResourceTypeFilter enum value
	ResourceTypeFilterEcsCluster = "ECS_CLUSTER"

	// ResourceTypeFilterEcsService is a ResourceTypeFilter enum value
	ResourceTypeFilterEcsService = "ECS_SERVICE"

	// ResourceTypeFilterEksCluster is a ResourceTypeFilter enum value
	ResourceTypeFilterEksCluster = "EKS_CLUSTER"

	// ResourceTypeFilterElasticBeanstalkEnvironment is a ResourceTypeFilter enum value
	ResourceTypeFilterElasticBeanstalkEnvironment = "ELASTIC_BEANSTALK_ENVIRONMENT"

	// ResourceTypeFilterElasticLoadBalancerLoadBalancer is a ResourceTypeFilter enum value
	ResourceTypeFilterElasticLoadBalancerLoadBalancer = "ELASTIC_LOAD_BALANCER_LOAD_BALANCER"

	// ResourceTypeFilterElasticLoadBalancingV2LoadBalancer is a ResourceTypeFilter enum value
	ResourceTypeFilterElasticLoadBalancingV2LoadBalancer = "ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER"

	// ResourceTypeFilterElasticLoadBalancingV2TargetGroup is a ResourceTypeFilter enum value
	ResourceTypeFilterElasticLoadBalancingV2TargetGroup = "ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP"

	// ResourceTypeFilterElasticacheCacheCluster is a ResourceTypeFilter enum value
	ResourceTypeFilterElasticacheCacheCluster = "ELASTICACHE_CACHE_CLUSTER"

	// ResourceTypeFilterElasticsearchDomain is a ResourceTypeFilter enum value
	ResourceTypeFilterElasticsearchDomain = "ELASTICSEARCH_DOMAIN"

	// ResourceTypeFilterKinesisStream is a ResourceTypeFilter enum value
	ResourceTypeFilterKinesisStream = "KINESIS_STREAM"

	// ResourceTypeFilterLambdaFunction is a ResourceTypeFilter enum value
	ResourceTypeFilterLambdaFunction = "LAMBDA_FUNCTION"

	// ResourceTypeFilterOpenSearchServiceDomain is a ResourceTypeFilter enum value
	ResourceTypeFilterOpenSearchServiceDomain = "OPEN_SEARCH_SERVICE_DOMAIN"

	// ResourceTypeFilterRdsDbInstance is a ResourceTypeFilter enum value
	ResourceTypeFilterRdsDbInstance = "RDS_DB_INSTANCE"

	// ResourceTypeFilterRdsDbCluster is a ResourceTypeFilter enum value
	ResourceTypeFilterRdsDbCluster = "RDS_DB_CLUSTER"

	// ResourceTypeFilterRedshiftCluster is a ResourceTypeFilter enum value
	ResourceTypeFilterRedshiftCluster = "REDSHIFT_CLUSTER"

	// ResourceTypeFilterRoute53HostedZone is a ResourceTypeFilter enum value
	ResourceTypeFilterRoute53HostedZone = "ROUTE53_HOSTED_ZONE"

	// ResourceTypeFilterRoute53HealthCheck is a ResourceTypeFilter enum value
	ResourceTypeFilterRoute53HealthCheck = "ROUTE53_HEALTH_CHECK"

	// ResourceTypeFilterS3Bucket is a ResourceTypeFilter enum value
	ResourceTypeFilterS3Bucket = "S3_BUCKET"

	// ResourceTypeFilterSagemakerEndpoint is a ResourceTypeFilter enum value
	ResourceTypeFilterSagemakerEndpoint = "SAGEMAKER_ENDPOINT"

	// ResourceTypeFilterSnsTopic is a ResourceTypeFilter enum value
	ResourceTypeFilterSnsTopic = "SNS_TOPIC"

	// ResourceTypeFilterSqsQueue is a ResourceTypeFilter enum value
	ResourceTypeFilterSqsQueue = "SQS_QUEUE"

	// ResourceTypeFilterStepFunctionsActivity is a ResourceTypeFilter enum value
	ResourceTypeFilterStepFunctionsActivity = "STEP_FUNCTIONS_ACTIVITY"

	// ResourceTypeFilterStepFunctionsStateMachine is a ResourceTypeFilter enum value
	ResourceTypeFilterStepFunctionsStateMachine = "STEP_FUNCTIONS_STATE_MACHINE"
)

// ResourceTypeFilter_Values returns all elements of the ResourceTypeFilter enum
func ResourceTypeFilter_Values() []string {
	return []string{
		ResourceTypeFilterLogGroups,
		ResourceTypeFilterCloudfrontDistribution,
		ResourceTypeFilterDynamodbTable,
		ResourceTypeFilterEc2NatGateway,
		ResourceTypeFilterEcsCluster,
		ResourceTypeFilterEcsService,
		ResourceTypeFilterEksCluster,
		ResourceTypeFilterElasticBeanstalkEnvironment,
		ResourceTypeFilterElasticLoadBalancerLoadBalancer,
		ResourceTypeFilterElasticLoadBalancingV2LoadBalancer,
		ResourceTypeFilterElasticLoadBalancingV2TargetGroup,
		ResourceTypeFilterElasticacheCacheCluster,
		ResourceTypeFilterElasticsearchDomain,
		ResourceTypeFilterKinesisStream,
		ResourceTypeFilterLambdaFunction,
		ResourceTypeFilterOpenSearchServiceDomain,
		ResourceTypeFilterRdsDbInstance,
		ResourceTypeFilterRdsDbCluster,
		ResourceTypeFilterRedshiftCluster,
		ResourceTypeFilterRoute53HostedZone,
		ResourceTypeFilterRoute53HealthCheck,
		ResourceTypeFilterS3Bucket,
		ResourceTypeFilterSagemakerEndpoint,
		ResourceTypeFilterSnsTopic,
		ResourceTypeFilterSqsQueue,
		ResourceTypeFilterStepFunctionsActivity,
		ResourceTypeFilterStepFunctionsStateMachine,
	}
}

const (
	// ServiceNameApiGateway is a ServiceName enum value
	ServiceNameApiGateway = "API_GATEWAY"

	// ServiceNameApplicationElb is a ServiceName enum value
	ServiceNameApplicationElb = "APPLICATION_ELB"

	// ServiceNameAutoScalingGroup is a ServiceName enum value
	ServiceNameAutoScalingGroup = "AUTO_SCALING_GROUP"

	// ServiceNameCloudFront is a ServiceName enum value
	ServiceNameCloudFront = "CLOUD_FRONT"

	// ServiceNameDynamoDb is a ServiceName enum value
	ServiceNameDynamoDb = "DYNAMO_DB"

	// ServiceNameEc2 is a ServiceName enum value
	ServiceNameEc2 = "EC2"

	// ServiceNameEcs is a ServiceName enum value
	ServiceNameEcs = "ECS"

	// ServiceNameEks is a ServiceName enum value
	ServiceNameEks = "EKS"

	// ServiceNameElasticBeanstalk is a ServiceName enum value
	ServiceNameElasticBeanstalk = "ELASTIC_BEANSTALK"

	// ServiceNameElastiCache is a ServiceName enum value
	ServiceNameElastiCache = "ELASTI_CACHE"

	// ServiceNameElb is a ServiceName enum value
	ServiceNameElb = "ELB"

	// ServiceNameEs is a ServiceName enum value
	ServiceNameEs = "ES"

	// ServiceNameKinesis is a ServiceName enum value
	ServiceNameKinesis = "KINESIS"

	// ServiceNameLambda is a ServiceName enum value
	ServiceNameLambda = "LAMBDA"

	// ServiceNameNatGateway is a ServiceName enum value
	ServiceNameNatGateway = "NAT_GATEWAY"

	// ServiceNameNetworkElb is a ServiceName enum value
	ServiceNameNetworkElb = "NETWORK_ELB"

	// ServiceNameRds is a ServiceName enum value
	ServiceNameRds = "RDS"

	// ServiceNameRedshift is a ServiceName enum value
	ServiceNameRedshift = "REDSHIFT"

	// ServiceNameRoute53 is a ServiceName enum value
	ServiceNameRoute53 = "ROUTE_53"

	// ServiceNameS3 is a ServiceName enum value
	ServiceNameS3 = "S3"

	// ServiceNameSageMaker is a ServiceName enum value
	ServiceNameSageMaker = "SAGE_MAKER"

	// ServiceNameSns is a ServiceName enum value
	ServiceNameSns = "SNS"

	// ServiceNameSqs is a ServiceName enum value
	ServiceNameSqs = "SQS"

	// ServiceNameStepFunctions is a ServiceName enum value
	ServiceNameStepFunctions = "STEP_FUNCTIONS"

	// ServiceNameSwf is a ServiceName enum value
	ServiceNameSwf = "SWF"
)

// ServiceName_Values returns all elements of the ServiceName enum
func ServiceName_Values() []string {
	return []string{
		ServiceNameApiGateway,
		ServiceNameApplicationElb,
		ServiceNameAutoScalingGroup,
		ServiceNameCloudFront,
		ServiceNameDynamoDb,
		ServiceNameEc2,
		ServiceNameEcs,
		ServiceNameEks,
		ServiceNameElasticBeanstalk,
		ServiceNameElastiCache,
		ServiceNameElb,
		ServiceNameEs,
		ServiceNameKinesis,
		ServiceNameLambda,
		ServiceNameNatGateway,
		ServiceNameNetworkElb,
		ServiceNameRds,
		ServiceNameRedshift,
		ServiceNameRoute53,
		ServiceNameS3,
		ServiceNameSageMaker,
		ServiceNameSns,
		ServiceNameSqs,
		ServiceNameStepFunctions,
		ServiceNameSwf,
	}
}

const (
	// UpdateResourceCollectionActionAdd is a UpdateResourceCollectionAction enum value
	UpdateResourceCollectionActionAdd = "ADD"

	// UpdateResourceCollectionActionRemove is a UpdateResourceCollectionAction enum value
	UpdateResourceCollectionActionRemove = "REMOVE"
)

// UpdateResourceCollectionAction_Values returns all elements of the UpdateResourceCollectionAction enum
func UpdateResourceCollectionAction_Values() []string {
	return []string{
		UpdateResourceCollectionActionAdd,
		UpdateResourceCollectionActionRemove,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"

	// ValidationExceptionReasonInvalidParameterCombination is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidParameterCombination = "INVALID_PARAMETER_COMBINATION"

	// ValidationExceptionReasonParameterInconsistentWithServiceState is a ValidationExceptionReason enum value
	ValidationExceptionReasonParameterInconsistentWithServiceState = "PARAMETER_INCONSISTENT_WITH_SERVICE_STATE"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
		ValidationExceptionReasonInvalidParameterCombination,
		ValidationExceptionReasonParameterInconsistentWithServiceState,
	}
}
