//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevcenter_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/devcenter/resource-manager/Microsoft.DevCenter/preview/2023-10-01-preview/examples/ProjectEnvironmentTypes_List.json
func ExampleProjectEnvironmentTypesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProjectEnvironmentTypesClient().NewListPager("rg1", "ContosoProj", &armdevcenter.ProjectEnvironmentTypesClientListOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProjectEnvironmentTypeListResult = armdevcenter.ProjectEnvironmentTypeListResult{
		// 	Value: []*armdevcenter.ProjectEnvironmentType{
		// 		{
		// 			Name: to.Ptr("DevTest"),
		// 			Type: to.Ptr("Microsoft.DevCenter/projects/environmentTypes"),
		// 			ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/ContosoProj/environmentTypes/DevTest"),
		// 			SystemData: &armdevcenter.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
		// 				CreatedBy: to.Ptr("User1@contoso.com"),
		// 				CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("User1@contoso.com"),
		// 				LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 			},
		// 			Identity: &armdevcenter.ManagedServiceIdentity{
		// 				Type: to.Ptr(armdevcenter.ManagedServiceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armdevcenter.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/identityGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity1": &armdevcenter.UserAssignedIdentity{
		// 						ClientID: to.Ptr("e35621a5-f615-4a20-940e-de8a84b15abc"),
		// 						PrincipalID: to.Ptr("2111b8fc-e123-485a-b408-bf1153189494"),
		// 					},
		// 				},
		// 			},
		// 			Location: to.Ptr("centralus"),
		// 			Properties: &armdevcenter.ProjectEnvironmentTypeProperties{
		// 				CreatorRoleAssignment: &armdevcenter.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment{
		// 					Roles: map[string]*armdevcenter.EnvironmentRole{
		// 						"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
		// 							Description: to.Ptr("Allows Developer access to project virtual machine resources."),
		// 							RoleName: to.Ptr("Developer"),
		// 						},
		// 					},
		// 				},
		// 				DeploymentTargetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000"),
		// 				Status: to.Ptr(armdevcenter.EnvironmentTypeEnableStatusEnabled),
		// 				UserRoleAssignments: map[string]*armdevcenter.UserRoleAssignmentValue{
		// 					"e45e3m7c-176e-416a-b466-0c5ec8298f8a": &armdevcenter.UserRoleAssignmentValue{
		// 						Roles: map[string]*armdevcenter.EnvironmentRole{
		// 							"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
		// 								Description: to.Ptr("Allows Developer access to project virtual machine resources."),
		// 								RoleName: to.Ptr("Developer"),
		// 							},
		// 						},
		// 					},
		// 				},
		// 				ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
		// 			},
		// 			Tags: map[string]*string{
		// 				"CostCenter": to.Ptr("RnD"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/devcenter/resource-manager/Microsoft.DevCenter/preview/2023-10-01-preview/examples/ProjectEnvironmentTypes_Get.json
func ExampleProjectEnvironmentTypesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProjectEnvironmentTypesClient().Get(ctx, "rg1", "ContosoProj", "DevTest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProjectEnvironmentType = armdevcenter.ProjectEnvironmentType{
	// 	Name: to.Ptr("DevTest"),
	// 	Type: to.Ptr("Microsoft.DevCenter/projects/environmentTypes"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/ContosoProj/environmentTypes/DevTest"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		CreatedBy: to.Ptr("User1@contoso.com"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("User1@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Identity: &armdevcenter.ManagedServiceIdentity{
	// 		Type: to.Ptr(armdevcenter.ManagedServiceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armdevcenter.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/identityGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity1": &armdevcenter.UserAssignedIdentity{
	// 				ClientID: to.Ptr("e35621a5-f615-4a20-940e-de8a84b15abc"),
	// 				PrincipalID: to.Ptr("2111b8fc-e123-485a-b408-bf1153189494"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("centralus"),
	// 	Properties: &armdevcenter.ProjectEnvironmentTypeProperties{
	// 		CreatorRoleAssignment: &armdevcenter.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment{
	// 			Roles: map[string]*armdevcenter.EnvironmentRole{
	// 				"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
	// 					Description: to.Ptr("Allows Developer access to project virtual machine resources."),
	// 					RoleName: to.Ptr("Developer"),
	// 				},
	// 			},
	// 		},
	// 		DeploymentTargetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000"),
	// 		Status: to.Ptr(armdevcenter.EnvironmentTypeEnableStatusEnabled),
	// 		UserRoleAssignments: map[string]*armdevcenter.UserRoleAssignmentValue{
	// 			"e45e3m7c-176e-416a-b466-0c5ec8298f8a": &armdevcenter.UserRoleAssignmentValue{
	// 				Roles: map[string]*armdevcenter.EnvironmentRole{
	// 					"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
	// 						Description: to.Ptr("Allows Developer access to project virtual machine resources."),
	// 						RoleName: to.Ptr("Developer"),
	// 					},
	// 				},
	// 			},
	// 		},
	// 		EnvironmentCount: to.Ptr[int32](1),
	// 		ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 	},
	// 	Tags: map[string]*string{
	// 		"CostCenter": to.Ptr("RnD"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/devcenter/resource-manager/Microsoft.DevCenter/preview/2023-10-01-preview/examples/ProjectEnvironmentTypes_Put.json
func ExampleProjectEnvironmentTypesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProjectEnvironmentTypesClient().CreateOrUpdate(ctx, "rg1", "ContosoProj", "DevTest", armdevcenter.ProjectEnvironmentType{
		Identity: &armdevcenter.ManagedServiceIdentity{
			Type: to.Ptr(armdevcenter.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armdevcenter.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/identityGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity1": {},
			},
		},
		Properties: &armdevcenter.ProjectEnvironmentTypeProperties{
			CreatorRoleAssignment: &armdevcenter.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment{
				Roles: map[string]*armdevcenter.EnvironmentRole{
					"4cbf0b6c-e750-441c-98a7-10da8387e4d6": {},
				},
			},
			DeploymentTargetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000"),
			Status:             to.Ptr(armdevcenter.EnvironmentTypeEnableStatusEnabled),
			UserRoleAssignments: map[string]*armdevcenter.UserRoleAssignmentValue{
				"e45e3m7c-176e-416a-b466-0c5ec8298f8a": {
					Roles: map[string]*armdevcenter.EnvironmentRole{
						"4cbf0b6c-e750-441c-98a7-10da8387e4d6": {},
					},
				},
			},
		},
		Tags: map[string]*string{
			"CostCenter": to.Ptr("RnD"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProjectEnvironmentType = armdevcenter.ProjectEnvironmentType{
	// 	Name: to.Ptr("DevTest"),
	// 	Type: to.Ptr("Microsoft.DevCenter/projects/environmentTypes"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/ContosoProj/environmentTypes/DevTest"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		CreatedBy: to.Ptr("User1@contoso.com"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("User1@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Identity: &armdevcenter.ManagedServiceIdentity{
	// 		Type: to.Ptr(armdevcenter.ManagedServiceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armdevcenter.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/identityGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity1": &armdevcenter.UserAssignedIdentity{
	// 				ClientID: to.Ptr("e35621a5-f615-4a20-940e-de8a84b15abc"),
	// 				PrincipalID: to.Ptr("2111b8fc-e123-485a-b408-bf1153189494"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("centralus"),
	// 	Properties: &armdevcenter.ProjectEnvironmentTypeProperties{
	// 		CreatorRoleAssignment: &armdevcenter.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment{
	// 			Roles: map[string]*armdevcenter.EnvironmentRole{
	// 				"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
	// 					Description: to.Ptr("Allows Developer access to project virtual machine resources."),
	// 					RoleName: to.Ptr("Developer"),
	// 				},
	// 			},
	// 		},
	// 		DeploymentTargetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000"),
	// 		Status: to.Ptr(armdevcenter.EnvironmentTypeEnableStatusEnabled),
	// 		UserRoleAssignments: map[string]*armdevcenter.UserRoleAssignmentValue{
	// 			"e45e3m7c-176e-416a-b466-0c5ec8298f8a": &armdevcenter.UserRoleAssignmentValue{
	// 				Roles: map[string]*armdevcenter.EnvironmentRole{
	// 					"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
	// 						Description: to.Ptr("Allows Developer access to project virtual machine resources."),
	// 						RoleName: to.Ptr("Developer"),
	// 					},
	// 				},
	// 			},
	// 		},
	// 		DisplayName: to.Ptr("DevTest"),
	// 		EnvironmentCount: to.Ptr[int32](0),
	// 		ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 	},
	// 	Tags: map[string]*string{
	// 		"CostCenter": to.Ptr("RnD"),
	// 		"hidden-title": to.Ptr("Dev"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/devcenter/resource-manager/Microsoft.DevCenter/preview/2023-10-01-preview/examples/ProjectEnvironmentTypes_Patch.json
func ExampleProjectEnvironmentTypesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProjectEnvironmentTypesClient().Update(ctx, "rg1", "ContosoProj", "DevTest", armdevcenter.ProjectEnvironmentTypeUpdate{
		Identity: &armdevcenter.ManagedServiceIdentity{
			Type: to.Ptr(armdevcenter.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armdevcenter.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/identityGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity1": {},
			},
		},
		Properties: &armdevcenter.ProjectEnvironmentTypeUpdateProperties{
			DeploymentTargetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000"),
			Status:             to.Ptr(armdevcenter.EnvironmentTypeEnableStatusEnabled),
			UserRoleAssignments: map[string]*armdevcenter.UserRoleAssignmentValue{
				"e45e3m7c-176e-416a-b466-0c5ec8298f8a": {
					Roles: map[string]*armdevcenter.EnvironmentRole{
						"4cbf0b6c-e750-441c-98a7-10da8387e4d6": {},
					},
				},
			},
		},
		Tags: map[string]*string{
			"CostCenter": to.Ptr("RnD"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProjectEnvironmentType = armdevcenter.ProjectEnvironmentType{
	// 	Name: to.Ptr("DevTest"),
	// 	Type: to.Ptr("Microsoft.DevCenter/projects/environmentTypes"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/ContosoProj/environmentTypes/DevTest"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		CreatedBy: to.Ptr("User1@contoso.com"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("User1@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Identity: &armdevcenter.ManagedServiceIdentity{
	// 		Type: to.Ptr(armdevcenter.ManagedServiceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armdevcenter.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/identityGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity1": &armdevcenter.UserAssignedIdentity{
	// 				ClientID: to.Ptr("e35621a5-f615-4a20-940e-de8a84b15abc"),
	// 				PrincipalID: to.Ptr("2111b8fc-e123-485a-b408-bf1153189494"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("centralus"),
	// 	Properties: &armdevcenter.ProjectEnvironmentTypeProperties{
	// 		CreatorRoleAssignment: &armdevcenter.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment{
	// 			Roles: map[string]*armdevcenter.EnvironmentRole{
	// 				"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
	// 					Description: to.Ptr("Allows Developer access to project virtual machine resources."),
	// 					RoleName: to.Ptr("Developer"),
	// 				},
	// 			},
	// 		},
	// 		DeploymentTargetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000"),
	// 		Status: to.Ptr(armdevcenter.EnvironmentTypeEnableStatusEnabled),
	// 		UserRoleAssignments: map[string]*armdevcenter.UserRoleAssignmentValue{
	// 			"e45e3m7c-176e-416a-b466-0c5ec8298f8a": &armdevcenter.UserRoleAssignmentValue{
	// 				Roles: map[string]*armdevcenter.EnvironmentRole{
	// 					"4cbf0b6c-e750-441c-98a7-10da8387e4d6": &armdevcenter.EnvironmentRole{
	// 						Description: to.Ptr("Allows Developer access to project virtual machine resources."),
	// 						RoleName: to.Ptr("Developer"),
	// 					},
	// 				},
	// 			},
	// 		},
	// 		EnvironmentCount: to.Ptr[int32](1),
	// 		ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 	},
	// 	Tags: map[string]*string{
	// 		"CostCenter": to.Ptr("RnD"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/devcenter/resource-manager/Microsoft.DevCenter/preview/2023-10-01-preview/examples/ProjectEnvironmentTypes_Delete.json
func ExampleProjectEnvironmentTypesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewProjectEnvironmentTypesClient().Delete(ctx, "rg1", "ContosoProj", "DevTest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
