//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SQLVulnerabilityAssessmentBaselineRulesServer is a fake server for instances of the armsecurity.SQLVulnerabilityAssessmentBaselineRulesClient type.
type SQLVulnerabilityAssessmentBaselineRulesServer struct {
	// Add is the fake for method SQLVulnerabilityAssessmentBaselineRulesClient.Add
	// HTTP status codes to indicate success: http.StatusOK
	Add func(ctx context.Context, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientAddOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientAddResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdate is the fake for method SQLVulnerabilityAssessmentBaselineRulesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SQLVulnerabilityAssessmentBaselineRulesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientDeleteOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SQLVulnerabilityAssessmentBaselineRulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientGetOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SQLVulnerabilityAssessmentBaselineRulesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientListOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientListResponse], errResp azfake.ErrorResponder)
}

// NewSQLVulnerabilityAssessmentBaselineRulesServerTransport creates a new instance of SQLVulnerabilityAssessmentBaselineRulesServerTransport with the provided implementation.
// The returned SQLVulnerabilityAssessmentBaselineRulesServerTransport instance is connected to an instance of armsecurity.SQLVulnerabilityAssessmentBaselineRulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLVulnerabilityAssessmentBaselineRulesServerTransport(srv *SQLVulnerabilityAssessmentBaselineRulesServer) *SQLVulnerabilityAssessmentBaselineRulesServerTransport {
	return &SQLVulnerabilityAssessmentBaselineRulesServerTransport{srv: srv}
}

// SQLVulnerabilityAssessmentBaselineRulesServerTransport connects instances of armsecurity.SQLVulnerabilityAssessmentBaselineRulesClient to instances of SQLVulnerabilityAssessmentBaselineRulesServer.
// Don't use this type directly, use NewSQLVulnerabilityAssessmentBaselineRulesServerTransport instead.
type SQLVulnerabilityAssessmentBaselineRulesServerTransport struct {
	srv *SQLVulnerabilityAssessmentBaselineRulesServer
}

// Do implements the policy.Transporter interface for SQLVulnerabilityAssessmentBaselineRulesServerTransport.
func (s *SQLVulnerabilityAssessmentBaselineRulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLVulnerabilityAssessmentBaselineRulesClient.Add":
		resp, err = s.dispatchAdd(req)
	case "SQLVulnerabilityAssessmentBaselineRulesClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SQLVulnerabilityAssessmentBaselineRulesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SQLVulnerabilityAssessmentBaselineRulesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SQLVulnerabilityAssessmentBaselineRulesClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLVulnerabilityAssessmentBaselineRulesServerTransport) dispatchAdd(req *http.Request) (*http.Response, error) {
	if s.srv.Add == nil {
		return nil, &nonRetriableError{errors.New("fake for method Add not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/baselineRules`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armsecurity.RulesResultsInput](req)
	if err != nil {
		return nil, err
	}
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	var options *armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientAddOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientAddOptions{
			Body: &body,
		}
	}
	respr, errRespr := s.srv.Add(req.Context(), workspaceIDParam, resourceIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RulesResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLVulnerabilityAssessmentBaselineRulesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/baselineRules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armsecurity.RuleResultsInput](req)
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	var options *armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions{
			Body: &body,
		}
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), ruleIDParam, workspaceIDParam, resourceIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RuleResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLVulnerabilityAssessmentBaselineRulesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/baselineRules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), ruleIDParam, workspaceIDParam, resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLVulnerabilityAssessmentBaselineRulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/baselineRules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), ruleIDParam, workspaceIDParam, resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RuleResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLVulnerabilityAssessmentBaselineRulesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/baselineRules`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.List(req.Context(), workspaceIDParam, resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RulesResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
