use progvis:lang:cpp:runtime;

// Output functions used by the implementation. They are here to avoid reloading the entire C
// frontend everytime we load a program that uses printf.
class PrintfHelpers {
	void putInt(Int width, Bool zeroPad, Int value) : static {
		StrBuf buf;
		if (width < 0)
			buf << left;
		else
			buf << right;

		buf << core:width(abs(width).nat);
		if (zeroPad)
			buf << core:fill('0');

		buf << value;
		printStr(buf.toS);
	}

	void putChar(Int width, Bool zeroPad, Byte value) : static {
		StrBuf buf;
		if (width < 0)
			buf << left;
		else
			buf << right;

		buf << core:width(abs(width).nat);
		if (zeroPad)
			buf << core:fill('0');

		buf << Char(value.nat);
		printStr(buf.toS);
	}

	void putStr(Int width, ConstPtr<Byte> str) : static {
		Int len = strlen(str);
		Int pad = max(abs(width) - len, 0);
		Str padStr = " " * pad.nat;

		if (width > 0)
			printStr(padStr);

		putstr(str);
		if (width < 0)
			printStr(padStr);
	}
}
