/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.geospatial;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.geospatial.DataSourceState;
import org.opensearch.client.opensearch.geospatial.Database;
import org.opensearch.client.opensearch.geospatial.UpdateStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DataSource
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DataSource> {
    @Nonnull
    private final Database database;
    @Nonnull
    private final String endpoint;
    @Nonnull
    private final String name;
    private final long nextUpdateAtInEpochMillis;
    @Nonnull
    private final DataSourceState state;
    private final int updateIntervalInDays;
    @Nonnull
    private final UpdateStats updateStats;
    public static final JsonpDeserializer<DataSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataSource::setupDataSourceDeserializer);

    private DataSource(Builder builder) {
        this.database = ApiTypeHelper.requireNonNull(builder.database, this, "database");
        this.endpoint = ApiTypeHelper.requireNonNull(builder.endpoint, this, "endpoint");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.nextUpdateAtInEpochMillis = ApiTypeHelper.requireNonNull(builder.nextUpdateAtInEpochMillis, this, "nextUpdateAtInEpochMillis");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.updateIntervalInDays = ApiTypeHelper.requireNonNull(builder.updateIntervalInDays, this, "updateIntervalInDays");
        this.updateStats = ApiTypeHelper.requireNonNull(builder.updateStats, this, "updateStats");
    }

    public static DataSource of(Function<Builder, ObjectBuilder<DataSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Database database() {
        return this.database;
    }

    @Nonnull
    public final String endpoint() {
        return this.endpoint;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    public final long nextUpdateAtInEpochMillis() {
        return this.nextUpdateAtInEpochMillis;
    }

    @Nonnull
    public final DataSourceState state() {
        return this.state;
    }

    public final int updateIntervalInDays() {
        return this.updateIntervalInDays;
    }

    @Nonnull
    public final UpdateStats updateStats() {
        return this.updateStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("database");
        this.database.serialize(generator, mapper);
        generator.writeKey("endpoint");
        generator.write(this.endpoint);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("next_update_at_in_epoch_millis");
        generator.write(this.nextUpdateAtInEpochMillis);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("update_interval_in_days");
        generator.write(this.updateIntervalInDays);
        generator.writeKey("update_stats");
        this.updateStats.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDataSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::database, Database._DESERIALIZER, "database");
        op.add(Builder::endpoint, JsonpDeserializer.stringDeserializer(), "endpoint");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::nextUpdateAtInEpochMillis, JsonpDeserializer.longDeserializer(), "next_update_at_in_epoch_millis");
        op.add(Builder::state, DataSourceState._DESERIALIZER, "state");
        op.add(Builder::updateIntervalInDays, JsonpDeserializer.integerDeserializer(), "update_interval_in_days");
        op.add(Builder::updateStats, UpdateStats._DESERIALIZER, "update_stats");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.database.hashCode();
        result = 31 * result + this.endpoint.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Long.hashCode(this.nextUpdateAtInEpochMillis);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + Integer.hashCode(this.updateIntervalInDays);
        result = 31 * result + this.updateStats.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSource other = (DataSource)o;
        return this.database.equals(other.database) && this.endpoint.equals(other.endpoint) && this.name.equals(other.name) && this.nextUpdateAtInEpochMillis == other.nextUpdateAtInEpochMillis && this.state.equals(other.state) && this.updateIntervalInDays == other.updateIntervalInDays && this.updateStats.equals(other.updateStats);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DataSource> {
        private Database database;
        private String endpoint;
        private String name;
        private Long nextUpdateAtInEpochMillis;
        private DataSourceState state;
        private Integer updateIntervalInDays;
        private UpdateStats updateStats;

        public Builder() {
        }

        private Builder(DataSource o) {
            this.database = o.database;
            this.endpoint = o.endpoint;
            this.name = o.name;
            this.nextUpdateAtInEpochMillis = o.nextUpdateAtInEpochMillis;
            this.state = o.state;
            this.updateIntervalInDays = o.updateIntervalInDays;
            this.updateStats = o.updateStats;
        }

        private Builder(Builder o) {
            this.database = o.database;
            this.endpoint = o.endpoint;
            this.name = o.name;
            this.nextUpdateAtInEpochMillis = o.nextUpdateAtInEpochMillis;
            this.state = o.state;
            this.updateIntervalInDays = o.updateIntervalInDays;
            this.updateStats = o.updateStats;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder database(Database value) {
            this.database = value;
            return this;
        }

        @Nonnull
        public final Builder database(Function<Database.Builder, ObjectBuilder<Database>> fn) {
            return this.database(fn.apply(new Database.Builder()).build());
        }

        @Nonnull
        public final Builder endpoint(String value) {
            this.endpoint = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder nextUpdateAtInEpochMillis(long value) {
            this.nextUpdateAtInEpochMillis = value;
            return this;
        }

        @Nonnull
        public final Builder state(DataSourceState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public final Builder updateIntervalInDays(int value) {
            this.updateIntervalInDays = value;
            return this;
        }

        @Nonnull
        public final Builder updateStats(UpdateStats value) {
            this.updateStats = value;
            return this;
        }

        @Nonnull
        public final Builder updateStats(Function<UpdateStats.Builder, ObjectBuilder<UpdateStats>> fn) {
            return this.updateStats(fn.apply(new UpdateStats.Builder()).build());
        }

        @Override
        @Nonnull
        public DataSource build() {
            this._checkSingleUse();
            return new DataSource(this);
        }
    }
}

