# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_lint_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_alpm_lint_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_lint_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_lint_using_subcommand
	set -l cmd (__fish_alpm_lint_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -s h -l help -d 'Print help'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -s V -l version -d 'Print version'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -f -a "check" -d 'Run lints on a file or directory'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -f -a "rules" -d 'Return the definition of all lint rules as structured data'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -f -a "options" -d 'Return the definition of all options to configure individual linting rules'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -f -a "meta" -d 'Return metadata about available lint groups, scopes, and levels for static site generators'
complete -c alpm-lint -n "__fish_alpm_lint_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s s -l scope -d 'Explicitly define the linting scope' -r -f -a "source-repository\t'Lint rules with this scope are specific to an [alpm-source-repo]'
package\t'Lint rules with this scope are specific to an [alpm-package]'
build-info\t'Lint rules with this scope are specific to a single [BUILDINFO] file'
package-build\t'Lint rules with this scope are specific to a single [PKGBUILD] file'
package-info\t'Lint rules with this scope are specific to a single [PKGINFO] file'
source-info\t'Lint rules with this scope are specific to a single [SRCINFO] file'"
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s f -l format -d 'The output format to use' -r -f -a "text\t'Human readable text'
json\t'The JSON output format'"
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s l -l level -d 'The level of lints to consider' -r -f -a "error\t'Lint rules leading to errors'
deny\t'Lint rules leading to denials'
warn\t'Lint rules leading to warnings'
suggest\t'Lint rules leading to suggestions'"
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s c -l config -d 'Supply a lint config path' -r -F
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s o -l output -d 'Optional output file path. If not provided, output goes to stdout' -r -F
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand check" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand rules" -s f -l format -d 'The output format to use' -r -f -a "json\t'The JSON output format'"
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand rules" -s o -l output -d 'Optional output file path' -r -F
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand rules" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand rules" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand rules" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand rules" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand options" -s f -l format -d 'The output format to use' -r -f -a "json\t'The JSON output format'"
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand options" -s o -l output -d 'Optional output file path' -r -F
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand options" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand options" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand options" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand options" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand meta" -s f -l format -d 'The output format to use' -r -f -a "json\t'The JSON output format'"
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand meta" -s o -l output -d 'Optional output file path' -r -F
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand meta" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand meta" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand meta" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand meta" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand help; and not __fish_seen_subcommand_from check rules options meta help" -f -a "check" -d 'Run lints on a file or directory'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand help; and not __fish_seen_subcommand_from check rules options meta help" -f -a "rules" -d 'Return the definition of all lint rules as structured data'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand help; and not __fish_seen_subcommand_from check rules options meta help" -f -a "options" -d 'Return the definition of all options to configure individual linting rules'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand help; and not __fish_seen_subcommand_from check rules options meta help" -f -a "meta" -d 'Return metadata about available lint groups, scopes, and levels for static site generators'
complete -c alpm-lint -n "__fish_alpm_lint_using_subcommand help; and not __fish_seen_subcommand_from check rules options meta help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
