﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class UpdateVoiceProfileDomainRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API UpdateVoiceProfileDomainRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateVoiceProfileDomain"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The domain ID.</p>
   */
  inline const Aws::String& GetVoiceProfileDomainId() const { return m_voiceProfileDomainId; }
  inline bool VoiceProfileDomainIdHasBeenSet() const { return m_voiceProfileDomainIdHasBeenSet; }
  template <typename VoiceProfileDomainIdT = Aws::String>
  void SetVoiceProfileDomainId(VoiceProfileDomainIdT&& value) {
    m_voiceProfileDomainIdHasBeenSet = true;
    m_voiceProfileDomainId = std::forward<VoiceProfileDomainIdT>(value);
  }
  template <typename VoiceProfileDomainIdT = Aws::String>
  UpdateVoiceProfileDomainRequest& WithVoiceProfileDomainId(VoiceProfileDomainIdT&& value) {
    SetVoiceProfileDomainId(std::forward<VoiceProfileDomainIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the voice profile domain.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateVoiceProfileDomainRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the voice profile domain.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateVoiceProfileDomainRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceProfileDomainId;

  Aws::String m_name;

  Aws::String m_description;
  bool m_voiceProfileDomainIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
