﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/cleanrooms/model/ProtectedJobSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CleanRooms {
namespace Model {
class ListProtectedJobsResult {
 public:
  AWS_CLEANROOMS_API ListProtectedJobsResult() = default;
  AWS_CLEANROOMS_API ListProtectedJobsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLEANROOMS_API ListProtectedJobsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The pagination token that's used to fetch the next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListProtectedJobsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of protected job summaries.</p>
   */
  inline const Aws::Vector<ProtectedJobSummary>& GetProtectedJobs() const { return m_protectedJobs; }
  template <typename ProtectedJobsT = Aws::Vector<ProtectedJobSummary>>
  void SetProtectedJobs(ProtectedJobsT&& value) {
    m_protectedJobsHasBeenSet = true;
    m_protectedJobs = std::forward<ProtectedJobsT>(value);
  }
  template <typename ProtectedJobsT = Aws::Vector<ProtectedJobSummary>>
  ListProtectedJobsResult& WithProtectedJobs(ProtectedJobsT&& value) {
    SetProtectedJobs(std::forward<ProtectedJobsT>(value));
    return *this;
  }
  template <typename ProtectedJobsT = ProtectedJobSummary>
  ListProtectedJobsResult& AddProtectedJobs(ProtectedJobsT&& value) {
    m_protectedJobsHasBeenSet = true;
    m_protectedJobs.emplace_back(std::forward<ProtectedJobsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListProtectedJobsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<ProtectedJobSummary> m_protectedJobs;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_protectedJobsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
