﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/GlueSchema.h>
#include <aws/glue/model/JDBCConnectorOptions.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>Specifies a connector to a JDBC data source.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JDBCConnectorSource">AWS
 * API Reference</a></p>
 */
class JDBCConnectorSource {
 public:
  AWS_GLUE_API JDBCConnectorSource() = default;
  AWS_GLUE_API JDBCConnectorSource(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API JDBCConnectorSource& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the data source.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  JDBCConnectorSource& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the connection that is associated with the connector.</p>
   */
  inline const Aws::String& GetConnectionName() const { return m_connectionName; }
  inline bool ConnectionNameHasBeenSet() const { return m_connectionNameHasBeenSet; }
  template <typename ConnectionNameT = Aws::String>
  void SetConnectionName(ConnectionNameT&& value) {
    m_connectionNameHasBeenSet = true;
    m_connectionName = std::forward<ConnectionNameT>(value);
  }
  template <typename ConnectionNameT = Aws::String>
  JDBCConnectorSource& WithConnectionName(ConnectionNameT&& value) {
    SetConnectionName(std::forward<ConnectionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of a connector that assists with accessing the data store in Glue
   * Studio.</p>
   */
  inline const Aws::String& GetConnectorName() const { return m_connectorName; }
  inline bool ConnectorNameHasBeenSet() const { return m_connectorNameHasBeenSet; }
  template <typename ConnectorNameT = Aws::String>
  void SetConnectorName(ConnectorNameT&& value) {
    m_connectorNameHasBeenSet = true;
    m_connectorName = std::forward<ConnectorNameT>(value);
  }
  template <typename ConnectorNameT = Aws::String>
  JDBCConnectorSource& WithConnectorName(ConnectorNameT&& value) {
    SetConnectorName(std::forward<ConnectorNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of connection, such as marketplace.jdbc or custom.jdbc, designating
   * a connection to a JDBC data store.</p>
   */
  inline const Aws::String& GetConnectionType() const { return m_connectionType; }
  inline bool ConnectionTypeHasBeenSet() const { return m_connectionTypeHasBeenSet; }
  template <typename ConnectionTypeT = Aws::String>
  void SetConnectionType(ConnectionTypeT&& value) {
    m_connectionTypeHasBeenSet = true;
    m_connectionType = std::forward<ConnectionTypeT>(value);
  }
  template <typename ConnectionTypeT = Aws::String>
  JDBCConnectorSource& WithConnectionType(ConnectionTypeT&& value) {
    SetConnectionType(std::forward<ConnectionTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Additional connection options for the connector.</p>
   */
  inline const JDBCConnectorOptions& GetAdditionalOptions() const { return m_additionalOptions; }
  inline bool AdditionalOptionsHasBeenSet() const { return m_additionalOptionsHasBeenSet; }
  template <typename AdditionalOptionsT = JDBCConnectorOptions>
  void SetAdditionalOptions(AdditionalOptionsT&& value) {
    m_additionalOptionsHasBeenSet = true;
    m_additionalOptions = std::forward<AdditionalOptionsT>(value);
  }
  template <typename AdditionalOptionsT = JDBCConnectorOptions>
  JDBCConnectorSource& WithAdditionalOptions(AdditionalOptionsT&& value) {
    SetAdditionalOptions(std::forward<AdditionalOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the table in the data source.</p>
   */
  inline const Aws::String& GetConnectionTable() const { return m_connectionTable; }
  inline bool ConnectionTableHasBeenSet() const { return m_connectionTableHasBeenSet; }
  template <typename ConnectionTableT = Aws::String>
  void SetConnectionTable(ConnectionTableT&& value) {
    m_connectionTableHasBeenSet = true;
    m_connectionTable = std::forward<ConnectionTableT>(value);
  }
  template <typename ConnectionTableT = Aws::String>
  JDBCConnectorSource& WithConnectionTable(ConnectionTableT&& value) {
    SetConnectionTable(std::forward<ConnectionTableT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The table or SQL query to get the data from. You can specify either
   * <code>ConnectionTable</code> or <code>query</code>, but not both.</p>
   */
  inline const Aws::String& GetQuery() const { return m_query; }
  inline bool QueryHasBeenSet() const { return m_queryHasBeenSet; }
  template <typename QueryT = Aws::String>
  void SetQuery(QueryT&& value) {
    m_queryHasBeenSet = true;
    m_query = std::forward<QueryT>(value);
  }
  template <typename QueryT = Aws::String>
  JDBCConnectorSource& WithQuery(QueryT&& value) {
    SetQuery(std::forward<QueryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the data schema for the custom JDBC source.</p>
   */
  inline const Aws::Vector<GlueSchema>& GetOutputSchemas() const { return m_outputSchemas; }
  inline bool OutputSchemasHasBeenSet() const { return m_outputSchemasHasBeenSet; }
  template <typename OutputSchemasT = Aws::Vector<GlueSchema>>
  void SetOutputSchemas(OutputSchemasT&& value) {
    m_outputSchemasHasBeenSet = true;
    m_outputSchemas = std::forward<OutputSchemasT>(value);
  }
  template <typename OutputSchemasT = Aws::Vector<GlueSchema>>
  JDBCConnectorSource& WithOutputSchemas(OutputSchemasT&& value) {
    SetOutputSchemas(std::forward<OutputSchemasT>(value));
    return *this;
  }
  template <typename OutputSchemasT = GlueSchema>
  JDBCConnectorSource& AddOutputSchemas(OutputSchemasT&& value) {
    m_outputSchemasHasBeenSet = true;
    m_outputSchemas.emplace_back(std::forward<OutputSchemasT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_connectionName;

  Aws::String m_connectorName;

  Aws::String m_connectionType;

  JDBCConnectorOptions m_additionalOptions;

  Aws::String m_connectionTable;

  Aws::String m_query;

  Aws::Vector<GlueSchema> m_outputSchemas;
  bool m_nameHasBeenSet = false;
  bool m_connectionNameHasBeenSet = false;
  bool m_connectorNameHasBeenSet = false;
  bool m_connectionTypeHasBeenSet = false;
  bool m_additionalOptionsHasBeenSet = false;
  bool m_connectionTableHasBeenSet = false;
  bool m_queryHasBeenSet = false;
  bool m_outputSchemasHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
