﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/inspector2/model/AccountState.h>
#include <aws/inspector2/model/FailedAccount.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Inspector2 {
namespace Model {
class BatchGetAccountStatusResult {
 public:
  AWS_INSPECTOR2_API BatchGetAccountStatusResult() = default;
  AWS_INSPECTOR2_API BatchGetAccountStatusResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_INSPECTOR2_API BatchGetAccountStatusResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of objects that provide details on the status of Amazon Inspector
   * for each of the requested accounts.</p>
   */
  inline const Aws::Vector<AccountState>& GetAccounts() const { return m_accounts; }
  template <typename AccountsT = Aws::Vector<AccountState>>
  void SetAccounts(AccountsT&& value) {
    m_accountsHasBeenSet = true;
    m_accounts = std::forward<AccountsT>(value);
  }
  template <typename AccountsT = Aws::Vector<AccountState>>
  BatchGetAccountStatusResult& WithAccounts(AccountsT&& value) {
    SetAccounts(std::forward<AccountsT>(value));
    return *this;
  }
  template <typename AccountsT = AccountState>
  BatchGetAccountStatusResult& AddAccounts(AccountsT&& value) {
    m_accountsHasBeenSet = true;
    m_accounts.emplace_back(std::forward<AccountsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of objects detailing any accounts that failed to enable Amazon
   * Inspector and why.</p>
   */
  inline const Aws::Vector<FailedAccount>& GetFailedAccounts() const { return m_failedAccounts; }
  template <typename FailedAccountsT = Aws::Vector<FailedAccount>>
  void SetFailedAccounts(FailedAccountsT&& value) {
    m_failedAccountsHasBeenSet = true;
    m_failedAccounts = std::forward<FailedAccountsT>(value);
  }
  template <typename FailedAccountsT = Aws::Vector<FailedAccount>>
  BatchGetAccountStatusResult& WithFailedAccounts(FailedAccountsT&& value) {
    SetFailedAccounts(std::forward<FailedAccountsT>(value));
    return *this;
  }
  template <typename FailedAccountsT = FailedAccount>
  BatchGetAccountStatusResult& AddFailedAccounts(FailedAccountsT&& value) {
    m_failedAccountsHasBeenSet = true;
    m_failedAccounts.emplace_back(std::forward<FailedAccountsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  BatchGetAccountStatusResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AccountState> m_accounts;

  Aws::Vector<FailedAccount> m_failedAccounts;

  Aws::String m_requestId;
  bool m_accountsHasBeenSet = false;
  bool m_failedAccountsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Inspector2
}  // namespace Aws
