﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sdb/SimpleDBRequest.h>
#include <aws/sdb/SimpleDB_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SimpleDB {
namespace Model {

/**
 */
class DomainMetadataRequest : public SimpleDBRequest {
 public:
  AWS_SIMPLEDB_API DomainMetadataRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DomainMetadata"; }

  AWS_SIMPLEDB_API Aws::String SerializePayload() const override;

 protected:
  AWS_SIMPLEDB_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * The name of the domain for which to display the metadata of.
   */
  inline const Aws::String& GetDomainName() const { return m_domainName; }
  inline bool DomainNameHasBeenSet() const { return m_domainNameHasBeenSet; }
  template <typename DomainNameT = Aws::String>
  void SetDomainName(DomainNameT&& value) {
    m_domainNameHasBeenSet = true;
    m_domainName = std::forward<DomainNameT>(value);
  }
  template <typename DomainNameT = Aws::String>
  DomainMetadataRequest& WithDomainName(DomainNameT&& value) {
    SetDomainName(std::forward<DomainNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainName;
  bool m_domainNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SimpleDB
}  // namespace Aws
