﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/ResponseMetadata.h>
#include <aws/redshift/model/ScheduledAction.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
class DescribeScheduledActionsResult {
 public:
  AWS_REDSHIFT_API DescribeScheduledActionsResult() = default;
  AWS_REDSHIFT_API DescribeScheduledActionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API DescribeScheduledActionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>An optional parameter that specifies the starting point to return a set of
   * response records. When the results of a <a>DescribeScheduledActions</a> request
   * exceed the value specified in <code>MaxRecords</code>, Amazon Web Services
   * returns a value in the <code>Marker</code> field of the response. You can
   * retrieve the next set of response records by providing the returned marker value
   * in the <code>Marker</code> parameter and retrying the request. </p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeScheduledActionsResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>List of retrieved scheduled actions. </p>
   */
  inline const Aws::Vector<ScheduledAction>& GetScheduledActions() const { return m_scheduledActions; }
  template <typename ScheduledActionsT = Aws::Vector<ScheduledAction>>
  void SetScheduledActions(ScheduledActionsT&& value) {
    m_scheduledActionsHasBeenSet = true;
    m_scheduledActions = std::forward<ScheduledActionsT>(value);
  }
  template <typename ScheduledActionsT = Aws::Vector<ScheduledAction>>
  DescribeScheduledActionsResult& WithScheduledActions(ScheduledActionsT&& value) {
    SetScheduledActions(std::forward<ScheduledActionsT>(value));
    return *this;
  }
  template <typename ScheduledActionsT = ScheduledAction>
  DescribeScheduledActionsResult& AddScheduledActions(ScheduledActionsT&& value) {
    m_scheduledActionsHasBeenSet = true;
    m_scheduledActions.emplace_back(std::forward<ScheduledActionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeScheduledActionsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_marker;

  Aws::Vector<ScheduledAction> m_scheduledActions;

  ResponseMetadata m_responseMetadata;
  bool m_markerHasBeenSet = false;
  bool m_scheduledActionsHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
